/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.multiple.incompleteConcordance;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;

public class IncompleteConcordance
extends StatisticalTest {
    private DataTable data;
    private double[][] ranks;
    private double[] sumRanks;
    private double k;
    private double n;
    private double m;
    private double lambda;
    private double Q;
    private double W;
    private double pValue;
    private double criticalZ90;
    private double criticalZ95;

    public IncompleteConcordance() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.Q = 0.0;
        this.W = 0.0;
        this.ranks = null;
        this.sumRanks = null;
        this.pValue = -1.0;
    }

    public IncompleteConcordance(DataTable newData, double lambda) {
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Incomplete concordance test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        this.n = this.data.getColumns();
        this.lambda = lambda;
        this.ranks = new double[this.data.getRows()][this.data.getColumns()];
        this.sumRanks = new double[this.data.getColumns()];
        this.m = 0.0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double mAux = 0.0;
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.ranks[i][j] = this.data.get(i, j);
                if (this.ranks[i][j] == Double.MIN_VALUE) {
                    this.ranks[i][j] = 0.0;
                    continue;
                }
                mAux += 1.0;
            }
            this.m = Math.max(this.m, mAux);
        }
        this.k = 0.0;
        for (int j = 0; j < this.data.getColumns(); ++j) {
            double kAux = 0.0;
            for (int i = 0; i < this.data.getRows(); ++i) {
                if (this.ranks[i][j] == 0.0) continue;
                kAux += 1.0;
            }
            this.k = Math.max(this.k, kAux);
        }
        Arrays.fill(this.sumRanks, 0.0);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData, double lambda) {
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        this.n = this.data.getColumns();
        this.lambda = lambda;
        this.ranks = new double[this.data.getRows()][this.data.getColumns()];
        this.sumRanks = new double[this.data.getColumns()];
        this.m = 0.0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double mAux = 0.0;
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.ranks[i][j] = this.data.get(i, j);
                if (this.ranks[i][j] == Double.MIN_VALUE) {
                    this.ranks[i][j] = 0.0;
                    continue;
                }
                mAux += 1.0;
            }
            this.m = Math.max(this.m, mAux);
        }
        this.k = 0.0;
        for (int j = 0; j < this.data.getColumns(); ++j) {
            double kAux = 0.0;
            for (int i = 0; i < this.data.getRows(); ++i) {
                if (this.ranks[i][j] == 0.0) continue;
                kAux += 1.0;
            }
            this.k = Math.max(this.k, kAux);
        }
        Arrays.fill(this.sumRanks, 0.0);
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        for (int i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                int n = j;
                this.sumRanks[n] = this.sumRanks[n] + this.ranks[i][j];
            }
        }
        double quadR = 0.0;
        for (int j = 0; j < this.data.getColumns(); ++j) {
            quadR += this.sumRanks[j] * this.sumRanks[j];
        }
        this.W = 12.0 * quadR - 3.0 * this.k * this.k * this.n * (this.m + 1.0) * (this.m + 1.0);
        this.W /= this.lambda * this.lambda * this.n * (this.n * this.n - 1.0);
        this.Q = 12.0 * quadR / (this.lambda * this.n * (this.m + 1.0)) - 3.0 * this.k * this.k * (this.m + 1.0) / this.lambda;
        this.computePValue(this.sumRanks.length - 1);
        this.multipleComparisonsProcedure();
        this.performed = true;
    }

    private void multipleComparisonsProcedure() {
        double critical90 = 1.0 - 0.1 / (double)(this.sumRanks.length * (this.sumRanks.length - 1));
        double critical95 = 1.0 - 0.05 / (double)(this.sumRanks.length * (this.sumRanks.length - 1));
        NormalDistribution normal = new NormalDistribution();
        critical90 = normal.inverseNormalDistribution(critical90);
        critical95 = normal.inverseNormalDistribution(critical95);
        double denominator = Math.sqrt(this.k * this.n * (this.n + 1.0) / 6.0);
        this.criticalZ90 = critical90 * denominator;
        this.criticalZ95 = critical95 * denominator;
    }

    private double computePValue(int dF) {
        ChiSquareDistribution chi = new ChiSquareDistribution();
        chi.setDegree(dF);
        this.pValue = chi.computeCumulativeProbability(this.Q);
        return this.pValue;
    }

    public double getQ() {
        return this.Q;
    }

    public double getW() {
        return this.W;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        int j;
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n******************\n";
        report = report + "Concordance coefficient based test\n";
        report = report + "for incomplete classifications\n";
        report = report + "******************\n\n";
        report = report + "Sum of ranks:\n";
        for (j = 0; j < this.sumRanks.length; ++j) {
            report = report + "S" + (j + 1) + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.sumRanks.length; ++j) {
            report = report + this.nf6.format(this.sumRanks[j]) + "\t";
        }
        report = report + "\n";
        report = report + "\n";
        report = report + "Q statistic: " + this.nf6.format(this.Q) + "\n\n";
        report = report + "W ratio (Kendall's coefficient of concordance): " + this.nf6.format(this.W) + "\n\n";
        report = report + "P-Value computed :" + this.nf6.format(this.pValue) + "\n\n";
        return report;
    }

    public String printMultipleComparisonsProcedureReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Multiple comparisons procedure (Incomplete concordance test)\n";
        report = report + "***************************************\n\n";
        report = report + "Critical values: Alpha=0.90: " + this.criticalZ90 + " Alpha=0.95: " + this.criticalZ95 + "\n\n";
        report = report + "Individual comparisons:\n\n";
        for (int first = 0; first < this.data.getColumns() - 1; ++first) {
            for (int second = first + 1; second < this.data.getColumns(); ++second) {
                double Z = Math.abs(this.sumRanks[first] - this.sumRanks[second]);
                report = report + (first + 1) + " vs " + (second + 1) + ": Z= " + Z + "\n\n";
            }
        }
        return report;
    }
}

