/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.location.normalScoresTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;

public class NormalScoresTest
extends StatisticalTest {
    private DataTable data;
    private double[] sample1;
    private double[] sample2;
    private int values1;
    private int values2;
    private double[] combined;
    private boolean[] ties;
    private double normalStatistic;
    private double normalStatistic2;
    private double asymptoticLeft;
    private double asymptoticRight;
    private double asymptoticDouble;
    private NormalDistribution normal;

    public NormalScoresTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.normalStatistic = 0.0;
        this.normalStatistic2 = 0.0;
        this.sample1 = null;
        this.sample2 = null;
        this.asymptoticLeft = -1.0;
        this.asymptoticRight = -1.0;
        this.asymptoticDouble = -1.0;
    }

    public NormalScoresTest(DataTable newData) {
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Normal Scores test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Normal Scores test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int pointer;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.combined = new double[this.sample1.length + this.sample2.length];
        Arrays.sort(this.sample1);
        Arrays.sort(this.sample2);
        System.arraycopy(this.sample1, 0, this.combined, 0, this.sample1.length);
        System.arraycopy(this.sample2, 0, this.combined, this.sample1.length, this.sample2.length);
        Arrays.sort(this.combined);
        this.ties = new boolean[this.combined.length];
        Arrays.fill(this.ties, false);
        double val = this.combined[0];
        if (this.combined[1] == val) {
            this.ties[0] = true;
        }
        for (int i = 1; i < this.combined.length; ++i) {
            if (this.combined[i] == val) {
                this.ties[i] = true;
                this.ties[i - 1] = true;
            }
            val = this.combined[i];
        }
        this.normal = new NormalDistribution();
        double[] ranks = new double[this.combined.length];
        int nValues = this.combined.length;
        for (int i = 0; i < this.combined.length; ++i) {
            if (!this.ties[i]) {
                ranks[i] = this.normal.inverseNormalDistribution((double)(i + 1) / ((double)nValues + 1.0));
                continue;
            }
            int j = 1;
            double sumRank = this.normal.inverseNormalDistribution((double)(i + 1) / ((double)nValues + 1.0));
            while (i + j < this.combined.length && this.ties[i + j]) {
                sumRank += this.normal.inverseNormalDistribution((double)(i + 1 + j) / ((double)nValues + 1.0));
                ++j;
            }
            for (int k = 0; k < j; ++k) {
                ranks[i] = sumRank / (double)j;
                ++i;
            }
            --i;
        }
        this.normalStatistic = 0.0;
        this.normalStatistic2 = 0.0;
        int pointer2 = 0;
        for (pointer = 0; pointer < this.sample1.length; ++pointer) {
            while (this.combined[pointer2] != this.sample1[pointer]) {
                ++pointer2;
            }
            this.normalStatistic += ranks[pointer2];
        }
        pointer2 = 0;
        for (pointer = 0; pointer < this.sample2.length; ++pointer) {
            while (this.combined[pointer2] != this.sample2[pointer]) {
                ++pointer2;
            }
            this.normalStatistic2 += ranks[pointer2];
        }
        this.computePValues();
        this.performed = true;
    }

    private void computePValues() {
        double N = this.values1 + this.values2;
        double numerator = 0.0;
        int i = 1;
        while ((double)i <= N) {
            double value = this.normal.inverseNormalDistribution((double)i / (N + 1.0));
            numerator += value * value;
            ++i;
        }
        double denominator = N * (N - 1.0);
        double variance = (double)(this.values1 * this.values2) * (numerator / denominator);
        double z = this.normalStatistic / Math.sqrt(variance);
        this.asymptoticLeft = this.normal.getTipifiedProbability(z, false);
        z = this.normalStatistic2 / Math.sqrt(variance);
        this.asymptoticRight = this.normal.getTipifiedProbability(z, false);
        this.asymptoticDouble = 2.0 * Math.min(this.asymptoticLeft, this.asymptoticRight);
    }

    public double getNormalStatistic1() {
        return this.normalStatistic;
    }

    public double getNormalStatistic2() {
        return this.normalStatistic2;
    }

    public double getLeftPValue() {
        return this.asymptoticLeft;
    }

    public double getRightPValue() {
        return this.asymptoticRight;
    }

    public double getDoublePValue() {
        return this.asymptoticDouble;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n*****************************\n";
        report = report + "Normal Scores test (van der Warden)\n";
        report = report + "*****************************\n\n";
        report = report + "Normal Statistic X: " + this.nf6.format(this.normalStatistic) + "\n";
        report = report + "Normal Statistic Y: " + this.nf6.format(this.normalStatistic2) + "\n\n";
        report = report + "Asymptotic P-Value (left tail): " + this.nf6.format(this.asymptoticLeft) + "\n";
        report = report + "Asymptotic P-Value (right tail): " + this.nf6.format(this.asymptoticRight) + "\n";
        report = report + "Asymptotic P-Value (double tail): " + this.nf6.format(this.asymptoticDouble) + "\n\n";
        return report;
    }
}

