/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.goodness.chiSquareTest;

import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.distributions.common.discrete.BinomialDistribution;
import javanpst.distributions.common.discrete.GeometricDistribution;
import javanpst.distributions.common.discrete.PoissonDistribution;
import javanpst.distributions.common.discrete.UniformDistribution;
import javanpst.tests.StatisticalTest;

public class ChiSquareTest
extends StatisticalTest {
    private DataTable data;
    private int typeDist;
    private int freedomDegree;
    private int nEstimated;
    private int nCount;
    private double[][] errorTable;
    private double[][] distribution;
    private boolean distributionReady;
    private double Q;
    private double pValue;
    private UniformDistribution uniform;
    private BinomialDistribution binomial;
    private PoissonDistribution poisson;
    private GeometricDistribution geometric;
    private ChiSquareDistribution chiSquare;

    public ChiSquareTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.distributionReady = false;
        this.typeDist = -1;
        this.freedomDegree = 0;
        this.nEstimated = 0;
        this.errorTable = null;
        this.pValue = -1.0;
    }

    public ChiSquareTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Chi-square test only accept tables in the following format:");
            System.out.println("<category> <frequency>");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.errorTable = new double[this.data.getRows()][2];
        this.distribution = new double[this.data.getRows()][2];
        this.nCount = 0;
        for (i = 0; i < this.data.getRows(); ++i) {
            this.distribution[i][0] = this.data.get(i, 0);
            this.distribution[i][1] = this.data.get(i, 1);
            this.nCount = (int)((double)this.nCount + this.data.get(i, 1));
        }
        this.dataReady = true;
        this.performed = false;
        this.distributionReady = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Chi-square test only accept tables in the following format:");
            System.out.println("<category> <frequency>");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.errorTable = new double[this.data.getRows()][2];
        this.distribution = new double[this.data.getRows()][2];
        this.nCount = 0;
        for (i = 0; i < this.data.getRows(); ++i) {
            this.distribution[i][0] = this.data.get(i, 0);
            this.distribution[i][1] = this.data.get(i, 1);
            this.nCount = (int)((double)this.nCount + this.data.get(i, 1));
        }
        this.dataReady = true;
        this.performed = false;
        this.distributionReady = false;
    }

    public void adjustUniform(int N) {
        this.uniform = new UniformDistribution();
        this.uniform.setN(N);
        this.typeDist = 0;
        this.nEstimated = 0;
        this.distributionReady = true;
    }

    public void adjustBinomial(int N, double P) {
        this.binomial = new BinomialDistribution();
        this.binomial.setN(N);
        this.binomial.setP(P);
        this.typeDist = 1;
        this.nEstimated = 0;
        this.distributionReady = true;
    }

    public void adjustBinomial(int N) {
        this.binomial = new BinomialDistribution();
        this.binomial.setN(N);
        this.binomial.setP(this.estimateProbability());
        this.typeDist = 1;
        this.nEstimated = 1;
        this.distributionReady = true;
    }

    public void adjustPoisson(int K) {
        this.poisson = new PoissonDistribution();
        this.poisson.setMean(K);
        this.typeDist = 2;
        this.nEstimated = 0;
        this.distributionReady = true;
    }

    public void adjustPoisson() {
        this.poisson = new PoissonDistribution();
        this.poisson.setMean(this.estimateMean());
        this.typeDist = 2;
        this.nEstimated = 1;
        this.distributionReady = true;
    }

    public void adjustGeometric(double P) {
        this.geometric = new GeometricDistribution();
        this.geometric.setP(P);
        this.typeDist = 3;
        this.nEstimated = 0;
        this.distributionReady = true;
    }

    @Override
    public void doTest() {
        int less = 0;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        if (!this.distributionReady) {
            System.out.println("Distribution to fit is not set");
            return;
        }
        this.chiSquare = new ChiSquareDistribution();
        this.errorTable = new double[this.data.getRows()][2];
        this.sortDistribution();
        for (int i = 0; i < this.distribution.length; ++i) {
            this.errorTable[i][0] = this.distribution[i][1];
            this.errorTable[i][1] = this.computeExpected((int)this.distribution[i][0]);
            double[] dArray = this.errorTable[i];
            dArray[1] = dArray[1] * (double)this.nCount;
            if (!(this.errorTable[i][1] < 1.0)) continue;
            ++less;
        }
        if (less > 0 && less < this.data.getRows()) {
            this.trimTable(less);
        }
        this.Q = 0.0;
        for (int i = 0; i < this.errorTable.length; ++i) {
            double value = (this.errorTable[i][0] - this.errorTable[i][1]) * (this.errorTable[i][0] - this.errorTable[i][1]) / this.errorTable[i][1];
            this.Q += value;
        }
        this.freedomDegree = Math.max(1, this.errorTable.length - 1 - this.nEstimated);
        this.chiSquare.setDegree(this.freedomDegree);
        this.pValue = this.chiSquare.computeCumulativeProbability(this.Q);
        this.performed = true;
    }

    private void trimTable(int delete) {
        int i;
        double[][] aux = new double[this.errorTable.length][2];
        for (i = 0; i < this.errorTable.length; ++i) {
            aux[i][0] = this.errorTable[i][0];
            aux[i][1] = this.errorTable[i][1];
        }
        this.errorTable = new double[this.errorTable.length - delete][2];
        for (i = 0; i < this.errorTable.length; ++i) {
            this.errorTable[i][1] = 0.0;
        }
        int pointer = 0;
        for (i = 0; i < aux.length; ++i) {
            double[] dArray = this.errorTable[pointer];
            dArray[0] = dArray[0] + aux[i][0];
            double[] dArray2 = this.errorTable[pointer];
            dArray2[1] = dArray2[1] + aux[i][1];
            if (!(this.errorTable[pointer][1] >= 1.0) || pointer >= this.errorTable.length - 1) continue;
            ++pointer;
        }
        if (pointer != this.errorTable.length - 1) {
            this.trimTable(this.errorTable.length - pointer);
        }
    }

    private double estimateMean() {
        double mean = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.distribution.length; ++i) {
            mean += this.distribution[i][0] * this.distribution[i][1];
            sum += this.distribution[i][1];
        }
        return mean /= sum;
    }

    private double estimateProbability() {
        double value = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.distribution.length; ++i) {
            value += this.distribution[i][0] * this.distribution[i][1];
            sum += this.distribution[i][1];
        }
        return value /= sum * (double)this.binomial.getN();
    }

    private double computeExpected(int value) {
        double prob = 0.0;
        switch (this.typeDist) {
            case 0: {
                prob = this.uniform.computeProbability(value);
                break;
            }
            case 1: {
                prob = this.binomial.computeProbability(value);
                break;
            }
            case 2: {
                prob = this.poisson.computeProbability(value);
                break;
            }
            case 3: {
                prob = this.geometric.computeProbability(value);
            }
        }
        return prob;
    }

    private void sortDistribution() {
        for (int i = 0; i < this.distribution.length; ++i) {
            for (int j = i + 1; j < this.distribution.length; ++j) {
                if (!(this.distribution[i][0] > this.distribution[j][0])) continue;
                this.swapRow(this.distribution[i][0], this.distribution[i][1], this.distribution[j][0], this.distribution[j][1]);
            }
        }
    }

    private void swapRow(double a1, double a2, double b1, double b2) {
        double aux1 = a1;
        a1 = b1;
        b1 = aux1;
        double aux2 = a2;
        a2 = b2;
        b2 = aux2;
    }

    public double getQ() {
        return this.Q;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n************\n";
        report = report + "Chi-square goodness of fit test\n";
        report = report + "**************\n\n";
        switch (this.typeDist) {
            case 0: {
                report = report + "Fitting data to Uniform distribution (N=" + this.nf6.format(this.uniform.getN()) + ")\n\n";
                break;
            }
            case 1: {
                report = report + "Fitting data to Binomial distribution (N=" + this.nf6.format(this.binomial.getN()) + " , P=" + this.nf6.format(this.binomial.getP()) + ")\n\n";
                break;
            }
            case 2: {
                report = report + "Fitting data to Poisson distribution (Mean=" + this.nf6.format(this.poisson.getMean()) + ")\n\n";
                break;
            }
            case 3: {
                report = report + "Fitting data to Geometric distribution (P=" + this.nf6.format(this.geometric.getP()) + ")\n\n";
            }
        }
        report = report + "Q Statistic: " + this.nf6.format(this.Q) + "\n\n";
        report = report + "P-Value : " + this.nf6.format(this.pValue) + "\n";
        return report;
    }
}

