/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.goodness.K_STest;

import javanpst.data.structures.sequence.NumericSequence;
import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.distributions.common.continuous.ExponentialDistribution;
import javanpst.distributions.common.continuous.GammaDistribution;
import javanpst.distributions.common.continuous.LaplaceDistribution;
import javanpst.distributions.common.continuous.LogisticDistribution;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.common.continuous.UniformCDistribution;
import javanpst.distributions.common.continuous.WeibullDistribution;
import javanpst.distributions.tests.KolmogorovDistribution;
import javanpst.tests.StatisticalTest;

public class K_STest
extends StatisticalTest {
    private KolmogorovDistribution distribution = KolmogorovDistribution.getInstance();
    private NumericSequence sequence;
    private double[] F0;
    private double[] Sn;
    private int typeDistribution;
    private ExponentialDistribution exponential;
    private NormalDistribution normal;
    private ChiSquareDistribution chisquare;
    private UniformCDistribution uniform;
    private GammaDistribution gamma;
    private LaplaceDistribution laplace;
    private LogisticDistribution logistic;
    private WeibullDistribution weibull;
    private boolean distributionReady;
    private double Dn;
    private double pValue;

    public K_STest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.sequence = new NumericSequence();
        this.performed = false;
        this.dataReady = false;
        this.distributionReady = false;
        this.typeDistribution = -1;
        this.F0 = null;
        this.Sn = null;
        this.pValue = -1.0;
    }

    public K_STest(NumericSequence newSequence) {
        this.setReportFormat();
        this.sequence = new NumericSequence(newSequence);
        this.sequence.sort();
        this.F0 = new double[this.sequence.size()];
        this.Sn = new double[this.sequence.size()];
        this.performed = false;
        this.dataReady = true;
        this.distributionReady = false;
    }

    public void setData(NumericSequence newSequence) {
        this.sequence = new NumericSequence(newSequence);
        this.sequence.sort();
        this.F0 = new double[this.sequence.size()];
        this.Sn = new double[this.sequence.size()];
        this.performed = false;
        this.dataReady = true;
        this.distributionReady = false;
    }

    public void adjustNormal(double m, double s) {
        this.typeDistribution = 4;
        this.normal = new NormalDistribution();
        this.normal.setMean(m);
        this.normal.setS(s);
        this.distributionReady = true;
    }

    public void adjustExponential(double m) {
        this.typeDistribution = 7;
        this.exponential = new ExponentialDistribution();
        this.exponential.setMean(m);
        this.distributionReady = true;
    }

    public void adjustUniform(double start, double end) {
        this.typeDistribution = 5;
        this.uniform = new UniformCDistribution();
        this.uniform.setStart(start);
        this.uniform.setEnd(end);
        this.distributionReady = true;
    }

    public void adjustChiSquare(int freedom) {
        this.typeDistribution = 6;
        this.chisquare = new ChiSquareDistribution();
        this.chisquare.setDegree(freedom);
        this.distributionReady = true;
    }

    public void adjustGamma(double K, double lambda) {
        this.typeDistribution = 8;
        this.gamma = new GammaDistribution();
        this.gamma.setK(K);
        this.gamma.setLambda(lambda);
        this.distributionReady = true;
    }

    public void adjustLaplace(double mean, double scale) {
        this.typeDistribution = 9;
        this.laplace = new LaplaceDistribution();
        this.laplace.setMean(mean);
        this.laplace.setScale(scale);
        this.distributionReady = true;
    }

    public void adjustLogistic(double mean, double S) {
        this.typeDistribution = 10;
        this.logistic = new LogisticDistribution();
        this.logistic.setMean(mean);
        this.logistic.setS(S);
        this.distributionReady = true;
    }

    public void adjustWeibull(double K, double lambda) {
        this.typeDistribution = 11;
        this.weibull = new WeibullDistribution();
        this.weibull.setK(K);
        this.weibull.setLambda(lambda);
        this.distributionReady = true;
    }

    @Override
    public void doTest() {
        int i;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        if (!this.distributionReady) {
            System.out.println("Distribution to fit is not set");
            return;
        }
        this.Dn = 0.0;
        for (i = 0; i < this.Sn.length; ++i) {
            this.Sn[i] = (double)(i + 1) / (double)this.Sn.length;
        }
        for (i = 0; i < this.F0.length; ++i) {
            this.F0[i] = this.computeExpected(this.sequence.getSequence().get(i));
        }
        for (i = 0; i < this.F0.length; ++i) {
            double value = Math.abs(this.Sn[i] - this.F0[i]);
            this.Dn = Math.max(this.Dn, value);
            double value2 = i == 0 ? 0.0 : this.Sn[i - 1];
            value = Math.abs(value2 - this.F0[i]);
            this.Dn = Math.max(this.Dn, value);
        }
        this.pValue = this.distribution.computeProbability(this.sequence.size(), this.Dn);
        this.performed = true;
    }

    private double computeExpected(double value) {
        double prob = 0.0;
        switch (this.typeDistribution) {
            case 4: {
                prob = this.normal.computeCumulativeProbability(value);
                break;
            }
            case 5: {
                prob = this.uniform.computeCumulativeProbability(value);
                break;
            }
            case 6: {
                prob = this.chisquare.computeCumulativeProbability(value);
                break;
            }
            case 7: {
                prob = this.exponential.computeCumulativeProbability(value);
                break;
            }
            case 8: {
                prob = this.gamma.computeCumulativeProbability(value);
                break;
            }
            case 9: {
                prob = this.laplace.computeCumulativeProbability(value);
                break;
            }
            case 10: {
                prob = this.logistic.computeCumulativeProbability(value);
                break;
            }
            case 11: {
                prob = this.weibull.computeCumulativeProbability(value);
            }
        }
        return prob;
    }

    public double getDn() {
        return this.Dn;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.sequence;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n************\n";
        report = report + "Kolmogorov-Smirnov goodness of fit test\n";
        report = report + "**************\n\n";
        switch (this.typeDistribution) {
            case 4: {
                report = report + "Fitting data to Normal distribution with Mean = " + this.nf6.format(this.normal.getMean()) + " and Sigma = " + this.nf6.format(this.normal.getSigma()) + "\n\n";
                break;
            }
            case 7: {
                report = report + "Fitting data to Exponential distribution with Mean = " + this.nf6.format(this.exponential.getMean()) + "\n\n";
                break;
            }
            case 5: {
                report = report + "Fitting data to Uniform distribution between [" + this.nf6.format(this.uniform.getStart()) + "," + this.nf6.format(this.uniform.getEnd()) + "]\n\n";
                break;
            }
            case 6: {
                report = report + "Fitting data to Chi-square distribution with " + this.nf6.format(this.chisquare.getDegree()) + " degrees of freedom\n\n";
                break;
            }
            case 8: {
                report = report + "Fitting data to Gamma distribution with K = " + this.nf6.format(this.gamma.getK()) + " and Lambda = " + this.nf6.format(this.gamma.getLambda()) + "\n\n";
                break;
            }
            case 11: {
                report = report + "Fitting data to Weibull distribution with K = " + this.nf6.format(this.weibull.getK()) + " and Lambda = " + this.nf6.format(this.weibull.getLambda()) + "\n\n";
                break;
            }
            case 9: {
                report = report + "Fitting data to Laplace distribution with Mean = " + this.nf6.format(this.laplace.getMean()) + " and Scale = " + this.nf6.format(this.laplace.getScale()) + "\n\n";
                break;
            }
            case 10: {
                report = report + "Fitting data to Logistic distribution with Mean = " + this.nf6.format(this.logistic.getMean()) + " and S = " + this.nf6.format(this.logistic.getS()) + "\n\n";
            }
        }
        report = report + "Dn Statistic: " + this.nf6.format(this.Dn) + "\n\n";
        report = report + "Exact p-value : <= " + this.nf6.format(this.pValue) + "\n";
        return report;
    }
}

