/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.countData.orderedEqualityTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;

public class OrderedEqualityTest
extends StatisticalTest {
    private DataTable data;
    private double[][] samples;
    private double N;
    private double Wx;
    private double Wy;
    private double Zright;
    private double Zleft;
    private double asymptoticRightTail;
    private double asymptoticLeftTail;
    private double asymptoticDoubleTail;

    public OrderedEqualityTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.Wx = 0.0;
        this.Wy = 0.0;
        this.samples = null;
        this.asymptoticRightTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public OrderedEqualityTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getRows() > 2 || this.data.getRows() < 2) {
            System.out.println("Data must be represented in two rows");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getRows() > 2 || this.data.getRows() < 2) {
            System.out.println("Data must be represented in two rows");
            this.clearData();
            return;
        }
        for (i = 0; i < newData.getColumns(); ++i) {
            if (newData.getRowNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int j;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        double[] sumColumns = new double[this.data.getColumns()];
        double[] ranks = new double[this.data.getColumns()];
        Arrays.fill(sumColumns, 0.0);
        double m = 0.0;
        double n = 0.0;
        this.N = 0.0;
        for (int j2 = 0; j2 < this.data.getColumns(); ++j2) {
            int n2 = j2;
            sumColumns[n2] = sumColumns[n2] + this.samples[0][j2];
            int n3 = j2;
            sumColumns[n3] = sumColumns[n3] + this.samples[1][j2];
            this.N += this.samples[0][j2];
            this.N += this.samples[1][j2];
            m += this.samples[0][j2];
            n += this.samples[1][j2];
        }
        ranks[0] = (1.0 + sumColumns[0]) / 2.0;
        double limit = sumColumns[0] + 1.0;
        for (j = 1; j < this.data.getColumns(); ++j) {
            ranks[j] = (limit + (sumColumns[j] + limit - 1.0)) / 2.0;
            limit += sumColumns[j];
        }
        this.Wx = 0.0;
        this.Wy = 0.0;
        for (j = 0; j < this.data.getColumns(); ++j) {
            this.Wx += ranks[j] * this.samples[0][j];
            this.Wy += ranks[j] * this.samples[1][j];
        }
        double sumTies = 0.0;
        for (int j3 = 0; j3 < this.data.getColumns(); ++j3) {
            sumTies += sumColumns[j3] * (sumColumns[j3] * sumColumns[j3] - 1.0);
        }
        double denominator = m * n * (m + n + 1.0) / 12.0;
        denominator -= m * n * sumTies / (12.0 * (m + n) * (m + n - 1.0));
        denominator = Math.sqrt(denominator);
        double numerator = this.Wx - 0.5 - m * (n + m + 1.0) / 2.0;
        this.Zright = numerator / denominator;
        numerator = this.Wx + 0.5 - m * (n + m + 1.0) / 2.0;
        this.Zleft = numerator / denominator;
        this.computePValues();
        this.performed = true;
    }

    private void computePValues() {
        NormalDistribution normal = new NormalDistribution();
        this.asymptoticRightTail = 1.0 - normal.getTipifiedProbability(this.Zright, false);
        this.asymptoticLeftTail = normal.getTipifiedProbability(this.Zleft, false);
        this.asymptoticDoubleTail = Math.min(Math.min(this.asymptoticLeftTail, this.asymptoticRightTail) * 2.0, 1.0);
    }

    public double getWx() {
        return this.Wx;
    }

    public double getWy() {
        return this.Wy;
    }

    public double getZleft() {
        return this.Zleft;
    }

    public double getZright() {
        return this.Zright;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        int j;
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n*************\n";
        report = report + "Multinomial equality test for ordered categories\n";
        report = report + "*************\n\n";
        report = report + "W statistic (first row): " + this.nf6.format(this.Wx) + "\n";
        report = report + "W statistic (second row): " + this.nf6.format(this.Wy) + "\n\n";
        report = report + "Asymptotic P-Values:\n";
        report = report + "Left tail p-Value (Y > X) :" + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Right tail p-Value (X > Y) :" + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Double tail p-Value (X != Y) :" + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        report = report + "Contingency table\n\n";
        for (j = 0; j < this.samples[0].length; ++j) {
            report = report + this.samples[0][j] + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.samples[1].length; ++j) {
            report = report + this.samples[1][j] + "\t";
        }
        report = report + "\n\n";
        return report;
    }
}

