/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.incompleteTable.Incomplete3KeyTable;
import javanpst.data.readers.distributionReaders.TotalNumberOfRunsReaderFormat;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TotalNumberOfRunsDistribution
extends TestDistribution {
    private NormalDistribution normal;
    private static Incomplete3KeyTable tableLeft;
    private static Incomplete3KeyTable tableRight;

    private TotalNumberOfRunsDistribution() {
        this.initialize();
    }

    public static TotalNumberOfRunsDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        tableLeft = new Incomplete3KeyTable(13, 19, 13);
        tableRight = new Incomplete3KeyTable(13, 18, 25);
        this.loadFiles();
        this.normal = new NormalDistribution();
    }

    @Override
    protected void loadFiles() {
        SAXParser sp;
        SAXParserFactory spf;
        try {
            spf = SAXParserFactory.newInstance();
            sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/TotalNumberOfRuns/TotalNumberOfRuns-Left.xml"), (DefaultHandler)new TotalNumberOfRunsReaderFormat(0));
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
        try {
            spf = SAXParserFactory.newInstance();
            sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/TotalNumberOfRuns/TotalNumberOfRuns-Right.xml"), (DefaultHandler)new TotalNumberOfRunsReaderFormat(1));
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Incomplete3KeyTable getTableLeft() {
        return tableLeft;
    }

    public static Incomplete3KeyTable getTableRight() {
        return tableRight;
    }

    public double computeLeftTailProbability(int a, int b, int R) {
        int n1 = Math.min(a, b);
        int n2 = Math.max(a, b);
        if (n1 > 12 || n1 < 9 && n1 + n2 > 20 || n1 > 8 && n2 > 12) {
            return -1.0;
        }
        double leftTail = tableLeft.get(n1, n2, R);
        double rightTail = tableRight.get(n1, n2, R + 1);
        if (leftTail == -1.0 && rightTail == -1.0) {
            return -1.0;
        }
        if (leftTail == -1.0) {
            leftTail = 1.0 - rightTail;
        }
        return leftTail;
    }

    public double computeRightTailProbability(int a, int b, int R) {
        int n1 = Math.min(a, b);
        int n2 = Math.max(a, b);
        if (n1 > 12 || n1 < 10 && n1 + n2 > 20 || n1 > 9 && n2 > 12) {
            return -1.0;
        }
        double leftTail = tableLeft.get(n1, n2, R - 1);
        double rightTail = tableRight.get(n1, n2, R);
        if (leftTail == -1.0 && rightTail == -1.0) {
            return -1.0;
        }
        if (rightTail == -1.0) {
            rightTail = 1.0 - leftTail;
        }
        return rightTail;
    }

    public double computeAsymptoticLeftTailProbability(int a, int b, int R) {
        double n1 = a;
        double n2 = b;
        double n = n1 + n2;
        double denominator = Math.sqrt(2.0 * n1 * n2 * (2.0 * n1 * n2 - n) / (n * n * (n - 1.0)));
        double numerator = (double)R + 0.5 - 1.0 - 2.0 * n1 * n2 / n;
        double z = numerator / denominator;
        return this.normal.getTipifiedProbability(z, false);
    }

    public double computeAsymptoticRightTailProbability(int a, int b, int R) {
        double n1 = a;
        double n2 = b;
        double n = n1 + n2;
        double denominator = Math.sqrt(2.0 * n1 * n2 * (2.0 * n1 * n2 - n) / (n * n * (n - 1.0)));
        double numerator = (double)R - 0.5 - 1.0 - 2.0 * n1 * n2 / n;
        double z = numerator / denominator;
        return this.normal.getTipifiedProbability(z, true);
    }

    public double computeAsymptoticDoubleTailProbability(int a, int b, int R) {
        double n1 = a;
        double n2 = b;
        double n = n1 + n2;
        double denominator = Math.sqrt(2.0 * n1 * n2 * (2.0 * n1 * n2 - n) / (n * n * (n - 1.0)));
        double numerator = (double)R - 0.5 - 1.0 - 2.0 * n1 * n2 / n;
        double z = numerator / denominator;
        double rightPValue = this.normal.getTipifiedProbability(z, true);
        numerator = (double)R + 0.5 - 1.0 - 2.0 * n1 * n2 / n;
        z = numerator / denominator;
        this.normal.getTipifiedProbability(z, false);
        double leftPValue = this.normal.getTipifiedProbability(z, false);
        return Math.min(Math.min(leftPValue, rightPValue) * 2.0, 1.0);
    }

    private static class SingletonHolder {
        public static final TotalNumberOfRunsDistribution distribution = new TotalNumberOfRunsDistribution();

        private SingletonHolder() {
        }
    }
}

