/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.criticalTable.Critical1KeyTable;
import javanpst.data.readers.distributionReaders.PartialCorrelationReaderFormat;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PartialCorrelationDistribution
extends TestDistribution {
    private static Critical1KeyTable table;

    private PartialCorrelationDistribution() {
        this.initialize();
    }

    public static PartialCorrelationDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        double[] tags = new double[]{0.005, 0.01, 0.025, 0.05};
        table = new Critical1KeyTable(31, tags);
        this.loadFiles();
    }

    @Override
    protected void loadFiles() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/PartialCorrelation/PartialCorrelation.xml"), (DefaultHandler)new PartialCorrelationReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Critical1KeyTable getTable() {
        return table;
    }

    public double computeProbability(int m, double tau) {
        tau = Math.abs(tau);
        if (m > 2 && m < 21 || m == 25 || m == 30) {
            for (int i = 0; i < 4; ++i) {
                if (!(tau >= table.get(m, i))) continue;
                return table.getHeader(i);
            }
            return 1.0;
        }
        return -1.0;
    }

    private static class SingletonHolder {
        public static final PartialCorrelationDistribution distribution = new PartialCorrelationDistribution();

        private SingletonHolder() {
        }
    }
}

