/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.criticalTable.Critical1KeyTable;
import javanpst.data.readers.distributionReaders.KolmogorovReaderFormat;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KolmogorovDistribution
extends TestDistribution {
    private static Critical1KeyTable table;

    private KolmogorovDistribution() {
        this.initialize();
    }

    public static KolmogorovDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        double[] tags = new double[]{0.2, 0.1, 0.05, 0.02, 0.01};
        table = new Critical1KeyTable(41, tags);
        this.loadFiles();
    }

    @Override
    protected void loadFiles() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/Kolmogorov/Kolmogorov.xml"), (DefaultHandler)new KolmogorovReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Critical1KeyTable getTable() {
        return table;
    }

    public double computeProbability(int n, double Dn) {
        double[] asymptoticValues = new double[]{1.07, 1.22, 1.36, 1.52, 1.63};
        if (n < 41) {
            if (table.get(n, 0) == -1.0) {
                return -1.0;
            }
            for (int i = 4; i > -1; --i) {
                if (!(Dn >= table.get(n, i))) continue;
                return table.getHeader(i);
            }
        } else {
            double size = Math.sqrt(n);
            for (int i = 4; i > -1; --i) {
                if (!(Dn >= asymptoticValues[i] / size)) continue;
                return table.getHeader(i);
            }
        }
        return 1.0;
    }

    private static class SingletonHolder {
        public static final KolmogorovDistribution distribution = new KolmogorovDistribution();

        private SingletonHolder() {
        }
    }
}

