/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.discrete;

import javanpst.distributions.common.Distribution;

public final class UniformDistribution
implements Distribution {
    private int n;

    public UniformDistribution() {
        this.n = 1;
    }

    public UniformDistribution(int n) {
        this.n = n;
    }

    public UniformDistribution(UniformDistribution old) {
        this(old.getN());
    }

    public void setN(int value) {
        if (value > 0) {
            this.n = value;
        }
    }

    public int getN() {
        return this.n;
    }

    @Override
    public double computeProbability(double value) {
        double prob = 0.0;
        int x = (int)Math.floor(value);
        prob = x < 1 ? 0.0 : (x <= this.n ? 1.0 / (double)this.n : 0.0);
        return prob;
    }

    @Override
    public double computeCumulativeProbability(double value) {
        double prob = 0.0;
        int x = (int)Math.floor(value);
        prob = x < 1 ? 0.0 : (x < this.n ? (double)x / (double)this.n : 1.0);
        return prob;
    }

    public String toString() {
        String text = "";
        text = text + "Uniform distribution. Parameters N:" + this.n;
        return text;
    }
}

