/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.structures.sequence;

import java.util.ArrayList;
import java.util.Collections;
import javanpst.data.readers.sequenceReaders.NumericSequenceCSVReader;
import javanpst.data.readers.sequenceReaders.NumericSequenceTXTReader;
import javanpst.data.readers.sequenceReaders.NumericSequenceXMLReader;
import javanpst.data.structures.sequence.Sequence;
import javanpst.data.writers.sequenceWriters.SequenceCSVWriter;
import javanpst.data.writers.sequenceWriters.SequenceTXTWriter;
import javanpst.data.writers.sequenceWriters.SequenceXMLWriter;

public class NumericSequence
extends Sequence {
    private ArrayList<Double> body;

    public NumericSequence() {
        this.body = new ArrayList();
    }

    public NumericSequence(ArrayList<Double> contents) {
        this.body = new ArrayList<Double>(contents);
    }

    public NumericSequence(double[] contents) {
        this.body = new ArrayList();
        for (int i = 0; i < contents.length; ++i) {
            this.body.add(contents[i]);
        }
    }

    public NumericSequence(NumericSequence copy) {
        this(copy.getSequence());
    }

    public ArrayList<Double> getSequence() {
        return this.body;
    }

    @Override
    public void append(Object value) {
        this.body.add((double)Double.valueOf(value.toString()));
    }

    @Override
    public void prepend(Object value) {
        this.body.add(0, (double)Double.valueOf(value.toString()));
    }

    @Override
    public int size() {
        return this.body.size();
    }

    public double get(int index) {
        if (index > -1 && index < this.body.size()) {
            return this.body.get(index);
        }
        return Double.NaN;
    }

    @Override
    public void clear() {
        this.body.clear();
    }

    public void sort() {
        Collections.sort(this.body);
    }

    @Override
    public String toString() {
        String text = "";
        for (Double s : this.body) {
            text = text + s + "*";
        }
        text = text.substring(0, text.length() - 1);
        return text;
    }

    @Override
    public void readXML(String file) {
        NumericSequenceXMLReader.readXMLSequence(file);
        this.body = NumericSequenceXMLReader.getSequence();
    }

    @Override
    public void writeXML(String file) {
        SequenceXMLWriter.writeNumericSequence(this.body, file);
    }

    @Override
    public void readCSV(String file) {
        NumericSequenceCSVReader.readCSVSequence(file);
        this.body = NumericSequenceCSVReader.getSequence();
    }

    @Override
    public void writeCSV(String file, boolean useComma) {
        SequenceCSVWriter.writeNumericSequence(this.body, file, useComma);
    }

    @Override
    public void readTXT(String file) {
        NumericSequenceTXTReader.readTXTSequence(file);
        this.body = NumericSequenceTXTReader.getSequence();
    }

    @Override
    public void writeTXT(String file) {
        SequenceTXTWriter.writeNumericSequence(this.body, file);
    }
}

