/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.distributions.incompleteTable;

import java.util.Arrays;

public class Incomplete2KeyTable {
    private int[] dimensions = new int[2];
    private double[][] body;

    public Incomplete2KeyTable(int dim1, int dim2) {
        this.dimensions[0] = dim1;
        this.dimensions[1] = dim2;
        this.body = new double[dim1][dim2];
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.dimensions[0]; ++i) {
            Arrays.fill(this.body[i], -1.0);
        }
    }

    public void erase(int dim1, int dim2) {
        if (dim1 >= 0 && dim1 < this.dimensions[0] && dim2 >= 0 && dim2 < this.dimensions[1]) {
            this.body[dim1][dim2] = -1.0;
        }
    }

    public void add(int dim1, int dim2, double value) {
        if (dim1 >= 0 && dim1 < this.dimensions[0] && dim2 >= 0 && dim2 < this.dimensions[1]) {
            this.body[dim1][dim2] = value;
        }
    }

    public double get(int dim1, int dim2) {
        double value = dim1 >= 0 && dim1 < this.dimensions[0] && dim2 >= 0 && dim2 < this.dimensions[1] ? this.body[dim1][dim2] : -1.0;
        return value;
    }
}

