/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseQuadratic_F64;
import georegression.struct.shapes.EllipseRotated_F64;

public class UtilEllipse_F64 {
    public static EllipseRotated_F64 convert(EllipseQuadratic_F64 input, EllipseRotated_F64 output) {
        double dy;
        double dx;
        if (output == null) {
            output = new EllipseRotated_F64();
        }
        double a11 = input.a;
        double a12 = input.b;
        double a22 = input.c;
        double b1 = 2.0 * input.d;
        double b2 = 2.0 * input.e;
        double c = input.f;
        output.center.x = (a22 * b1 - a12 * b2) / (2.0 * (a12 * a12 - a11 * a22));
        output.center.y = (a11 * b2 - a12 * b1) / (2.0 * (a12 * a12 - a11 * a22));
        double k1 = output.center.x;
        double k2 = output.center.y;
        double mu = 1.0 / (a11 * k1 * k1 + 2.0 * a12 * k1 * k2 + a22 * k2 * k2 - c);
        double m11 = mu * a11;
        double m12 = mu * a12;
        double m22 = mu * a22;
        double inner = Math.sqrt((m11 - m22) * (m11 - m22) + 4.0 * m12 * m12);
        double l1 = (m11 + m22 + inner) / 2.0;
        double l2 = (m11 + m22 - inner) / 2.0;
        output.b = 1.0 / Math.sqrt(l1);
        output.a = 1.0 / Math.sqrt(l2);
        if (m11 >= m22) {
            dx = l1 - m22;
            dy = m12;
        } else {
            dx = m12;
            dy = l1 - m11;
        }
        output.phi = Math.atan2(-dx, dy);
        if (output.phi < -GrlConstants.PId2) {
            output.phi += Math.PI;
        } else if (output.phi > GrlConstants.PId2) {
            output.phi -= Math.PI;
        }
        return output;
    }

    public static EllipseQuadratic_F64 convert(EllipseRotated_F64 input, EllipseQuadratic_F64 output) {
        if (output == null) {
            output = new EllipseQuadratic_F64();
        }
        double x0 = input.center.x;
        double y0 = input.center.y;
        double a = input.a;
        double b = input.b;
        double phi = input.phi;
        double cphi = Math.cos(phi);
        double sphi = Math.sin(phi);
        double cphi2 = cphi * cphi;
        double sphi2 = sphi * sphi;
        double a2 = a * a;
        double b2 = b * b;
        double x02 = x0 * x0;
        double y02 = y0 * y0;
        output.a = cphi2 / a2 + sphi2 / b2;
        output.b = sphi * cphi / a2 - sphi * cphi / b2;
        output.c = sphi2 / a2 + cphi2 / b2;
        output.d = -x0 * cphi2 / a2 - y0 * sphi * cphi / a2 - x0 * sphi2 / b2 + y0 * sphi * cphi / b2;
        output.e = -x0 * sphi * cphi / a2 - y0 * sphi2 / a2 + x0 * sphi * cphi / b2 - y0 * cphi2 / b2;
        output.f = x02 * cphi2 / a2 + 2.0 * x0 * y0 * sphi * cphi / a2 + y02 * sphi2 / a2 + x02 * sphi2 / b2 - 2.0 * x0 * y0 * sphi * cphi / b2 + y02 * cphi2 / b2 - 1.0;
        return output;
    }

    public static double evaluate(double x, double y, EllipseQuadratic_F64 ellipse) {
        return ellipse.a * x * x + 2.0 * ellipse.b * x * y + ellipse.c * y * y + 2.0 * ellipse.d * x + 2.0 * ellipse.e * y + ellipse.f;
    }

    public static double evaluate(double x, double y, EllipseRotated_F64 ellipse) {
        double cphi = Math.cos(ellipse.phi);
        double sphi = Math.sin(ellipse.phi);
        double left = (x -= ellipse.center.x) * cphi + (y -= ellipse.center.y) * sphi;
        double right = -x * sphi + y * cphi;
        return left * left / (ellipse.a * ellipse.a) + right * right / (ellipse.b * ellipse.b);
    }

    public static Point2D_F64 computePoint(double t, EllipseRotated_F64 ellipse, Point2D_F64 output) {
        if (output == null) {
            output = new Point2D_F64();
        }
        double ct = Math.cos(t);
        double st = Math.sin(t);
        double cphi = Math.cos(ellipse.phi);
        double sphi = Math.sin(ellipse.phi);
        output.x = ellipse.center.x + ellipse.a * ct * cphi - ellipse.b * st * sphi;
        output.y = ellipse.center.y + ellipse.a * ct * sphi + ellipse.b * st * cphi;
        return output;
    }

    public static double computeAngle(Point2D_F64 p, EllipseRotated_F64 ellipse) {
        double ce = Math.cos(ellipse.phi);
        double se = Math.sin(ellipse.phi);
        double xc = p.x - ellipse.center.x;
        double yc = p.y - ellipse.center.y;
        double x = ce * xc + se * yc;
        double y = -se * xc + ce * yc;
        return Math.atan2(y / ellipse.b, x / ellipse.a);
    }
}

