/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.se;

import georegression.fitting.MotionTransformPoint;
import georegression.geometry.ConvertRotation3D_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.geometry.UtilPoint3D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.Se3_F32;
import georegression.struct.so.Quaternion_F32;
import java.util.List;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleEVD;
import org.ejml.simple.SimpleMatrix;

public class MotionSe3PointCrossCovariance_F32
implements MotionTransformPoint<Se3_F32, Point3D_F32> {
    private float[] param = new float[7];
    private Se3_F32 motion = new Se3_F32();
    private Quaternion_F32 quat = new Quaternion_F32();

    public float[] getParam() {
        return this.param;
    }

    @Override
    public Se3_F32 getTransformSrcToDst() {
        return this.motion;
    }

    @Override
    public boolean process(List<Point3D_F32> srcPts, List<Point3D_F32> dstPts) {
        if (srcPts.size() != dstPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        Point3D_F32 meanFrom = UtilPoint3D_F32.mean(srcPts, null);
        Point3D_F32 meanTo = UtilPoint3D_F32.mean(dstPts, null);
        int N = srcPts.size();
        float s11 = 0.0f;
        float s12 = 0.0f;
        float s13 = 0.0f;
        float s21 = 0.0f;
        float s22 = 0.0f;
        float s23 = 0.0f;
        float s31 = 0.0f;
        float s32 = 0.0f;
        float s33 = 0.0f;
        float m11 = meanFrom.x * meanTo.x;
        float m12 = meanFrom.x * meanTo.y;
        float m13 = meanFrom.x * meanTo.z;
        float m21 = meanFrom.y * meanTo.x;
        float m22 = meanFrom.y * meanTo.y;
        float m23 = meanFrom.y * meanTo.z;
        float m31 = meanFrom.z * meanTo.x;
        float m32 = meanFrom.z * meanTo.y;
        float m33 = meanFrom.z * meanTo.z;
        for (int i = 0; i < N; ++i) {
            Point3D_F32 f = srcPts.get(i);
            Point3D_F32 t = dstPts.get(i);
            s11 += f.x * t.x;
            s12 += f.x * t.y;
            s13 += f.x * t.z;
            s21 += f.y * t.x;
            s22 += f.y * t.y;
            s23 += f.y * t.z;
            s31 += f.z * t.x;
            s32 += f.z * t.y;
            s33 += f.z * t.z;
        }
        s11 = s11 / (float)N - m11;
        s12 = s12 / (float)N - m12;
        s13 = s13 / (float)N - m13;
        s21 = s21 / (float)N - m21;
        s22 = s22 / (float)N - m22;
        s23 = s23 / (float)N - m23;
        s31 = s31 / (float)N - m31;
        s32 = s32 / (float)N - m32;
        s33 = s33 / (float)N - m33;
        SimpleMatrix Sigma = new SimpleMatrix(3, 3, true, s11, s12, s13, s21, s22, s23, s31, s32, s33);
        SimpleMatrix Delta = new SimpleMatrix(3, 1, true, s23 - s32, s31 - s13, s12 - s21);
        SimpleMatrix Q = new SimpleMatrix(4, 4);
        SimpleMatrix BR = (SimpleMatrix)((SimpleMatrix)Sigma.plus(Sigma.transpose())).minus(SimpleMatrix.identity(3).scale(Sigma.trace()));
        Q.set(0, 0, Sigma.trace());
        Q.insertIntoThis(0, 1, Delta.transpose());
        Q.insertIntoThis(1, 0, Delta);
        Q.insertIntoThis(1, 1, BR);
        this.extractQuaternionFromQ(Q);
        GeometryMath_F32.mult(this.motion.getR(), meanFrom, meanFrom);
        Vector3D_F32 T = this.motion.getT();
        this.param[4] = T.x = meanTo.x - meanFrom.x;
        this.param[5] = T.y = meanTo.y - meanFrom.y;
        this.param[6] = T.z = meanTo.z - meanFrom.z;
        return true;
    }

    private void extractQuaternionFromQ(SimpleMatrix q) {
        SimpleEVD evd = q.eig();
        int indexMax = evd.getIndexMax();
        Object v_max = evd.getEigenVector(indexMax);
        this.quat.w = (float)((SimpleBase)v_max).get(0);
        this.quat.x = (float)((SimpleBase)v_max).get(1);
        this.quat.y = (float)((SimpleBase)v_max).get(2);
        this.quat.z = (float)((SimpleBase)v_max).get(3);
        this.quat.normalize();
        ConvertRotation3D_F32.quaternionToMatrix(this.quat, this.motion.getR());
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

