/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.se;

import georegression.fitting.MotionTransformPoint;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se2_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class MotionSe2PointSVD_F64
implements MotionTransformPoint<Se2_F64, Point2D_F64> {
    Se2_F64 motion = new Se2_F64();
    Point2D_F64 meanFrom = new Point2D_F64();
    Point2D_F64 meanTo = new Point2D_F64();
    SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd(2, 2, true, true, false);
    DenseMatrix64F Sigma = new DenseMatrix64F(2, 2);
    DenseMatrix64F U = new DenseMatrix64F(2, 2);
    DenseMatrix64F V = new DenseMatrix64F(2, 2);
    DenseMatrix64F R = new DenseMatrix64F(2, 2);

    @Override
    public Se2_F64 getTransformSrcToDst() {
        return this.motion;
    }

    @Override
    public boolean process(List<Point2D_F64> srcPts, List<Point2D_F64> dstPts) {
        if (srcPts.size() != dstPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        UtilPoint2D_F64.mean(srcPts, this.meanFrom);
        UtilPoint2D_F64.mean(dstPts, this.meanTo);
        int N = srcPts.size();
        double s11 = 0.0;
        double s12 = 0.0;
        double s21 = 0.0;
        double s22 = 0.0;
        double m11 = this.meanFrom.x * this.meanTo.x;
        double m12 = this.meanFrom.x * this.meanTo.y;
        double m21 = this.meanFrom.y * this.meanTo.x;
        double m22 = this.meanFrom.y * this.meanTo.y;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 f = srcPts.get(i);
            Point2D_F64 t = dstPts.get(i);
            s11 += f.x * t.x;
            s12 += f.x * t.y;
            s21 += f.y * t.x;
            s22 += f.y * t.y;
        }
        s11 = s11 / (double)N - m11;
        s12 = s12 / (double)N - m12;
        s21 = s21 / (double)N - m21;
        s22 = s22 / (double)N - m22;
        this.Sigma.data[0] = s11;
        this.Sigma.data[1] = s12;
        this.Sigma.data[2] = s21;
        this.Sigma.data[3] = s22;
        if (!this.svd.decompose(this.Sigma)) {
            return false;
        }
        this.svd.getU(this.U, false);
        this.svd.getV(this.V, false);
        CommonOps.multTransB(this.V, this.U, this.R);
        double det = CommonOps.det(this.R);
        if (det < 0.0) {
            for (int i = 0; i < 2; ++i) {
                this.V.set(i, 1, -this.V.get(i, 1));
            }
            CommonOps.multTransB(this.V, this.U, this.R);
            det = CommonOps.det(this.R);
            if (det < 0.0) {
                throw new RuntimeException("Crap");
            }
        }
        double yaw = Math.atan2(this.R.get(1, 0), this.R.get(0, 0));
        GeometryMath_F64.rotate(yaw, this.meanFrom, this.meanFrom);
        this.motion.getTranslation().x = this.meanTo.x - this.meanFrom.x;
        this.motion.getTranslation().y = this.meanTo.y - this.meanFrom.y;
        this.motion.setYaw(yaw);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

