/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.CantComputeException;
import debuxter.DExtractor;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

class GaugeGauge
extends Panel
implements TextListener {
    TextField start;
    TextField end;
    int naturalx = 0;
    int naturaly = 0;
    boolean vertical;
    GridBagLayout layout = new GridBagLayout();
    Checkbox islog;
    DExtractor parent;
    static final long serialVersionUID = 20060308L;

    GaugeGauge(String variable, Color bgcolor, boolean vertical, DExtractor parent) {
        int labelalign;
        GridBagConstraints c = new GridBagConstraints();
        String[] labels = new String[]{"0", "1"};
        this.vertical = vertical;
        this.parent = parent;
        this.setForeground(bgcolor);
        this.setLayout(this.layout);
        this.start = new TextField("", 8);
        this.end = new TextField("", 8);
        this.islog = new Checkbox("log", false);
        if (vertical) {
            String tmp = labels[0];
            labels[0] = labels[1];
            labels[1] = tmp;
            c.fill = 1;
            c.gridwidth = 0;
            labelalign = 0;
        } else {
            c.fill = 2;
            labelalign = 2;
        }
        c.weighty = 0.5;
        c.weightx = 0.0;
        Label lab = new Label(variable + labels[0], labelalign);
        this.layout.setConstraints(lab, c);
        this.add(lab);
        c.weightx = 0.5;
        c.weighty = 0.5;
        TextField nf = vertical ? this.end : this.start;
        this.layout.setConstraints(nf, c);
        this.add(nf);
        nf.addKeyListener(new NumOnly());
        nf.addTextListener(this);
        int oldfill = c.fill;
        c.fill = 0;
        this.layout.setConstraints(this.islog, c);
        this.add(this.islog);
        c.fill = oldfill;
        lab = new Label(variable + labels[1], labelalign);
        c.weightx = 0.0;
        c.weighty = 0.5;
        this.layout.setConstraints(lab, c);
        this.add(lab);
        c.weightx = 0.5;
        c.weighty = 0.5;
        nf = vertical ? this.start : this.end;
        this.layout.setConstraints(nf, c);
        this.add(nf);
        nf.addKeyListener(new NumOnly());
        nf.addTextListener(this);
    }

    public double getstart() {
        return new Double(this.start.getText());
    }

    public double getend() {
        return new Double(this.end.getText());
    }

    public int computeUsefulSignificantDigits() {
        try {
            return Math.max(4, (int)Math.round(-Math.log(Math.abs(this.getend() - this.getstart()) / this.getstart()) / 2.3 + 4.0));
        }
        catch (NumberFormatException e) {
            return 4;
        }
    }

    public boolean isLogAxis() {
        return this.islog.getState();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.layout.preferredLayoutSize(this);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void textValueChanged(TextEvent ev) {
        try {
            this.parent.computeTransform();
        }
        catch (CantComputeException cantComputeException) {
            // empty catch block
        }
    }

    private class NumOnly
    extends KeyAdapter {
        private NumOnly() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            char c = e.getKeyChar();
            if (c >= ' ' && (c < '0' || c > '9') && c != '-' && c != '+' && c != 'e' && c != '.' && c != 'E') {
                e.consume();
            }
        }
    }
}

