/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.ImageWithPoints;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class Gauge {
    Point start;
    Point end;
    public boolean horiz;
    Color hcolor;
    Color vcolor;
    Rectangle startListen = null;
    Rectangle endListen = null;
    int listenSize = 6;
    int iAmDragging = 0;
    ImageWithPoints parent;
    boolean horizLock = false;

    Gauge(ImageWithPoints parent, int sx, int sy, int ex, int ey) {
        this.parent = parent;
        this.setStart(sx, sy);
        this.setEnd(ex, ey);
        this.hcolor = new Color(255, 0, 0);
        this.vcolor = new Color(0, 0, 255);
        this.sethoriz();
    }

    void sethoriz() {
        if (this.horizLock || this.start == null || this.end == null) {
            return;
        }
        this.horiz = Math.abs(this.start.x - this.end.x) > Math.abs(this.start.y - this.end.y);
    }

    public void setStart(int ex, int ey) {
        this.start = new Point(ex, ey);
        this.startListen = new Rectangle(ex - this.listenSize / 2, ey - this.listenSize / 2, this.listenSize, this.listenSize);
        this.sethoriz();
    }

    public void setEnd(int ex, int ey) {
        this.end = new Point(ex, ey);
        this.endListen = new Rectangle(ex - this.listenSize / 2, ey - this.listenSize / 2, this.listenSize, this.listenSize);
        this.sethoriz();
    }

    public void normalise() {
        if (this.horiz) {
            if (this.start.x > this.end.x) {
                Point tmp = this.start;
                this.setStart(this.end.x, this.end.y);
                this.setEnd(tmp.x, tmp.y);
            }
        } else if (this.start.y < this.end.y) {
            Point tmp = this.start;
            this.setStart(this.end.x, this.end.y);
            this.setEnd(tmp.x, tmp.y);
        }
    }

    public synchronized void paint(Graphics g) {
        if (this.horiz) {
            g.setColor(this.hcolor);
        } else {
            g.setColor(this.vcolor);
        }
        g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
        int dx = this.start.x - this.end.x;
        int dy = this.start.y - this.end.y;
        double scale = 10.0 / Math.sqrt(dx * dx + dy * dy);
        g.drawLine((int)Math.round((double)this.start.x - (double)(dy / 2) * scale), (int)Math.round((double)this.start.y + (double)(dx / 2) * scale), (int)Math.round((double)this.start.x + (double)(dy / 2) * scale), (int)Math.round((double)this.start.y - (double)(dx / 2) * scale));
        g.drawLine((int)Math.round((double)this.end.x - (double)(dy / 2) * scale), (int)Math.round((double)this.end.y + (double)(dx / 2) * scale), (int)Math.round((double)this.end.x + (double)(dy / 2) * scale), (int)Math.round((double)this.end.y - (double)(dx / 2) * scale));
    }

    public Rectangle bbox() {
        int x0 = Math.min(this.start.x, this.end.x);
        int y0 = Math.min(this.start.y, this.end.y);
        int w = Math.abs(this.start.x - this.end.x);
        int h = Math.abs(this.start.y - this.end.y);
        return new Rectangle(x0 - 10, y0 - 10, w + 20, h + 20);
    }

    public double length() {
        int dx = this.start.x - this.end.x;
        int dy = this.start.y - this.end.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public void newScale(int oldscale, int newscale) {
        this.start.x = Math.round((float)(this.start.x * oldscale) / (float)newscale);
        this.start.y = this.start.y * oldscale / newscale;
        this.end.x = this.end.x * oldscale / newscale;
        this.end.y = this.end.y * oldscale / newscale;
    }

    public void mousePressed(MouseEvent e) {
        if (this.startListen != null && this.startListen.contains(e.getPoint())) {
            this.iAmDragging = 1;
            this.horizLock = true;
            e.consume();
        }
        if (this.endListen != null && this.endListen.contains(e.getPoint())) {
            this.iAmDragging = 2;
            this.horizLock = true;
            e.consume();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.iAmDragging != 0) {
            this.mouseDragged(e);
            e.consume();
            this.iAmDragging = 0;
            this.parent.setGauge(this);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.iAmDragging == 0) {
            return;
        }
        Rectangle obb = this.bbox();
        if (this.iAmDragging == 1) {
            this.setStart(e.getX(), e.getY());
        }
        if (this.iAmDragging == 2) {
            this.setEnd(e.getX(), e.getY());
        }
        this.parent.makeImage(this.bbox().union(obb));
    }
}

