/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.AlertBox;
import debuxter.AppletDataDeliverer;
import debuxter.AppletImageGetter;
import debuxter.DExtractor;
import debuxter.MainServices;
import debuxter.ScrollImScrollBar;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.net.MalformedURLException;
import java.net.URL;

public class Dexter
extends Applet
implements MainServices {
    DExtractor worker;
    String imageURL;
    int scale;
    ScrollImScrollBar sel = null;
    DExtractor window = null;
    String sourcebib;
    String sourcepage;
    boolean onIndexedDisplay = false;
    AppletImageGetter imageGetter;
    AppletDataDeliverer dataDeliverer = new AppletDataDeliverer(this);
    Color xAxisColor;
    Color yAxisColor;
    static final long serialVersionUID = 20060308L;

    @Override
    public void init() {
        ColorModel colormodel = Toolkit.getDefaultToolkit().getColorModel();
        if (colormodel instanceof IndexColorModel) {
            this.onIndexedDisplay = true;
        }
        try {
            this.scale = Integer.parseInt(this.getParameter("DEFAULTSCALE"));
        }
        catch (NumberFormatException e) {
            this.scale = 8;
        }
        this.imageURL = this.getParameter("SOURCEIMAGE");
        this.imageGetter = new AppletImageGetter(this, this.imageURL);
        Image fullpg = this.imageGetter.getImage(this.scale);
        try {
            this.sourcebib = this.getParameter("BIBCODE");
        }
        catch (NumberFormatException e) {
            this.sourcebib = "unknown";
        }
        try {
            this.sourcepage = this.getParameter("PAGE");
        }
        catch (NumberFormatException e) {
            this.sourcepage = "unknown";
        }
        try {
            this.xAxisColor = this.makeColor(this.getParameter("XAXISCOLOR"));
        }
        catch (Exception e) {
            this.xAxisColor = new Color(200, 0, 0);
        }
        try {
            this.yAxisColor = this.makeColor(this.getParameter("YAXISCOLOR"));
        }
        catch (Exception e) {
            this.yAxisColor = new Color(50, 50, 255);
        }
        try {
            this.sel = new ScrollImScrollBar(this, fullpg, this.onIndexedDisplay);
        }
        catch (Exception e) {
            System.out.println("Yikes -- no image.  I'm dying.");
        }
        this.setLayout(new GridLayout(1, 1));
    }

    @Override
    public void start() {
        if (this.sel == null) {
            Graphics g = this.getGraphics();
            if (g != null) {
                try {
                    g.setColor(Color.black);
                    g.drawString("Could not connect to image source.\n  Check your java console.", 10, 10);
                }
                finally {
                    g.dispose();
                }
            }
        } else {
            this.add(this.sel);
            this.validate();
            this.sel.doLayout();
        }
    }

    protected void closeWindow() {
        if (this.window != null) {
            if (this.window.isShowing()) {
                this.window.closeWin();
            }
            this.window = null;
        }
    }

    @Override
    public void stop() {
        if (this.sel != null) {
            this.remove(this.sel);
        }
        this.closeWindow();
    }

    @Override
    public void destroy() {
    }

    @Override
    public synchronized void paint(Graphics g) {
    }

    @Override
    public void notifySelection(Rectangle bbox) {
        if (bbox.width < 50 || bbox.height < 50) {
            return;
        }
        this.closeWindow();
        bbox.x *= this.scale;
        bbox.y *= this.scale;
        bbox.width *= this.scale;
        bbox.height *= this.scale;
        try {
            this.window = new DExtractor(this, bbox, this.sourcebib, this.sourcepage, this.imageGetter, this.dataDeliverer, this.xAxisColor, this.yAxisColor);
            this.window.setTitle("Dexter");
            this.window.pack();
            this.window.setVisible(true);
        }
        catch (SecurityException e) {
            new AlertBox(this.getEnclosingFrame(), "Dexter Error", "I am not allowed to open a window\non this machine.\n Please review the security options\n for your virtual machine and allow me to open windows.  Thank you.");
        }
    }

    protected Frame getEnclosingFrame() {
        Container parentComponent;
        for (parentComponent = this.getParent(); parentComponent != null && !(parentComponent instanceof Frame); parentComponent = parentComponent.getParent()) {
        }
        return (Frame)parentComponent;
    }

    @Override
    public void childClosed() {
        this.window = null;
    }

    @Override
    public void notifyChangedSize() {
    }

    @Override
    public void showHelp() {
        try {
            this.getAppletContext().showDocument(new URL(this.getDocumentBase() + "/Dexterhelp.html"), "_new");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public String getAppletInfo() {
        return "Dexter by Markus Demleitner (ads@cfa.harvard.edu), a little tool to extract data from graphs";
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"DEFAULTSCALE", "int", "initial scale in extraction window"}, {"SOURCEIMAGEDEFAULTSCALE", "int", "initial scale in extraction window"}, {"SOURCEIMAGE", "URL", "URL of CGI that produces the image"}, {"BIBCODE", "String", "Bibcode of article (for file name)"}, {"PAGE", "int", "Page within article (for file name)"}, {"XAXISCOLOR", "String", "Color of x axis marker in rrggbb format (hex chars)"}, {"YAXISCOLOR", "String", "Color of y axis marker in rrggbb format (hex chars)"}};
        return info;
    }

    private Color makeColor(String colorSpec) {
        return new Color(Integer.parseInt(colorSpec.substring(0, 2), 16), Integer.parseInt(colorSpec.substring(2, 4), 16), Integer.parseInt(colorSpec.substring(4, 6), 16));
    }
}

