/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import java.util.Vector;
import jv.geom.PgEdgeStar;
import jv.geom.PgPointSet;
import jv.geom.PgTetraSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwTetraRivara
extends PjWorkshop {
    private static final int NUM = 4;
    private PgTetraSet m_geom;
    private int[] m_tetraRefinementEdge = new int[0];
    private PiVector[] m_faceRefinementEdge = new PiVector[0];
    private int[] m_refinementType = new int[0];
    static /* synthetic */ Class class$jvx$volume$PwTetraRivara;

    public PwTetraRivara() {
        super(PsConfig.getMessage((boolean)true, (int)54000, (String)"Rivara Bisection"));
        if (((Object)((Object)this)).getClass() == (class$jvx$volume$PwTetraRivara == null ? (class$jvx$volume$PwTetraRivara = PwTetraRivara.class$("jvx.volume.PwTetraRivara")) : class$jvx$volume$PwTetraRivara)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void reset() {
        super.reset();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgPointSet)) {
            PsDebug.warning((String)"workshop requires instance of PgPointSet.");
            return;
        }
        super.setGeometry(pgGeometry);
        this.m_geom = (PgTetraSet)pgGeometry;
        this.assureRefinement();
        this.makeRefinementEdges();
        this.makeRefinementType();
    }

    public void refineGlobalIntoEight() {
        PwTetraRivara.refineGlobalIntoEight(this.m_geom);
    }

    public static void refineGlobalIntoEight(PgTetraSet pgTetraSet) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = pgTetraSet.getNumVertices();
        Vector<Object> vector = new Vector<Object>();
        for (n7 = 0; n7 < n8; ++n7) {
            vector.addElement(null);
        }
        n7 = pgTetraSet.getNumTetras();
        if (n7 == 0) {
            return;
        }
        pgTetraSet.setNumTetras(8 * n7);
        PgEdgeStar[] pgEdgeStarArray = pgTetraSet.makeEdgeStars();
        if (pgEdgeStarArray == null) {
            return;
        }
        int n9 = pgEdgeStarArray.length;
        int[] nArray = new int[n8];
        for (int i = 0; i < n9; ++i) {
            int n10 = n6 = pgEdgeStarArray[i].getVertexInd(0);
            nArray[n10] = nArray[n10] + 1;
        }
        int[][] nArrayArray = new int[n8][];
        n6 = 0;
        for (int i = 0; i < n8; ++i) {
            nArrayArray[i] = new int[nArray[i]];
            for (n5 = 0; n5 < nArray[i]; ++n5) {
                nArrayArray[i][n5] = n6++;
            }
        }
        pgTetraSet.setNumVertices(n8 + n9);
        PdVector[] pdVectorArray = pgTetraSet.getVertices();
        for (n5 = 0; n5 < n8; ++n5) {
            for (n4 = 0; n4 < nArray[n5]; ++n4) {
                int n11 = nArrayArray[n5][n4];
                n3 = n8 + nArrayArray[n5][n4];
                n2 = pgEdgeStarArray[n11].getVertexInd(0);
                n = pgEdgeStarArray[n11].getVertexInd(1);
                pdVectorArray[n3].blend(0.5, pdVectorArray[n2], 0.5, pdVectorArray[n]);
            }
        }
        int[] nArray2 = new int[10];
        n4 = n7;
        PiVector[] piVectorArray = pgTetraSet.getTetras();
        for (n3 = 0; n3 < n7; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                nArray2[n2] = piVectorArray[n3].m_data[n2];
            }
            for (n2 = 4; n2 < 10; ++n2) {
                int n12;
                n = piVectorArray[n3].m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n2 - 4][0]];
                int n13 = piVectorArray[n3].m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n2 - 4][1]];
                if (n > n13) {
                    n12 = n;
                    n = n13;
                    n13 = n12;
                }
                n12 = nArrayArray[n][0];
                for (int i = 0; i < nArray[n]; ++i) {
                    if (pgEdgeStarArray[n12].getVertexInd(1) == n13) continue;
                    ++n12;
                }
                nArray2[n2] = n8 + n12;
            }
            piVectorArray[n3].set(nArray2[0], nArray2[6], nArray2[5], nArray2[7]);
            piVectorArray[n4++].set(nArray2[6], nArray2[1], nArray2[4], nArray2[8]);
            piVectorArray[n4++].set(nArray2[5], nArray2[4], nArray2[2], nArray2[9]);
            piVectorArray[n4++].set(nArray2[5], nArray2[9], nArray2[8], nArray2[4]);
            piVectorArray[n4++].set(nArray2[5], nArray2[4], nArray2[8], nArray2[6]);
            piVectorArray[n4++].set(nArray2[7], nArray2[8], nArray2[6], nArray2[5]);
            piVectorArray[n4++].set(nArray2[7], nArray2[5], nArray2[9], nArray2[8]);
            piVectorArray[n4++].set(nArray2[7], nArray2[8], nArray2[9], nArray2[3]);
            if (!pgTetraSet.hasTetraColors()) continue;
            for (n2 = n4 - 7; n2 < n4; ++n2) {
                pgTetraSet.setTetraColor(n2, pgTetraSet.getTetraColor(n3));
            }
        }
        pgTetraSet.makeNeighbour();
    }

    private int addTetra(PiVector piVector) {
        int[] nArray;
        int n = this.m_geom.addTetra(piVector);
        if (n == -1) {
            return -1;
        }
        int n2 = this.m_tetraRefinementEdge.length;
        int n3 = this.m_geom.getMaxNumTetras();
        if (n2 != n3) {
            nArray = new int[n3];
            System.arraycopy(this.m_tetraRefinementEdge, 0, nArray, 0, n3 <= n2 ? n3 : n2);
            this.m_tetraRefinementEdge = nArray;
        }
        this.m_faceRefinementEdge = PiVector.realloc((PiVector[])this.m_faceRefinementEdge, (int)n3, (int)4);
        n2 = this.m_refinementType.length;
        if (n2 != n3) {
            nArray = new int[n3];
            System.arraycopy(this.m_refinementType, 0, nArray, 0, n3 <= n2 ? n3 : n2);
            this.m_refinementType = nArray;
        }
        return n;
    }

    private void assureRefinement() {
        int[] nArray;
        int n = this.m_tetraRefinementEdge.length;
        int n2 = this.m_geom.getNumTetras();
        if (n != n2) {
            nArray = new int[n2];
            System.arraycopy(this.m_tetraRefinementEdge, 0, nArray, 0, n2 <= n ? n2 : n);
            this.m_tetraRefinementEdge = nArray;
        }
        if ((n = this.m_faceRefinementEdge.length) != n2) {
            this.m_faceRefinementEdge = PiVector.realloc((PiVector[])this.m_faceRefinementEdge, (int)n2, (int)4);
        }
        for (n = 0; n < n2; ++n) {
            this.m_faceRefinementEdge[n].setConstant(-1);
        }
        n = this.m_refinementType.length;
        if (n != n2) {
            nArray = new int[n2];
            System.arraycopy(this.m_refinementType, 0, nArray, 0, n2 <= n ? n2 : n);
            this.m_refinementType = nArray;
        }
    }

    private int findRefinementEdgeInTriangle(int n, int n2, int n3) {
        if (n == n2 || n2 == n3 || n3 == n) {
            return -1;
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        double d = Math.abs(PdVector.dist((PdVector)pdVectorArray[n2], (PdVector)pdVectorArray[n3]));
        double d2 = Math.abs(PdVector.dist((PdVector)pdVectorArray[n], (PdVector)pdVectorArray[n3]));
        double d3 = Math.abs(PdVector.dist((PdVector)pdVectorArray[n], (PdVector)pdVectorArray[n2]));
        int n4 = d > d2 ? (d > d3 ? 0 : (d3 > d ? 2 : (n3 < n ? 0 : 2))) : (d2 > d ? (d2 > d3 ? 1 : (d3 > d2 ? 2 : (n3 < n2 ? 1 : 2))) : (d3 > d ? 2 : (d > d3 ? (n2 < n ? 0 : 1) : (n < n3 ? (n2 < n3 ? 2 : 1) : (n < n2 ? 1 : 0)))));
        return n4;
    }

    private int[] makeAdjustment(int n) {
        int[] nArray = null;
        int[] nArray2 = null;
        PiVector[] piVectorArray = this.m_geom.getTetras();
        int[] nArray3 = piVectorArray[n].m_data;
        switch (this.m_tetraRefinementEdge[n]) {
            case 0: {
                if (nArray3[1] < nArray3[2]) {
                    nArray = new int[]{1, 2, 0, 3};
                    nArray2 = new int[]{2, 0, 1, 5, 3, 4};
                    break;
                }
                nArray = new int[]{2, 1, 3, 0};
                nArray2 = new int[]{2, 3, 4, 5, 0, 1};
                break;
            }
            case 1: {
                if (nArray3[0] < nArray3[2]) {
                    nArray = new int[]{0, 2, 3, 1};
                    nArray2 = new int[]{4, 2, 3, 1, 5, 0};
                    break;
                }
                nArray = new int[]{2, 0, 1, 3};
                nArray2 = new int[]{1, 2, 0, 4, 5, 3};
                break;
            }
            case 2: {
                if (nArray3[0] < nArray3[1]) {
                    nArray = new int[]{0, 1, 2, 3};
                    nArray2 = new int[]{0, 1, 2, 3, 4, 5};
                    break;
                }
                nArray = new int[]{1, 0, 3, 2};
                nArray2 = new int[]{3, 4, 2, 0, 1, 5};
                break;
            }
            case 3: {
                if (nArray3[0] < nArray3[3]) {
                    nArray = new int[]{0, 3, 1, 2};
                    nArray2 = new int[]{5, 3, 1, 2, 0, 4};
                    break;
                }
                nArray = new int[]{3, 0, 2, 1};
                nArray2 = new int[]{5, 0, 4, 2, 3, 1};
                break;
            }
            case 4: {
                if (nArray3[1] < nArray3[3]) {
                    nArray = new int[]{1, 3, 2, 0};
                    nArray2 = new int[]{1, 5, 3, 4, 2, 0};
                    break;
                }
                nArray = new int[]{3, 1, 0, 2};
                nArray2 = new int[]{4, 5, 0, 1, 2, 3};
                break;
            }
            default: {
                if (nArray3[2] < nArray3[3]) {
                    nArray = new int[]{2, 3, 0, 1};
                    nArray2 = new int[]{3, 1, 5, 0, 4, 2};
                    break;
                }
                nArray = new int[]{3, 2, 1, 0};
                nArray2 = new int[]{0, 4, 5, 3, 1, 2};
            }
        }
        piVectorArray[n].m_data = new int[]{nArray3[nArray[0]], nArray3[nArray[1]], nArray3[nArray[2]], nArray3[nArray[3]]};
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        nArray3 = piVectorArray2[n].m_data;
        piVectorArray2[n].m_data = new int[]{nArray3[nArray[0]], nArray3[nArray[1]], nArray3[nArray[2]], nArray3[nArray[3]]};
        this.m_tetraRefinementEdge[n] = 2;
        nArray3 = this.m_faceRefinementEdge[n].m_data;
        this.m_faceRefinementEdge[n].m_data = new int[]{nArray2[nArray3[nArray[0]]], nArray2[nArray3[nArray[1]]], nArray2[nArray3[nArray[2]]], nArray2[nArray3[nArray[3]]]};
        return nArray;
    }

    private void makeRefinementEdges() {
        PiVector[] piVectorArray = this.m_geom.getTetras();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        for (int i = 0; i < this.m_tetraRefinementEdge.length; ++i) {
            if (i >= this.m_faceRefinementEdge.length) {
                return;
            }
            int[] nArray = piVectorArray[i].m_data;
            int[] nArray2 = this.m_faceRefinementEdge[i].m_data;
            int n = this.findRefinementEdgeInTriangle(nArray[1], nArray[2], nArray[3]);
            nArray2[0] = n == 0 ? 5 : (n == 1 ? 4 : 0);
            n = this.findRefinementEdgeInTriangle(nArray[0], nArray[2], nArray[3]);
            nArray2[1] = n == 0 ? 5 : (n == 1 ? 3 : 1);
            n = this.findRefinementEdgeInTriangle(nArray[0], nArray[1], nArray[3]);
            nArray2[2] = n == 0 ? 4 : (n == 1 ? 3 : 2);
            nArray2[3] = this.findRefinementEdgeInTriangle(nArray[0], nArray[1], nArray[2]);
            int[] nArray3 = new int[6];
            this.m_tetraRefinementEdge[i] = -1;
            for (int j = 0; j < 4; ++j) {
                int n2 = nArray2[j];
                nArray3[n2] = nArray3[n2] + 1;
                if (nArray3[nArray2[j]] != 2) continue;
                if (this.m_tetraRefinementEdge[i] == -1) {
                    this.m_tetraRefinementEdge[i] = nArray2[j];
                    continue;
                }
                int[] nArray4 = PgTetraSet.LOCAL_EDGE_TO_VERTEX[this.m_tetraRefinementEdge[i]];
                int[] nArray5 = PgTetraSet.LOCAL_EDGE_TO_VERTEX[nArray2[j]];
                double d = Math.abs(PdVector.dist((PdVector)pdVectorArray[nArray4[0]], (PdVector)pdVectorArray[nArray4[1]]));
                double d2 = Math.abs(PdVector.dist((PdVector)pdVectorArray[nArray5[0]], (PdVector)pdVectorArray[nArray5[1]]));
                if (d2 > d) {
                    this.m_tetraRefinementEdge[i] = nArray2[j];
                    continue;
                }
                if (d != d2 || (nArray5[0] >= nArray4[0] || nArray5[0] >= nArray4[1]) && (nArray5[1] >= nArray4[0] || nArray5[1] >= nArray4[1])) continue;
                this.m_tetraRefinementEdge[i] = nArray2[j];
            }
        }
    }

    private void makeRefinementType() {
        for (int i = 0; i < this.m_tetraRefinementEdge.length; ++i) {
            if (i >= this.m_faceRefinementEdge.length || i >= this.m_tetraRefinementEdge.length || i >= this.m_refinementType.length) {
                return;
            }
            int[] nArray = this.m_faceRefinementEdge[i].m_data;
            int n = -1;
            if (nArray[0] == nArray[1]) {
                n = nArray[2] == 3 && nArray[3] == 0 || nArray[2] == 4 && nArray[3] == 1 ? 0 : (nArray[2] == 3 && nArray[3] == 1 || nArray[2] == 4 && nArray[3] == 0 ? 1 : -1);
            } else if (nArray[0] == nArray[2]) {
                n = nArray[1] == 3 && nArray[3] == 0 || nArray[1] == 5 && nArray[3] == 2 ? 0 : (nArray[1] == 3 && nArray[3] == 2 || nArray[1] == 5 && nArray[3] == 0 ? 1 : -1);
            } else if (nArray[0] == nArray[3]) {
                n = nArray[1] == 1 && nArray[2] == 4 || nArray[1] == 5 && nArray[2] == 2 ? 0 : (nArray[1] == 1 && nArray[2] == 2 || nArray[1] == 5 && nArray[2] == 4 ? 1 : -1);
            } else if (nArray[1] == nArray[2]) {
                n = nArray[0] == 4 && nArray[3] == 1 || nArray[0] == 5 && nArray[3] == 2 ? 0 : (nArray[0] == 4 && nArray[3] == 2 || nArray[0] == 5 && nArray[3] == 1 ? 1 : -1);
            } else if (nArray[1] == nArray[3]) {
                n = nArray[0] == 0 && nArray[2] == 3 || nArray[0] == 5 && nArray[2] == 2 ? 0 : (nArray[0] == 0 && nArray[2] == 2 || nArray[0] == 5 && nArray[2] == 3 ? 1 : -1);
            } else if (nArray[2] == nArray[3]) {
                n = nArray[0] == 0 && nArray[1] == 3 || nArray[0] == 4 && nArray[1] == 1 ? 0 : (nArray[0] == 0 && nArray[1] == 1 || nArray[0] == 4 && nArray[1] == 3 ? 1 : -1);
            }
            this.m_refinementType[i] = n;
        }
    }

    public void refine(Vector vector) {
        int n;
        if (vector == null) {
            return;
        }
        if (vector.size() == 0) {
            return;
        }
        this.assureRefinement();
        this.makeRefinementEdges();
        this.makeRefinementType();
        PiVector[] piVectorArray = this.m_geom.getTetras();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<int[][]> vector3 = new Vector<int[][]>();
        for (int i = 0; i < this.m_geom.getNumTetras(); ++i) {
            vector3.addElement(null);
        }
        Vector<Vector> vector4 = new Vector<Vector>();
        for (n = 0; n < pdVectorArray.length; ++n) {
            vector4.addElement(null);
        }
        for (n = 0; n < vector.size(); ++n) {
            int n2 = (Integer)vector.elementAt(n);
            if (n2 >= this.m_geom.getNumTetras()) {
                PsDebug.warning((String)("PgTetraSet.refine(Vector): index " + n2 + " in tetrahedron list is out of bounds"));
                continue;
            }
            if (vector3.elementAt(n2) != null) {
                PsDebug.warning((String)("PgTetraSet.refine(Vector): index " + n2 + " is twice in tetrahedron list"));
                continue;
            }
            vector2.addElement(new Integer(n2));
            vector3.setElementAt(new int[][]{{-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}}, n2);
        }
        while (vector2.size() > 0) {
            int n3;
            PiVector[] piVectorArray3;
            Vector vector5;
            int[] nArray = new int[2];
            nArray[0] = (Integer)vector2.elementAt(0);
            vector2.removeElementAt(0);
            int[][][] nArrayArray = new int[2][][];
            nArrayArray[0] = (int[][])vector3.elementAt(nArray[0]);
            vector3.setElementAt(null, nArray[0]);
            int[] nArray2 = this.makeAdjustment(nArray[0]);
            nArrayArray[0] = new int[][]{nArrayArray[0][nArray2[0]], nArrayArray[0][nArray2[1]], nArrayArray[0][nArray2[2]], nArrayArray[0][nArray2[3]]};
            nArray[1] = this.addTetra(PiVector.copyNew((PiVector)piVectorArray[nArray[0]]));
            piVectorArray = this.m_geom.getTetras();
            piVectorArray2 = this.m_geom.getNeighbours();
            piVectorArray2[nArray[1]] = PiVector.copyNew((PiVector)piVectorArray2[nArray[0]]);
            this.m_faceRefinementEdge[nArray[1]] = PiVector.copyNew((PiVector)this.m_faceRefinementEdge[nArray[0]]);
            this.m_refinementType[nArray[1]] = this.m_refinementType[nArray[0]];
            if (this.m_geom.hasTetraColors()) {
                this.m_geom.setTetraColor(nArray[1], this.m_geom.getTetraColor(nArray[0]));
            }
            vector3.addElement(null);
            nArrayArray[1] = new int[][]{(int[])nArrayArray[0][0].clone(), (int[])nArrayArray[0][1].clone(), (int[])nArrayArray[0][2].clone(), (int[])nArrayArray[0][3].clone()};
            int[] nArray3 = piVectorArray[nArray[0]].m_data;
            int n4 = -1;
            if (vector4.elementAt(nArray3[0]) == null) {
                vector5 = new Vector();
                vector4.setElementAt(vector5, nArray3[0]);
            } else {
                vector5 = (Vector)vector4.elementAt(nArray3[0]);
                if (vector5.size() > 0) {
                    piVectorArray3 = vector5.elements();
                    while (piVectorArray3.hasMoreElements()) {
                        int[] nArray4 = (int[])piVectorArray3.nextElement();
                        if (nArray4[1] != nArray3[1]) continue;
                        n4 = nArray4[0];
                        break;
                    }
                }
            }
            if (n4 == -1) {
                n4 = this.m_geom.addVertex(PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[nArray3[0]], (double)0.5, (PdVector)pdVectorArray[nArray3[1]]));
                pdVectorArray = this.m_geom.getVertices();
                vector5.addElement(new int[]{n4, nArray3[1]});
                vector4.addElement(null);
            }
            piVectorArray[nArray[0]].m_data[1] = n4;
            piVectorArray[nArray[1]].m_data[0] = n4;
            piVectorArray3 = new PiVector[]{this.m_faceRefinementEdge[nArray[0]], this.m_faceRefinementEdge[nArray[1]]};
            block9: for (n3 = 0; n3 < 2; ++n3) {
                piVectorArray3[n3].m_data[2] = 3 + n3;
                piVectorArray3[n3].m_data[3] = 1 - n3;
                switch (this.m_refinementType[nArray[n3]]) {
                    case 0: 
                    case 1: {
                        piVectorArray3[n3].m_data[n3] = 5;
                        this.m_tetraRefinementEdge[nArray[n3]] = piVectorArray3[n3].m_data[1 - n3];
                        int n5 = nArray[n3];
                        this.m_refinementType[n5] = this.m_refinementType[n5] + 1;
                        continue block9;
                    }
                    case 2: {
                        piVectorArray3[n3].m_data[n3] = piVectorArray3[n3].m_data[1 - n3] + 1 - 2 * (piVectorArray3[n3].m_data[1 - n3] % 3);
                        this.m_tetraRefinementEdge[nArray[n3]] = piVectorArray3[n3].m_data[1 - n3];
                        this.m_refinementType[nArray[n3]] = 0;
                        continue block9;
                    }
                    default: {
                        piVectorArray3[n3].m_data[n3] = 5;
                        this.m_tetraRefinementEdge[nArray[n3]] = piVectorArray3[n3].m_data[1 - n3];
                        this.m_refinementType[nArray[n3]] = 1;
                    }
                }
            }
            piVectorArray2[nArray[0]].m_data[0] = nArray[1];
            nArrayArray[0][0] = new int[]{-1, -1, -1};
            piVectorArray2[nArray[1]].m_data[1] = nArray[0];
            nArrayArray[1][1] = new int[]{-1, -1, -1};
            for (n3 = 0; n3 < 4; ++n3) {
                int n6;
                int n7;
                int n8 = piVectorArray2[nArray[1 - n3 % 2]].m_data[n3];
                if (n8 == -1) continue;
                Object object = (int[][])vector3.elementAt(n8);
                int n9 = -1;
                for (int i = 0; i < 4; ++i) {
                    if (piVectorArray2[n8].m_data[i] != nArray[0] && (object == null || object[i][0] != nArray[0] && object[i][1] != nArray[0] && object[i][2] != nArray[0])) continue;
                    n9 = i;
                    break;
                }
                if (n9 == -1) {
                    PsDebug.warning((String)("PgTetraSet.refine(Vector): inconsistent neighbourhood data for " + nArray[0] + " and " + n8 + "."));
                    continue;
                }
                int[] nArray5 = new int[]{-1, -1, -1};
                block12: for (n7 = 0; n7 < 3; ++n7) {
                    n6 = nArrayArray[1 - n3 % 2][n3][n7];
                    for (int i = 0; i < 4; ++i) {
                        if (n6 == -1 || piVectorArray2[n6].m_data[i] != nArray[0]) continue;
                        nArray5[n7] = i;
                        continue block12;
                    }
                }
                if (n3 == 0) {
                    if (piVectorArray2[n8].m_data[n9] == nArray[0]) {
                        piVectorArray2[n8].m_data[n9] = nArray[1];
                        for (n7 = 0; n7 < 3; ++n7) {
                            n6 = nArrayArray[1][0][n7];
                            if (n6 == -1) continue;
                            piVectorArray2[n6].m_data[nArray5[n7]] = nArray[1];
                        }
                    } else if (object[n9][0] == nArray[0]) {
                        object[n9][0] = nArray[1];
                    } else if (object[n9][1] == nArray[0]) {
                        object[n9][1] = nArray[1];
                    } else {
                        object[n9][2] = nArray[1];
                    }
                } else if (n3 > 1) {
                    if (nArrayArray[0][n3][0] == -1) {
                        if (object == null) {
                            vector2.addElement(new Integer(n8));
                            object = new int[][]{{-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}};
                        }
                        if (object[n9][0] == -1) {
                            object[n9][0] = nArray[1];
                        } else if (piVectorArray2[n8].m_data[n9] == nArray[0]) {
                            object[n9][1] = nArray[1];
                        } else {
                            object[n9][2] = nArray[1];
                        }
                        vector3.setElementAt((int[][])object, n8);
                    } else if (nArrayArray[0][n3][1] == -1 && nArrayArray[0][n3][2] == -1) {
                        nArrayArray[0][n3][0] = -1;
                        piVectorArray2[nArrayArray[1][n3][0]].m_data[nArray5[0]] = nArray[1];
                        piVectorArray2[nArray[1]].m_data[n3] = nArrayArray[1][n3][0];
                        nArrayArray[1][n3][0] = -1;
                    } else {
                        nArrayArray[0][n3][0] = nArrayArray[0][n3][1];
                        piVectorArray2[nArrayArray[1][n3][0]].m_data[nArray5[0]] = nArray[1];
                        if (nArray5[2] != -1) {
                            piVectorArray2[nArrayArray[1][n3][2]].m_data[nArray5[2]] = nArray[1];
                        }
                        piVectorArray2[nArray[1]].m_data[n3] = nArrayArray[1][n3][0];
                        nArrayArray[1][n3][0] = nArrayArray[1][n3][2];
                        nArrayArray[0][n3][1] = -1;
                        nArrayArray[0][n3][2] = -1;
                        nArrayArray[1][n3][1] = -1;
                        nArrayArray[1][n3][2] = -1;
                    }
                }
                for (n7 = 0; n7 < 2; ++n7) {
                    if (nArrayArray[n7][n3][0] == -1 || vector3.elementAt(nArray[n7]) != null) continue;
                    vector2.addElement(new Integer(nArray[n7]));
                    vector3.setElementAt(nArrayArray[n7], nArray[n7]);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

