/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgTetraSet;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgSmallTetrahedra
extends PgElementSet {
    protected PgTetraSet m_tetraSet;
    protected PuDouble m_tetraSize;
    static /* synthetic */ Class class$jvx$volume$PgSmallTetrahedra;

    public PgSmallTetrahedra(int n) {
        super(n);
        this.setTag(10);
        this.m_tetraSize = new PuDouble("Tetrahedron Size", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$volume$PgSmallTetrahedra == null ? (class$jvx$volume$PgSmallTetrahedra = PgSmallTetrahedra.class$("jvx.volume.PgSmallTetrahedra")) : class$jvx$volume$PgSmallTetrahedra)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_tetraSize.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_tetraSize.setDefValue(0.5);
        this.m_tetraSize.init();
        if (this.m_tetraSet != null) {
            this.update(this.m_tetraSet);
        }
    }

    public Object clone() {
        PgSmallTetrahedra pgSmallTetrahedra = (PgSmallTetrahedra)((Object)super.clone());
        if (pgSmallTetrahedra == null) {
            return null;
        }
        if (this.m_tetraSet != null) {
            pgSmallTetrahedra.setTetraSet(this.m_tetraSet);
        }
        pgSmallTetrahedra.m_tetraSize = (PuDouble)this.m_tetraSize.clone();
        pgSmallTetrahedra.m_tetraSize.setParent((PsUpdateIf)pgSmallTetrahedra);
        return pgSmallTetrahedra;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgSmallTetrahedra)) {
            return;
        }
        PgSmallTetrahedra pgSmallTetrahedra = (PgSmallTetrahedra)psObject;
        this.m_tetraSize.copy(pgSmallTetrahedra.m_tetraSize);
    }

    public void setTetraSet(PgTetraSet pgTetraSet) {
        if (pgTetraSet == null) {
            PsDebug.warning((String)"missing tetraSet");
            return;
        }
        if (this.m_tetraSet == pgTetraSet) {
            return;
        }
        this.removeTetraSet();
        this.m_tetraSet = pgTetraSet;
        this.m_tetraSet.addUpdateListener((PsUpdateIf)this);
    }

    public void removeTetraSet() {
        if (this.m_tetraSet == null) {
            return;
        }
        this.m_tetraSet.removeUpdateListener((PsUpdateIf)this);
        this.m_tetraSet = null;
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object != null && object == this.m_tetraSet) {
            PsDebug.notify((String)"event=m_tetraSet");
            this.computeTetrahedra();
            return super.update((Object)this);
        }
        if (object == this.m_tetraSize) {
            PsDebug.notify((String)"called with event=m_tetraSize");
            this.computeTetrahedra();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void computeTetrahedra() {
        if (this.m_tetraSet == null) {
            PsDebug.warning((String)"missing tetraSet");
            return;
        }
        int n = this.m_tetraSet.getNumTetras();
        if (n == 0) {
            PsDebug.warning((String)"missing tetrahedra in m_tetraSet, no tetrahedron faces are computed.");
            this.setNumVertices(0);
            this.setNumElements(0);
            return;
        }
        PdVector[] pdVectorArray = this.m_tetraSet.getVertices();
        PiVector[] piVectorArray = this.m_tetraSet.getTetras();
        double d = this.m_tetraSize.getValue();
        this.setDimOfElements(3);
        this.setNumElements(4 * n);
        this.setNumVertices(4 * n);
        boolean bl = this.m_tetraSet.hasTetraColors();
        if (bl) {
            this.assureElementColors();
            this.showElementColors(true);
        }
        int[][] nArray = PgTetraSet.FACE_TO_VERTEX;
        PdVector pdVector = new PdVector(this.m_tetraSet.getDimOfVertices());
        for (int i = 0; i < n; ++i) {
            int n2;
            pdVector.setConstant(0.0);
            for (n2 = 0; n2 < 4; ++n2) {
                pdVector.add(pdVectorArray[piVectorArray[i].m_data[n2]]);
            }
            pdVector.multScalar(0.25);
            for (n2 = 0; n2 < 4; ++n2) {
                ((PgPointSet)this).m_vertex[4 * i + n2].blend(1.0 - d, pdVector, d, pdVectorArray[piVectorArray[i].m_data[n2]]);
            }
            for (n2 = 0; n2 < 4; ++n2) {
                this.m_element[4 * i + n2].set(4 * i + nArray[n2][0], 4 * i + nArray[n2][1], 4 * i + nArray[n2][2]);
                if (!bl) continue;
                this.setElementColor(4 * i + n2, this.m_tetraSet.getTetraColor(i));
            }
        }
        this.makeNeighbour();
        this.makeElementNormals();
        this.makeVertexNormals();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

