/*
 * Decompiled with CFR 0.152.
 */
package jvx.vector;

import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;
import jvx.project.PjWorkshop;
import jvx.util.PuPriorityQueue;

public class PwVectorField
extends PjWorkshop {
    private static final double SINGULARITY_VERTEX_SIZE = 3.0;
    public static final int TYPE_ROTATION = 0;
    public static final int TYPE_GRADIENT = 1;
    public static final int TYPE_STRAIGHT = 2;
    public static final int TYPE_LINEAR = 3;
    public static final int TYPE_Z_K = 4;
    public static final int TYPE_1_Z_K = 5;
    protected int TYPE_MAX = 5;
    protected static final String[] TYPE_STRINGS = new String[]{PsConfig.getMessage((int)54210), PsConfig.getMessage((int)54211), PsConfig.getMessage((int)54212), PsConfig.getMessage((int)54213), PsConfig.getMessage((int)54214), PsConfig.getMessage((int)54395)};
    protected PgElementSet m_elemSet;
    protected PgPointSet m_pointSet;
    protected boolean m_bAllowConvert = true;
    protected PiVector m_centerType;
    protected PgPointSet m_centers;
    protected int m_dim;
    protected PuInteger m_centerIndex;
    protected boolean m_bMakeTangential;
    protected int m_numVF = -1;
    protected PgVectorField m_saveVF;
    protected PgVectorField m_vf;
    protected PvDisplayIf m_disp;
    protected PuDouble m_slope;
    protected PuDouble m_principleA;
    protected PuDouble m_principleB;
    protected PuDouble m_angleExp;
    protected PuDouble m_slope2;
    protected PuDouble m_centerInfluence;
    protected PuDouble m_angleStraight;
    protected PuDouble m_xStretch;
    protected PuDouble m_yStretch;
    protected PuDouble m_rotation;
    protected PuDouble m_sheer;
    protected PuDouble m_decay;
    protected PuDouble m_decInner;
    protected PuDouble m_zkFact;
    protected PuInteger m_power;
    protected PuDouble m_1_zkFact;
    protected PuInteger m_1_zkPower;
    protected PuDouble m_scale;
    protected static final int P_INFL = 0;
    protected static final int P_ANGSTR = 1;
    protected static final int P_SLOP = 2;
    protected static final int P_PRINCA = 3;
    protected static final int P_PRINCB = 4;
    protected static final int P_ANGEXP = 5;
    protected static final int P_SLOP2 = 6;
    protected static final int P_XSTRETCH = 7;
    protected static final int P_YSTRETCH = 8;
    protected static final int P_ROTATION = 9;
    protected static final int P_SHEER = 10;
    protected static final int P_DECAY = 11;
    protected static final int P_DECINNER = 12;
    protected static final int P_ZKFACT = 13;
    protected static final int P_POWER = 14;
    protected static final int P_1_ZKFACT = 15;
    protected static final int P_1_ZKPOWER = 16;
    protected static final int NUM_PARAMS = 17;
    protected static final double[] P_DEF_VALUES = new double[]{1.0, 0.0, 0.5, 1.0, 1.0, 0.0, 0.5, 0.1, 0.1, 0.1, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0, 1.0};
    protected PdVector[] m_parameters = new PdVector[17];
    static /* synthetic */ Class class$jvx$vector$PwVectorField;

    public PwVectorField() {
        this((PvDisplayIf)null);
    }

    public PwVectorField(PvDisplayIf pvDisplayIf) {
        super(PsConfig.getMessage((int)51090));
        this.m_centerIndex = new PuInteger(PsConfig.getMessage((int)54217), (PsUpdateIf)this);
        this.m_centerIndex.setEnabledConfigButton(false);
        this.m_slope = new PuDouble(PsConfig.getMessage((int)54218), (PsUpdateIf)this);
        this.m_slope2 = new PuDouble(PsConfig.getMessage((int)54218), (PsUpdateIf)this);
        this.m_principleA = new PuDouble(PsConfig.getMessage((int)54219), (PsUpdateIf)this);
        this.m_principleB = new PuDouble(PsConfig.getMessage((int)54220), (PsUpdateIf)this);
        this.m_angleExp = new PuDouble(PsConfig.getMessage((int)54179), (PsUpdateIf)this);
        this.m_centerInfluence = new PuDouble(PsConfig.getMessage((int)54307), (PsUpdateIf)this);
        this.m_angleStraight = new PuDouble(PsConfig.getMessage((int)54179), (PsUpdateIf)this);
        this.m_xStretch = new PuDouble(PsConfig.getMessage((int)54486), (PsUpdateIf)this);
        this.m_yStretch = new PuDouble(PsConfig.getMessage((int)54487), (PsUpdateIf)this);
        this.m_rotation = new PuDouble(PsConfig.getMessage((int)54488), (PsUpdateIf)this);
        this.m_sheer = new PuDouble(PsConfig.getMessage((int)54331), (PsUpdateIf)this);
        this.m_decay = new PuDouble(PsConfig.getMessage((int)54489), (PsUpdateIf)this);
        this.m_decInner = new PuDouble(PsConfig.getMessage((int)54490), (PsUpdateIf)this);
        this.m_zkFact = new PuDouble(PsConfig.getMessage((int)54225), (PsUpdateIf)this);
        this.m_power = new PuInteger(PsConfig.getMessage((int)54226), (PsUpdateIf)this);
        this.m_1_zkFact = new PuDouble(PsConfig.getMessage((int)54225), (PsUpdateIf)this);
        this.m_1_zkPower = new PuInteger(PsConfig.getMessage((int)54226), (PsUpdateIf)this);
        this.m_scale = new PuDouble(PsConfig.getMessage((int)54491), (PsUpdateIf)this);
        this.m_centers = new PgPointSet(3);
        this.setCenterGeometryProperties();
        this.m_centers.setParent((PsUpdateIf)this);
        this.m_centerType = new PiVector(0);
        this.m_centerType.setName(PsConfig.getMessage((int)45051));
        for (int i = 0; i < 17; ++i) {
            this.m_parameters[i] = new PdVector(0);
            this.m_parameters[i].setName(PsConfig.getMessage((int)45052) + " " + (i + 1));
        }
        this.setDisplay(pvDisplayIf);
        if (((Object)((Object)this)).getClass() == (class$jvx$vector$PwVectorField == null ? (class$jvx$vector$PwVectorField = PwVectorField.class$("jvx.vector.PwVectorField")) : class$jvx$vector$PwVectorField)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bMakeTangential = true;
        int n = 1;
        if (this.m_centers.getNumVertices() == 0) {
            n = 0;
        }
        this.m_centerIndex.setDefBounds(n, this.m_centers.getNumVertices(), 1, 2);
        this.m_centerIndex.setDefValue(this.m_centers.getNumVertices());
        this.m_centerIndex.init();
        this.m_slope.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_slope.setDefValue(0.5);
        this.m_slope.init();
        this.m_principleA.setDefBounds(0.01, 5.0, 0.1, 1.0);
        this.m_principleA.setDefValue(1.0);
        this.m_principleA.init();
        this.m_principleB.setDefBounds(0.01, 5.0, 0.1, 1.0);
        this.m_principleB.setDefValue(1.0);
        this.m_principleB.init();
        this.m_angleExp.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_angleExp.setDefValue(0.0);
        this.m_angleExp.init();
        this.m_slope.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_slope2.setDefValue(0.5);
        this.m_slope2.init();
        this.m_centerInfluence.setDefBounds(-5.0, 5.0, 0.1, 1.0);
        this.m_centerInfluence.setDefValue(1.0);
        this.m_centerInfluence.init();
        this.m_angleStraight.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_angleStraight.setDefValue(0.0);
        this.m_angleStraight.init();
        this.m_xStretch.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_xStretch.setDefValue(0.1);
        this.m_xStretch.init();
        this.m_yStretch.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_yStretch.setDefValue(0.1);
        this.m_yStretch.init();
        this.m_rotation.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_rotation.setDefValue(0.1);
        this.m_rotation.init();
        this.m_sheer.setDefBounds(-3.0, 3.0, 0.1, 0.5);
        this.m_sheer.setDefValue(0.0);
        this.m_sheer.init();
        this.m_decay.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_decay.setDefValue(P_DEF_VALUES[11]);
        this.m_decay.init();
        this.m_decInner.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_decInner.setDefValue(P_DEF_VALUES[12]);
        this.m_decInner.init();
        this.m_zkFact.setDefBounds(0.0, 3.0, 0.1, 0.5);
        this.m_zkFact.setDefValue(0.1);
        this.m_zkFact.init();
        this.m_power.setDefBounds(0, 6, 1, 2);
        this.m_power.setDefValue(2);
        this.m_power.init();
        this.m_1_zkFact.setDefBounds(0.0, 3.0, 0.1, 0.5);
        this.m_1_zkFact.setDefValue(0.1);
        this.m_1_zkFact.init();
        this.m_1_zkPower.setDefBounds(0, 6, 1, 2);
        this.m_1_zkPower.setDefValue(2);
        this.m_1_zkPower.init();
        this.m_scale.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_scale.setDefValue(1.0);
        this.m_scale.init();
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_disp != null && this.m_centers != null) {
            this.m_disp.removeGeometry((PgGeometryIf)this.m_centers);
        }
        super.setDisplay(pvDisplayIf);
        this.m_disp = pvDisplayIf;
        if (this.m_disp != null && this.m_centers != null) {
            this.m_disp.addGeometry((PgGeometryIf)this.m_centers);
            this.m_disp.selectGeometry((PgGeometryIf)this.m_centers);
        }
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgPointSet)) {
            PsDebug.warning((String)"workshop requires instance of PgPointSet.");
            return;
        }
        if (pgGeometry != this.m_pointSet) {
            this.removeGeometry();
            super.setGeometry(pgGeometry);
        }
        if (pgGeometry instanceof PgElementSet) {
            this.m_elemSet = (PgElementSet)pgGeometry;
        } else {
            this.m_elemSet = null;
            this.m_bMakeTangential = false;
        }
        this.m_pointSet = (PgPointSet)pgGeometry;
        this.m_pointSet.showVectorArrows(true);
        this.m_pointSet.showSingleVectorField(true);
        this.m_dim = this.m_pointSet.getDimOfVertices();
        if (this.m_elemSet != null) {
            this.m_elemSet.makeElementNormals();
            this.m_elemSet.makeVertexNormals();
        }
        if (this.m_dim > 2) {
            this.m_principleA.setEnabled(true);
            this.m_principleB.setEnabled(false);
            this.m_angleExp.setEnabled(false);
            this.TYPE_MAX = 2;
        } else {
            this.m_principleA.setEnabled(true);
            this.m_principleB.setEnabled(true);
            this.m_angleExp.setEnabled(true);
            this.TYPE_MAX = 5;
        }
        PgVectorField pgVectorField = this.m_pointSet.getSelectedVectorField();
        if (pgVectorField != null) {
            if (pgVectorField != this.m_vf || this.m_saveVF != null && pgVectorField.getNumVectors() != this.m_saveVF.getNumVectors()) {
                this.setSelectedVF(this.m_pointSet.getIndexOfVectorField(pgVectorField));
            } else if (this.m_saveVF != null) {
                this.m_vf.copy((PsObject)this.m_saveVF);
            }
        } else {
            this.m_vf = null;
            this.m_saveVF = null;
        }
        if (this.m_pointSet.getNumVectorFields() == 0) {
            this.makeNewVF(0);
            PdVector[] pdVectorArray = this.m_pointSet.getBounds();
            double d = 0.0;
            PdVector pdVector = new PdVector(this.m_dim);
            for (int i = 0; i < this.m_dim; ++i) {
                double d2 = pdVectorArray[1].m_data[i] - pdVectorArray[0].m_data[i];
                pdVector.m_data[i] = Math.random() * d2 / 2.0 + pdVectorArray[0].m_data[i] + d2 / 4.0;
                if (!(Math.abs(d2) > d)) continue;
                d = Math.abs(d2);
            }
            if (d <= 0.0) {
                d = 0.001;
            }
            this.addCenter(pdVector, 0, Math.log(d));
        }
        if (this.m_centers == null || this.m_centers.getDimOfVertices() != this.m_dim) {
            if (this.m_centers != null && this.m_disp != null) {
                this.m_disp.removeGeometry((PgGeometryIf)this.m_centers);
            }
            this.m_centers = new PgPointSet(this.m_dim);
            this.setCenterGeometryProperties();
            this.m_centers.setParent((PsUpdateIf)this);
            if (this.m_disp != null) {
                this.m_disp.addGeometry((PgGeometryIf)this.m_centers);
            }
        }
    }

    public void removeGeometry() {
        this.m_pointSet = null;
        this.m_elemSet = null;
        this.m_vf = null;
        this.m_saveVF = null;
        super.removeGeometry();
    }

    public boolean update(Object object) {
        if (this.isUpdateSender()) {
            return true;
        }
        if (object == null) {
            return super.update(object);
        }
        int n = this.m_centerIndex.getValue();
        if (object == this) {
            this.setUpdateSender(true);
            if (this.m_centers != null) {
                this.m_centers.update((Object)this.m_centers);
            }
            if (this.m_centerIndex != null) {
                this.m_centerIndex.update((Object)this.m_centerIndex);
            }
            this.setUpdateSender(false);
        } else if (object == this.m_centers) {
            this.adaptParametersToSize();
        } else if (object == this.m_centerIndex) {
            this.setUpdateSender(true);
            this.selectCenter(this.m_centerIndex.getValue() - 1);
            this.m_centers.update((Object)this.m_centers);
            this.setUpdateSender(false);
        } else if (object == this.m_centerInfluence) {
            if (n > 0) {
                this.m_parameters[0].setEntry(n - 1, this.m_centerInfluence.getValue());
            }
        } else if (object == this.m_angleStraight && n > 0) {
            if (n > 0) {
                this.m_parameters[1].setEntry(n - 1, this.m_angleStraight.getValue());
            }
        } else if (object == this.m_slope) {
            if (n > 0) {
                this.m_parameters[2].setEntry(n - 1, this.m_slope.getValue());
            }
        } else if (object == this.m_principleA) {
            if (n > 0) {
                this.m_parameters[3].setEntry(n - 1, this.m_principleA.getValue());
            }
        } else if (object == this.m_principleB) {
            if (n > 0) {
                this.m_parameters[4].setEntry(n - 1, this.m_principleB.getValue());
            }
        } else if (object == this.m_angleExp) {
            if (n > 0) {
                this.m_parameters[5].setEntry(n - 1, this.m_angleExp.getValue());
            }
        } else if (object == this.m_slope2) {
            if (n > 0) {
                this.m_parameters[6].setEntry(n - 1, this.m_slope2.getValue());
            }
        } else if (object == this.m_xStretch) {
            if (n > 0) {
                this.m_parameters[7].setEntry(n - 1, this.m_xStretch.getValue());
            }
        } else if (object == this.m_yStretch) {
            if (n > 0) {
                this.m_parameters[8].setEntry(n - 1, this.m_yStretch.getValue());
            }
        } else if (object == this.m_rotation) {
            if (n > 0) {
                this.m_parameters[9].setEntry(n - 1, this.m_rotation.getValue());
            }
        } else if (object == this.m_sheer) {
            if (n > 0) {
                this.m_parameters[10].setEntry(n - 1, this.m_sheer.getValue());
            }
        } else if (object == this.m_decay) {
            if (n > 0) {
                this.m_parameters[11].setEntry(n - 1, this.m_decay.getValue());
            }
        } else if (object == this.m_decInner) {
            if (n > 0) {
                this.m_parameters[12].setEntry(n - 1, this.m_decInner.getValue());
            }
        } else if (object == this.m_zkFact) {
            if (n > 0) {
                this.m_parameters[13].setEntry(n - 1, this.m_zkFact.getValue());
            }
        } else if (object == this.m_power) {
            if (n > 0) {
                this.m_parameters[14].setEntry(n - 1, this.m_power.getValue());
            }
        } else if (object == this.m_1_zkFact) {
            if (n > 0) {
                this.m_parameters[15].setEntry(n - 1, this.m_1_zkFact.getValue());
            }
        } else if (object == this.m_1_zkPower) {
            if (n > 0) {
                this.m_parameters[16].setEntry(n - 1, this.m_1_zkPower.getValue());
            }
        } else if (object != this.m_scale) {
            return super.update(object);
        }
        if (this.m_vf != null) {
            this.calculateVF();
        }
        return super.update((Object)this);
    }

    private void adaptParametersToSize() {
        int n;
        int n2;
        int n3;
        if (this.m_centers.getNumVertices() > this.m_centerType.getSize()) {
            n3 = this.m_centerType.getSize();
            n2 = this.m_centers.getNumVertices();
            this.m_centerType.setSize(n2);
            for (n = 0; n < 17; ++n) {
                this.m_parameters[n].setSize(n2);
            }
            for (n = n3; n < n2; ++n) {
                this.m_centers.getVertex(n).setName("" + (n + 1));
                this.m_centerType.setEntry(n, 0);
                for (int i = 0; i < 17; ++i) {
                    this.m_parameters[i].setEntry(n, P_DEF_VALUES[i]);
                }
            }
            this.m_centerIndex.setBounds(1, n2, 1, 2);
        } else if (this.m_centers.getNumVertices() < this.m_centerType.getSize()) {
            n3 = this.m_centers.getNumVertices();
            this.m_centerType.setSize(n3);
            for (n2 = 0; n2 < 17; ++n2) {
                this.m_parameters[n2].setSize(n3);
            }
            this.m_centerIndex.setBounds(1, n3, 1, 2);
        }
        n3 = this.m_centers.getNumVertices();
        n2 = this.m_centerIndex.getValue();
        for (n = 0; n < n3; ++n) {
            if (!this.m_centers.hasTagVertex(n, 11)) continue;
            if (n2 == n + 1) break;
            if (n2 > 0 && n2 <= n3) {
                this.m_centers.clearTagVertex(n2 - 1, 1);
            }
            this.m_centers.setTagVertex(n, 1);
            this.m_centerIndex.setValue(n + 1);
            break;
        }
    }

    public void setEnabledConvert(boolean bl) {
        this.m_bAllowConvert = bl;
    }

    public boolean isEnabledConvert() {
        return this.m_bAllowConvert;
    }

    private void setCenterGeometryProperties() {
        this.m_centers.setName(PsConfig.getMessage((int)45050));
        this.m_centers.setGlobalVertexSize(3.0);
        this.m_centers.setNumVertices(0);
        this.m_centers.showVertexLabels(true);
    }

    public void setCenterType(int n, int n2) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        if (n < 0 || n >= this.m_centers.getNumVertices()) {
            PsDebug.warning((String)("Invalid center index = " + n + "."));
            return;
        }
        if (n2 < 0 || n2 > this.TYPE_MAX) {
            PsDebug.warning((String)("Invalid center type = " + n2 + "."));
            return;
        }
        this.m_centerType.setEntry(n, n2);
    }

    public void setCenterInfluence(int n, double d) {
        int n2 = this.m_centers.getNumVertices();
        if (n < 0 || n2 <= n) {
            PsDebug.warning((String)("Invalid center index = " + n + "."));
            return;
        }
        this.m_parameters[0].setEntry(n, d);
    }

    public void selectCenter(int n) {
        if (n != this.m_centerIndex.getValue() - 1) {
            this.m_centerIndex.setValue(n + 1);
        }
        int n2 = this.m_centers.getNumVertices();
        if (n < 0 || n2 <= n) {
            PsDebug.warning((String)("Invalid center index = " + n + "."));
            return;
        }
        for (int i = 0; i < n2; ++i) {
            this.m_centers.clearTagVertex(i, 1);
        }
        this.m_centers.setTagVertex(n, 1);
    }

    public int getCenterType(int n) {
        if (this.m_centerType == null) {
            return -1;
        }
        return this.m_centerType.getEntry(n);
    }

    public int getNumCenters() {
        if (this.m_centers == null) {
            return -1;
        }
        return this.m_centers.getNumVertices();
    }

    public int getSelectedCenter() {
        return this.m_centerIndex.getValue() - 1;
    }

    public int getSelectedVFIndex() {
        if (this.m_pointSet == null) {
            return -1;
        }
        return this.m_pointSet.getIndexOfVectorField(this.m_pointSet.getSelectedVectorField());
    }

    public PgVectorField getSelectedVF() {
        return this.m_vf;
    }

    public void addCenter(int n) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"missing centers.");
            return;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        pdVector.setConstant(Math.random() / 2.0);
        pdVector.setName("" + (this.m_centers.getNumVertices() + 1));
        this.m_centers.addVertex(pdVector);
        int n2 = this.m_centers.getNumVertices();
        this.m_centerType.setSize(n2);
        this.m_centerType.setEntry(n2 - 1, n);
        for (int i = 0; i < 17; ++i) {
            this.m_parameters[i].setSize(n2);
            this.m_parameters[i].setEntry(n2 - 1, P_DEF_VALUES[i]);
        }
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        if (this.m_centers.getNumVertices() == 1) {
            this.selectCenter(0);
        }
    }

    public void addCenter(int n, double d) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        pdVector.setConstant(Math.random() / 2.0);
        pdVector.setName("" + (this.m_centers.getNumVertices() + 1));
        this.m_centers.addVertex(pdVector);
        int n2 = this.m_centers.getNumVertices();
        this.m_centerType.setSize(n2);
        this.m_centerType.setEntry(n2 - 1, n);
        for (int i = 0; i < 17; ++i) {
            this.m_parameters[i].setSize(n2);
            this.m_parameters[i].setEntry(n2 - 1, d);
        }
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        if (this.m_centers.getNumVertices() == 1) {
            this.selectCenter(0);
        }
    }

    public void addCenter(PdVector pdVector, int n, double d) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        PdVector pdVector2 = new PdVector(this.m_dim);
        pdVector2.copy(pdVector);
        pdVector2.setName("" + (this.m_centers.getNumVertices() + 1));
        this.m_centers.addVertex(pdVector2);
        int n2 = this.m_centers.getNumVertices();
        this.m_centerType.setSize(n2);
        this.m_centerType.setEntry(n2 - 1, n);
        for (int i = 0; i < 17; ++i) {
            this.m_parameters[i].setSize(n2);
            this.m_parameters[i].setEntry(n2 - 1, d);
        }
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        if (this.m_centers.getNumVertices() == 1) {
            this.selectCenter(0);
        }
    }

    public void addCenter(PdVector pdVector, int n) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"missing centers.");
            return;
        }
        PdVector pdVector2 = new PdVector(this.m_dim);
        pdVector2.copy(pdVector);
        pdVector2.setName("" + (this.m_centers.getNumVertices() + 1));
        this.m_centers.addVertex(pdVector2);
        int n2 = this.m_centers.getNumVertices();
        this.m_centerType.setSize(n2);
        this.m_centerType.setEntry(n2 - 1, n);
        for (int i = 0; i < 17; ++i) {
            this.m_parameters[i].setSize(n2);
            this.m_parameters[i].setEntry(n2 - 1, P_DEF_VALUES[i]);
        }
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        if (this.m_centers.getNumVertices() == 1) {
            this.selectCenter(0);
        }
    }

    public void removeCenter(int n) {
        int n2;
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        if (n < 0 || n >= this.m_centers.getNumVertices()) {
            return;
        }
        this.m_centers.removeVertex(n);
        int n3 = this.m_centers.getNumVertices();
        for (n2 = n; n2 < n3; ++n2) {
            this.m_centers.getVertex(n2).setName("" + (n2 + 1));
            this.m_centerType.setEntry(n2, this.m_centerType.getEntry(n2 + 1));
            for (int i = 0; i < 17; ++i) {
                this.m_parameters[i].setEntry(n2, this.m_parameters[i].getEntry(n2 + 1));
            }
        }
        this.m_centerType.setSize(n3);
        for (n2 = 0; n2 < 17; ++n2) {
            this.m_parameters[n2].setSize(n3);
        }
        this.m_centerIndex.setBounds(1, n3, 1, 2);
        this.adaptParametersToSize();
    }

    public void clearCenter() {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        this.m_centers.setNumVertices(0);
        this.m_centerType.setSize(0);
        for (int i = 0; i < 17; ++i) {
            this.m_parameters[i].setSize(0);
        }
        this.m_centerIndex.setBounds(0, 0, 0, 0);
    }

    public void makeNewVF(int n) {
        if (this.m_pointSet == null) {
            PsDebug.warning((String)"No geometry set.");
            return;
        }
        if (n == 1 && this.m_elemSet == null) {
            PsDebug.warning((String)"No element set set.");
            return;
        }
        PgVectorField pgVectorField = new PgVectorField(this.m_dim, n);
        pgVectorField.setName(PsConfig.getMessage((int)45053) + "[" + PsObject.getNumObjects() + "]");
        pgVectorField.setGeometry(this.m_pointSet);
        this.m_pointSet.addVectorField(pgVectorField);
        if (this.m_pointSet.getNumVectorFields() == 1) {
            this.setSelectedVF(0);
        }
    }

    public void setSelectedVF(int n) {
        if (this.m_pointSet == null) {
            PsDebug.warning((String)"Missing geometry of workshop.");
            return;
        }
        if (n < 0 || n >= this.m_pointSet.getNumVectorFields()) {
            PsDebug.warning((String)("No valid vector field index = " + n + "."));
            return;
        }
        if (this.m_saveVF != null && this.m_vf != null) {
            this.m_vf.copy((PsObject)this.m_saveVF);
        }
        this.m_vf = this.m_pointSet.getVectorField(n);
        if (this.m_saveVF == null) {
            this.m_saveVF = new PgVectorField(this.m_dim);
            this.m_saveVF.setGeometry(this.m_pointSet);
        }
        this.m_saveVF.copy((PsObject)this.m_vf);
        this.m_pointSet.selectVectorField(this.m_vf);
    }

    public void fixVF() {
        if (this.m_vf == null) {
            PsDebug.warning((String)"missing vector field.");
            return;
        }
        if (this.m_saveVF == null) {
            this.m_saveVF = new PgVectorField(this.m_dim);
            this.m_saveVF.setGeometry(this.m_pointSet);
        }
        this.m_saveVF.copy((PsObject)this.m_vf);
        this.clearCenter();
        this.m_scale.setValue(1.0);
    }

    public void setMakeTangential(boolean bl) {
        this.m_bMakeTangential = bl;
    }

    protected void convertToOtherBase(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing vector field");
            return;
        }
        if (pgVectorField.getBasedOn() == 1) {
            pgVectorField.copy((PsObject)PwVectorField.getInterpolatedVertexBased(pgVectorField, null));
        } else {
            if (!(pgVectorField.getGeometry() instanceof PgElementSet)) {
                PsDebug.warning((String)"geometry is not an element set");
                return;
            }
            pgVectorField.copy((PsObject)PwVectorField.getInterpolatedElementBased(pgVectorField, null));
        }
    }

    public void cancel() {
        if (this.m_saveVF != null && this.m_vf != null) {
            this.m_vf.copy((PsObject)this.m_saveVF);
        }
        super.cancel();
    }

    public void close() {
        if (this.m_centers != null) {
            this.clearCenter();
            if (this.m_disp != null) {
                this.m_disp.removeGeometry((PgGeometryIf)this.m_centers);
                this.m_disp.update((Object)this.m_disp);
            }
        }
        this.m_disp = null;
        this.m_saveVF = null;
        this.m_vf = null;
        this.m_elemSet = null;
        this.m_pointSet = null;
        super.close();
    }

    public void ok() {
        this.fixVF();
        super.ok();
    }

    public void reset() {
    }

    public void calculateVF() {
        int n;
        if (this.m_vf == null) {
            PsDebug.warning((String)"No vector field selected.");
            return;
        }
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        int n2 = this.m_centers.getNumVertices();
        if (n2 == 0) {
            this.m_vf.copy((PsObject)this.m_saveVF);
        }
        int n3 = this.m_saveVF.getNumVectors();
        int n4 = this.m_saveVF.getBasedOn();
        if (this.m_vf.getBasedOn() != n4) {
            this.m_vf.setBasedOn(n4);
            if (n4 == 1) {
                this.m_vf.setGeometry((PgPointSet)this.m_elemSet);
            } else {
                this.m_vf.setGeometry(this.m_pointSet);
            }
        }
        if ((n = this.m_vf.getNumVectors()) < 1) {
            return;
        }
        PdVector[] pdVectorArray = this.m_pointSet.getVertices();
        PiVector[] piVectorArray = null;
        PdVector[] pdVectorArray2 = null;
        PdVector[] pdVectorArray3 = null;
        if (this.m_elemSet != null) {
            piVectorArray = this.m_elemSet.getElements();
            pdVectorArray2 = this.m_elemSet.getElementNormals();
            pdVectorArray3 = this.m_elemSet.getVertexNormals();
        }
        PdVector[] pdVectorArray4 = this.m_vf.getVectors();
        PdVector[] pdVectorArray5 = this.m_saveVF.getVectors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = null;
        PdVector pdVector4 = null;
        for (int i = 0; i < n; ++i) {
            int n5;
            int n6;
            if (i < n3) {
                pdVectorArray4[i].copy(pdVectorArray5[i]);
            } else {
                pdVectorArray4[i].setConstant(0.0);
            }
            if (n4 == 0) {
                pdVector3 = pdVectorArray[i];
                if (pdVectorArray3 != null) {
                    pdVector4 = pdVectorArray3[i];
                }
            } else if (n4 == 1) {
                pdVector3 = new PdVector(this.m_dim);
                n6 = piVectorArray[i].getSize();
                for (n5 = 0; n5 < n6; ++n5) {
                    pdVector3.add(pdVectorArray[piVectorArray[i].getEntry(n5)]);
                }
                pdVector3.multScalar(1.0 / (double)n6);
                if (pdVectorArray2 != null) {
                    pdVector4 = pdVectorArray2[i];
                }
            }
            if (pdVector4 != null) {
                pdVector4.normalize();
            }
            if (this.m_bMakeTangential && this.m_dim > 2) {
                PuVectorGeom.projectOntoPlane((PdVector)pdVectorArray4[i], (PdVector)pdVector4);
            }
            block10: for (n6 = 0; n6 < n2; ++n6) {
                PdVector pdVector5 = this.m_centers.getVertex(n6);
                n5 = this.m_centerType.getEntry(n6);
                switch (n5) {
                    case 2: {
                        double d7;
                        if (this.m_dim > 2) {
                            pdVector2.copy(pdVector5);
                            if (this.m_bMakeTangential && this.m_elemSet != null) {
                                PuVectorGeom.projectOntoPlane((PdVector)pdVector2, (PdVector)pdVector4);
                            }
                            if (pdVector2.length() > 1.0E-10) {
                                pdVector2.normalize();
                            }
                        } else {
                            d7 = this.m_parameters[1].getEntry(n6) / 180.0 * Math.PI;
                            pdVector2.setEntry(0, Math.cos(d7));
                            pdVector2.setEntry(1, Math.sin(d7));
                        }
                        pdVector2.multScalar(this.m_parameters[0].getEntry(n6));
                        pdVectorArray4[i].add(pdVector2);
                        continue block10;
                    }
                    case 0: {
                        double d13;
                        double d2;
                        double d3;
                        double d4;
                        double d5;
                        double d6;
                        double d7;
                        pdVector2.sub(pdVector5, pdVector3);
                        if (this.m_dim > 2) {
                            d7 = Math.exp(-2.0 * pdVector2.length() / Math.max(this.m_parameters[3].getEntry(n6), 1.0E-4));
                            pdVector2.multScalar(d7);
                            if (this.m_bMakeTangential && this.m_elemSet != null) {
                                PuVectorGeom.projectOntoPlane((PdVector)pdVector2, (PdVector)pdVector4);
                            }
                            pdVector2.multScalar(this.m_parameters[2].getEntry(n6));
                            if (this.m_elemSet != null) {
                                pdVector.cross(pdVector4, pdVector2);
                            } else {
                                pdVector.cross(pdVector5, pdVector2);
                            }
                            pdVector.setLength(pdVector2.length());
                        } else {
                            d7 = this.m_parameters[3].getEntry(n6);
                            if ((d7 *= d7) < 1.0E-10) {
                                d7 = 1.0E-10;
                            }
                            d6 = this.m_parameters[4].getEntry(n6);
                            if ((d6 *= d6) < 1.0E-10) {
                                d6 = 1.0E-10;
                            }
                            d5 = this.m_parameters[2].getEntry(n6);
                            d4 = Math.sqrt(Math.exp(1.0));
                            double d8 = this.m_parameters[5].getEntry(n6) / 180.0 * Math.PI;
                            d3 = Math.sin(d8);
                            d2 = Math.cos(d8);
                            d13 = pdVector2.getEntry(0);
                            double d9 = pdVector2.getEntry(1);
                            double d10 = d13 * d2 + d9 * d3;
                            double d11 = d9 * d2 - d13 * d3;
                            double d12 = Math.exp(-0.5 * (d10 * d10 / d7 + d11 * d11 / d6));
                            pdVector.setEntry(0, -d5 * d4 / 2.0 * (d7 + d6) * (d10 * d3 / d7 + d11 * d2 / d6) * d12);
                            pdVector.setEntry(1, d5 * d4 / 2.0 * (d7 + d6) * (d10 * d2 / d7 - d11 * d3 / d6) * d12);
                        }
                        pdVectorArray4[i].add(pdVector);
                        continue block10;
                    }
                    case 1: {
                        pdVector2.sub(pdVector5, pdVector3);
                        double d7 = 2.0 * Math.exp(-2.0 * pdVector2.length() * 0.6);
                        pdVector2.multScalar(d7);
                        if (this.m_bMakeTangential && this.m_dim > 2 && this.m_elemSet != null) {
                            PuVectorGeom.projectOntoPlane((PdVector)pdVector2, (PdVector)pdVector4);
                        }
                        pdVector2.multScalar(this.m_parameters[6].getEntry(n6));
                        pdVectorArray4[i].add(pdVector2);
                        continue block10;
                    }
                    case 3: {
                        if (this.m_dim != 2) continue block10;
                        pdVector2.sub(pdVector3, pdVector5);
                        double d6 = pdVector2.getEntry(0);
                        double d5 = pdVector2.getEntry(1);
                        double d4 = this.m_parameters[11].getEntry(n6);
                        double d = Math.sqrt(d6 * d6 + d5 * d5) - this.m_parameters[12].getEntry(n6);
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        double d3 = Math.exp(-d4 * d * d / 2.0);
                        double d2 = this.m_parameters[9].getEntry(n6);
                        double d13 = this.m_parameters[10].getEntry(n6);
                        pdVector.setEntry(0, this.m_parameters[7].getEntry(n6) * (d6 *= d3) - d2 * (d5 *= d3) + d13 * d5);
                        pdVector.setEntry(1, this.m_parameters[8].getEntry(n6) * d5 + d2 * d6);
                        pdVectorArray4[i].add(pdVector);
                        continue block10;
                    }
                    case 4: {
                        double d;
                        double d4;
                        if (this.m_dim != 2) continue block10;
                        pdVector2.sub(pdVector5, pdVector3);
                        double d6 = pdVector2.getEntry(0) / 8.0;
                        double d5 = -pdVector2.getEntry(1) / 8.0;
                        int n7 = (int)this.m_parameters[14].getEntry(n6) - 1;
                        if (n7 == 0) {
                            d6 = 1.0;
                            d5 = 0.0;
                        } else if (n7 < 0) {
                            d6 = 0.0;
                            d5 = 0.0;
                        } else {
                            for (int j = 1; j < n7; ++j) {
                                d4 = d5;
                                d5 = 2.0 * d6 * d5;
                                d6 = d6 * d6 - d4 * d4;
                            }
                            d = this.m_parameters[13].getEntry(n6);
                            d6 *= (double)(n7 + 1) * d;
                            d5 *= (double)(n7 + 1) * d;
                        }
                        pdVector.setEntry(0, d6);
                        pdVector.setEntry(1, d5);
                        pdVectorArray4[i].add(pdVector);
                        continue block10;
                    }
                    case 5: {
                        double d;
                        double d4;
                        if (this.m_dim != 2) continue block10;
                        pdVector2.sub(pdVector5, pdVector3);
                        double d6 = pdVector2.getEntry(0);
                        double d5 = pdVector2.getEntry(1);
                        int n8 = (int)this.m_parameters[16].getEntry(n6) + 1;
                        if (n8 < 1) {
                            d6 = 0.0;
                            d5 = 0.0;
                        } else {
                            int n9;
                            d = d6 * d6 + d5 * d5;
                            for (n9 = 1; n9 < n8; ++n9) {
                                d *= d;
                            }
                            if (d < 1.0E-10) {
                                d6 = 0.0;
                                d5 = 0.0;
                            } else {
                                for (n9 = 1; n9 < n8; ++n9) {
                                    d4 = d5;
                                    d5 = 2.0 * d6 * d5;
                                    d6 = d6 * d6 - d4 * d4;
                                }
                                double d14 = this.m_parameters[15].getEntry(n6);
                                d6 *= (double)(-(n8 - 1)) * d14 / d;
                                d5 *= (double)(-(n8 - 1)) * d14 / d;
                            }
                        }
                        pdVector.setEntry(0, d6);
                        pdVector.setEntry(1, d5);
                        pdVectorArray4[i].add(pdVector);
                    }
                }
            }
            pdVectorArray4[i].multScalar(this.m_scale.getValue());
        }
    }

    public static PdVector parallelTransport(PgElementSet pgElementSet, PdVector pdVector, int n, int n2, PdVector pdVector2) {
        if (pdVector2 == null) {
            pdVector2 = new PdVector(3);
        } else {
            pdVector2.setSize(3);
        }
        int n3 = pgElementSet.getNeighbour((int)n).m_data[n2];
        if (n3 < 0) {
            PsDebug.warning((String)"Cannot parallel transport over surface boundary.");
            return null;
        }
        PiVector piVector = pgElementSet.getElement(n);
        PdVector pdVector3 = pgElementSet.getVertex(piVector.m_data[(n2 + 1) % 3]);
        PdVector pdVector4 = pgElementSet.getVertex(piVector.m_data[(n2 + 2) % 3]);
        PdVector pdVector5 = PdVector.subNew((PdVector)pdVector4, (PdVector)pdVector3);
        PdVector pdVector6 = pgElementSet.getElementNormal(n);
        PdVector pdVector7 = pgElementSet.getElementNormal(n3);
        double d = PdVector.angleWithOrientation((PdVector)pdVector, (PdVector)pdVector5, (PdVector)pdVector6);
        PuVectorGeom.rotatePointAroundVector((PdVector)pdVector2, (PdVector)pdVector5, (PdVector)pdVector7, (double)(-d));
        pdVector2.setLength(pdVector.length());
        return pdVector2;
    }

    public static double calcVertexAngle(PgVectorField pgVectorField, int n, int n2) {
        PdVector[] pdVectorArray = pgVectorField.getGeometry().getVertexNormals();
        return PwVectorField.angleWithNormals(pgVectorField.getVector(n), pdVectorArray[n], pgVectorField.getVector(n2), pdVectorArray[n2]);
    }

    public static double calcAngle(PgVectorField pgVectorField, int n, int n2) {
        PdVector[] pdVectorArray = ((PgElementSet)pgVectorField.getGeometry()).getElementNormals();
        return PwVectorField.angleWithNormals(pgVectorField.getVector(n), pdVectorArray[n], pgVectorField.getVector(n2), pdVectorArray[n2]);
    }

    public static double angleWithNormals(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        double d;
        if (pdVector == null || pdVector3 == null || pdVector2 == null || pdVector4 == null) {
            PsDebug.warning((String)"Void input vectors.");
            return 0.0;
        }
        if (pdVector.getSize() != 3 || pdVector3.getSize() != 3 || pdVector2.getSize() != 3 || pdVector4.getSize() != 3) {
            PsDebug.warning((String)"Wrong size of input vectors.");
            return 0.0;
        }
        PdVector pdVector5 = PdVector.crossNew((PdVector)pdVector2, (PdVector)pdVector4);
        if (pdVector5.sqrLength() < 1.0E-10) {
            d = PdVector.angleWithOrientation((PdVector)pdVector, (PdVector)pdVector3, (PdVector)pdVector2);
        } else {
            d = PdVector.angleWithOrientation((PdVector)pdVector, (PdVector)pdVector5, (PdVector)pdVector2);
            d += PdVector.angleWithOrientation((PdVector)pdVector5, (PdVector)pdVector3, (PdVector)pdVector4);
        }
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    public static PgVectorField getInterpolatedElementBased(PgVectorField pgVectorField, PgVectorField pgVectorField2) {
        PgPointSet pgPointSet = pgVectorField.getGeometry();
        if (!(pgPointSet instanceof PgElementSet)) {
            PsDebug.warning((String)"underlying geometry of vector field is no element set");
            return null;
        }
        PgElementSet pgElementSet = (PgElementSet)pgPointSet;
        int n = pgVectorField.getBasedOn();
        int n2 = pgVectorField.getDimOfVectors();
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        if (pgVectorField2 == null) {
            pgVectorField2 = new PgVectorField(n2);
            pgVectorField2.setName(PsConfig.getMessage((int)45054) + " " + pgVectorField.getName());
        }
        if (n == 1) {
            pgVectorField2.copy((PsObject)pgVectorField);
            return pgVectorField2;
        }
        pgVectorField2.setBasedOn(1);
        pgVectorField2.setGeometry((PgPointSet)pgElementSet);
        int n3 = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (int i = 0; i < n3; ++i) {
            PdVector pdVector = new PdVector(n2);
            pdVector.setConstant(0.0);
            int n4 = piVectorArray[i].getSize();
            for (int j = 0; j < n4; ++j) {
                pdVector.add(pdVectorArray[piVectorArray[i].getEntry(j)]);
            }
            pdVector.multScalar(1.0 / (double)n4);
            pgVectorField2.setVector(i, pdVector);
        }
        return pgVectorField2;
    }

    public static PgVectorField getInterpolatedVertexBased(PgVectorField pgVectorField, PgVectorField pgVectorField2) {
        PgPointSet pgPointSet = pgVectorField.getGeometry();
        if (!(pgPointSet instanceof PgElementSet)) {
            PsDebug.warning((String)"underlying geometry of vector field is no element set");
            return null;
        }
        PgElementSet pgElementSet = (PgElementSet)pgPointSet;
        int n = pgVectorField.getBasedOn();
        int n2 = pgVectorField.getDimOfVectors();
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        if (pgVectorField2 == null) {
            pgVectorField2 = new PgVectorField(n2);
            pgVectorField2.setName(PsConfig.getMessage((int)45054) + " " + pgVectorField.getName());
        }
        if (n == 0) {
            pgVectorField2.copy((PsObject)pgVectorField);
            return pgVectorField2;
        }
        pgVectorField2.setBasedOn(0);
        pgVectorField2.setGeometry((PgPointSet)pgElementSet);
        int n3 = pgElementSet.getNumVertices();
        PgVertexStar pgVertexStar = new PgVertexStar();
        PdVector pdVector = new PdVector(n2);
        for (int i = 0; i < n3; ++i) {
            PdVector pdVector2 = new PdVector(n2);
            pdVector2.setConstant(0.0);
            pgVertexStar.makeVertexStar(pgElementSet, i, -1);
            PiVector piVector = pgVertexStar.getElement();
            int n4 = piVector.getSize();
            double d = 0.0;
            for (int j = 0; j < n4; ++j) {
                int n5 = piVector.m_data[j];
                double d2 = pgElementSet.getAreaOfElement(n5);
                pdVector.copy(pdVectorArray[n5]);
                pdVector.multScalar(d2);
                pdVector2.add(pdVector);
                d += d2;
            }
            if (d > 0.0) {
                pdVector2.multScalar(1.0 / d);
            }
            pgVectorField2.setVector(i, pdVector2);
        }
        return pgVectorField2;
    }

    public static PdVector[][] vectorFieldFromEigenVectors(PdVector[][] pdVectorArray, PgElementSet pgElementSet) {
        int n;
        int n2;
        int n3;
        double d;
        double d2;
        int n4;
        PdVector[] pdVectorArray2;
        int n5;
        int n6;
        int n7;
        int n8;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Given geometry is null. No action.");
            return pdVectorArray;
        }
        int n9 = pgElementSet.getNumVertices();
        if (pdVectorArray.length < 2 || pdVectorArray[0].length < n9 || pdVectorArray[1].length < n9) {
            PsDebug.warning((String)"Given vectors do not have the necessary size.");
            return pdVectorArray;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n10 = pgElementSet.getNumElements();
        PdVector pdVector = new PdVector(3);
        boolean[] blArray = new boolean[n9];
        PdVector pdVector2 = new PdVector(3);
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)2, (int)3);
        PdMatrix pdMatrix = new PdMatrix(3);
        Vector[] vectorArray = new Vector[n9];
        for (n8 = 0; n8 < n9; ++n8) {
            vectorArray[n8] = new Vector(6, 6);
        }
        for (int i = 0; i < n10; ++i) {
            n7 = piVectorArray[i].getSize();
            for (n6 = 0; n6 < n7; ++n6) {
                if (piVectorArray2[i].m_data[n6] > i) continue;
                n8 = piVectorArray[i].m_data[(n6 + 1) % n7];
                int n11 = piVectorArray[i].m_data[(n6 + 2) % n7];
                vectorArray[n8].addElement(new Integer(n11));
                vectorArray[n11].addElement(new Integer(n8));
            }
        }
        PiVector[] piVectorArray3 = new PiVector[n9];
        for (n6 = 0; n6 < n9; ++n6) {
            n7 = vectorArray[n6].size();
            piVectorArray3[n6] = new PiVector(n7);
            for (n5 = 0; n5 < n7; ++n5) {
                piVectorArray3[n6].m_data[n5] = (Integer)vectorArray[n6].elementAt(n5);
            }
        }
        vectorArray = null;
        boolean[] blArray2 = new boolean[n9];
        int[] nArray = new int[n9];
        int[] nArray2 = new int[n9];
        PuPriorityQueue puPriorityQueue = new PuPriorityQueue(n9);
        int n12 = 0;
        puPriorityQueue.enqueue(0, 0.0);
        nArray2[0] = -1;
        block5: while (n12 < n9) {
            int n13;
            int n14 = puPriorityQueue.extractMin();
            if (n14 == -1) {
                for (n13 = 0; n13 < n9; ++n13) {
                    if (blArray2[n13]) continue;
                    puPriorityQueue.enqueue(n13, 0.0);
                    nArray2[n13] = n13;
                    continue block5;
                }
                continue;
            }
            nArray[n12++] = n14;
            blArray2[n14] = true;
            n7 = piVectorArray3[n14].getSize();
            for (n13 = 0; n13 < n7; ++n13) {
                int n15 = piVectorArray3[n14].m_data[n13];
                if (blArray2[n15]) continue;
                double d3 = -Math.min(pdVectorArray[0][n14].length(), pdVectorArray[0][n15].length());
                if (puPriorityQueue.isElement(n15)) {
                    if (!(puPriorityQueue.getKey(n15) > d3)) continue;
                    puPriorityQueue.decreaseKey(n15, d3);
                    nArray2[n15] = n14;
                    continue;
                }
                puPriorityQueue.enqueue(n15, d3);
                nArray2[n15] = n14;
            }
        }
        pgElementSet.makeVertexNormals();
        PdVector[] pdVectorArray4 = pdVectorArray2 = pgElementSet.getVertexNormals();
        PdVector[][] pdVectorArrayArray = new PdVector[][]{PdVector.realloc(null, (int)n9, (int)3), PdVector.realloc(null, (int)n9, (int)3)};
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < n9; ++j) {
                pdVectorArrayArray[i][j].copyArray(pdVectorArray[i][j]);
                pdVectorArrayArray[i][j].normalize();
            }
        }
        for (n4 = 1; n4 < n9; ++n4) {
            double d4;
            n6 = nArray[n4];
            n5 = nArray2[n6];
            pdVector2.cross(pdVectorArray4[n5], pdVectorArray4[n6]);
            d2 = PdVector.angleWithOrientation((PdVector)pdVectorArray4[n5], (PdVector)pdVectorArray4[n6], (PdVector)pdVector2);
            PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector2, (double)d2);
            pdVectorArray3[0].leftMultMatrix(pdMatrix, pdVectorArrayArray[0][n5]);
            pdVectorArray3[1].leftMultMatrix(pdMatrix, pdVectorArrayArray[1][n5]);
            if (blArray[n5]) {
                d = Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[0][n6], (PdVector)pdVectorArray3[0])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[1][n6], (PdVector)pdVectorArray3[1]));
                d4 = Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[1][n6], (PdVector)pdVectorArray3[0])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[0][n6], (PdVector)pdVectorArray3[1]));
            } else {
                d4 = Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[0][n6], (PdVector)pdVectorArray3[0])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[1][n6], (PdVector)pdVectorArray3[1]));
                d = Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[1][n6], (PdVector)pdVectorArray3[0])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[0][n6], (PdVector)pdVectorArray3[1]));
            }
            if (!(d > d4)) continue;
            blArray[n6] = true;
        }
        n4 = Math.max(n10 / 10, 50);
        boolean bl = true;
        int n16 = 0;
        while (bl && n16 < n4) {
            bl = false;
            ++n16;
            for (n3 = 0; n3 < n9; ++n3) {
                int n17;
                n7 = piVectorArray3[n3].getSize();
                if (blArray[n3]) {
                    n6 = 1;
                    n17 = 0;
                } else {
                    n6 = 0;
                    n17 = 1;
                }
                double d5 = 0.0;
                d = 0.0;
                for (n2 = 0; n2 < n7; ++n2) {
                    int n18;
                    n = piVectorArray3[n3].m_data[n2];
                    if (blArray[n]) {
                        n5 = 1;
                        n18 = 0;
                    } else {
                        n5 = 0;
                        n18 = 1;
                    }
                    pdVector2.cross(pdVectorArray4[n], pdVectorArray4[n3]);
                    d2 = PdVector.angleWithOrientation((PdVector)pdVectorArray4[n], (PdVector)pdVectorArray4[n3], (PdVector)pdVector2);
                    PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector2, (double)d2);
                    pdVectorArray3[0].leftMultMatrix(pdMatrix, pdVectorArrayArray[0][n]);
                    pdVectorArray3[1].leftMultMatrix(pdMatrix, pdVectorArrayArray[1][n]);
                    d5 += Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[n6][n3], (PdVector)pdVectorArray3[n5])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[n17][n3], (PdVector)pdVectorArray3[n18]));
                    d += Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[n17][n3], (PdVector)pdVectorArray3[n5])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[n6][n3], (PdVector)pdVectorArray3[n18]));
                }
                if (!(d > d5)) continue;
                bl = true;
                blArray[n3] = !blArray[n3];
            }
        }
        for (n3 = 0; n3 < n9; ++n3) {
            if (!blArray[n3]) continue;
            pdVector.copyArray(pdVectorArray[0][n3]);
            pdVectorArray[0][n3].copyArray(pdVectorArray[1][n3]);
            pdVectorArray[1][n3].copyArray(pdVector);
        }
        for (n3 = 1; n3 < n9; ++n3) {
            n6 = nArray[n3];
            n5 = nArray2[n6];
            pdVector2.cross(pdVectorArray4[n5], pdVectorArray4[n6]);
            d2 = PdVector.angleWithOrientation((PdVector)pdVectorArray4[n5], (PdVector)pdVectorArray4[n6], (PdVector)pdVector2);
            PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector2, (double)d2);
            pdVectorArray3[0].leftMultMatrix(pdMatrix, pdVectorArray[0][n5]);
            pdVectorArray3[1].leftMultMatrix(pdMatrix, pdVectorArray[1][n5]);
            if (PdVector.dot((PdVector)pdVectorArray[0][n6], (PdVector)pdVectorArray3[0]) < 0.0) {
                pdVectorArray[0][n6].multScalar(-1.0);
            }
            if (!(PdVector.dot((PdVector)pdVectorArray[1][n6], (PdVector)pdVectorArray3[1]) < 0.0)) continue;
            pdVectorArray[1][n6].multScalar(-1.0);
        }
        for (n3 = 0; n3 < 2; ++n3) {
            for (n2 = 0; n2 < n9; ++n2) {
                pdVectorArrayArray[n3][n2].copyArray(pdVectorArray[n3][n2]);
                pdVectorArrayArray[n3][n2].normalize();
            }
        }
        bl = true;
        n16 = 0;
        while (bl && n16 < n4) {
            bl = false;
            ++n16;
            for (int i = 0; i < n9; ++i) {
                n7 = piVectorArray3[i].getSize();
                double d6 = 0.0;
                double d7 = 0.0;
                for (int j = 0; j < n7; ++j) {
                    n = piVectorArray3[i].m_data[j];
                    pdVector2.cross(pdVectorArray4[n], pdVectorArray4[i]);
                    d2 = PdVector.angleWithOrientation((PdVector)pdVectorArray4[n], (PdVector)pdVectorArray4[i], (PdVector)pdVector2);
                    PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector2, (double)d2);
                    pdVectorArray3[0].leftMultMatrix(pdMatrix, pdVectorArrayArray[0][n]);
                    pdVectorArray3[1].leftMultMatrix(pdMatrix, pdVectorArrayArray[1][n]);
                    d6 += PdVector.dot((PdVector)pdVectorArrayArray[0][i], (PdVector)pdVectorArray3[0]);
                    d7 += PdVector.dot((PdVector)pdVectorArrayArray[1][i], (PdVector)pdVectorArray3[1]);
                }
                if (d6 < 0.0) {
                    bl = true;
                    pdVectorArray[0][i].multScalar(-1.0);
                    pdVectorArrayArray[0][i].multScalar(-1.0);
                }
                if (!(d7 < 0.0)) continue;
                bl = true;
                pdVectorArray[1][i].multScalar(-1.0);
                pdVectorArrayArray[1][i].multScalar(-1.0);
            }
        }
        return pdVectorArray;
    }

    public static void rotateVectorField(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing vector field.");
            return;
        }
        PgPointSet pgPointSet = pgVectorField.getGeometry();
        if (pgPointSet == null) {
            PsDebug.warning((String)"missing geometry of vector field.");
            return;
        }
        int n = pgPointSet.getDimOfVertices();
        if (n != 2 && n != 3) {
            PsDebug.warning((String)("void dimension of vertices, currently muss be 2 or 3, found dim=" + String.valueOf(n)));
            return;
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        int n2 = pgVectorField.getNumVectors();
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].set(-pdVectorArray[i].m_data[1], pdVectorArray[i].m_data[0]);
            }
        } else {
            PdVector[] pdVectorArray2 = null;
            if (pgVectorField.getBasedOn() == 1) {
                if (!(pgPointSet instanceof PgElementSet)) {
                    PsDebug.warning((String)"geometry not instance of elementSet but has element-based vector field.");
                    return;
                }
                PgElementSet pgElementSet = (PgElementSet)pgPointSet;
                pgElementSet.makeElementNormals();
                pdVectorArray2 = pgElementSet.getElementNormals();
            } else {
                pgPointSet.makeVertexNormals();
                pdVectorArray2 = pgPointSet.getVertexNormals();
            }
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].cross(pdVectorArray2[i], pdVectorArray[i]);
            }
        }
    }

    public static void rotateVectorField(PgVectorField pgVectorField, double d) {
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing vector field.");
            return;
        }
        PgPointSet pgPointSet = pgVectorField.getGeometry();
        if (pgPointSet == null) {
            PsDebug.warning((String)"missing geometry of vector field.");
            return;
        }
        int n = pgPointSet.getDimOfVertices();
        if (n != 3) {
            PsDebug.warning((String)("void dimension of vertices, currently muss be 3, found dim=" + String.valueOf(n)));
            return;
        }
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        int n2 = pgVectorField.getNumVectors();
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].set(d2 * pdVectorArray[i].m_data[0] - d3 * pdVectorArray[i].m_data[1], d3 * pdVectorArray[i].m_data[0] + d2 * pdVectorArray[i].m_data[1]);
            }
        } else {
            PdVector[] pdVectorArray2 = null;
            PdVector pdVector = new PdVector(3);
            if (pgVectorField.getBasedOn() == 1) {
                if (!(pgPointSet instanceof PgElementSet)) {
                    PsDebug.warning((String)"geometry not instance of elementSet but has element-based vector field.");
                    return;
                }
                PgElementSet pgElementSet = (PgElementSet)pgPointSet;
                pgElementSet.makeElementNormals();
                pdVectorArray2 = pgElementSet.getElementNormals();
            } else {
                pgPointSet.makeVertexNormals();
                pdVectorArray2 = pgPointSet.getVertexNormals();
            }
            for (int i = 0; i < n2; ++i) {
                pdVector.cross(pdVectorArray2[i], pdVectorArray[i]);
                pdVectorArray[i].blend(d2, pdVectorArray[i], d3, pdVector);
            }
        }
    }

    public static void normalizeVectorField(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing vector field.");
            return;
        }
        int n = pgVectorField.getNumVectors();
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        for (int i = 0; i < n; ++i) {
            pdVectorArray[i].normalize();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

