/*
 * Decompiled with CFR 0.152.
 */
package jvx.vector;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.image.MemoryImageSource;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jvx.numeric.PnElementRK;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnLIC;
import jvx.numeric.PnVertexRK;
import jvx.numeric.PnVertexRKIgnoreDirection;
import jvx.project.PjWorkshop;

public class PwLIC
extends PjWorkshop
implements Runnable {
    protected PgElementSet m_elemSet;
    protected Thread m_thread;
    protected PuInteger m_vfIndex;
    protected PuInteger m_licSize = new PuInteger(PsConfig.getMessage((int)54110), null);
    protected PuInteger m_conv = new PuInteger(PsConfig.getMessage((int)54111), null);
    protected PuInteger m_minConv = new PuInteger(PsConfig.getMessage((int)54112), null);
    protected PuDouble m_coarseness = new PuDouble(PsConfig.getMessage((int)54113), null);
    protected PuDouble m_stepSize;
    protected boolean m_bFast;
    protected boolean m_bIgnoreDir;
    protected boolean m_bManyUpdates;
    protected PuDouble m_contrast;
    protected Dimension m_textureSize;
    protected int m_workPercent = -1;
    protected long m_time = -1L;
    protected PnLIC m_pnLic;
    protected boolean m_bPreview;
    static /* synthetic */ Class class$jvx$vector$PwLIC;

    public PwLIC() {
        super(PsConfig.getMessage((int)54109));
        this.m_vfIndex = new PuInteger(PsConfig.getMessage((int)54096), null);
        this.m_stepSize = new PuDouble(PsConfig.getMessage((int)54114), null);
        this.m_contrast = new PuDouble(PsConfig.getMessage((int)54304), null);
        this.m_textureSize = new Dimension(0, 0);
        this.m_pnLic = new PnLIC();
        if (this.getClass() == (class$jvx$vector$PwLIC == null ? (class$jvx$vector$PwLIC = PwLIC.class$("jvx.vector.PwLIC")) : class$jvx$vector$PwLIC)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bFast = false;
        this.m_bIgnoreDir = false;
        this.m_bManyUpdates = false;
        this.m_bPreview = false;
        this.m_licSize.setDefBounds(10, 500, 5, 50);
        this.m_licSize.setDefValue(50);
        this.m_licSize.init();
        this.m_conv.setDefBounds(2, 600, 1, 5);
        this.m_conv.setDefValue(100);
        this.m_conv.init();
        this.m_minConv.setDefBounds(1, 50, 1, 5);
        this.m_minConv.setDefValue(1);
        this.m_minConv.init();
        this.m_coarseness.setDefBounds(0.0, 1.0, 0.05, 0.1);
        this.m_coarseness.setDefValue(0.1);
        this.m_coarseness.init();
        this.m_vfIndex.setDefBounds(0, 0, 1, 2);
        this.m_vfIndex.setDefValue(0);
        this.m_vfIndex.init();
        this.m_stepSize.setDefBounds(0.001, 3.0, 0.05, 0.1);
        this.m_stepSize.setDefValue(0.1);
        this.m_stepSize.init();
        this.m_contrast.setDefBounds(0.0, 100.0, 1.0, 10.0);
        this.m_contrast.setDefValue(10.0);
        this.m_contrast.init();
        if (this.m_elemSet != null) {
            this.update(this.m_elemSet);
        }
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"workshop requires instance of PgElementSet.");
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometry;
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry must be a triangulation");
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_elemSet = pgElementSet;
        int n = this.m_elemSet.getNumVectorFields();
        if (n != this.m_vfIndex.getMax()) {
            if (n > 0) {
                this.m_vfIndex.setBounds(1, n, 1, 2);
            } else {
                this.m_vfIndex.setBounds(0, 0, 1, 2);
                this.m_vfIndex.setValue(0);
            }
            this.m_vfIndex.update((Object)this.m_vfIndex);
        }
        if (this.m_elemSet.getTexture() == null) {
            this.m_elemSet.setTexture(new PgTexture());
            this.m_elemSet.showElementTexture(true);
        }
        this.m_pnLic.setGeometry(this.m_elemSet);
        this.computeTextureSize();
    }

    public int getVectorFieldIndex() {
        return this.m_vfIndex.getValue() - 1;
    }

    public void setVectorFieldIndex(int n) {
        this.m_vfIndex.setValue(n + 1);
    }

    public boolean update(Object object) {
        return super.update(object);
    }

    public void computeTextureSize() {
        this.m_pnLic.setSize(this.m_licSize.getValue());
        this.m_textureSize = new Dimension(this.m_pnLic.getTextureWidth(), this.m_pnLic.getTextureHeight());
    }

    public void setFast(boolean bl) {
        this.m_bFast = bl;
    }

    public boolean getFast() {
        return this.m_bFast;
    }

    public void setIgnoreDirection(boolean bl) {
        this.m_bIgnoreDir = bl;
    }

    public boolean getIgnoreDirection() {
        return this.m_bIgnoreDir;
    }

    public void setSendManyUpdates(boolean bl) {
        this.m_bManyUpdates = bl;
    }

    public boolean getSendManyUpdates() {
        return this.m_bManyUpdates;
    }

    public void setConvolutionWidth(int n) {
        if (n > this.m_conv.getMax()) {
            this.m_conv.setBounds(this.m_conv.getMin(), n, this.m_conv.getLineIncr(), this.m_conv.getPageIncr());
        }
        this.m_conv.setValue(n);
        if (this.m_minConv.getValue() > n) {
            this.m_minConv.setValue(n);
        }
    }

    public int getConvolutionWidth() {
        return this.m_conv.getValue();
    }

    public double getCoarseness() {
        return this.m_coarseness.getValue();
    }

    public double getStepSize() {
        return this.m_stepSize.getValue();
    }

    public void setMinConvolutionWidth(int n) {
        if (n > this.m_minConv.getMax()) {
            this.m_minConv.setBounds(this.m_minConv.getMin(), n, this.m_minConv.getLineIncr(), this.m_minConv.getPageIncr());
        }
        this.m_minConv.setValue(n);
        if (this.m_minConv.getValue() > this.m_conv.getValue()) {
            this.m_minConv.setValue(this.m_conv.getValue());
        }
    }

    public int getMinConvolutionWidth() {
        return this.m_minConv.getValue();
    }

    public double getContrast() {
        return this.m_contrast.getValue();
    }

    public void setLICSize(int n) {
        if (n > this.m_licSize.getMax()) {
            this.m_licSize.setBounds(this.m_licSize.getMin(), n, this.m_licSize.getLineIncr(), this.m_licSize.getPageIncr());
        }
        this.m_licSize.setValue(n);
        this.m_textureSize = new Dimension(0, 0);
    }

    public int getLICSize() {
        return this.m_licSize.getValue();
    }

    public Dimension getTextureSize() {
        return this.m_textureSize;
    }

    public PnLIC getNumericLICInstance() {
        return this.m_pnLic;
    }

    public boolean isComputingLIC() {
        return this.m_thread != null && this.m_thread.isAlive();
    }

    public void startLIC() {
        this.startLIC(this.m_bPreview);
    }

    public void startLIC(boolean bl) {
        this.m_bPreview = bl;
        if (this.isComputingLIC()) {
            return;
        }
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    public void stopLIC() {
        if (this.m_thread == null) {
            return;
        }
        this.m_thread.interrupt();
        this.m_thread = null;
        System.gc();
        this.m_workPercent = -1;
        this.update(this);
    }

    public void close() {
        this.stopLIC();
        super.close();
    }

    protected int getWorkPercent() {
        return this.m_workPercent;
    }

    protected long getLicTime() {
        return this.m_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        long l;
        int n;
        if (this.m_elemSet == null) {
            PsDebug.warning((String)"missing element set");
            return;
        }
        if (this.m_vfIndex.getValue() <= 0 || this.m_vfIndex.getValue() > this.m_elemSet.getNumVectorFields()) {
            return;
        }
        PgVectorField pgVectorField = this.m_elemSet.getVectorField(this.m_vfIndex.getValue() - 1);
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing vector field");
            return;
        }
        long l2 = new Date().getTime();
        this.m_workPercent = 0;
        this.update(this);
        PnGeodesicRK pnGeodesicRK = null;
        if (pgVectorField.getBasedOn() == 1) {
            pnGeodesicRK = new PnElementRK(this.m_elemSet);
            ((PnElementRK)pnGeodesicRK).setVectorField(pgVectorField);
        } else if (this.m_bIgnoreDir) {
            pnGeodesicRK = new PnVertexRKIgnoreDirection(this.m_elemSet);
            ((PnVertexRKIgnoreDirection)pnGeodesicRK).setVectorField(pgVectorField);
        } else {
            pnGeodesicRK = new PnVertexRK(this.m_elemSet);
            ((PnVertexRK)pnGeodesicRK).setVectorField(pgVectorField);
        }
        pnGeodesicRK.setFirstOrder(this.m_bFast);
        PgTexture pgTexture = this.m_elemSet.getTexture();
        Frame frame = new Frame();
        double d = this.m_contrast.getValue();
        if (this.m_textureSize.width == 0 || this.m_textureSize.height == 0 || this.m_elemSet.getElementTextures() == null) {
            this.m_pnLic.setSize(this.m_licSize.getValue());
            this.m_textureSize = new Dimension(this.m_pnLic.getTextureWidth(), this.m_pnLic.getTextureHeight());
        }
        this.m_pnLic.setRungeKutta(pnGeodesicRK);
        int[] nArray = null;
        int n2 = this.m_pnLic.getTextureWidth();
        int n3 = this.m_pnLic.getTextureHeight();
        this.m_pnLic.setWorldConvolutionWidth((double)this.m_conv.getValue() / 100.0);
        this.m_pnLic.setMinConvolutionWidth(this.m_minConv.getValue());
        this.m_pnLic.setCoarseness(this.m_coarseness.getValue());
        this.m_pnLic.setStepSize(this.m_stepSize.getValue());
        int n4 = this.m_elemSet.getNumElements();
        this.m_pnLic.reset();
        PdVector[] pdVectorArray = new PdVector[n4];
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[n4];
        double[] dArray = new double[n4];
        PdVector[] pdVectorArray2 = new PdVector[3 * n4];
        boolean[] blArray = new boolean[n4];
        boolean[] blArray2 = new boolean[n4];
        for (n = 0; n < n4; ++n) {
            blArray[n] = false;
            blArray2[n] = false;
        }
        for (n = n4 - 1; n >= 0; --n) {
            if (this.m_bPreview) {
                this.m_pnLic.makeFastElement(n, pdVectorArray, pdBaryDirArray, dArray, pdVectorArray2, blArray, blArray2);
            } else {
                this.m_pnLic.makeElement(n);
            }
            if (!this.m_bPreview && (this.m_bManyUpdates || n4 >= 10 && n % (n4 / 10) == 0) && this.m_workPercent != -1) {
                this.m_workPercent = 100 - (int)((double)n / ((double)n4 / 10.0) * 10.0);
                nArray = this.m_pnLic.getPixArray(nArray, d);
                pgTexture.setImage(frame.createImage(new MemoryImageSource(n2, n3, nArray, 0, n2)));
                this.m_elemSet.showElements(true);
                this.m_elemSet.showElementTexture(true);
                this.update(this);
            } else if (!this.m_bPreview && n4 < 10 && this.m_workPercent != -1) {
                this.m_workPercent = (int)((double)(n4 - n) * 100.0 / (double)n4);
                nArray = this.m_pnLic.getPixArray(nArray, d);
                pgTexture.setImage(frame.createImage(new MemoryImageSource(n2, n3, nArray, 0, n2)));
                this.m_elemSet.showElements(true);
                this.m_elemSet.showElementTexture(true);
                this.update(this);
            }
            if (this.m_thread == null || this.m_thread.isInterrupted()) break;
        }
        PwLIC pwLIC = this;
        synchronized (pwLIC) {
            nArray = this.m_pnLic.getPixArray(nArray, d);
            pgTexture.setImage(frame.createImage(new MemoryImageSource(n2, n3, nArray, 0, n2)));
            this.m_elemSet.showElements(true);
            this.m_elemSet.showElementTexture(true);
        }
        this.m_workPercent = -1;
        this.m_time = l = new Date().getTime() - l2;
        nArray = null;
        this.m_thread = null;
        System.gc();
        this.update(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

