/*
 * Decompiled with CFR 0.152.
 */
package jvx.util;

import jv.object.PsDebug;
import jv.vecmath.PiVector;

public class PuQueue {
    private int[] m_data;
    private int m_numEntries;
    private int m_size;
    private int m_last;
    private int m_first;

    public PuQueue() {
        this(0);
    }

    public PuQueue(int n) {
        if (n <= 0) {
            n = 1;
        }
        this.m_size = n;
        this.m_data = new int[this.m_size];
        this.m_last = this.m_size - 1;
        this.m_first = 0;
        this.m_numEntries = 0;
    }

    public PuQueue(int[] nArray) {
        this(nArray != null ? nArray.length : 0);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.enqueue(nArray[i]);
            }
        }
    }

    public void copy(PuQueue puQueue) {
        if (puQueue == null) {
            PsDebug.warning((String)"Emtpy argument.");
            return;
        }
        this.m_size = puQueue.m_size;
        this.m_data = new int[this.m_size];
        System.arraycopy(puQueue.m_data, 0, this.m_data, 0, this.m_size);
        this.m_last = puQueue.m_last;
        this.m_first = puQueue.m_first;
        this.m_numEntries = puQueue.m_numEntries;
    }

    public static PuQueue copyNew(PuQueue puQueue) {
        if (puQueue == null) {
            return null;
        }
        PuQueue puQueue2 = new PuQueue(puQueue.getNumEntries());
        puQueue2.copy(puQueue);
        return puQueue2;
    }

    public int getNumEntries() {
        return this.m_numEntries;
    }

    public int getSize() {
        return this.m_size;
    }

    public void enqueue(int n) {
        if (this.m_numEntries >= this.m_size) {
            this.setSize((int)(1.5 * (double)this.m_numEntries) + 4);
        }
        this.m_last = (this.m_last + 1) % this.m_size;
        this.m_data[this.m_last] = n;
        ++this.m_numEntries;
    }

    public void setSize(int n) {
        if (n < 0 || n == this.getSize()) {
            return;
        }
        int[] nArray = new int[n];
        if (this.m_numEntries > 0) {
            if (this.m_first < this.m_last) {
                int n2 = Math.min(this.m_last, n - 1);
                for (int i = this.m_first; i <= n2; ++i) {
                    nArray[i - this.m_first] = this.m_data[i];
                }
            } else {
                int n3;
                int n4 = Math.min(this.m_size - 1, this.m_first + this.m_numEntries - 1);
                for (n3 = this.m_first; n3 <= n4; ++n3) {
                    nArray[n3 - this.m_first] = this.m_data[n3];
                }
                n4 = Math.min(this.m_last, this.m_numEntries + this.m_first - this.m_size - 1);
                for (n3 = 0; n3 <= n4; ++n3) {
                    nArray[n3 + this.m_size - this.m_first] = this.m_data[n3];
                }
            }
            this.m_first = 0;
            if (n < this.m_numEntries) {
                this.m_numEntries = n;
            }
            this.m_last = this.m_numEntries - 1;
        } else {
            this.m_first = 0;
            this.m_last = n - 1;
        }
        this.m_data = nArray;
        this.m_size = n;
    }

    public int extractFirst() {
        if (this.m_numEntries == 0) {
            return 0;
        }
        --this.m_numEntries;
        int n = this.m_data[this.m_first];
        this.m_first = (this.m_first + 1) % this.m_size;
        return n;
    }

    public int extractLast() {
        if (this.m_numEntries == 0) {
            return 0;
        }
        --this.m_numEntries;
        int n = this.m_data[this.m_last];
        this.m_last = (this.m_last - 1 + this.m_size) % this.m_size;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.m_numEntries > 0) {
            stringBuffer.append("{" + String.valueOf(this.m_data[this.m_first]));
            for (int i = 1; i < this.m_numEntries; ++i) {
                stringBuffer.append(", " + String.valueOf(this.m_data[(this.m_first + i) % this.m_size]));
            }
            stringBuffer.append("}");
        } else if (this.m_data != null) {
            stringBuffer.append("{}");
        } else {
            stringBuffer.append("m_data = null");
        }
        return stringBuffer.toString();
    }

    public PiVector toPiVector() {
        PiVector piVector = new PiVector(this.m_numEntries);
        for (int i = 0; i < this.m_numEntries; ++i) {
            piVector.m_data[i] = this.m_data[(this.m_first + i) % this.m_size];
        }
        return piVector;
    }

    public void removeAll() {
        this.m_last = this.m_size - 1;
        this.m_first = 0;
        this.m_numEntries = 0;
    }

    public boolean isEmpty() {
        return this.m_numEntries <= 0;
    }
}

