/*
 * Decompiled with CFR 0.152.
 */
package jvx.util;

import jv.object.PsDebug;
import jv.object.PsObject;

public final class PuPriorityQueue
extends PsObject {
    protected int[] m_elements;
    protected int[] m_positions;
    protected double[] m_keys;
    protected int m_capacity;
    protected int m_heapSize;

    public PuPriorityQueue(int n) {
        this.m_capacity = n;
        this.m_elements = new int[n];
        this.m_positions = new int[n];
        this.m_keys = new double[n];
        this.m_heapSize = 0;
        for (int i = 0; i < n; ++i) {
            this.m_keys[i] = Double.MAX_VALUE;
            this.m_elements[i] = -1;
            this.m_positions[i] = Integer.MAX_VALUE;
        }
    }

    public PuPriorityQueue(double[] dArray) {
        int n;
        this.m_capacity = dArray.length;
        this.m_elements = new int[dArray.length];
        this.m_positions = new int[dArray.length];
        this.m_keys = new double[dArray.length];
        this.m_heapSize = dArray.length;
        for (n = 0; n < dArray.length; ++n) {
            this.m_keys[n] = dArray[n];
            this.m_elements[n] = n;
            this.m_positions[n] = n;
        }
        for (n = this.m_heapSize >> 1; n >= 0; --n) {
            this.heapify(n);
        }
    }

    public PuPriorityQueue(int n, double d) {
        this.m_capacity = n;
        this.m_elements = new int[n];
        this.m_positions = new int[n];
        this.m_keys = new double[n];
        this.m_heapSize = n;
        for (int i = 0; i < n; ++i) {
            this.m_keys[i] = d;
            this.m_elements[i] = i;
            this.m_positions[i] = i;
        }
    }

    public int getCapacity() {
        return this.m_capacity;
    }

    public int[] getElements() {
        return this.m_elements;
    }

    public int getElement(int n) {
        return this.m_elements[n];
    }

    public int[] getPositions() {
        return this.m_positions;
    }

    public int getPosition(int n) {
        if (n < 0 || this.m_positions.length <= n) {
            PsDebug.warning((String)("specified element: " + n + " is out of the range of the heap."));
            return -1;
        }
        return this.m_positions[n] < this.m_heapSize ? this.m_positions[n] : -1;
    }

    public double[] getKeys() {
        return this.m_keys;
    }

    public double getKey(int n) {
        if (n < 0 || this.m_positions.length <= n) {
            PsDebug.warning((String)("specified element: " + n + " is out of the range of the heap."));
            return Double.POSITIVE_INFINITY;
        }
        return this.m_keys[n];
    }

    protected final int left(int n) {
        return (n << 1) + 1;
    }

    protected final int right(int n) {
        return (n << 1) + 2;
    }

    protected final int parent(int n) {
        if (n == 0) {
            return -1;
        }
        return n - 1 >> 1;
    }

    protected final void heapify(int n) {
        while (true) {
            int n2 = (n << 1) + 1;
            int n3 = (n << 1) + 2;
            int n4 = n;
            if (n2 < this.m_heapSize && this.m_keys[this.m_elements[n2]] < this.m_keys[this.m_elements[n]]) {
                n4 = n2;
            }
            if (n3 < this.m_heapSize && this.m_keys[this.m_elements[n3]] < this.m_keys[this.m_elements[n4]]) {
                n4 = n3;
            }
            if (n4 == n) {
                return;
            }
            int n5 = this.m_elements[n];
            this.m_positions[n5] = n4;
            this.m_elements[n] = this.m_elements[n4];
            this.m_positions[this.m_elements[n4]] = n;
            this.m_elements[n4] = n5;
            n = n4;
        }
    }

    public boolean decreaseKey(int n, double d) {
        if (!this.isElement(n)) {
            return false;
        }
        if (this.m_keys[n] < d) {
            return false;
        }
        int n2 = this.m_positions[n];
        int n3 = n2 - 1 >> 1;
        this.m_keys[n] = d;
        while (n3 >= 0 && this.m_keys[n] < this.m_keys[this.m_elements[n3]]) {
            int n4 = this.m_elements[n2];
            int n5 = n2;
            this.m_positions[this.m_elements[n2]] = n3;
            this.m_elements[n2] = this.m_elements[n3];
            this.m_positions[this.m_elements[n3]] = n5;
            this.m_elements[n3] = n4;
            n2 = n3;
            n3 = n2 - 1 >> 1;
        }
        return true;
    }

    public boolean increaseKey(int n, double d) {
        if (!this.isElement(n)) {
            return false;
        }
        if (this.m_keys[n] > d) {
            return false;
        }
        this.m_keys[n] = d;
        this.heapify(this.m_positions[n]);
        return true;
    }

    public boolean changeKey(int n, double d) {
        if (!this.isElement(n)) {
            return false;
        }
        if (this.m_keys[n] < d) {
            this.increaseKey(n, d);
        } else if (this.m_keys[n] > d) {
            this.decreaseKey(n, d);
        }
        return true;
    }

    public double getKeyOfMin() {
        if (this.m_heapSize < 1) {
            PsDebug.warning((String)"cannot return the key of the minimun, because the heap is empty.");
            return Double.POSITIVE_INFINITY;
        }
        return this.m_keys[this.m_elements[0]];
    }

    public int extractMin() {
        if (this.m_heapSize <= 1) {
            if (this.m_heapSize == 1) {
                this.m_heapSize = 0;
                this.m_positions[this.m_elements[0]] = Integer.MAX_VALUE;
                return this.m_elements[0];
            }
            return -1;
        }
        int n = this.m_elements[0];
        this.m_positions[n] = Integer.MAX_VALUE;
        this.m_positions[this.m_elements[this.m_heapSize - 1]] = 0;
        this.m_elements[0] = this.m_elements[this.m_heapSize - 1];
        --this.m_heapSize;
        this.heapify(0);
        return n;
    }

    public double extractElement(int n) {
        if (n < 0 || n >= this.m_positions.length || !this.isElement(n)) {
            PsDebug.warning((String)"Index out of range.");
            return Double.NaN;
        }
        double d = this.m_keys[n];
        this.decreaseKey(n, Double.NEGATIVE_INFINITY);
        this.extractMin();
        this.m_keys[n] = d;
        return d;
    }

    public int getHeapSize() {
        return this.m_heapSize;
    }

    public boolean isEmpty() {
        return this.m_heapSize == 0;
    }

    public Object clone() {
        PuPriorityQueue puPriorityQueue = (PuPriorityQueue)((Object)super.clone());
        puPriorityQueue.m_heapSize = this.m_heapSize;
        for (int i = 0; i < this.m_keys.length; ++i) {
            puPriorityQueue.m_keys[i] = this.m_keys[i];
            puPriorityQueue.m_elements[i] = this.m_elements[i];
            puPriorityQueue.m_positions[i] = this.m_positions[i];
        }
        return puPriorityQueue;
    }

    public boolean isElement(int n) {
        return this.m_positions[n] < this.m_heapSize;
    }

    public boolean enqueue(int n, double d) {
        if (n < 0 || n >= this.m_capacity) {
            PsDebug.warning((String)"Element index out of bounds");
            return false;
        }
        if (this.isElement(n)) {
            return false;
        }
        this.m_keys[n] = Double.MAX_VALUE;
        this.m_elements[this.m_heapSize] = n;
        this.m_positions[n] = this.m_heapSize++;
        this.decreaseKey(n, d);
        return true;
    }

    public boolean enqueueOrDecrease(int n, double d) {
        if (this.isElement(n)) {
            if (this.m_keys[n] > d) {
                this.decreaseKey(n, d);
                return true;
            }
            return false;
        }
        this.enqueue(n, d);
        return true;
    }

    public void emptyHeap() {
        for (int i = this.m_heapSize - 1; i >= 0; --i) {
            this.m_keys[this.m_elements[i]] = Double.MAX_VALUE;
            this.m_positions[this.m_elements[i]] = Integer.MAX_VALUE;
            this.m_elements[i] = -1;
        }
        this.m_heapSize = 0;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\t ******* PuPriorityQueue *******\n");
        stringBuffer.append("\t Heap Size: " + this.m_heapSize + "\n");
        stringBuffer.append("\t Capacity:  " + this.m_elements.length + "\n");
        stringBuffer.append("\t Elements: (");
        for (n = 0; n < this.m_heapSize; ++n) {
            stringBuffer.append("" + this.m_elements[n] + ", ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        stringBuffer.append(")\n");
        stringBuffer.append("\t Keys: (");
        for (n = 0; n < this.m_heapSize; ++n) {
            stringBuffer.append("" + this.m_keys[this.m_elements[n]] + ", ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        stringBuffer.append(")\n");
        return stringBuffer.toString();
    }
}

