/*
 * Decompiled with CFR 0.152.
 */
package jvx.util;

import jvx.util.PuBinaryTreeNode;
import jvx.util.PuCompare_If;

public class PuAVLTree {
    private PuBinaryTreeNode m_root;
    private int m_size;
    private PuCompare_If m_comparator;
    private boolean m_bAvoidDuplicates = true;

    public PuAVLTree(PuCompare_If puCompare_If) {
        this.m_comparator = puCompare_If;
        this.m_root = null;
        this.m_size = 0;
    }

    public int getSize() {
        return this.m_size;
    }

    public PuBinaryTreeNode getRoot() {
        return this.m_root;
    }

    public void setAvoidDuplicates(boolean bl) {
        this.m_bAvoidDuplicates = bl;
    }

    public boolean getAvoidDuplicates() {
        return this.m_bAvoidDuplicates;
    }

    public PuBinaryTreeNode[] getSortedList() {
        PuBinaryTreeNode[] puBinaryTreeNodeArray = new PuBinaryTreeNode[this.m_size];
        this.fillList(puBinaryTreeNodeArray, this.m_root, 0);
        return puBinaryTreeNodeArray;
    }

    private int fillList(PuBinaryTreeNode[] puBinaryTreeNodeArray, PuBinaryTreeNode puBinaryTreeNode, int n) {
        int n2 = n;
        if (puBinaryTreeNode.getLeft() != null) {
            n2 = this.fillList(puBinaryTreeNodeArray, puBinaryTreeNode.getLeft(), n2);
        }
        puBinaryTreeNodeArray[n2] = puBinaryTreeNode;
        ++n2;
        if (puBinaryTreeNode.getRight() != null) {
            n2 = this.fillList(puBinaryTreeNodeArray, puBinaryTreeNode.getRight(), n2);
        }
        return n2;
    }

    public int insert(Object object) {
        if (this.m_root == null) {
            this.m_root = new PuBinaryTreeNode(0, object);
            this.m_root.setParent(null);
            this.m_root.setLeft(null);
            this.m_root.setRight(null);
            this.m_root.setHeight(0);
            this.m_size = 1;
            return 0;
        }
        return this.insert(object, this.m_root);
    }

    private int insert(Object object, PuBinaryTreeNode puBinaryTreeNode) {
        int n = this.compareValue(puBinaryTreeNode.getValue(), object);
        if (this.m_bAvoidDuplicates && n == 0) {
            return puBinaryTreeNode.getKey();
        }
        if (n < 0) {
            if (puBinaryTreeNode.getRight() == null) {
                PuBinaryTreeNode puBinaryTreeNode2 = new PuBinaryTreeNode(this.m_size, object);
                puBinaryTreeNode2.setParent(puBinaryTreeNode);
                puBinaryTreeNode.setRight(puBinaryTreeNode2);
                this.balance(puBinaryTreeNode);
                ++this.m_size;
                return this.m_size - 1;
            }
            return this.insert(object, puBinaryTreeNode.getRight());
        }
        if (puBinaryTreeNode.getLeft() == null) {
            PuBinaryTreeNode puBinaryTreeNode3 = new PuBinaryTreeNode(this.m_size, object);
            puBinaryTreeNode3.setParent(puBinaryTreeNode);
            puBinaryTreeNode.setLeft(puBinaryTreeNode3);
            this.balance(puBinaryTreeNode);
            ++this.m_size;
            return this.m_size - 1;
        }
        return this.insert(object, puBinaryTreeNode.getLeft());
    }

    private void balance(PuBinaryTreeNode puBinaryTreeNode) {
        int n = puBinaryTreeNode.getHeight();
        this.computeHeight(puBinaryTreeNode);
        int n2 = -1;
        if (puBinaryTreeNode.getRight() != null) {
            n2 = puBinaryTreeNode.getRight().getHeight();
        }
        int n3 = -1;
        if (puBinaryTreeNode.getLeft() != null) {
            n3 = puBinaryTreeNode.getLeft().getHeight();
        }
        if (n2 - n3 > 1) {
            PuBinaryTreeNode puBinaryTreeNode2;
            PuBinaryTreeNode puBinaryTreeNode3 = puBinaryTreeNode.getRight();
            int n4 = -1;
            if (puBinaryTreeNode3.getRight() != null) {
                n4 = puBinaryTreeNode3.getRight().getHeight();
            }
            int n5 = -1;
            if (puBinaryTreeNode3.getLeft() != null) {
                n5 = puBinaryTreeNode3.getLeft().getHeight();
            }
            if (n5 > n4) {
                PuBinaryTreeNode puBinaryTreeNode4;
                PuBinaryTreeNode puBinaryTreeNode5 = puBinaryTreeNode3.getLeft();
                PuBinaryTreeNode puBinaryTreeNode6 = puBinaryTreeNode5.getLeft();
                puBinaryTreeNode.setRight(puBinaryTreeNode6);
                if (puBinaryTreeNode6 != null) {
                    puBinaryTreeNode6.setParent(puBinaryTreeNode);
                }
                PuBinaryTreeNode puBinaryTreeNode7 = puBinaryTreeNode5.getRight();
                puBinaryTreeNode3.setLeft(puBinaryTreeNode7);
                if (puBinaryTreeNode7 != null) {
                    puBinaryTreeNode7.setParent(puBinaryTreeNode3);
                }
                if ((puBinaryTreeNode4 = puBinaryTreeNode.getParent()) != null) {
                    if (puBinaryTreeNode4.getLeft() == puBinaryTreeNode) {
                        puBinaryTreeNode4.setLeft(puBinaryTreeNode5);
                    } else {
                        puBinaryTreeNode4.setRight(puBinaryTreeNode5);
                    }
                } else {
                    this.m_root = puBinaryTreeNode5;
                }
                puBinaryTreeNode5.setParent(puBinaryTreeNode4);
                puBinaryTreeNode5.setRight(puBinaryTreeNode3);
                puBinaryTreeNode3.setParent(puBinaryTreeNode5);
                puBinaryTreeNode5.setLeft(puBinaryTreeNode);
                puBinaryTreeNode.setParent(puBinaryTreeNode5);
                this.computeHeight(puBinaryTreeNode);
                this.computeHeight(puBinaryTreeNode3);
                this.computeHeight(puBinaryTreeNode5);
                if (puBinaryTreeNode4 != null) {
                    this.balance(puBinaryTreeNode4);
                }
                return;
            }
            PuBinaryTreeNode puBinaryTreeNode8 = puBinaryTreeNode3.getLeft();
            puBinaryTreeNode.setRight(puBinaryTreeNode8);
            if (puBinaryTreeNode8 != null) {
                puBinaryTreeNode8.setParent(puBinaryTreeNode);
            }
            if ((puBinaryTreeNode2 = puBinaryTreeNode.getParent()) != null) {
                if (puBinaryTreeNode2.getLeft() == puBinaryTreeNode) {
                    puBinaryTreeNode2.setLeft(puBinaryTreeNode3);
                } else {
                    puBinaryTreeNode2.setRight(puBinaryTreeNode3);
                }
            } else {
                this.m_root = puBinaryTreeNode3;
            }
            puBinaryTreeNode3.setParent(puBinaryTreeNode2);
            puBinaryTreeNode3.setLeft(puBinaryTreeNode);
            puBinaryTreeNode.setParent(puBinaryTreeNode3);
            this.computeHeight(puBinaryTreeNode);
            this.computeHeight(puBinaryTreeNode3);
            if (puBinaryTreeNode2 != null) {
                this.balance(puBinaryTreeNode2);
            }
            return;
        }
        if (n3 - n2 > 1) {
            PuBinaryTreeNode puBinaryTreeNode9;
            PuBinaryTreeNode puBinaryTreeNode10 = puBinaryTreeNode.getLeft();
            int n6 = -1;
            if (puBinaryTreeNode10.getLeft() != null) {
                n6 = puBinaryTreeNode10.getLeft().getHeight();
            }
            int n7 = -1;
            if (puBinaryTreeNode10.getRight() != null) {
                n7 = puBinaryTreeNode10.getRight().getHeight();
            }
            if (n7 > n6) {
                PuBinaryTreeNode puBinaryTreeNode11;
                PuBinaryTreeNode puBinaryTreeNode12 = puBinaryTreeNode10.getRight();
                PuBinaryTreeNode puBinaryTreeNode13 = puBinaryTreeNode12.getRight();
                puBinaryTreeNode.setLeft(puBinaryTreeNode13);
                if (puBinaryTreeNode13 != null) {
                    puBinaryTreeNode13.setParent(puBinaryTreeNode);
                }
                PuBinaryTreeNode puBinaryTreeNode14 = puBinaryTreeNode12.getLeft();
                puBinaryTreeNode10.setRight(puBinaryTreeNode14);
                if (puBinaryTreeNode14 != null) {
                    puBinaryTreeNode14.setParent(puBinaryTreeNode10);
                }
                if ((puBinaryTreeNode11 = puBinaryTreeNode.getParent()) != null) {
                    if (puBinaryTreeNode11.getRight() == puBinaryTreeNode) {
                        puBinaryTreeNode11.setRight(puBinaryTreeNode12);
                    } else {
                        puBinaryTreeNode11.setLeft(puBinaryTreeNode12);
                    }
                } else {
                    this.m_root = puBinaryTreeNode12;
                }
                puBinaryTreeNode12.setParent(puBinaryTreeNode11);
                puBinaryTreeNode12.setLeft(puBinaryTreeNode10);
                puBinaryTreeNode10.setParent(puBinaryTreeNode12);
                puBinaryTreeNode12.setRight(puBinaryTreeNode);
                puBinaryTreeNode.setParent(puBinaryTreeNode12);
                this.computeHeight(puBinaryTreeNode);
                this.computeHeight(puBinaryTreeNode10);
                this.computeHeight(puBinaryTreeNode12);
                if (puBinaryTreeNode11 != null) {
                    this.balance(puBinaryTreeNode11);
                }
                return;
            }
            PuBinaryTreeNode puBinaryTreeNode15 = puBinaryTreeNode10.getRight();
            puBinaryTreeNode.setLeft(puBinaryTreeNode15);
            if (puBinaryTreeNode15 != null) {
                puBinaryTreeNode15.setParent(puBinaryTreeNode);
            }
            if ((puBinaryTreeNode9 = puBinaryTreeNode.getParent()) != null) {
                if (puBinaryTreeNode9.getRight() == puBinaryTreeNode) {
                    puBinaryTreeNode9.setRight(puBinaryTreeNode10);
                } else {
                    puBinaryTreeNode9.setLeft(puBinaryTreeNode10);
                }
            } else {
                this.m_root = puBinaryTreeNode10;
            }
            puBinaryTreeNode10.setParent(puBinaryTreeNode9);
            puBinaryTreeNode10.setRight(puBinaryTreeNode);
            puBinaryTreeNode.setParent(puBinaryTreeNode10);
            this.computeHeight(puBinaryTreeNode);
            this.computeHeight(puBinaryTreeNode10);
            if (puBinaryTreeNode9 != null) {
                this.balance(puBinaryTreeNode9);
            }
            return;
        }
        if (n == puBinaryTreeNode.getHeight()) {
            return;
        }
        if (puBinaryTreeNode.getParent() != null) {
            this.balance(puBinaryTreeNode.getParent());
        }
    }

    public int getHeight() {
        if (this.m_root == null) {
            return 0;
        }
        return this.m_root.getHeight();
    }

    public void remove(Object object) {
        PuBinaryTreeNode puBinaryTreeNode = this.findNode(object, this.m_root);
        if (puBinaryTreeNode != null) {
            this.removeNode(puBinaryTreeNode);
        }
    }

    public Object findNode(Object object) {
        if (this.m_root == null) {
            return null;
        }
        PuBinaryTreeNode puBinaryTreeNode = this.findNode(object, this.m_root);
        if (puBinaryTreeNode != null) {
            return puBinaryTreeNode.getValue();
        }
        return null;
    }

    private PuBinaryTreeNode findNode(Object object, PuBinaryTreeNode puBinaryTreeNode) {
        int n = this.compareValue(puBinaryTreeNode.getValue(), object);
        if (n == 0) {
            return puBinaryTreeNode;
        }
        if (n < 0) {
            if (puBinaryTreeNode.getRight() == null) {
                return null;
            }
            return this.findNode(object, puBinaryTreeNode.getRight());
        }
        if (puBinaryTreeNode.getLeft() == null) {
            return null;
        }
        return this.findNode(object, puBinaryTreeNode.getLeft());
    }

    public void removeNode(PuBinaryTreeNode puBinaryTreeNode) {
        PuBinaryTreeNode puBinaryTreeNode2 = puBinaryTreeNode.getLeft();
        PuBinaryTreeNode puBinaryTreeNode3 = puBinaryTreeNode.getRight();
        PuBinaryTreeNode puBinaryTreeNode4 = puBinaryTreeNode.getParent();
        if (puBinaryTreeNode2 == null && puBinaryTreeNode3 == null && puBinaryTreeNode4 == null) {
            if (puBinaryTreeNode == this.m_root) {
                this.m_root = null;
                this.m_size = 0;
            }
            return;
        }
        if (puBinaryTreeNode2 == null) {
            if (puBinaryTreeNode3 == null) {
                if (puBinaryTreeNode4.getRight() == puBinaryTreeNode) {
                    puBinaryTreeNode4.setRight(null);
                } else {
                    puBinaryTreeNode4.setLeft(null);
                }
                puBinaryTreeNode.setParent(null);
                --this.m_size;
                this.balance(puBinaryTreeNode4);
                return;
            }
            puBinaryTreeNode3.setParent(puBinaryTreeNode4);
            if (puBinaryTreeNode4 == null) {
                this.m_root = puBinaryTreeNode3;
            } else {
                if (puBinaryTreeNode4.getRight() == puBinaryTreeNode) {
                    puBinaryTreeNode4.setRight(puBinaryTreeNode3);
                } else {
                    puBinaryTreeNode4.setLeft(puBinaryTreeNode3);
                }
                puBinaryTreeNode.setParent(null);
            }
            puBinaryTreeNode.setRight(null);
            --this.m_size;
            this.balance(puBinaryTreeNode3);
            return;
        }
        if (puBinaryTreeNode3 == null) {
            puBinaryTreeNode2.setParent(puBinaryTreeNode4);
            if (puBinaryTreeNode4 == null) {
                this.m_root = puBinaryTreeNode2;
            } else {
                if (puBinaryTreeNode4.getRight() == puBinaryTreeNode) {
                    puBinaryTreeNode4.setRight(puBinaryTreeNode2);
                } else {
                    puBinaryTreeNode4.setLeft(puBinaryTreeNode2);
                }
                puBinaryTreeNode.setParent(null);
            }
            puBinaryTreeNode.setLeft(null);
            --this.m_size;
            this.balance(puBinaryTreeNode2);
            return;
        }
        PuBinaryTreeNode puBinaryTreeNode5 = puBinaryTreeNode2.getRight();
        if (puBinaryTreeNode5 == null) {
            puBinaryTreeNode2.setParent(puBinaryTreeNode4);
            puBinaryTreeNode2.setRight(puBinaryTreeNode3);
            puBinaryTreeNode3.setParent(puBinaryTreeNode2);
            if (puBinaryTreeNode4 == null) {
                this.m_root = puBinaryTreeNode2;
            } else {
                if (puBinaryTreeNode4.getRight() == puBinaryTreeNode) {
                    puBinaryTreeNode4.setRight(puBinaryTreeNode2);
                } else {
                    puBinaryTreeNode4.setLeft(puBinaryTreeNode2);
                }
                puBinaryTreeNode.setParent(null);
            }
            puBinaryTreeNode.setLeft(null);
            puBinaryTreeNode.setRight(null);
            --this.m_size;
            this.balance(puBinaryTreeNode2);
            return;
        }
        PuBinaryTreeNode puBinaryTreeNode6 = puBinaryTreeNode2;
        while (puBinaryTreeNode5.getRight() != null) {
            puBinaryTreeNode6 = puBinaryTreeNode5;
            puBinaryTreeNode5 = puBinaryTreeNode5.getRight();
        }
        PuBinaryTreeNode puBinaryTreeNode7 = puBinaryTreeNode5.getLeft();
        puBinaryTreeNode6.setRight(puBinaryTreeNode7);
        if (puBinaryTreeNode7 != null) {
            puBinaryTreeNode7.setParent(puBinaryTreeNode6);
        }
        puBinaryTreeNode5.setParent(puBinaryTreeNode4);
        if (puBinaryTreeNode4 == null) {
            this.m_root = puBinaryTreeNode5;
        } else {
            if (puBinaryTreeNode4.getRight() == puBinaryTreeNode) {
                puBinaryTreeNode4.setRight(puBinaryTreeNode5);
            } else {
                puBinaryTreeNode4.setLeft(puBinaryTreeNode5);
            }
            puBinaryTreeNode.setParent(null);
        }
        puBinaryTreeNode5.setRight(puBinaryTreeNode3);
        puBinaryTreeNode3.setParent(puBinaryTreeNode5);
        puBinaryTreeNode5.setLeft(puBinaryTreeNode2);
        puBinaryTreeNode2.setParent(puBinaryTreeNode5);
        puBinaryTreeNode.setRight(null);
        puBinaryTreeNode.setLeft(null);
        --this.m_size;
        this.balance(puBinaryTreeNode6);
        this.computeHeight(puBinaryTreeNode5);
    }

    private void computeHeight(PuBinaryTreeNode puBinaryTreeNode) {
        int n;
        int n2 = 0;
        if (puBinaryTreeNode.getRight() != null) {
            n2 = puBinaryTreeNode.getRight().getHeight() + 1;
        }
        if (puBinaryTreeNode.getLeft() != null && (n = puBinaryTreeNode.getLeft().getHeight()) + 1 > n2) {
            n2 = n + 1;
        }
        puBinaryTreeNode.setHeight(n2);
    }

    public int compareValue(Object object, Object object2) {
        return this.m_comparator.compare(object, object2);
    }
}

