/*
 * Decompiled with CFR 0.152.
 */
package jvx.thirdParty.jpegEncode;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jv.loader.PsImageCoderIf;
import jv.object.PsDebug;
import jvx.thirdParty.jpegEncode.DCT;
import jvx.thirdParty.jpegEncode.Huffman;
import jvx.thirdParty.jpegEncode.JpegInfo;

public class JpegEncoder
extends Frame
implements PsImageCoderIf {
    protected BufferedOutputStream m_outStream;
    protected Image m_image;
    protected JpegInfo m_jpegObj;
    protected Huffman m_huf;
    protected DCT m_dct;
    protected int m_imageHeight;
    protected int m_imageWidth;
    protected int m_quality;
    protected int m_code;
    protected static int[] JPEG_NATURAL_ORDER = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public JpegEncoder() {
        this.setQuality(95);
    }

    public JpegEncoder(Image image, int n, OutputStream outputStream) {
        this.setImage(image);
        this.setQuality(n);
        this.setOutputStream(outputStream);
    }

    public void setImage(Image image) {
        this.m_image = image;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.m_outStream = new BufferedOutputStream(outputStream);
    }

    protected void setQuality(int n) {
        this.m_dct = new DCT(n);
        this.m_quality = n;
    }

    protected int getQuality() {
        return this.m_quality;
    }

    public void encode() {
        if (this.m_image == null) {
            PsDebug.warning((String)"missing image");
            return;
        }
        if (this.m_outStream == null) {
            PsDebug.warning((String)"missing output stream");
            return;
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.m_image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_jpegObj = new JpegInfo(this.m_image);
        this.m_imageHeight = this.m_jpegObj.imageHeight;
        this.m_imageWidth = this.m_jpegObj.imageWidth;
        this.m_huf = new Huffman(this.m_imageWidth, this.m_imageHeight);
        this.WriteHeaders(this.m_outStream);
        this.WriteCompressedData(this.m_outStream);
        this.WriteEOI(this.m_outStream);
        try {
            this.m_outStream.flush();
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("IO Error: " + iOException.getMessage()));
        }
    }

    protected void WriteCompressedData(BufferedOutputStream bufferedOutputStream) {
        int n;
        float[][] fArray = new float[8][8];
        double[][] dArray = new double[8][8];
        int[] nArray = new int[64];
        int[] nArray2 = new int[this.m_jpegObj.NumberOfComponents];
        int n2 = this.m_imageWidth % 8 != 0 ? (int)(Math.floor((double)this.m_imageWidth / 8.0) + 1.0) * 8 : this.m_imageWidth;
        int n3 = this.m_imageHeight % 8 != 0 ? (int)(Math.floor((double)this.m_imageHeight / 8.0) + 1.0) * 8 : this.m_imageHeight;
        for (n = 0; n < this.m_jpegObj.NumberOfComponents; ++n) {
            n2 = Math.min(n2, this.m_jpegObj.BlockWidth[n]);
            n3 = Math.min(n3, this.m_jpegObj.BlockHeight[n]);
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                n4 = j * 8;
                int n5 = i * 8;
                for (n = 0; n < this.m_jpegObj.NumberOfComponents; ++n) {
                    float[][] fArray2 = (float[][])this.m_jpegObj.Components[n];
                    for (int k = 0; k < this.m_jpegObj.VsampFactor[n]; ++k) {
                        for (int i2 = 0; i2 < this.m_jpegObj.HsampFactor[n]; ++i2) {
                            int n6 = i2 * 8;
                            int n7 = k * 8;
                            for (int i3 = 0; i3 < 8; ++i3) {
                                for (int i4 = 0; i4 < 8; ++i4) {
                                    fArray[i3][i4] = fArray2[n5 + n7 + i3][n4 + n6 + i4];
                                }
                            }
                            dArray = this.m_dct.forwardDCT(fArray);
                            nArray = this.m_dct.quantizeBlock(dArray, this.m_jpegObj.QtableNumber[n]);
                            this.m_huf.HuffmanBlockEncoder(bufferedOutputStream, nArray, nArray2[n], this.m_jpegObj.DCtableNumber[n], this.m_jpegObj.ACtableNumber[n]);
                            nArray2[n] = nArray[0];
                        }
                    }
                }
            }
        }
        this.m_huf.flushBuffer(bufferedOutputStream);
    }

    protected void WriteEOI(BufferedOutputStream bufferedOutputStream) {
        byte[] byArray = new byte[]{-1, -39};
        this.WriteMarker(byArray, bufferedOutputStream);
    }

    protected void WriteHeaders(BufferedOutputStream bufferedOutputStream) {
        int n;
        int n2;
        byte[] byArray = new byte[]{-1, -40};
        this.WriteMarker(byArray, bufferedOutputStream);
        byte[] byArray2 = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        this.WriteArray(byArray2, bufferedOutputStream);
        String string = new String();
        string = this.m_jpegObj.getComment();
        int n3 = string.length();
        byte[] byArray3 = new byte[n3 + 4];
        byArray3[0] = -1;
        byArray3[1] = -2;
        byArray3[2] = (byte)(n3 >> 8 & 0xFF);
        byArray3[3] = (byte)(n3 & 0xFF);
        System.arraycopy(this.m_jpegObj.Comment.getBytes(), 0, byArray3, 4, this.m_jpegObj.Comment.length());
        this.WriteArray(byArray3, bufferedOutputStream);
        byte[] byArray4 = new byte[134];
        byArray4[0] = -1;
        byArray4[1] = -37;
        byArray4[2] = 0;
        byArray4[3] = -124;
        int n4 = 4;
        for (n2 = 0; n2 < 2; ++n2) {
            byArray4[n4++] = (byte)(0 + n2);
            int[] nArray = (int[])this.m_dct.quantum[n2];
            for (n = 0; n < 64; ++n) {
                byArray4[n4++] = (byte)nArray[JPEG_NATURAL_ORDER[n]];
            }
        }
        this.WriteArray(byArray4, bufferedOutputStream);
        byte[] byArray5 = new byte[19];
        byArray5[0] = -1;
        byArray5[1] = -64;
        byArray5[2] = 0;
        byArray5[3] = 17;
        byArray5[4] = (byte)this.m_jpegObj.Precision;
        byArray5[5] = (byte)(this.m_jpegObj.imageHeight >> 8 & 0xFF);
        byArray5[6] = (byte)(this.m_jpegObj.imageHeight & 0xFF);
        byArray5[7] = (byte)(this.m_jpegObj.imageWidth >> 8 & 0xFF);
        byArray5[8] = (byte)(this.m_jpegObj.imageWidth & 0xFF);
        byArray5[9] = (byte)this.m_jpegObj.NumberOfComponents;
        int n5 = 10;
        for (n2 = 0; n2 < byArray5[9]; ++n2) {
            byArray5[n5++] = (byte)this.m_jpegObj.CompID[n2];
            byArray5[n5++] = (byte)((this.m_jpegObj.HsampFactor[n2] << 4) + this.m_jpegObj.VsampFactor[n2]);
            byArray5[n5++] = (byte)this.m_jpegObj.QtableNumber[n2];
        }
        this.WriteArray(byArray5, bufferedOutputStream);
        n3 = 2;
        n5 = 4;
        int n6 = 4;
        byte[] byArray6 = new byte[17];
        byte[] byArray7 = new byte[4];
        byArray7[0] = -1;
        byArray7[1] = -60;
        for (n2 = 0; n2 < 4; ++n2) {
            int n7 = 0;
            byArray6[n5++ - n6] = (byte)((int[])this.m_huf.bits.elementAt(n2))[0];
            for (n = 1; n < 17; ++n) {
                int n8 = ((int[])this.m_huf.bits.elementAt(n2))[n];
                byArray6[n5++ - n6] = (byte)n8;
                n7 += n8;
            }
            int n9 = n5;
            byte[] byArray8 = new byte[n7];
            for (n = 0; n < n7; ++n) {
                byArray8[n5++ - n9] = (byte)((int[])this.m_huf.val.elementAt(n2))[n];
            }
            byte[] byArray9 = new byte[n5];
            System.arraycopy(byArray7, 0, byArray9, 0, n6);
            System.arraycopy(byArray6, 0, byArray9, n6, 17);
            System.arraycopy(byArray8, 0, byArray9, n6 + 17, n7);
            byArray7 = byArray9;
            n6 = n5;
        }
        byArray7[2] = (byte)(n5 - 2 >> 8 & 0xFF);
        byArray7[3] = (byte)(n5 - 2 & 0xFF);
        this.WriteArray(byArray7, bufferedOutputStream);
        byte[] byArray10 = new byte[14];
        byArray10[0] = -1;
        byArray10[1] = -38;
        byArray10[2] = 0;
        byArray10[3] = 12;
        byArray10[4] = (byte)this.m_jpegObj.NumberOfComponents;
        n5 = 5;
        for (n2 = 0; n2 < byArray10[4]; ++n2) {
            byArray10[n5++] = (byte)this.m_jpegObj.CompID[n2];
            byArray10[n5++] = (byte)((this.m_jpegObj.DCtableNumber[n2] << 4) + this.m_jpegObj.ACtableNumber[n2]);
        }
        byArray10[n5++] = (byte)this.m_jpegObj.Ss;
        byArray10[n5++] = (byte)this.m_jpegObj.Se;
        byArray10[n5++] = (byte)((this.m_jpegObj.Ah << 4) + this.m_jpegObj.Al);
        this.WriteArray(byArray10, bufferedOutputStream);
    }

    void WriteMarker(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            bufferedOutputStream.write(byArray, 0, 2);
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
        }
    }

    void WriteArray(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            int n = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF) + 2;
            bufferedOutputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
        }
    }
}

