/*
 * Decompiled with CFR 0.152.
 */
package jvx.thirdParty.fonts;

import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import jv.object.PsConfig;

public class FontsCanvas
extends Canvas {
    protected int m_size = 16;
    protected int[] style = new int[]{0, 2, 1, 3};
    protected String[] styleName = new String[]{"plain", "italic", "bold", "bold-italic", "plain-bold-italic"};

    public void setSize(int n) {
        this.m_size = n;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = 25 * PsConfig.getMonitorScale();
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < this.style.length; ++j) {
                Font font = new Font(stringArray[i], this.style[j], this.m_size * PsConfig.getMonitorScale());
                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                graphics.setFont(font);
                graphics.drawString("Size=" + this.m_size + " " + stringArray[i] + " " + this.styleName[j] + " (" + font.getFamily() + ")", 5 * PsConfig.getMonitorScale(), n += fontMetrics.getAscent());
                n += fontMetrics.getLeading();
            }
            n += 10 * PsConfig.getMonitorScale();
        }
    }
}

