/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;

public class PnVertexRK
extends PnGeodesicRK {
    protected PdBaryDir[][] m_vec;

    public PnVertexRK(PgElementSet pgElementSet) {
        super(pgElementSet);
        if (pgElementSet.getDimOfElements() != 3) {
            throw new IllegalArgumentException("geometry is no triangulation");
        }
        this.m_vec = null;
    }

    public void setVectorField(PdBaryDir[][] pdBaryDirArray) {
        this.m_vec = pdBaryDirArray;
    }

    public void setVectorField(PgVectorField pgVectorField) {
        int n = pgVectorField.getNumVectors();
        int n2 = this.m_geom.getNumElements();
        this.m_vec = new PdBaryDir[n2][3];
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        PiVector[] piVectorArray = this.m_geom.getElements();
        for (int i = 0; i < n2; ++i) {
            int n3 = piVectorArray[i].getSize();
            for (int j = 0; j < n3; ++j) {
                int n4 = piVectorArray[i].getEntry(j);
                if (n4 >= n) continue;
                this.m_vec[i][j] = new PdBaryDir(3);
                PwBary.projectOntoElement(this.m_geom, i, pdVectorArray[n4], this.m_vec[i][j]);
            }
        }
    }

    public void eval(int n, PdBary pdBary, PdBaryDir pdBaryDir) {
        int n2;
        if (pdBary == null) {
            PsDebug.warning((String)"missing bary parameter");
            return;
        }
        if (pdBaryDir == null) {
            PsDebug.warning((String)"missing output parameter");
            return;
        }
        PdBaryDir[] pdBaryDirArray = this.m_vec[n];
        for (n2 = 0; n2 < 3; ++n2) {
            pdBaryDir.m_data[n2] = 0.0;
            for (int i = 0; i < 3; ++i) {
                int n3 = n2;
                pdBaryDir.m_data[n3] = pdBaryDir.m_data[n3] + pdBary.m_data[i] * pdBaryDirArray[i].m_data[n2];
            }
        }
        if (this.m_bInvert) {
            for (n2 = 0; n2 < 3; ++n2) {
                pdBaryDir.m_data[n2] = -pdBaryDir.m_data[n2];
            }
        }
    }
}

