/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

public class PnNoise {
    private static final int TABSIZE = 256;
    private float[] m_gradTab = new float[512];
    private float[] m_valueTab = new float[256];
    private int[] m_perm = new int[256];
    private int[] m_byteValueTab = new int[256];
    public int[][] m_preComputedNoise = null;
    private double m_coarseness = -1.0;
    private int m_xmin = -1;
    private int m_ymin = -1;
    private int m_xmax = -1;
    private int m_ymax = -1;

    public PnNoise() {
        int n;
        for (n = 0; n < 256; ++n) {
            this.m_perm[n] = (int)(Math.random() * 255.0 + 0.5);
        }
        for (n = 0; n < 256; ++n) {
            this.m_valueTab[n] = (float)Math.random() * 2.0f - 1.0f;
        }
        for (n = 0; n < 256; ++n) {
            float f = (float)(Math.PI * 2 * Math.random());
            this.m_gradTab[n * 2] = (float)Math.cos(f);
            this.m_gradTab[n * 2 + 1] = (float)Math.sin(f);
        }
        for (n = 0; n < 256; ++n) {
            this.m_byteValueTab[n] = (int)(Math.random() * 255.0 + 0.5);
        }
    }

    protected int index(int n, int n2) {
        return this.m_perm[(n + this.m_perm[n2]) % 256];
    }

    protected float glattice(int n, int n2, float f, float f2) {
        int n3 = 2 * this.index(n, n2);
        return this.m_gradTab[n3] * f + this.m_gradTab[n3 + 1] * f2;
    }

    protected float smoothstep(float f) {
        return f * f * (3.0f - 2.0f * f);
    }

    public float noise(float f, float f2) {
        while (f < 0.0f) {
            f += 255.0f;
        }
        while (f2 < 0.0f) {
            f2 += 255.0f;
        }
        int n = (int)f;
        int n2 = (int)f2;
        float f3 = f - (float)n;
        float f4 = 1.0f - f3;
        float f5 = f2 - (float)n2;
        float f6 = 1.0f - f5;
        float f7 = this.glattice(n %= 255, n2 %= 255, f3, f5);
        float f8 = this.glattice(n + 1, n2, f4, f5);
        float f9 = this.glattice(n, n2 + 1, f3, f6);
        float f10 = this.glattice(n + 1, n2 + 1, f4, f6);
        float f11 = this.smoothstep(f3);
        float f12 = this.smoothstep(f5);
        float f13 = f7 + f11 * (f8 - f7);
        float f14 = f9 + f11 * (f10 - f9);
        float f15 = f13 + f12 * (f14 - f13);
        float f16 = this.m_valueTab[this.index(n, n2)];
        float f17 = this.m_valueTab[this.index(n + 1, n2)];
        float f18 = this.m_valueTab[this.index(n, n2 + 1)];
        float f19 = this.m_valueTab[this.index(n + 1, n2 + 1)];
        float f20 = f16 + f11 * (f17 - f16);
        float f21 = f18 + f11 * (f19 - f18);
        float f22 = f20 + f12 * (f21 - f20);
        f15 += 2.0f * f22;
        return f15 /= 3.0f;
    }

    public int intNoise(double d, double d2) {
        while (d < 0.0) {
            d += 256.0;
        }
        while (d2 < 0.0) {
            d2 += 256.0;
        }
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = 1.0 - d3;
        double d5 = d2 - (double)n2;
        double d6 = 1.0 - d5;
        int n3 = ((n2 %= 256) + 1) % 256;
        int n4 = this.m_perm[((n %= 256) + this.m_perm[n2]) % 256];
        int n5 = this.m_perm[(n + 1 + this.m_perm[n2]) % 256];
        int n6 = this.m_perm[(n + this.m_perm[n3]) % 256];
        int n7 = this.m_perm[(n + 1 + this.m_perm[n3]) % 256];
        double d7 = d4 * (double)n4 + d3 * (double)n5;
        double d8 = d4 * (double)n6 + d3 * (double)n7;
        return (int)(d6 * d7 + d5 * d8);
    }

    public void preComputeNoise(double d, int n, int n2, int n3, int n4) {
        if (this.m_preComputedNoise != null && n == this.m_xmin && n2 == this.m_ymin && n3 == this.m_xmax && n4 == this.m_ymax && d == this.m_coarseness) {
            return;
        }
        this.m_xmin = n;
        this.m_ymin = n2;
        this.m_xmax = n3;
        this.m_ymax = n4;
        this.m_coarseness = d;
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        this.m_preComputedNoise = new int[n5][n6];
        double d2 = (double)n2 * d;
        double d3 = (double)n * d;
        for (int i = 0; i < n6; ++i) {
            double d4 = d3;
            for (int j = 0; j < n5; ++j) {
                this.m_preComputedNoise[j][i] = (int)(((double)this.noise((float)d4, (float)d2) + 1.0) * 255.0 / 2.0);
                d4 += d;
            }
            d2 += d;
        }
    }

    public int getPreComputedNoise(int n, int n2) {
        if (n < this.m_xmin || n > this.m_xmax || n2 < this.m_ymin || n2 > this.m_ymax) {
            return (int)(((double)this.noise((float)((double)n * this.m_coarseness), (float)((double)n2 * this.m_coarseness)) + 1.0) * 255.0 / 2.0);
        }
        return this.m_preComputedNoise[n][n2];
    }
}

