/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.numeric.PnStraightestGeodesic;

public abstract class PnGeodesicRK
extends PsObject {
    protected PgElementSet m_geom;
    protected boolean m_bFirstOrder = false;
    protected boolean m_bGeometryChanged = false;
    private PgPolygonOnElementSet m_geod;
    private PdBary m_pos;
    private int m_elem;
    private PgPolygonOnElementSet m_outpoly;
    protected PdBaryDir m_dir;
    protected double m_h;
    protected double m_lastLength = 0.0;
    protected boolean m_bInvert = false;
    protected PnStraightestGeodesic m_exp;
    private PdBaryDir k_i = new PdBaryDir(3);
    private PdBary inner = new PdBary(3);
    private PdBaryDir transformedDir = new PdBaryDir(3);
    private PdBaryDir value = new PdBaryDir(3);
    static final double[] a = new double[]{1.0, 0.5, 0.5, 1.0};
    static final double[] b = new double[]{0.16666666666666666, 0.3333333333333333, 0.3333333333333333, 0.16666666666666666};

    public PnGeodesicRK(PgElementSet pgElementSet) {
        this.setGeometry(pgElementSet);
        this.m_pos = new PdBary(3);
        this.m_dir = new PdBaryDir(3);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        this.m_geom = pgElementSet;
        this.m_bGeometryChanged = true;
        this.m_geod = new PgPolygonOnElementSet(this.m_geom);
        this.m_exp = new PnStraightestGeodesic(this.m_geom, true);
    }

    public void setFirstOrder(boolean bl) {
        this.m_bFirstOrder = bl;
    }

    public void setFourthOrder(boolean bl) {
        this.m_bFirstOrder = !bl;
    }

    public void solve(PgPolygonOnElementSet pgPolygonOnElementSet, int n, PdBary pdBary, double d, int n2) {
        if (!this.prepareSolve(pgPolygonOnElementSet, n, pdBary, d)) {
            return;
        }
        while (n2-- > 0 && this.nextStep()) {
        }
    }

    private void computeDirection(PdBary pdBary, PdBaryDir pdBaryDir, double d) {
        if (this.m_bFirstOrder) {
            this.eval(pdBary.m_elementInd, pdBary, pdBaryDir);
            pdBaryDir.multScalar(d);
        } else {
            int n = 0;
            this.eval(pdBary.m_elementInd, pdBary, this.k_i);
            pdBaryDir.multScalar(this.k_i, d * b[n]);
            double d2 = PwBary.norm(this.m_geom, pdBary.m_elementInd, this.k_i, this.m_bGeometryChanged);
            this.m_bGeometryChanged = false;
            for (n = 1; n < 4; ++n) {
                if (d2 < 1.0E-10) {
                    this.eval(pdBary.m_elementInd, pdBary, this.k_i);
                    d2 = PwBary.norm(this.m_geom, pdBary.m_elementInd, this.k_i, this.m_bGeometryChanged);
                    pdBaryDir.blendBase(pdBaryDir, d * b[n], this.k_i);
                    continue;
                }
                this.transformedDir.multScalar(this.k_i, d * a[n - 1]);
                this.m_exp.eval(pdBary, this.transformedDir, this.inner, this.transformedDir);
                if (this.inner.m_elementInd == pdBary.m_elementInd) {
                    this.eval(this.inner.m_elementInd, this.inner, this.k_i);
                    d2 = PwBary.norm(this.m_geom, this.inner.m_elementInd, this.k_i, this.m_bGeometryChanged);
                } else {
                    this.eval(this.inner.m_elementInd, this.inner, this.value);
                    double d3 = PwBary.norm(this.m_geom, this.inner.m_elementInd, this.value, this.m_bGeometryChanged);
                    if (d3 > 1.0E-10) {
                        double d4 = PwBary.getOrientedAngle(this.m_geom, this.inner.m_elementInd, this.transformedDir, this.value, this.m_bGeometryChanged);
                        if (d4 != Double.NEGATIVE_INFINITY) {
                            PwBary.rotateInElement(this.m_geom, pdBary.m_elementInd, this.k_i, d4, this.k_i, this.m_bGeometryChanged);
                        }
                        this.k_i.multScalar(d3 / d2);
                        d2 = d3;
                    } else {
                        this.k_i.setZero();
                        d2 = 0.0;
                    }
                }
                pdBaryDir.blendBase(pdBaryDir, d * b[n], this.k_i);
            }
        }
    }

    public void solve(PdBary pdBary, double d, int n, PdBary pdBary2) {
        if (n <= 0) {
            return;
        }
        this.computeDirection(pdBary, this.m_dir, d);
        if (this.m_exp.eval(pdBary, this.m_dir, pdBary2, this.m_dir) != 1) {
            return;
        }
        while (n-- > 1) {
            this.computeDirection(pdBary2, this.m_dir, d);
            if (this.m_exp.eval(pdBary2, this.m_dir, pdBary2, this.m_dir) == 1) continue;
            return;
        }
    }

    public void solve(PdBary pdBary, double d, PdBary pdBary2) {
        this.computeDirection(pdBary, this.m_dir, d);
        this.m_exp.eval(pdBary, this.m_dir, pdBary2);
    }

    public boolean prepareSolve(PgPolygonOnElementSet pgPolygonOnElementSet, int n, PdBary pdBary, double d) {
        if (pgPolygonOnElementSet == null) {
            PsDebug.warning((String)"Missing output polygon.");
            return false;
        }
        if (pdBary == null) {
            PsDebug.warning((String)"Missing initial coordinates.");
            return false;
        }
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing geometry.");
            return false;
        }
        if (n < 0 || n >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)"Invalid initial element.");
            return false;
        }
        this.m_elem = n;
        this.m_outpoly = pgPolygonOnElementSet;
        this.m_outpoly.setNumVertices(1);
        this.m_outpoly.setVertexBary(0, n, pdBary);
        this.m_outpoly.setNumVertices(100);
        this.m_outpoly.setNumVertices(1);
        this.m_geod.setNumVertices(1);
        this.m_geod.setNumVertices(100);
        this.m_geod.setNumVertices(1);
        this.m_h = d;
        this.m_dir.setZero();
        return true;
    }

    public boolean nextStep() {
        int n = this.m_outpoly.getNumVertices();
        this.m_pos = this.m_geod.swap(this.m_outpoly, 0, n - 1, 1);
        this.computeDirection(this.m_pos, this.m_dir, this.m_h);
        int n2 = this.m_exp.eval(this.m_pos, this.m_dir, this.m_geod, this.m_dir);
        int n3 = this.m_geod.getNumVertices();
        this.m_outpoly.setNumVertices(n - 1 + n3);
        this.m_pos = this.m_outpoly.swap(this.m_geod, n - 1, 0, n3);
        this.m_elem = this.m_pos.m_elementInd;
        this.m_lastLength = PwBary.norm(this.m_geom, this.m_elem, this.m_dir, this.m_bGeometryChanged);
        this.m_bGeometryChanged = false;
        return n3 > 1 && n2 == 1 && this.m_lastLength > 1.0E-10;
    }

    public double getStepLength() {
        return this.m_lastLength;
    }

    public void setInvertDirection(boolean bl) {
        this.m_bInvert = bl;
    }

    public boolean getInvertDirection() {
        return this.m_bInvert;
    }

    public abstract void eval(int var1, PdBary var2, PdBaryDir var3);

    public PdBaryDir eval(int n, PdBary pdBary) {
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        this.eval(n, pdBary, pdBaryDir);
        return pdBaryDir;
    }
}

