/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgBndConstraint;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnAlignmentEnergy;
import jvx.numeric.PnFunction;
import jvx.numeric.PnJacobi;
import jvx.numeric.PnMatrix;
import jvx.numeric.PnStiffDiriNonConforming;
import jvx.numeric.PnStiffMatrix;

public abstract class PnEnergy
extends PnFunction {
    protected PgElementSet m_domain;
    protected PgElementSet m_surface;
    protected int m_nop;
    protected int m_noiv;
    protected int m_dim;
    protected PnStiffMatrix m_stiffMatrix;
    protected PgBndPolygon[] m_bndList;
    protected PdVector m_store = new PdVector();
    private PdVector m_vertexGrad;
    private PdMatrix m_subConstrain;
    protected PdMatrix m_constrain;
    protected boolean m_bTangential;
    protected boolean m_bNormal;
    protected int[] m_index;
    protected int[] m_invIndex;
    protected boolean m_bZeroGradient = true;
    protected boolean m_bUseConstrainMatrix = false;
    protected boolean m_bFixMarkedVertices = false;
    static /* synthetic */ Class class$jvx$numeric$PnEnergy;

    public PnEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnEnergy == null ? (class$jvx$numeric$PnEnergy = PnEnergy.class$("jvx.numeric.PnEnergy")) : class$jvx$numeric$PnEnergy)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bTangential = true;
        this.m_bNormal = true;
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return;
        }
    }

    public int getNumOfVariables() {
        return this.m_dim * this.m_noiv;
    }

    public boolean isEnabledConstrainMatrix() {
        return this.m_bUseConstrainMatrix;
    }

    public void setEnabledConstrainMatrix(boolean bl) {
        this.m_bUseConstrainMatrix = bl;
        if (this.m_bUseConstrainMatrix) {
            this.m_vertexGrad = new PdVector();
            this.m_subConstrain = new PdMatrix();
            this.m_constrain = new PdMatrix();
        } else {
            this.m_vertexGrad = null;
            this.m_subConstrain = null;
            this.m_constrain = null;
        }
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry");
            return false;
        }
        this.m_domain = pgElementSet;
        this.m_surface = pgElementSet2;
        int n = 0;
        int n2 = 0;
        this.m_dim = pgElementSet2.getDimOfVertices();
        this.m_nop = pgElementSet2.getNumVertices();
        this.m_bndList = pgElementSet2.getBoundaries();
        PdVector[] pdVectorArray = pgElementSet2.getVertices();
        this.m_store.setSize(this.m_dim * this.m_nop);
        if (this.m_bUseConstrainMatrix) {
            this.m_vertexGrad.setSize(this.m_dim);
        }
        pgElementSet2.markBoundary();
        int n3 = pgElementSet2.getNumBoundaryVertices();
        if (this.m_bUseConstrainMatrix) {
            n3 = 0;
        }
        this.m_noiv = this.m_nop - n3;
        this.m_index = new int[this.m_noiv];
        this.m_invIndex = new int[this.m_nop];
        n2 = 0;
        PsDebug.notify((String)("nop = " + this.m_nop + ", m_noiv = " + this.m_noiv + ", nobv = " + n3));
        for (n = 0; n < this.m_nop; ++n) {
            if (!this.m_bUseConstrainMatrix && pdVectorArray[n].hasTag(14)) {
                this.m_invIndex[n] = -1;
                continue;
            }
            this.m_invIndex[n] = n2;
            this.m_index[n2] = n;
            ++n2;
        }
        if (this.m_noiv != n2) {
            PsDebug.warning((String)("error: m_noiv = " + this.m_noiv + " != " + n2 + " = ipos"));
            return false;
        }
        if (this.m_bUseConstrainMatrix) {
            this.m_subConstrain.setSize(this.m_dim);
            this.m_constrain.setSize(this.m_dim * this.m_nop);
            this.getConstrainMatrix(this.m_constrain);
        }
        return true;
    }

    public void setZeroGradientAtBounds(boolean bl) {
        this.m_bZeroGradient = bl;
    }

    public boolean getZeroGradientAtBounds() {
        return this.m_bZeroGradient;
    }

    public double eval(PdVector pdVector) {
        int n;
        int n2;
        int n3;
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return 0.0;
        }
        this.m_store.setConstant(0.0);
        for (n3 = 0; n3 < this.m_nop; ++n3) {
            for (int i = 0; i < this.m_stiffMatrix.m_snoe.m_data[n3]; ++i) {
                n2 = this.m_dim * this.m_stiffMatrix.m_sindx[n3].m_data[i];
                if (n2 < 0) continue;
                for (n = 0; n < this.m_dim; ++n) {
                    int n4 = this.m_dim * n3 + n;
                    this.m_store.m_data[n4] = this.m_store.m_data[n4] + this.m_stiffMatrix.m_stiff[n3].m_data[i] * pdVector.m_data[n2 + n];
                }
            }
        }
        double d = 0.0;
        for (n3 = 0; n3 < this.m_nop; ++n3) {
            if (this.m_stiffMatrix.m_snoe.m_data[n3] <= 0 || (n2 = this.m_dim * n3) < 0) continue;
            for (n = 0; n < this.m_dim; ++n) {
                d += this.m_store.m_data[n2 + n] * pdVector.m_data[n2 + n];
            }
        }
        return d;
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null) {
            PsDebug.warning((String)"Missing coordinate array.");
            return null;
        }
        if (pdVector2 == null) {
            if (this.m_store == null || this.m_store.getSize() == 0 && pdVector.getSize() != 0) {
                PsDebug.warning((String)"PnEnergy not initialized, cannot evaluate gradient");
                return null;
            }
            pdVector2 = this.m_store;
        }
        pdVector2.setConstant(0.0);
        if (this.m_surface.getNumVertices() != this.m_nop) {
            return pdVector2;
        }
        if (this.m_stiffMatrix != null) {
            for (int i = 0; i < this.m_nop; ++i) {
                for (int j = 0; j < this.m_stiffMatrix.m_snoe.m_data[i]; ++j) {
                    int n = this.m_dim * this.m_stiffMatrix.m_sindx[i].m_data[j];
                    if (n < 0) continue;
                    for (int k = 0; k < this.m_dim; ++k) {
                        int n2 = this.m_dim * i + k;
                        pdVector2.m_data[n2] = pdVector2.m_data[n2] + 2.0 * this.m_stiffMatrix.m_stiff[i].m_data[j] * pdVector.m_data[n + k];
                    }
                }
            }
        }
        return this.constrainGradient(pdVector, pdVector2);
    }

    protected PdVector constrainGradient(PdVector pdVector, PdVector pdVector2) {
        block35: {
            int n;
            PdVector pdVector3;
            block34: {
                PdVector[] pdVectorArray;
                if (pdVector == null) {
                    PsDebug.warning((String)"Missing coordinate array.");
                    return null;
                }
                if (!(this.m_bTangential && this.m_bNormal || !this.m_surface.hasVertexNormals())) {
                    pdVectorArray = this.m_surface.getVertexNormals();
                    pdVector3 = new PdVector(this.m_dim);
                    int n2 = 0;
                    for (n = 0; n < this.m_nop; ++n) {
                        int n3;
                        pdVector3.set(pdVector2, n2, this.m_dim);
                        double d = PdVector.dot((PdVector)pdVector3, (PdVector)pdVectorArray[n]);
                        if (!this.m_bTangential) {
                            for (n3 = 0; n3 < this.m_dim; ++n3) {
                                pdVector2.m_data[n2 + n3] = d * pdVectorArray[n].m_data[n3];
                            }
                        }
                        if (!this.m_bNormal) {
                            for (n3 = 0; n3 < this.m_dim; ++n3) {
                                int n4 = n2 + n3;
                                pdVector2.m_data[n4] = pdVector2.m_data[n4] - d * pdVectorArray[n].m_data[n3];
                            }
                        }
                        n2 += this.m_dim;
                    }
                }
                if (this.m_bFixMarkedVertices) {
                    pdVectorArray = this.m_surface.getVertices();
                    for (n = 0; n < this.m_nop; ++n) {
                        if (!pdVectorArray[n].hasTag(1)) continue;
                        this.projectOntoNull(pdVector2.m_data, this.m_dim * n);
                    }
                }
                if (this.m_bndList != null && this.m_bndList.length != 0) break block34;
                if (!this.m_bZeroGradient) break block35;
                for (n = 0; n < this.m_nop; ++n) {
                    if (this.m_invIndex[n] != -1) continue;
                    this.projectOntoNull(pdVector2.m_data, this.m_dim * n);
                }
                break block35;
            }
            for (int i = 0; i < this.m_bndList.length; ++i) {
                PdVector pdVector4;
                if (this.m_bndList[i].hasTag(2)) continue;
                pdVector3 = this.m_bndList[i].getBndConstraint();
                if (pdVector3 == null) {
                    return pdVector2;
                }
                int n5 = this.m_bndList[i].getNumVertices();
                int[] nArray = this.m_bndList[i].getVertexInd().m_data;
                if (pdVector3.hasShape(3)) {
                    for (n = 0; n < n5; ++n) {
                        this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[n]);
                    }
                    continue;
                }
                if (pdVector3.hasShape(4)) {
                    pdVector4 = pdVector3.m_dir;
                    if (!(this instanceof PnAlignmentEnergy) && !(this.m_stiffMatrix instanceof PnStiffDiriNonConforming)) {
                        this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[0]);
                        if (nArray[0] != nArray[n5 - 1]) {
                            this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[n5 - 1]);
                        }
                        for (n = 1; n < n5 - 1; ++n) {
                            this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[n], pdVector4);
                        }
                        continue;
                    }
                    for (n = 0; n < n5; ++n) {
                        this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[n], pdVector4);
                    }
                    continue;
                }
                if (pdVector3.hasShape(5) || pdVector3.hasShape(11)) {
                    pdVector4 = pdVector3.m_dir;
                    PdVector pdVector5 = pdVector3.m_startDir;
                    PdVector pdVector6 = pdVector3.m_endDir;
                    if (pdVector5 == null) {
                        this.projectOntoPlane(pdVector2.m_data, this.m_dim * nArray[0], pdVector4);
                    } else if (pdVector5.sqrLength() > 1.0E-10) {
                        this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[0], pdVector5);
                    } else {
                        this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[0]);
                    }
                    if (nArray[0] != nArray[n5 - 1]) {
                        if (pdVector6 == null) {
                            this.projectOntoPlane(pdVector2.m_data, this.m_dim * nArray[n5 - 1], pdVector4);
                        } else if (pdVector6.sqrLength() > 1.0E-10) {
                            this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[n5 - 1], pdVector6);
                        } else {
                            this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[n5 - 1]);
                        }
                    }
                    for (n = 1; n < n5 - 1; ++n) {
                        this.projectOntoPlane(pdVector2.m_data, this.m_dim * nArray[n], pdVector4);
                    }
                    continue;
                }
                if (pdVector3.hasShape(6)) {
                    this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[0]);
                    if (nArray[0] != nArray[n5 - 1]) {
                        this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[n5 - 1]);
                    }
                    PsDebug.warning((String)"fixThread not implemented yet");
                    continue;
                }
                if (pdVector3.hasShape(13)) {
                    for (n = 0; n < n5; ++n) {
                        this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[n]);
                    }
                    continue;
                }
                PsDebug.warning((String)"no boundary condition found");
            }
        }
        return pdVector2;
    }

    private void projectOntoNull(double[] dArray, int n) {
        for (int i = 0; i < this.m_dim; ++i) {
            dArray[n + i] = 0.0;
        }
    }

    private void projectOntoLine(double[] dArray, int n, PdVector pdVector) {
        int n2;
        double d = 0.0;
        for (n2 = 0; n2 < this.m_dim; ++n2) {
            d += dArray[n + n2] * pdVector.m_data[n2];
        }
        for (n2 = 0; n2 < this.m_dim; ++n2) {
            dArray[n + n2] = d * pdVector.m_data[n2];
        }
    }

    private void projectOntoPlane(double[] dArray, int n, PdVector pdVector) {
        int n2;
        double d = 0.0;
        for (n2 = 0; n2 < this.m_dim; ++n2) {
            d += dArray[n + n2] * pdVector.m_data[n2];
        }
        for (n2 = 0; n2 < this.m_dim; ++n2) {
            int n3 = n + n2;
            dArray[n3] = dArray[n3] - d * pdVector.m_data[n2];
        }
    }

    public PdMatrix evalHessian(PdMatrix pdMatrix) {
        PsDebug.warning((String)"method not implemented by subclass");
        return null;
    }

    public PdVector[] getSpectrum(PdVector pdVector, PdVector[] pdVectorArray) {
        pdVector.setSize(this.m_dim * this.m_noiv);
        pdVectorArray = PdVector.realloc((PdVector[])pdVectorArray, (int)(this.m_dim * this.m_noiv), (int)(this.m_dim * this.m_noiv));
        PdMatrix pdMatrix = new PdMatrix();
        PdMatrix pdMatrix2 = new PdMatrix();
        if (!this.computeNormalizedHessian(pdMatrix, pdMatrix2)) {
            return null;
        }
        PnJacobi.computeEigenvectors(pdMatrix, this.m_dim * this.m_noiv, pdVector, pdVectorArray);
        if (PnJacobi.isInterrupted()) {
            PsDebug.warning((String)"Computation of spectrum aborted by user.");
            return null;
        }
        for (int i = 0; i < this.m_dim * this.m_noiv; ++i) {
            pdVectorArray[i].leftMultMatrix(pdMatrix2);
            pdVectorArray[i].normalize();
        }
        return pdVectorArray;
    }

    public boolean computeNormalizedHessian(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        int n;
        PdMatrix pdMatrix3 = this.evalHessian(null);
        PdMatrix pdMatrix4 = this.m_surface.getL2Matrix(null);
        PdMatrix pdMatrix5 = new PdMatrix(this.m_noiv);
        for (n = 0; n < this.m_noiv; ++n) {
            for (int i = 0; i < this.m_noiv; ++i) {
                pdMatrix5.m_data[n][i] = pdMatrix4.m_data[this.m_index[n]][this.m_index[i]];
            }
        }
        PdMatrix pdMatrix6 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix6.m_data, pdMatrix5.m_data, this.m_noiv);
        PdVector pdVector = new PdVector(this.m_noiv);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)this.m_noiv, (int)this.m_noiv);
        PnJacobi.computeEigenvectors(pdMatrix5, this.m_noiv, pdVector, pdVectorArray);
        if (PnJacobi.isInterrupted()) {
            PsDebug.warning((String)"Computation of spectrum aborted by user.");
            return false;
        }
        for (n = 0; n < this.m_noiv; ++n) {
            pdVectorArray[n].multScalar(1.0 / Math.sqrt(pdVector.m_data[n]));
        }
        PdMatrix pdMatrix7 = pdMatrix5;
        pdMatrix7.setColumns(pdVectorArray);
        if (this.m_bUseConstrainMatrix) {
            pdMatrix7.leftMult(this.m_constrain, this.m_noiv);
        }
        PdMatrix pdMatrix8 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix8.m_data, pdMatrix7.m_data, this.m_noiv);
        PdMatrix pdMatrix9 = PdMatrix.expandComponents((PdMatrix)pdMatrix7, (int)this.m_dim);
        PdMatrix pdMatrix10 = pdMatrix7;
        pdMatrix10.mult(pdMatrix8, pdMatrix6);
        PdMatrix pdMatrix11 = PdMatrix.expandComponents((PdMatrix)pdMatrix10, (int)this.m_dim);
        PdMatrix pdMatrix12 = new PdMatrix(this.m_dim * this.m_noiv);
        pdMatrix12.mult(pdMatrix11, pdMatrix3);
        PdMatrix pdMatrix13 = pdMatrix11;
        pdMatrix13.mult(pdMatrix12, pdMatrix9);
        pdMatrix.set(pdMatrix13.m_data);
        pdMatrix2.set(pdMatrix9.m_data);
        return true;
    }

    public void testEigenvalues() {
        int n;
        PdMatrix pdMatrix = this.evalHessian(null);
        PsDebug.message((String)(PsConfig.getMessage((int)63006) + " Q \n" + pdMatrix.toString()));
        PdMatrix pdMatrix2 = this.m_surface.getL2Matrix(null);
        PsDebug.message((String)PsConfig.getMessage((int)63007));
        PsDebug.message((String)pdMatrix2.toString());
        PdMatrix pdMatrix3 = new PdMatrix(this.m_noiv);
        for (n = 0; n < this.m_noiv; ++n) {
            for (int i = 0; i < this.m_noiv; ++i) {
                pdMatrix3.m_data[n][i] = pdMatrix2.m_data[this.m_index[n]][this.m_index[i]];
            }
        }
        PsDebug.message((String)("S\n" + pdMatrix3.toString()));
        PdMatrix pdMatrix4 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix4.m_data, pdMatrix3.m_data, this.m_noiv);
        PdMatrix pdMatrix5 = new PdMatrix(this.m_noiv);
        pdMatrix5.copy(pdMatrix4);
        pdMatrix5.rightMult(pdMatrix3);
        PsDebug.message((String)("SInv*S\n" + pdMatrix5.toString()));
        PdVector pdVector = new PdVector(this.m_noiv);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)this.m_noiv, (int)this.m_noiv);
        PnJacobi.computeEigenvectors(pdMatrix3, this.m_noiv, pdVector, pdVectorArray);
        for (n = 0; n < this.m_noiv; ++n) {
            pdVectorArray[n].multScalar(1.0 / Math.sqrt(pdVector.m_data[n]));
        }
        PdMatrix pdMatrix6 = new PdMatrix(this.m_noiv);
        pdMatrix6.setColumns(pdVectorArray);
        PsDebug.message((String)("m\n" + pdMatrix6.toString()));
        PdMatrix pdMatrix7 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix7.m_data, pdMatrix6.m_data, this.m_noiv);
        PdMatrix pdMatrix8 = new PdMatrix(this.m_noiv);
        pdMatrix8.mult(pdMatrix7, pdMatrix4);
        PdMatrix pdMatrix9 = PdMatrix.expandComponents((PdMatrix)pdMatrix8, (int)this.m_dim);
        PdMatrix pdMatrix10 = PdMatrix.expandComponents((PdMatrix)pdMatrix6, (int)this.m_dim);
        PdMatrix pdMatrix11 = new PdMatrix(this.m_dim * this.m_noiv);
        pdMatrix11.mult(pdMatrix9, pdMatrix);
        PdMatrix pdMatrix12 = new PdMatrix(this.m_dim * this.m_noiv);
        pdMatrix12.mult(pdMatrix11, pdMatrix10);
        PsDebug.message((String)("mInv*SInv*Q*mBig\n" + pdMatrix12.toString()));
        pdVector = new PdVector(this.m_dim * this.m_noiv);
        pdVectorArray = PdVector.realloc(null, (int)(this.m_dim * this.m_noiv), (int)(this.m_dim * this.m_noiv));
        PnJacobi.computeEigenvectors(pdMatrix12, this.m_dim * this.m_noiv, pdVector, pdVectorArray);
        for (n = 0; n < this.m_dim * this.m_noiv; ++n) {
            pdVectorArray[n].leftMultMatrix(pdMatrix10);
            pdVectorArray[n].normalize();
        }
        PsDebug.message((String)PsConfig.getMessage((int)63008));
        PnJacobi.printEigenvectors(this.m_dim * this.m_noiv, pdVector, pdVectorArray);
    }

    protected PdMatrix getConstrainMatrix(PdMatrix pdMatrix) {
        block25: {
            block24: {
                if (pdMatrix == null) {
                    pdMatrix = new PdMatrix(this.m_dim * this.m_nop);
                } else {
                    pdMatrix.setSize(this.m_dim * this.m_nop);
                }
                pdMatrix.setIdentity();
                if (this.m_bndList != null && this.m_bndList.length != 0) break block24;
                if (!this.m_bZeroGradient) break block25;
                for (int i = 0; i < this.m_nop; ++i) {
                    if (this.m_invIndex[i] != -1) continue;
                    this.projectOntoNull(pdMatrix, this.m_dim, i);
                }
                break block25;
            }
            for (int i = 0; i < this.m_bndList.length; ++i) {
                int n;
                PgBndConstraint pgBndConstraint;
                if (this.m_bndList[i].hasTag(2) || (pgBndConstraint = this.m_bndList[i].getBndConstraint()) == null) continue;
                int n2 = this.m_bndList[i].getNumVertices();
                int[] nArray = this.m_bndList[i].getVertexInd().m_data;
                if (pgBndConstraint.hasShape(3)) {
                    for (n = 0; n < n2; ++n) {
                        this.projectOntoNull(pdMatrix, this.m_dim, nArray[n]);
                    }
                    continue;
                }
                if (pgBndConstraint.hasShape(4)) {
                    PdVector pdVector = pgBndConstraint.m_dir;
                    this.projectOntoNull(pdMatrix, this.m_dim, nArray[0]);
                    if (nArray[0] != nArray[n2 - 1]) {
                        this.projectOntoNull(pdMatrix, this.m_dim, nArray[n2 - 1]);
                    }
                    for (int j = 1; j < n2 - 1; ++j) {
                        this.projectOntoLine(pdMatrix, this.m_dim, nArray[j], pdVector);
                    }
                    continue;
                }
                if (pgBndConstraint.hasShape(5) || pgBndConstraint.hasShape(11)) {
                    PdVector pdVector = pgBndConstraint.m_dir;
                    PdVector pdVector2 = pgBndConstraint.m_startDir;
                    PdVector pdVector3 = pgBndConstraint.m_endDir;
                    if (pdVector2 == null) {
                        this.projectOntoPlane(pdMatrix, this.m_dim, nArray[0], pdVector);
                    } else if (pdVector2.sqrLength() > 1.0E-10) {
                        this.projectOntoLine(pdMatrix, this.m_dim, nArray[0], pdVector2);
                    } else {
                        this.projectOntoNull(pdMatrix, this.m_dim, nArray[0]);
                    }
                    if (nArray[0] != nArray[n2 - 1]) {
                        if (pdVector3 == null) {
                            this.projectOntoPlane(pdMatrix, this.m_dim, nArray[n2 - 1], pdVector);
                        } else if (pdVector3.sqrLength() > 1.0E-10) {
                            this.projectOntoLine(pdMatrix, this.m_dim, nArray[n2 - 1], pdVector3);
                        } else {
                            this.projectOntoNull(pdMatrix, this.m_dim, nArray[n2 - 1]);
                        }
                    }
                    for (int j = 1; j < n2 - 1; ++j) {
                        this.projectOntoPlane(pdMatrix, this.m_dim, nArray[j], pdVector);
                    }
                    continue;
                }
                if (pgBndConstraint.hasShape(6)) {
                    this.projectOntoNull(pdMatrix, this.m_dim, nArray[0]);
                    if (nArray[0] != nArray[n2 - 1]) {
                        this.projectOntoNull(pdMatrix, this.m_dim, nArray[n2 - 1]);
                    }
                    PsDebug.warning((String)"fixThread not implemented yet");
                    continue;
                }
                if (pgBndConstraint.hasShape(13)) {
                    for (n = 0; n < n2; ++n) {
                        this.projectOntoNull(pdMatrix, this.m_dim, nArray[n]);
                    }
                    continue;
                }
                PsDebug.warning((String)"no boundary condition found");
            }
        }
        return pdMatrix;
    }

    private void projectOntoNull(PdMatrix pdMatrix, int n, int n2) {
        int n3 = n * n2;
        for (int i = 0; i < n; ++i) {
            pdMatrix.m_data[n3 + i][n3 + i] = 0.0;
        }
    }

    private void projectOntoLine(PdMatrix pdMatrix, int n, int n2, PdVector pdVector) {
        this.m_subConstrain.adjoint(pdVector);
        int n3 = n * n2;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                pdMatrix.m_data[n3 + i][n3 + j] = this.m_subConstrain.m_data[i][j];
            }
        }
    }

    private void projectOntoPlane(PdMatrix pdMatrix, int n, int n2, PdVector pdVector) {
        this.m_subConstrain.adjoint(pdVector);
        int n3 = n * n2;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray = pdMatrix.m_data[n3 + i];
                int n4 = n3 + j;
                dArray[n4] = dArray[n4] - this.m_subConstrain.m_data[i][j];
            }
        }
    }

    public PdMatrix getConstrain() {
        return this.m_constrain;
    }

    public void setConstrain(PdMatrix pdMatrix) {
        this.m_constrain = pdMatrix;
    }

    public boolean isUseConstrainMatrix() {
        return this.m_bUseConstrainMatrix;
    }

    public void setUseConstrainMatrix(boolean bl) {
        this.m_bUseConstrainMatrix = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

