/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.numeric.PnLanczos;
import jvx.numeric.PnSparseMatrix;

public abstract class PnBandEigenSolver
extends PsObject {
    private int m_stepsize = 25;
    private double m_shift = 0.0;
    private boolean m_ascending = true;
    private int m_count = 25;
    private boolean m_checkquali = false;
    public static final int DENSE = 0;
    public static final int SPARSE = 1;

    protected abstract void shiftSpectrum(double var1);

    protected abstract PnLanczos getLanczos();

    protected abstract void destroy();

    public abstract boolean isAvailable();

    public abstract int getInputType();

    public abstract void setMatrix(Object var1);

    public abstract Object getMatrix();

    public int computeBand(PdVector pdVector, PdVector[] pdVectorArray) {
        double d = this.m_shift;
        int n = this.m_count;
        int n2 = this.m_ascending ? 1 : -1;
        int n3 = 0;
        double d2 = d;
        if (d != 0.0) {
            this.shiftSpectrum(d);
        }
        PdVector[] pdVectorArray2 = new PdVector[this.m_stepsize];
        PdVector pdVector2 = new PdVector(this.m_stepsize);
        while (true) {
            double d3;
            int n4 = 0;
            pdVector2.setConstant((double)n2 * Double.NEGATIVE_INFINITY);
            PsDebug.message((String)("Computing band around " + d + "."));
            PnLanczos pnLanczos = this.getLanczos();
            pnLanczos.computeEigenpairs(pdVector2, pdVectorArray2, this.m_stepsize, 0, 3 * this.m_stepsize);
            for (int i = 0; i < this.m_stepsize; ++i) {
                if (pdVector2.m_data[i] == 0.0) continue;
                pdVector2.m_data[i] = 1.0 / pdVector2.m_data[i] + d;
            }
            int[] nArray = new int[this.m_stepsize];
            PuMath.heapsort((int)this.m_stepsize, (double[])pdVector2.m_data, (int[])nArray);
            if (n3 != 0) {
                double d4 = d3 = this.m_ascending ? pdVector2.m_data[nArray[0]] : pdVector2.m_data[nArray[nArray.length - 1]];
                if (this.m_ascending && d2 + 1.0E-10 < d3 || !this.m_ascending && d2 - 1.0E-10 > d3) {
                    PsDebug.notify((String)"recompute band due to skipped eigenvalues");
                    double d5 = d3 - d2;
                    this.shiftSpectrum(-d5);
                    d -= d5;
                    continue;
                }
            }
            for (int i = 0; i < this.m_stepsize && n3 != pdVector.m_data.length; ++i) {
                int n5 = this.m_ascending ? nArray[i] : nArray[nArray.length - 1 - i];
                if (this.m_ascending == pdVector2.m_data[n5] < d2 || n4 == 0 && Math.abs(pdVector2.m_data[n5] - d2) < 1.0E-10) continue;
                pdVector.m_data[n3] = d2 = pdVector2.m_data[n5];
                pdVectorArray[n3] = pdVectorArray2[n5];
                ++n3;
                ++n4;
            }
            PsDebug.message((String)("Found " + n4 + " new eigenpairs."));
            if (n4 == 0 || (n -= n4) == 0) break;
            d3 = d2 + 0.4 * (d2 - pdVector.m_data[n3 - n4]);
            this.shiftSpectrum(d3 - d);
            d = d3;
        }
        this.shiftSpectrum(-d);
        if (this.isCheckResults()) {
            this.checkResults(pdVectorArray2, pdVector2);
        }
        return n3;
    }

    private void checkResults(PdVector[] pdVectorArray, PdVector pdVector) {
        int n = this.getInputType();
        PdVector pdVector2 = new PdVector();
        for (int i = 0; i < pdVectorArray.length; ++i) {
            if (n == 0) {
                pdVector2.rightMultMatrix(pdVectorArray[i], (PdMatrix)this.getMatrix());
            } else {
                PnSparseMatrix.rightMultVector((PnSparseMatrix)((Object)this.getMatrix()), pdVectorArray[i], pdVector2);
            }
            pdVector2.add(-1.0 * pdVector.m_data[i], pdVectorArray[i]);
            double d = pdVector2.length();
            if (pdVector.m_data[i] < 1.0E-10) {
                d /= pdVector.m_data[i];
            }
            PsDebug.message((String)("Residual " + i + ": " + d));
        }
    }

    public int getStepsize() {
        return this.m_stepsize;
    }

    public void setStepsize(int n) {
        this.m_stepsize = n;
    }

    public double getShift() {
        return this.m_shift;
    }

    public void setShift(double d) {
        this.m_shift = d;
    }

    public boolean isAscending() {
        return this.m_ascending;
    }

    public void setAscending(boolean bl) {
        this.m_ascending = bl;
    }

    public int getCount() {
        return this.m_count;
    }

    public void setCount(int n) {
        this.m_count = n;
    }

    public void setCheckResults(boolean bl) {
        this.m_checkquali = bl;
    }

    public boolean isCheckResults() {
        return this.m_checkquali;
    }
}

