/*
 * Decompiled with CFR 0.152.
 */
package jvx.material;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgTetraSet;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jvx.project.PjWorkshop;
import jvx.volume.PgCubeSet;

public class PwAdjustColors
extends PjWorkshop {
    public static final int RGB = 0;
    public static final int HSB = 1;
    protected int m_mode = 0;
    protected boolean m_bModifyVertexColors = true;
    protected boolean m_bModifyElementColors = false;
    protected boolean m_bModifyElementBackColors = false;
    protected boolean m_bModifyPolygonColors = false;
    protected boolean m_bModifyTetrahedronColors = false;
    protected boolean m_bModifyCubeColors = false;
    protected PuDouble m_brightness = new PuDouble("Brightness", (PsUpdateIf)this);
    protected PuDouble m_saturation = new PuDouble("Saturation", (PsUpdateIf)this);
    protected PuDouble m_hue = new PuDouble("Hue", (PsUpdateIf)this);
    protected PuDouble m_contrast = new PuDouble("Contrast", (PsUpdateIf)this);
    protected boolean m_bSelectedOnly = false;
    protected PuDouble m_red = new PuDouble("Red", (PsUpdateIf)this);
    protected PuDouble m_green = new PuDouble("Green", (PsUpdateIf)this);
    protected PuDouble m_blue = new PuDouble("Blue", (PsUpdateIf)this);
    protected boolean m_bSaveShowTaggedElements;
    protected boolean m_bSaveShowTaggedVertices;
    protected boolean m_bSaveShowTaggedEdges;
    protected boolean m_bSaveShowTaggedPolygons;
    protected boolean m_bSaveShowTaggedTetrahedra;
    protected boolean m_bSaveShowTaggedCubes;
    static /* synthetic */ Class class$jvx$material$PwAdjustColors;
    static /* synthetic */ Class class$jvx$volume$PgCubeSet;

    public PwAdjustColors() {
        super("Brightness and Contrast");
        if (((Object)((Object)this)).getClass() == (class$jvx$material$PwAdjustColors == null ? (class$jvx$material$PwAdjustColors = PwAdjustColors.class$("jvx.material.PwAdjustColors")) : class$jvx$material$PwAdjustColors)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_brightness.setDefBounds(-1.0, 1.0, 0.01, 0.1);
        this.m_brightness.setDefValue(0.0);
        this.m_brightness.init();
        this.m_saturation.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_saturation.setDefValue(1.0);
        this.m_saturation.init();
        this.m_hue.setDefBounds(-1.0, 1.0, 0.01, 0.1);
        this.m_hue.setDefValue(0.0);
        this.m_hue.init();
        this.m_contrast.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_contrast.setDefValue(1.0);
        this.m_contrast.init();
        this.m_red.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_red.setDefValue(1.0);
        this.m_red.init();
        this.m_green.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_green.setDefValue(1.0);
        this.m_green.init();
        this.m_blue.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_blue.setDefValue(1.0);
        this.m_blue.init();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        PgPointSet pgPointSet;
        super.setGeometry(pgGeometry);
        if (pgGeometry.getType() == 30 || pgGeometry.getType() == 31 || pgGeometry.getType() == 32 || pgGeometry.getType() == 33 || pgGeometry.getType() == 34) {
            pgPointSet = (PgPointSet)pgGeometry;
            this.m_bModifyVertexColors = pgPointSet.hasVertexColors();
            this.m_bSaveShowTaggedVertices = pgPointSet.isShowingTaggedVertices();
        }
        if (pgGeometry.getType() == 33) {
            pgPointSet = (PgElementSet)pgGeometry;
            this.m_bModifyElementColors = pgPointSet.hasElementColors();
            this.m_bModifyElementBackColors = pgPointSet.hasElementBackColors();
            this.m_bSaveShowTaggedElements = pgPointSet.isShowingTaggedElements();
        } else if (pgGeometry.getType() == 32) {
            pgPointSet = (PgPolygonSet)pgGeometry;
            this.m_bModifyPolygonColors = pgPointSet.hasPolygonColors();
            this.m_bSaveShowTaggedPolygons = pgPointSet.isShowingTaggedPolygons();
        } else if (pgGeometry.getType() == 34) {
            if (pgGeometry.getClass() == (class$jvx$volume$PgCubeSet == null ? (class$jvx$volume$PgCubeSet = PwAdjustColors.class$("jvx.volume.PgCubeSet")) : class$jvx$volume$PgCubeSet)) {
                pgPointSet = (PgCubeSet)pgGeometry;
                this.m_bModifyCubeColors = pgPointSet.hasCubeColors();
                this.m_bSaveShowTaggedCubes = pgPointSet.isShowingTaggedCubes();
            } else {
                pgPointSet = (PgTetraSet)pgGeometry;
                this.m_bModifyTetrahedronColors = pgPointSet.hasTetraColors();
                this.m_bSaveShowTaggedTetrahedra = pgPointSet.isShowingTaggedTetras();
            }
        }
    }

    protected void resetVisibility() {
        PgPointSet pgPointSet = (PgPointSet)this.m_geom;
        pgPointSet.showTaggedVertices(this.m_bSaveShowTaggedVertices);
        if (this.m_geom.getType() == 33) {
            PgElementSet pgElementSet = (PgElementSet)this.m_geom;
            pgElementSet.showTaggedElements(this.m_bSaveShowTaggedElements);
            pgElementSet.showTaggedEdges(this.m_bSaveShowTaggedEdges);
        } else if (this.m_geom.getType() == 32) {
            PgPolygonSet pgPolygonSet = (PgPolygonSet)this.m_geom;
            pgPolygonSet.showTaggedPolygons(this.m_bSaveShowTaggedPolygons);
        } else if (this.m_geom.getType() == 34) {
            if (this.m_geom.getClass() == (class$jvx$volume$PgCubeSet == null ? (class$jvx$volume$PgCubeSet = PwAdjustColors.class$("jvx.volume.PgCubeSet")) : class$jvx$volume$PgCubeSet)) {
                PgCubeSet pgCubeSet = (PgCubeSet)this.m_geom;
                pgCubeSet.showTaggedCubes(this.m_bSaveShowTaggedCubes);
            } else {
                PgTetraSet pgTetraSet = (PgTetraSet)this.m_geom;
                pgTetraSet.showTaggedTetras(this.m_bSaveShowTaggedTetrahedra);
            }
        }
    }

    public void close() {
        this.resetVisibility();
        this.m_geom.update((Object)this.m_geom);
        super.close();
    }

    public boolean update(Object object) {
        if (object == this.m_hue || object == this.m_brightness || object == this.m_saturation || object == this.m_contrast) {
            int n;
            int n2;
            Color[] colorArray;
            if (this.m_bModifyVertexColors && ((PgPointSet)this.m_geom).hasVertexColors()) {
                colorArray = PwAdjustColors.modifyHSB(((PgPointSet)this.m_geomSave).getVertexColors(), (float)this.m_hue.getValue(), (float)this.m_saturation.getValue(), (float)this.m_brightness.getValue(), (float)this.m_contrast.getValue());
                if (this.m_bSelectedOnly) {
                    n2 = ((PgPointSet)this.m_geom).getNumVertices();
                    for (n = 0; n < n2; ++n) {
                        if (!((PgPointSet)this.m_geom).hasTagVertex(n, 1)) continue;
                        ((PgPointSet)this.m_geom).setVertexColor(n, colorArray[n]);
                    }
                } else {
                    ((PgPointSet)this.m_geom).setVertexColors(colorArray);
                }
            }
            if (this.m_bModifyElementColors && ((PgElementSet)this.m_geom).hasElementColors()) {
                colorArray = PwAdjustColors.modifyHSB(((PgElementSet)this.m_geomSave).getElementColors(), (float)this.m_hue.getValue(), (float)this.m_saturation.getValue(), (float)this.m_brightness.getValue(), (float)this.m_contrast.getValue());
                if (this.m_bSelectedOnly) {
                    n2 = ((PgElementSet)this.m_geom).getNumElements();
                    for (n = 0; n < n2; ++n) {
                        if (!((PgElementSet)this.m_geom).hasTagElement(n, 1)) continue;
                        ((PgElementSet)this.m_geom).setElementColor(n, colorArray[n]);
                    }
                } else {
                    ((PgElementSet)this.m_geom).setElementColors(colorArray);
                }
            }
            if (this.m_bModifyElementBackColors && ((PgElementSet)this.m_geom).hasElementBackColors()) {
                colorArray = PwAdjustColors.modifyHSB(((PgElementSet)this.m_geomSave).getElementBackColors(), (float)this.m_hue.getValue(), (float)this.m_saturation.getValue(), (float)this.m_brightness.getValue(), (float)this.m_contrast.getValue());
                if (this.m_bSelectedOnly) {
                    n2 = ((PgElementSet)this.m_geom).getNumElements();
                    for (n = 0; n < n2; ++n) {
                        if (!((PgElementSet)this.m_geom).hasTagElement(n, 1)) continue;
                        ((PgElementSet)this.m_geom).setElementBackColor(n, colorArray[n]);
                    }
                } else {
                    ((PgElementSet)this.m_geom).setElementBackColors(colorArray);
                }
            }
            if (this.m_bModifyPolygonColors && ((PgPolygonSet)this.m_geom).hasPolygonColors()) {
                colorArray = PwAdjustColors.modifyHSB(((PgPolygonSet)this.m_geomSave).getPolygonColors(), (float)this.m_hue.getValue(), (float)this.m_saturation.getValue(), (float)this.m_brightness.getValue(), (float)this.m_contrast.getValue());
                if (this.m_bSelectedOnly) {
                    n2 = ((PgPolygonSet)this.m_geom).getNumPolygons();
                    for (n = 0; n < n2; ++n) {
                        if (!((PgPolygonSet)this.m_geom).hasTagPolygon(n, 1)) continue;
                        ((PgPolygonSet)this.m_geom).setPolygonColor(n, colorArray[n]);
                    }
                } else {
                    ((PgPolygonSet)this.m_geom).setPolygonColors(colorArray);
                }
            }
            if (this.m_bModifyCubeColors && ((PgCubeSet)this.m_geom).hasCubeColors()) {
                colorArray = PwAdjustColors.modifyHSB(((PgCubeSet)this.m_geomSave).getCubeColors(), (float)this.m_hue.getValue(), (float)this.m_saturation.getValue(), (float)this.m_brightness.getValue(), (float)this.m_contrast.getValue());
                if (this.m_bSelectedOnly) {
                    n2 = ((PgCubeSet)this.m_geom).getNumCubes();
                    for (n = 0; n < n2; ++n) {
                        if (!((PgCubeSet)this.m_geom).hasTagCube(n, 1)) continue;
                        ((PgCubeSet)this.m_geom).setCubeColor(n, colorArray[n]);
                    }
                } else {
                    ((PgCubeSet)this.m_geom).setCubeColors(colorArray);
                }
            }
            if (this.m_bModifyTetrahedronColors && ((PgTetraSet)this.m_geom).hasTetraColors()) {
                colorArray = PwAdjustColors.modifyHSB(((PgTetraSet)this.m_geomSave).getTetraColors(), (float)this.m_hue.getValue(), (float)this.m_saturation.getValue(), (float)this.m_brightness.getValue(), (float)this.m_contrast.getValue());
                if (this.m_bSelectedOnly) {
                    n2 = ((PgTetraSet)this.m_geom).getNumTetras();
                    for (n = 0; n < n2; ++n) {
                        if (!((PgTetraSet)this.m_geom).hasTagTetra(n, 1)) continue;
                        ((PgTetraSet)this.m_geom).setTetraColor(n, colorArray[n]);
                    }
                } else {
                    ((PgTetraSet)this.m_geom).setTetraColors(colorArray);
                }
            }
            return this.m_geom.update(null);
        }
        if (object == this.m_red || object == this.m_green || object == this.m_blue) {
            int n;
            int n3;
            Color[] colorArray;
            if (this.m_bModifyVertexColors && ((PgPointSet)this.m_geom).hasVertexColors()) {
                colorArray = PwAdjustColors.modifyRGB(((PgPointSet)this.m_geomSave).getVertexColors(), this.m_red.getValue(), this.m_green.getValue(), this.m_blue.getValue());
                if (this.m_bSelectedOnly) {
                    n3 = ((PgPointSet)this.m_geom).getNumVertices();
                    for (n = 0; n < n3; ++n) {
                        if (!((PgPointSet)this.m_geom).hasTagVertex(n, 1)) continue;
                        ((PgPointSet)this.m_geom).setVertexColor(n, colorArray[n]);
                    }
                } else {
                    ((PgPointSet)this.m_geom).setVertexColors(colorArray);
                }
            }
            if (this.m_bModifyElementColors && ((PgElementSet)this.m_geom).hasElementColors()) {
                colorArray = PwAdjustColors.modifyRGB(((PgElementSet)this.m_geomSave).getElementColors(), this.m_red.getValue(), this.m_green.getValue(), this.m_blue.getValue());
                if (this.m_bSelectedOnly) {
                    n3 = ((PgElementSet)this.m_geom).getNumElements();
                    for (n = 0; n < n3; ++n) {
                        if (!((PgElementSet)this.m_geom).hasTagElement(n, 1)) continue;
                        ((PgElementSet)this.m_geom).setElementColor(n, colorArray[n]);
                    }
                } else {
                    ((PgElementSet)this.m_geom).setElementColors(colorArray);
                }
            }
            if (this.m_bModifyElementBackColors && ((PgElementSet)this.m_geom).hasElementBackColors()) {
                colorArray = PwAdjustColors.modifyRGB(((PgElementSet)this.m_geomSave).getElementBackColors(), this.m_red.getValue(), this.m_green.getValue(), this.m_blue.getValue());
                if (this.m_bSelectedOnly) {
                    n3 = ((PgElementSet)this.m_geom).getNumElements();
                    for (n = 0; n < n3; ++n) {
                        if (!((PgElementSet)this.m_geom).hasTagElement(n, 1)) continue;
                        ((PgElementSet)this.m_geom).setElementBackColor(n, colorArray[n]);
                    }
                } else {
                    ((PgElementSet)this.m_geom).setElementBackColors(colorArray);
                }
            }
            if (this.m_bModifyPolygonColors && ((PgPolygonSet)this.m_geom).hasPolygonColors()) {
                colorArray = PwAdjustColors.modifyRGB(((PgPolygonSet)this.m_geomSave).getPolygonColors(), this.m_red.getValue(), this.m_green.getValue(), this.m_blue.getValue());
                if (this.m_bSelectedOnly) {
                    n3 = ((PgPolygonSet)this.m_geom).getNumPolygons();
                    for (n = 0; n < n3; ++n) {
                        if (!((PgPolygonSet)this.m_geom).hasTagPolygon(n, 1)) continue;
                        ((PgPolygonSet)this.m_geom).setPolygonColor(n, colorArray[n]);
                    }
                } else {
                    ((PgPolygonSet)this.m_geom).setPolygonColors(colorArray);
                }
            }
            if (this.m_bModifyCubeColors && ((PgCubeSet)this.m_geom).hasCubeColors()) {
                colorArray = PwAdjustColors.modifyRGB(((PgCubeSet)this.m_geomSave).getCubeColors(), this.m_red.getValue(), this.m_green.getValue(), this.m_blue.getValue());
                if (this.m_bSelectedOnly) {
                    n3 = ((PgCubeSet)this.m_geom).getNumCubes();
                    for (n = 0; n < n3; ++n) {
                        if (!((PgCubeSet)this.m_geom).hasTagCube(n, 1)) continue;
                        ((PgCubeSet)this.m_geom).setCubeColor(n, colorArray[n]);
                    }
                } else {
                    ((PgCubeSet)this.m_geom).setCubeColors(colorArray);
                }
            }
            if (this.m_bModifyTetrahedronColors && ((PgTetraSet)this.m_geom).hasTetraColors()) {
                colorArray = PwAdjustColors.modifyRGB(((PgTetraSet)this.m_geomSave).getTetraColors(), this.m_red.getValue(), this.m_green.getValue(), this.m_blue.getValue());
                if (this.m_bSelectedOnly) {
                    n3 = ((PgTetraSet)this.m_geom).getNumTetras();
                    for (n = 0; n < n3; ++n) {
                        if (!((PgTetraSet)this.m_geom).hasTagTetra(n, 1)) continue;
                        ((PgTetraSet)this.m_geom).setTetraColor(n, colorArray[n]);
                    }
                } else {
                    ((PgTetraSet)this.m_geom).setTetraColors(colorArray);
                }
            }
            return this.m_geom.update(null);
        }
        return super.update(object);
    }

    public void setMode(int n) {
        this.m_mode = n;
    }

    public int getMode() {
        return this.m_mode;
    }

    public static Color[] modifyHSB(Color[] colorArray, double d, double d2, double d3, double d4) {
        int n = colorArray.length;
        Color[] colorArray2 = new Color[n];
        for (int i = 0; i < n; ++i) {
            float[] fArray = Color.RGBtoHSB(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue(), null);
            fArray[1] = (float)((double)fArray[1] * d2);
            if ((double)fArray[1] > 1.0) {
                fArray[1] = 1.0f;
            }
            fArray[2] = (fArray[2] - 0.5f) * (float)d4 + 0.5f + (float)d3;
            if ((double)fArray[2] > 1.0) {
                fArray[2] = 1.0f;
            }
            if ((double)fArray[2] < 0.0) {
                fArray[2] = 0.0f;
            }
            fArray[0] = (float)((double)fArray[0] + d);
            while ((double)fArray[0] < 0.0) {
                fArray[0] = (float)((double)fArray[0] + 1.0);
            }
            while ((double)fArray[0] >= 1.0) {
                fArray[0] = (float)((double)fArray[0] - 1.0);
            }
            colorArray2[i] = new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
        }
        return colorArray2;
    }

    public static Color[] modifyRGB(Color[] colorArray, double d, double d2, double d3) {
        int n = colorArray.length;
        Color[] colorArray2 = new Color[n];
        for (int i = 0; i < n; ++i) {
            double d4 = colorArray[i].getRed();
            if ((d4 *= d) > 255.0) {
                d4 = 255.0;
            }
            double d5 = colorArray[i].getGreen();
            if ((d5 *= d2) > 255.0) {
                d5 = 255.0;
            }
            double d6 = colorArray[i].getBlue();
            if ((d6 *= d3) > 255.0) {
                d6 = 255.0;
            }
            colorArray2[i] = new Color((int)d4, (int)d5, (int)d6);
        }
        return colorArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

