/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.util.Vector;
import jvx.loader.contextManager;

class encoder {
    protected Vector m_output = new Vector();
    protected int m_high = 65535;
    protected int m_low = 0;
    protected int m_underflowBits = 0;
    protected int m_numZeros = 0;
    protected int m_dataLocal = 0;
    protected int m_dataBitOffset = 0;
    protected int m_halfMask = 32768;
    protected int m_quarterMask = 16384;
    protected contextManager m_cm = new contextManager();
    private static final boolean m_bUseContextManager = true;
    protected boolean m_bCompressed = true;

    private boolean writeSymbol(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if ((n5 = this.m_cm.getSymbolFrequency(n + 1024, ++n2)) == 0) {
            n2 = 0;
            n5 = this.m_cm.getSymbolFrequency(n + 1024, n2);
        }
        n3 = this.m_cm.getTotalSymbolFrequency(n + 1024);
        n4 = this.m_cm.getCumulativeSymbolFrequency(n + 1024, n2);
        if (n2 == 0) {
            bl = true;
        }
        int n6 = this.m_high + 1 - this.m_low;
        this.m_high = this.m_low - 1 + n6 * (n4 + n5) / n3;
        this.m_low += n6 * n4 / n3;
        this.m_cm.addSymbol(n + 1024, n2);
        int n7 = this.m_low >> 15;
        while ((this.m_high & this.m_halfMask) == (this.m_low & this.m_halfMask)) {
            this.m_high &= ~this.m_halfMask;
            this.m_high += this.m_high + 1;
            this.writeBit(n7);
            while (this.m_underflowBits > 0) {
                --this.m_underflowBits;
                this.writeBit(~n7 & 1);
            }
            this.m_low &= ~this.m_halfMask;
            this.m_low += this.m_low;
            n7 = this.m_low >> 15;
        }
        while ((this.m_high & this.m_quarterMask) == 0 && (this.m_low & this.m_quarterMask) == this.m_quarterMask) {
            this.m_high &= ~this.m_halfMask;
            this.m_high <<= 1;
            this.m_low <<= 1;
            this.m_high |= this.m_halfMask;
            this.m_high |= 1;
            this.m_low &= ~this.m_halfMask;
            ++this.m_underflowBits;
        }
        return bl;
    }

    private void writeBit(int n) {
        int n2 = 1;
        this.m_dataLocal &= ~(n2 << this.m_dataBitOffset);
        this.m_dataLocal |= (n &= n2) << this.m_dataBitOffset;
        ++this.m_dataBitOffset;
        if (this.m_dataBitOffset >= 32) {
            this.m_dataBitOffset -= 32;
            this.incrementPosition();
        }
    }

    private void incrementPosition() {
        this.m_output.addElement(new Integer(this.m_dataLocal));
    }

    public int[] getCompressedData() {
        int n = this.m_output.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)this.m_output.elementAt(i);
        }
        return nArray;
    }

    public void finalize() {
        if (this.m_bCompressed) {
            this.writeU32(0);
        }
        while (this.m_dataBitOffset != 0) {
            this.writeBit(0);
        }
    }

    public void writeCompressedU32(int n, int n2) {
        if (n > 16382) {
            this.writeU32(n2);
        } else if (this.writeSymbol(n, n2)) {
            this.writeU32(n2);
            this.m_cm.addSymbol(n + 1024, n2 + 1);
        }
    }

    protected void writeU32(int n) {
        this.writeU16(0xFFFF & n);
        this.writeU16(0xFFFF & n >> 16);
    }

    protected void writeU16(int n) {
        this.writeU8(0xFF & n);
        this.writeU8(0xFF & n >> 8);
    }

    protected void writeU8(int n) {
        this.writeSymbol(256, this.swapBits8(n));
    }

    protected int swapBits8(int n) {
        return (1 & n) << 7 | (2 & n) << 5 | (4 & n) << 3 | (8 & n) << 1 | (0x10 & n) >> 1 | (0x20 & n) >> 3 | (0x40 & n) >> 5 | (0x80 & n) >> 7;
    }
}

