/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.DataOutputStream;
import jvx.loader.PsU3dBlock;

class PsU3dViewNodeBlock
extends PsU3dBlock {
    public String m_name;
    public int m_parentNodeCount;
    public String[] m_parentNodeName;
    public float[][][] m_parentNodeTransform;
    public String m_resourceName;
    public int m_viewNodeAttributes = 0;
    public float m_viewNearClip;
    public float m_viewFarClip;
    public float m_viewProjection;
    public float m_viewOrthographicHeight;
    public float m_viewPortWidth;
    public float m_viewPortHeight;
    public float m_viewPortHorizontalPos;
    public float m_viewPortVerticalPos;
    public int m_backdropCount;
    String[] m_backdropTextureName;
    float[] m_backdropTextureBlend;
    float[] m_backdropRotation;
    float[] m_backdropLocationX;
    float[] m_backdropLocationY;
    int[] m_backdropRegistrationPointX;
    int[] m_backdropRegistrationPointY;
    float[] m_backdropScaleX;
    float[] m_backdropScaleY;
    public int m_overlayCount;
    String[] m_overlayTextureName;
    float[] m_overlayTextureBlend;
    float[] m_overlayRotation;
    float[] m_overlayLocationX;
    float[] m_overlayLocationY;
    int[] m_overlayRegistrationPointX;
    int[] m_overlayRegistrationPointY;
    float[] m_overlayScaleX;
    float[] m_overlayScaleY;

    public PsU3dViewNodeBlock() {
        this.m_blockType = -220;
    }

    public void setNumParents(int n) {
        this.m_parentNodeCount = n;
        this.m_parentNodeTransform = new float[n][4][4];
        this.m_parentNodeName = new String[n];
    }

    public void computeSize() {
        int n;
        this.m_dataSize = this.m_name.length() + 2 + this.m_resourceName.length() + 2 + 4;
        for (n = 0; n < this.m_parentNodeCount; ++n) {
            this.m_dataSize += this.m_parentNodeName[n].length() + 2 + 64;
        }
        this.m_dataSize += 12;
        if ((this.m_viewNodeAttributes & 4) != 4) {
            this.m_dataSize += 4;
        }
        this.m_dataSize += 16;
        this.m_dataSize += 4;
        for (n = 0; n < this.m_backdropCount; ++n) {
            this.m_dataSize += this.m_backdropTextureName[n].length() + 2 + 32;
        }
        this.m_dataSize += 4;
        for (n = 0; n < this.m_overlayCount; ++n) {
            this.m_dataSize += this.m_overlayTextureName[n].length() + 2 + 32;
        }
        this.m_metaDataSize = 0;
    }

    public void write(DataOutputStream dataOutputStream) {
        int n;
        super.write(dataOutputStream);
        int n2 = this.writeString(dataOutputStream, this.m_name);
        this.writeUInt32(dataOutputStream, this.m_parentNodeCount);
        for (n = 0; n < this.m_parentNodeCount; ++n) {
            n2 += this.writeString(dataOutputStream, this.m_parentNodeName[n]);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.writeFloat32(dataOutputStream, this.m_parentNodeTransform[n][i][j]);
                }
            }
        }
        n2 += this.writeString(dataOutputStream, this.m_resourceName);
        this.writeUInt32(dataOutputStream, this.m_viewNodeAttributes);
        this.writeFloat32(dataOutputStream, this.m_viewNearClip);
        this.writeFloat32(dataOutputStream, this.m_viewFarClip);
        if ((this.m_viewNodeAttributes & 4) != 4) {
            if ((this.m_viewNodeAttributes & 2) == 2) {
                this.writeFloat32(dataOutputStream, this.m_viewOrthographicHeight);
            } else {
                this.writeFloat32(dataOutputStream, this.m_viewProjection);
            }
        }
        this.writeFloat32(dataOutputStream, this.m_viewPortWidth);
        this.writeFloat32(dataOutputStream, this.m_viewPortHeight);
        this.writeFloat32(dataOutputStream, this.m_viewPortHorizontalPos);
        this.writeFloat32(dataOutputStream, this.m_viewPortVerticalPos);
        this.writeUInt32(dataOutputStream, this.m_backdropCount);
        for (n = 0; n < this.m_backdropCount; ++n) {
            n2 += this.writeString(dataOutputStream, this.m_backdropTextureName[n]);
            this.writeFloat32(dataOutputStream, this.m_backdropTextureBlend[n]);
            this.writeFloat32(dataOutputStream, this.m_backdropRotation[n]);
            this.writeFloat32(dataOutputStream, this.m_backdropLocationX[n]);
            this.writeFloat32(dataOutputStream, this.m_backdropLocationY[n]);
            this.writeUInt32(dataOutputStream, this.m_backdropRegistrationPointX[n]);
            this.writeUInt32(dataOutputStream, this.m_backdropRegistrationPointY[n]);
            this.writeFloat32(dataOutputStream, this.m_backdropScaleX[n]);
            this.writeFloat32(dataOutputStream, this.m_backdropScaleY[n]);
        }
        this.writeUInt32(dataOutputStream, this.m_overlayCount);
        for (n = 0; n < this.m_overlayCount; ++n) {
            n2 += this.writeString(dataOutputStream, this.m_overlayTextureName[n]);
            this.writeFloat32(dataOutputStream, this.m_overlayTextureBlend[n]);
            this.writeFloat32(dataOutputStream, this.m_overlayRotation[n]);
            this.writeFloat32(dataOutputStream, this.m_overlayLocationX[n]);
            this.writeFloat32(dataOutputStream, this.m_overlayLocationY[n]);
            this.writeUInt32(dataOutputStream, this.m_overlayRegistrationPointX[n]);
            this.writeUInt32(dataOutputStream, this.m_overlayRegistrationPointY[n]);
            this.writeFloat32(dataOutputStream, this.m_overlayScaleX[n]);
            this.writeFloat32(dataOutputStream, this.m_overlayScaleY[n]);
        }
        this.writePaddingBytes(dataOutputStream, n2 %= 4);
    }
}

