/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.DataOutputStream;
import jvx.loader.PsU3dBlock;

class PsU3dModifierChainBlock
extends PsU3dBlock {
    public String m_name;
    public int m_type;
    public int m_attributes = 0;
    public float[] m_boundingSphere = new float[4];
    public float[] m_boundingBox = new float[6];
    public int m_modifierCount;
    public PsU3dBlock[] m_modifierDeclaration;

    public PsU3dModifierChainBlock() {
        this.m_blockType = -236;
    }

    public void setNumModifiers(int n) {
        this.m_modifierCount = n;
        this.m_modifierDeclaration = new PsU3dBlock[n];
    }

    public void computeSize() {
        this.m_dataSize = 4 * ((this.m_name.length() + 2 + 3) / 4) + 12;
        if ((1 & this.m_attributes) == 1) {
            this.m_dataSize += 16;
        }
        if ((2 & this.m_attributes) == 2) {
            this.m_dataSize += 24;
        }
        for (int i = 0; i < this.m_modifierCount; ++i) {
            this.m_dataSize += this.m_modifierDeclaration[i].getSize();
        }
        this.m_metaDataSize = 0;
    }

    public void write(DataOutputStream dataOutputStream) {
        int n;
        super.write(dataOutputStream);
        int n2 = this.writeString(dataOutputStream, this.m_name);
        this.writeUInt32(dataOutputStream, this.m_type);
        this.writeUInt32(dataOutputStream, this.m_attributes);
        if ((1 & this.m_attributes) == 1) {
            for (n = 0; n < 4; ++n) {
                this.writeFloat32(dataOutputStream, this.m_boundingSphere[n]);
            }
        }
        if ((2 & this.m_attributes) == 2) {
            for (n = 0; n < 6; ++n) {
                this.writeFloat32(dataOutputStream, this.m_boundingBox[n]);
            }
        }
        this.writePaddingBytes(dataOutputStream, n2);
        this.writeUInt32(dataOutputStream, this.m_modifierCount);
        for (n = 0; n < this.m_modifierCount; ++n) {
            this.m_modifierDeclaration[n].write(dataOutputStream);
        }
    }
}

