/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Frame;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.loader.PgHtmlLoader;
import jv.loader.PgLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsJavaView;
import jv.rsrc.PsXmlSrc;
import jvx.loader.PsJvzConfig;
import jvx.project.PjWorkshop;

public class PsExportInfo
extends PjWorkshop {
    public static final int FILE_SIZE_USER = -1;
    public static final int FILE_SIZE_SCRN = 0;
    public static final int FILE_SIZE_PAL = 1;
    public static final int FILE_SIZE_NTSC = 2;
    public static final int FILE_SIZE_MED = 3;
    public static final int FILE_SIZE_BOOK = 4;
    public static final int FILE_SIZE_SGL = 5;
    public static final int FILE_SIZE_SML = 6;
    public static final int FILE_SIZE_TINY = 7;
    public static final int FILE_FORMAT_BYU = 0;
    public static final int FILE_FORMAT_DXF = 1;
    public static final int FILE_FORMAT_FE = 2;
    public static final int FILE_FORMAT_JVX = 3;
    public static final int FILE_FORMAT_JVZ = 4;
    public static final int FILE_FORMAT_MA = 5;
    public static final int FILE_FORMAT_MGS = 6;
    public static final int FILE_FORMAT_MPL = 7;
    public static final int FILE_FORMAT_OBJ = 8;
    public static final int FILE_FORMAT_OFF = 9;
    public static final int FILE_FORMAT_STL = 10;
    public static final int FILE_FORMAT_U3D = 11;
    public static final int FILE_FORMAT_WRL = 12;
    public static final int FILE_FORMAT_XYZ = 13;
    public static final int FILE_FORMAT_GIF = 14;
    public static final int FILE_FORMAT_JPG = 15;
    public static final int FILE_FORMAT_PNG = 16;
    public static final int FILE_FORMAT_PPM = 17;
    public static final int FILE_FORMAT_EPS = 18;
    public static final int FILE_FORMAT_PS = 19;
    public static final int FILE_FORMAT_JVD = 20;
    public static final int GEOM_DATA_HEADER = 0;
    public static final int GEOM_DATA_AUTHOR = 1;
    public static final int GEOM_DATA_INFO = 2;
    public static final int GEOM_DATA_NORMALS = 3;
    public static final int GEOM_DATA_COLORS = 4;
    public static final int GEOM_DATA_TEXTURE = 5;
    public static final int GEOM_DATA_VECTORS = 6;
    protected static final int[] GEOM_DATA_FORMAT = new int[]{0, 1, 2, 3, 4, 5, 6};
    protected static final String[] GEOM_DATA_FORMAT_EXT = new String[]{"Header", "Author", "Info", "Normal", "Color", "Texture", "Vector"};
    protected static final int[] GEOM_FORMAT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    protected static final String[] GEOM_FORMAT_EXT = new String[]{"BYU", "DXF", "FE", "JVX", "JVZ", "MA", "MGS", "MPL", "OBJ", "OFF", "STL", "U3D", "WRL", "XYZ"};
    protected static final int[] IMAGE_FORMAT = new int[]{14, 15, 16, 17, 18, 19};
    protected static final String[] IMAGE_FORMAT_EXT = new String[]{"GIF", "JPG", "PNG", "PPM", "EPS", "PS"};
    protected static final int IMAGE_RATIO_LANDSCAPE = 0;
    protected static final int IMAGE_RATIO_PORTRAIT = 1;
    protected static final int IMAGE_RATIO_SQUARE = 2;
    protected static final int[] IMAGE_SIZE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, -1};
    protected int m_maxNumImageTypes = 8;
    protected static final String[] IMAGE_SIZE_EXT = new String[]{"_scrn", "_pal", "_ntsc", "_med", "_book", "_sgl", "_sml", "_tiny"};
    protected static String IMAGE_SIZE_EXT_USER = "_user";
    protected int[][] IMAGE_SIZE_LAND = new int[][]{{1280, 1024}, {720, 576}, {720, 480}, {640, 512}, {480, 384}, {320, 256}, {240, 192}, {160, 128}};
    protected int[][] IMAGE_SIZE_PORT = new int[][]{{768, 1024}, {432, 576}, {360, 480}, {384, 512}, {288, 384}, {192, 256}, {144, 192}, {96, 128}};
    protected int[][] IMAGE_SIZE_SQUARE = new int[][]{{1024, 1024}, {576, 576}, {480, 480}, {512, 512}, {384, 384}, {256, 256}, {160, 160}, {128, 128}};
    protected static String m_baseDirectory = "";
    protected static String m_baseFileName = "geom";
    protected static int[] m_bFormatSelection;
    protected int[] m_dataFormat = GEOM_DATA_FORMAT;
    protected static int[] m_exportedFields;
    protected int[] m_geomFormat = GEOM_FORMAT;
    protected int[] m_imageFormat = IMAGE_FORMAT;
    protected static int[] m_exportedFile;
    protected PsAuthorInfo m_authorInfo;
    protected static PsGeometryInfo m_geometryInfo;
    protected PsJvzConfig m_jvzConfig;
    protected String m_sceneTitle;
    protected static boolean m_bFilePerField;
    protected static boolean m_bConfigImage;
    protected static int m_defImageType;
    protected static int m_imageType;
    protected static String[] m_imageTypeExt;
    protected static String m_imageSuffix;
    protected static int m_imageRatio;
    protected static int m_imageWidth;
    protected static int m_imageHeight;
    protected static int GEOM_SAVE_ALL;
    protected static int GEOM_SAVE_VISIBLE;
    protected static int GEOM_SAVE_SELECTED;
    protected static int m_selectGeom;
    protected static boolean m_bCompress;
    protected static boolean m_bSaveAsFloat;
    protected static boolean m_bValidate;
    protected static int m_valAppletWidth;
    protected static int m_valAppletHeight;
    protected static int m_valImageSize;
    protected static int m_valImageFormat;
    protected boolean m_bSaveEachVectorfield = false;
    static /* synthetic */ Class class$jvx$loader$PsExportInfo;

    public PsExportInfo() {
        super("Save Dialog");
        PsAuthorInfo psAuthorInfo;
        if (this.m_authorInfo == null && (psAuthorInfo = PsJavaView.getAuthorInfo()) != null && psAuthorInfo.getNumAuthors() > 0) {
            this.m_authorInfo = (PsAuthorInfo)PsJavaView.getAuthorInfo().clone();
        }
        if (((Object)((Object)this)).getClass() == (class$jvx$loader$PsExportInfo == null ? (class$jvx$loader$PsExportInfo = PsExportInfo.class$("jvx.loader.PsExportInfo")) : class$jvx$loader$PsExportInfo)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        m_imageRatio = 0;
        if (m_imageType == -1) {
            this.setImageType(m_defImageType);
        }
    }

    public void setViewer(PvViewerIf pvViewerIf) {
        super.setViewer(pvViewerIf);
        this.setDirectory(PsJavaView.getDirectory((int)7));
        this.setBaseFileName(PsJavaView.getFileName((int)7));
        PvDisplayIf pvDisplayIf = pvViewerIf.getDisplay();
        PgGeometryIf pgGeometryIf = null;
        if (pvDisplayIf != null) {
            pgGeometryIf = pvDisplayIf.getSelectedGeometry();
        }
        if (pgGeometryIf != null && pgGeometryIf.getAuthorInfo() != null && pgGeometryIf.getAuthorInfo().getNumAuthors() > 0) {
            this.m_authorInfo = pgGeometryIf.getAuthorInfo();
        } else if (PsJavaView.getAuthorInfo() != null && PsJavaView.getAuthorInfo().getNumAuthors() > 0) {
            this.m_authorInfo = (PsAuthorInfo)PsJavaView.getAuthorInfo().clone();
        }
        if (pgGeometryIf != null && pgGeometryIf.getGeometryInfo() != null) {
            m_geometryInfo = pgGeometryIf.getGeometryInfo();
        }
        if (pvDisplayIf != null && !PuString.isEmpty((String)pvDisplayIf.getSceneTitle())) {
            this.m_sceneTitle = pvDisplayIf.getSceneTitle();
        } else if (pgGeometryIf != null) {
            this.m_sceneTitle = pgGeometryIf.getTitle() != null ? pgGeometryIf.getTitle() : pgGeometryIf.getName();
        }
    }

    public void setMode(int n) {
        if (n == 1) {
            PsDebug.warning((String)"mode BUG not supported yet.");
            return;
        }
        super.setMode(n);
    }

    public int getImageType() {
        return m_imageType;
    }

    public void setImageType(int n) {
        if (n == m_imageType) {
            return;
        }
        if (n == -1) {
            m_imageType = -1;
            m_imageSuffix = IMAGE_SIZE_EXT_USER;
        } else if (0 <= n && n < this.m_maxNumImageTypes) {
            m_imageType = n;
            m_imageSuffix = IMAGE_SIZE_EXT[m_imageType];
            if (m_imageRatio == 0) {
                m_imageWidth = this.IMAGE_SIZE_LAND[m_imageType][0];
                m_imageHeight = this.IMAGE_SIZE_LAND[m_imageType][1];
            } else if (m_imageRatio == 1) {
                m_imageWidth = this.IMAGE_SIZE_PORT[m_imageType][0];
                m_imageHeight = this.IMAGE_SIZE_PORT[m_imageType][1];
            } else if (m_imageRatio == 2) {
                m_imageWidth = this.IMAGE_SIZE_SQUARE[m_imageType][0];
                m_imageHeight = this.IMAGE_SIZE_SQUARE[m_imageType][1];
            }
        } else {
            PsDebug.warning((String)("image type out of range, type = " + n));
            return;
        }
    }

    private int getFileDialog(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 44;
                break;
            }
            case 1: {
                n2 = 45;
                break;
            }
            case 2: {
                n2 = 46;
                break;
            }
            case 3: {
                n2 = 47;
                break;
            }
            case 4: {
                n2 = 48;
                break;
            }
            case 5: {
                n2 = 49;
                break;
            }
            case 6: {
                n2 = 50;
                break;
            }
            case 7: {
                n2 = 51;
                break;
            }
            case 8: {
                n2 = 52;
                break;
            }
            case 9: {
                n2 = 53;
                break;
            }
            case 10: {
                n2 = 56;
                break;
            }
            case 11: {
                n2 = 57;
                break;
            }
            case 12: {
                n2 = 58;
                break;
            }
            case 13: {
                n2 = 59;
                break;
            }
            case 14: {
                n2 = 61;
                break;
            }
            case 15: {
                n2 = 63;
                break;
            }
            case 16: {
                n2 = 67;
                break;
            }
            case 17: {
                n2 = 65;
                break;
            }
            case 18: {
                n2 = 69;
                break;
            }
            case 19: {
                n2 = 70;
                break;
            }
            case 20: {
                n2 = 60;
                break;
            }
            default: {
                PsDebug.warning((String)("Unknown file format = " + String.valueOf(n)));
            }
        }
        return n2;
    }

    public String getFileExtension(int n) {
        int n2;
        int n3 = GEOM_FORMAT_EXT.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (n != GEOM_FORMAT[n2]) continue;
            return GEOM_FORMAT_EXT[n2];
        }
        n2 = IMAGE_FORMAT_EXT.length;
        for (int i = 0; i < n2; ++i) {
            if (n != IMAGE_FORMAT[i]) continue;
            return IMAGE_FORMAT_EXT[i];
        }
        if (n == 20) {
            return "JVD";
        }
        PsDebug.warning((String)("Unknown file format = " + n));
        return "";
    }

    public PsJvzConfig getJvzConfig() {
        if (this.m_jvzConfig == null) {
            this.m_jvzConfig = new PsJvzConfig();
        }
        return this.m_jvzConfig;
    }

    public void setJvzConfig(PsJvzConfig psJvzConfig) {
        this.m_jvzConfig = psJvzConfig;
    }

    public boolean isEnabledCompress() {
        return m_bCompress;
    }

    public void setEnabledCompress(boolean bl) {
        m_bCompress = bl;
    }

    public boolean isEnabledSaveAsFloat() {
        return m_bSaveAsFloat;
    }

    public void setEnabledSaveAsFloat(boolean bl) {
        m_bSaveAsFloat = bl;
    }

    public boolean isEnabledConfigDisplay() {
        return m_bConfigImage;
    }

    public void setEnabledConfigDisplay(boolean bl) {
        m_bConfigImage = bl;
    }

    public String getBaseFileName() {
        return m_baseFileName;
    }

    public void setBaseFileName(String string) {
        m_baseFileName = PsUtil.getFileBaseName((String)string);
    }

    public String getDirectory() {
        return m_baseDirectory;
    }

    public void setDirectory(String string) {
        m_baseDirectory = string;
    }

    public String getImageSuffix() {
        return m_imageSuffix;
    }

    public void setImageSuffix(String string) {
        m_imageSuffix = string;
    }

    public int[] getExportedFiles() {
        return m_exportedFile;
    }

    public void setExportedFiles(int[] nArray) {
        m_exportedFile = nArray == null ? new int[0] : (int[])nArray.clone();
    }

    public String getDataName(int n) {
        return GEOM_DATA_FORMAT_EXT[n];
    }

    public int[] getExportedDataFields() {
        return m_exportedFields;
    }

    public void setExportedDataFields(int[] nArray) {
        m_exportedFields = nArray == null ? new int[0] : (int[])nArray.clone();
    }

    public int[] getDataFields() {
        return this.m_dataFormat;
    }

    public void setDataFields(int[] nArray) {
        this.m_dataFormat = nArray == null ? new int[0] : (int[])nArray.clone();
    }

    public int[] getGeomFormat() {
        return this.m_geomFormat;
    }

    public void setGeomFormat(int[] nArray) {
        this.m_geomFormat = nArray == null ? new int[0] : (int[])nArray.clone();
    }

    public int[] getImageFormat() {
        return this.m_imageFormat;
    }

    public void setImageFormat(int[] nArray) {
        this.m_imageFormat = nArray == null ? new int[0] : (int[])nArray.clone();
    }

    public PsAuthorInfo getAuthorInfo() {
        return this.m_authorInfo;
    }

    public void setAuthorInfo(PsAuthorInfo psAuthorInfo) {
        this.m_authorInfo = psAuthorInfo;
    }

    public PsGeometryInfo getGeometryInfo() {
        return m_geometryInfo;
    }

    public void setGeometryInfo(PsGeometryInfo psGeometryInfo) {
        m_geometryInfo = psGeometryInfo;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this) {
            super.update((Object)this);
        }
        return super.update(object);
    }

    public void ok() {
        String string;
        Object object;
        String string2;
        String string3;
        int n;
        if (m_exportedFile == null || m_exportedFile.length == 0) {
            super.ok();
            return;
        }
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf == null) {
            super.ok();
            return;
        }
        PvDisplayIf pvDisplayIf = pvViewerIf.getDisplay();
        if (pvDisplayIf == null) {
            PsDebug.warning((String)"missing display. Currently, export dialog requires a display.");
            super.ok();
            return;
        }
        boolean bl = !PuString.isEmpty((String)this.m_sceneTitle);
        PgGeometryIf[] pgGeometryIfArray = pvDisplayIf.getGeometries();
        PgGeometryIf pgGeometryIf = pvDisplayIf.getSelectedGeometry();
        if (pgGeometryIfArray != null) {
            for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                if (pgGeometryIfArray[i] == null || pgGeometryIfArray[i] == pgGeometryIf) continue;
                if (pgGeometryIfArray[i].getAuthorInfo() == null) {
                    pgGeometryIfArray[i].setAuthorInfo(this.m_authorInfo);
                }
                if (pgGeometryIfArray[i].getGeometryInfo() == null) {
                    pgGeometryIfArray[i].setGeometryInfo(m_geometryInfo);
                }
                if (!bl) continue;
                pgGeometryIfArray[i].setTitle(this.m_sceneTitle);
            }
        }
        if (pgGeometryIf != null) {
            pgGeometryIf.setAuthorInfo(this.m_authorInfo);
            pgGeometryIf.setGeometryInfo(m_geometryInfo);
            if (bl) {
                pgGeometryIf.setTitle(this.m_sceneTitle);
            }
        }
        if (bl) {
            pvDisplayIf.setSceneTitle(this.m_sceneTitle);
        }
        String string4 = m_baseDirectory + m_baseFileName;
        int n2 = m_exportedFile.length;
        String string5 = null;
        PgLoader pgLoader = new PgLoader();
        for (n = 0; n < m_exportedFields.length; ++n) {
            pgLoader.setTag(m_exportedFields[n], true);
        }
        if (m_exportedFields.length == 0) {
            pgLoader.setTag(0, true);
            pgLoader.setTag(0, false);
        }
        n = 0;
        block15: for (int i = 0; i < n2; ++i) {
            int n3 = this.getFileDialog(m_exportedFile[i]);
            string3 = this.getFileExtension(m_exportedFile[i]).toLowerCase();
            string2 = string4 + "." + string3;
            object = null;
            switch (n3) {
                case 53: 
                case 60: 
                case 72: {
                    object = new PvDisplayOption();
                    object.setOptions(pvDisplayIf);
                    if (bl) {
                        object.setTitle(this.m_sceneTitle);
                    }
                    if (this.m_authorInfo == null) break;
                    object.setAuthorInfo(this.m_authorInfo);
                }
            }
            pgLoader.setDisplayOption(object);
            switch (n3) {
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 56: 
                case 57: 
                case 58: 
                case 59: {
                    if (m_bCompress) {
                        string2 = string2 + ".zip";
                    }
                }
                case 72: {
                    PgGeometryIf pgGeometryIf2;
                    PgGeometryIf[] pgGeometryIfArray2 = null;
                    if (m_selectGeom == GEOM_SAVE_ALL) {
                        pgGeometryIfArray2 = pvDisplayIf.getGeometries();
                        if (pgGeometryIfArray2 == null) {
                            break;
                        }
                    } else {
                        pgGeometryIfArray2 = m_selectGeom == GEOM_SAVE_VISIBLE ? pvDisplayIf.getVisibleGeometries() : new PgGeometryIf[]{pvDisplayIf.getSelectedGeometry()};
                    }
                    if (pgGeometryIfArray2 != null && pgGeometryIfArray2.length > 1 && pgGeometryIfArray2[0] != (pgGeometryIf2 = pvDisplayIf.getSelectedGeometry())) {
                        for (int j = 0; j < pgGeometryIfArray2.length; ++j) {
                            if (pgGeometryIfArray2[j] != pgGeometryIf2) continue;
                            string = pgGeometryIfArray2[0];
                            pgGeometryIfArray2[0] = pgGeometryIf2;
                            pgGeometryIfArray2[j] = string;
                            break;
                        }
                    }
                    boolean bl2 = PuString.m_bConvertDoubleToFloat;
                    PuString.m_bConvertDoubleToFloat = m_bSaveAsFloat;
                    n = pgLoader.saveGeometry(pgGeometryIfArray2, string2) ? 1 : 0;
                    PuString.m_bConvertDoubleToFloat = bl2;
                    break;
                }
                case 60: {
                    n = pgLoader.saveDisplay(new PvDisplayOption[]{object}, string2) ? 1 : 0;
                    break;
                }
                case 61: 
                case 63: 
                case 65: 
                case 67: 
                case 69: 
                case 70: {
                    PgGeometryIf pgGeometryIf3 = pvDisplayIf.getSelectedGeometry();
                    if (this.m_bSaveEachVectorfield && pgGeometryIf3 != null && pgGeometryIf3 instanceof PgElementSet) {
                        PgVectorField pgVectorField;
                        int n4;
                        string = (PgElementSet)pgGeometryIf3;
                        int n5 = string.getNumVectorFields();
                        if (!this.m_bSaveEachVectorfield && n5 <= 1) break;
                        boolean bl3 = string.isShowingVectorFields();
                        boolean bl4 = string.isShowingSingleVectorField();
                        string.showVectorFields(true);
                        string.showSingleVectorField(true);
                        boolean[] blArray = new boolean[n5];
                        for (n4 = 0; n4 < n5; ++n4) {
                            pgVectorField = string.getVectorField(n4);
                            blArray[n4] = pgVectorField.isVisible();
                            pgVectorField.setVisible(false);
                        }
                        for (n4 = 0; n4 < n5; ++n4) {
                            pgVectorField = string.getVectorField(n4);
                            pgVectorField.setVisible(true);
                            pgGeometryIf3.update(null);
                            String string6 = pgVectorField.getName();
                            String string7 = string4;
                            string7 = string7 + "_vf-" + string6;
                            if (m_imageSuffix != null) {
                                string7 = string7 + m_imageSuffix;
                            }
                            string7 = string7 + "." + string3;
                            if (this.isEnabledConfigDisplay()) {
                                pvViewerIf.export(n3, string7, m_imageWidth, m_imageHeight);
                            } else {
                                pvViewerIf.export(n3, string7);
                            }
                            pgVectorField.setVisible(false);
                        }
                        for (n4 = 0; n4 < n5; ++n4) {
                            pgVectorField = string.getVectorField(n4);
                            pgVectorField.setVisible(blArray[n4]);
                        }
                        string.showVectorFields(bl3);
                        string.showSingleVectorField(bl4);
                        pgGeometryIf3.update((Object)pgGeometryIf3);
                        break;
                    }
                    string = string4;
                    if (m_imageSuffix != null) {
                        string = string + m_imageSuffix;
                    }
                    string = string + "." + string3;
                    if (this.isEnabledConfigDisplay()) {
                        pvViewerIf.export(n3, string, m_imageWidth, m_imageHeight);
                        break;
                    }
                    pvViewerIf.export(n3, string);
                    break;
                }
                default: {
                    PsDebug.warning((String)("missing export handler for file = " + string2));
                    continue block15;
                }
            }
            if (string3.equalsIgnoreCase("jvx") || string3.equalsIgnoreCase("jvz")) {
                string5 = string3;
                continue;
            }
            if (string5 != null || string3.equalsIgnoreCase("html") || string3.equalsIgnoreCase("eps") || string3.equalsIgnoreCase("ps") || string3.equalsIgnoreCase("jvd") || string3.equalsIgnoreCase("gif") || string3.equalsIgnoreCase("jpg") || string3.equalsIgnoreCase("png") || string3.equalsIgnoreCase("ppm")) continue;
            string5 = string3;
        }
        if (this.getMode() == 1) {
            PsDebug.warning((String)"mode BUG not supported yet.");
            return;
        }
        if (this.getMode() == 2) {
            String string8 = PsJavaView.getDirectory((int)6);
            String string9 = m_baseFileName;
            string3 = "";
            if (!string4.startsWith(string8)) {
                string3 = "./";
            } else {
                string9 = string4.substring(string8.length());
                string2 = PsUtil.getFilePath((String)string9);
                object = PuString.splitString((String)string2, (char)PsConfig.getFileSeparator());
                for (int i = 0; i < ((PvDisplayOption)object).length; ++i) {
                    if (PuString.isEmpty((String)object[i])) continue;
                    string3 = string3 + "../";
                }
            }
            string2 = string4 + ".html";
            object = PsUtil.writeFile((String)string2);
            if (object == null) {
                PsDebug.warning((String)("could not open file = " + string2));
                return;
            }
            string9 = string9.replace('\\', '/');
            String string10 = null;
            try {
                PgHtmlLoader.writeValidate((Writer)object, (String)this.m_sceneTitle, (PsAuthorInfo)this.m_authorInfo, (PsGeometryInfo)m_geometryInfo, (String)string3, (String)(string9 + ".jvx"), (String)(string9 + ".jvd"), (String)(string9 + IMAGE_SIZE_EXT[m_valImageSize] + "." + this.getFileExtension(m_valImageFormat).toLowerCase()), (int)m_valAppletWidth, (int)m_valAppletHeight, string10);
            }
            catch (IOException iOException) {
                PsDebug.warning((String)("could not export file = " + string2));
            }
            ((PrintWriter)object).close();
            object = null;
            String string11 = string4 + ".jvv";
            PrintWriter printWriter = PsUtil.writeFile((String)string11);
            if (printWriter == null) {
                PsDebug.warning((String)("could not open file = " + string11));
                return;
            }
            try {
                string = PgHtmlLoader.writeValidateDescr((String)this.m_sceneTitle, (PsAuthorInfo)this.m_authorInfo, (PsGeometryInfo)m_geometryInfo, (String)(m_baseFileName + ".jvx"), (String)(m_baseFileName + ".jvd"), (String)(m_baseFileName + IMAGE_SIZE_EXT[m_valImageSize] + "." + this.getFileExtension(m_valImageFormat).toLowerCase()), (int)m_valAppletWidth, (int)m_valAppletHeight, string10, (boolean)m_bValidate);
                PsXmlSrc.write((Writer)printWriter, (PsXmlSrc)string);
            }
            catch (IOException iOException) {
                PsDebug.warning((String)("could not export file = " + string11));
            }
            printWriter.close();
        }
        if (n != 0 && string5 != null) {
            string4 = string4 + "." + string5;
            PsJavaView.setFullFileName((int)7, (String)string4);
            Frame frame = pvViewerIf.getFrame();
            if (frame != null) {
                frame.setTitle(PsConfig.getProgramAndVersion() + ": " + string4);
            }
        }
        super.ok();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_exportedFields = new int[]{0, 1, 2, 3, 4, 5, 6};
        m_exportedFile = new int[]{3, 20};
        m_bFilePerField = false;
        m_bConfigImage = true;
        m_defImageType = 0;
        m_imageType = -1;
        m_imageTypeExt = IMAGE_SIZE_EXT;
        GEOM_SAVE_ALL = 1;
        GEOM_SAVE_VISIBLE = 2;
        GEOM_SAVE_SELECTED = 3;
        m_selectGeom = GEOM_SAVE_ALL;
        m_bCompress = false;
        m_bSaveAsFloat = false;
        m_bValidate = true;
        m_valAppletWidth = 320;
        m_valAppletHeight = 256;
        m_valImageSize = 5;
        m_valImageFormat = 15;
    }
}

