/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnStraightestGeodesic;

public final class PwBary {
    private static PgElementSet m_prevGeom = null;
    private static int m_prevElement = -1;
    private static double m_xx;
    private static double m_yy;
    private static double m_zz;
    private static final double m_eps = 1.0E-10;
    private static PdBaryDir m_tmpEdge1;
    private static PdBaryDir m_tmpEdge2;
    private static PdBaryDir m_tmpEdge3;
    private static PdBaryDir m_tmpEdge4;
    private static PdVector[] m_projVert;
    private static PdVector m_projN;
    private static PdVector m_rotVertAngles;
    private static PgVertexStar m_rotVertStar;
    private static PdBaryDir m_rotVertEdge;
    private static PdBaryDir m_rotVertHalf;
    private static PdBaryDir m_rotVertNormal;
    private static PdBaryDir m_angleEdge;
    private static double[] m_angleOriented;
    private static PdBaryDir[] m_angleVectors;
    private static final String errormsg = "Elements degenerated in element set.";

    public static double scalar(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, PdBaryDir pdBaryDir2, boolean bl) {
        Object object;
        Object object2;
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Not a valid element index " + n + "."));
            return 0.0;
        }
        if (bl || m_prevGeom != pgElementSet || m_prevElement != n) {
            object2 = pgElementSet.getElement(n);
            object = pgElementSet.getVertex(object2.m_data[0]);
            PdVector pdVector = pgElementSet.getVertex(object2.m_data[1]);
            PdVector pdVector2 = pgElementSet.getVertex(object2.m_data[2]);
            int n2 = object.getSize();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < n2; ++i) {
                double d4 = pdVector.m_data[i] - pdVector2.m_data[i];
                d += d4 * d4;
                double d5 = pdVector2.m_data[i] - object.m_data[i];
                d2 += d5 * d5;
                double d6 = object.m_data[i] - pdVector.m_data[i];
                d3 += d6 * d6;
            }
            double d7 = 0.5 * (d + d2 + d3);
            m_xx = d7 - d;
            m_yy = d7 - d2;
            m_zz = d7 - d3;
            m_prevGeom = pgElementSet;
            m_prevElement = n;
        }
        object2 = pdBaryDir.m_data;
        object = pdBaryDir2.m_data;
        reference var7_8 = object2[0] * object[0] * m_xx + object2[1] * object[1] * m_yy + object2[2] * object[2] * m_zz;
        return (double)var7_8;
    }

    public static double norm(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4;
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Not a valid element index " + n + "."));
            return 0.0;
        }
        if (bl || m_prevGeom != pgElementSet || m_prevElement != n) {
            PiVector piVector = pgElementSet.getElement(n);
            double[] dArray = pgElementSet.getVertex((int)piVector.m_data[0]).m_data;
            double[] dArray2 = pgElementSet.getVertex((int)piVector.m_data[1]).m_data;
            double[] dArray3 = pgElementSet.getVertex((int)piVector.m_data[2]).m_data;
            d4 = 0.0;
            d3 = 0.0;
            double d5 = 0.0;
            int n2 = pgElementSet.getDimOfVertices();
            for (int i = 0; i < n2; ++i) {
                double d6 = dArray2[i] - dArray3[i];
                d4 += d6 * d6;
                double d7 = dArray3[i] - dArray[i];
                d3 += d7 * d7;
                double d8 = dArray[i] - dArray2[i];
                d5 += d8 * d8;
            }
            double d9 = 0.5 * (d4 + d3 + d5);
            m_xx = d9 - d4;
            m_yy = d9 - d3;
            m_zz = d9 - d5;
            m_prevGeom = pgElementSet;
            m_prevElement = n;
        }
        return (d3 = (d2 = pdBaryDir.m_data[0]) * d2 * m_xx + (d = pdBaryDir.m_data[1]) * d * m_yy + (d4 = pdBaryDir.m_data[2]) * d4 * m_zz) > 0.0 ? Math.sqrt(d3) : 0.0;
    }

    public static double getVertexAngles(PgVertexStar pgVertexStar, PgElementSet pgElementSet, PdVector pdVector) {
        PiVector piVector = pgVertexStar.getElement();
        PiVector piVector2 = pgVertexStar.getVertexLocInd();
        int n = piVector.m_data.length;
        if (pdVector == null) {
            pdVector = new PdVector(n);
        } else if (pdVector.m_data == null || pdVector.m_data.length != n) {
            pdVector.setSize(n);
        }
        double d = 0.0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            int n2 = piVector2.m_data[i];
            PwBary.m_tmpEdge1.m_data[n2] = -1.0;
            PwBary.m_tmpEdge1.m_data[(n2 + 1) % 3] = 1.0;
            PwBary.m_tmpEdge1.m_data[(n2 + 2) % 3] = 0.0;
            PwBary.m_tmpEdge2.m_data[n2] = -1.0;
            PwBary.m_tmpEdge2.m_data[(n2 + 1) % 3] = 0.0;
            PwBary.m_tmpEdge2.m_data[(n2 + 2) % 3] = 1.0;
            double d2 = PwBary.scalar(pgElementSet, piVector.m_data[i], m_tmpEdge1, m_tmpEdge2, bl);
            if (bl) {
                bl = false;
            }
            d2 /= PwBary.norm(pgElementSet, piVector.m_data[i], m_tmpEdge1, bl);
            if ((d2 /= PwBary.norm(pgElementSet, piVector.m_data[i], m_tmpEdge2, bl)) > 1.0) {
                d2 = 1.0;
            } else if (d2 < -1.0) {
                d2 = -1.0;
            }
            pdVector.m_data[i] = d2 = Math.acos(d2);
            d += d2;
        }
        return d;
    }

    public static PdBaryDir[] getGeodRepresentation(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return null;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return null;
        }
        if (n2 < 0 || n2 >= 3) {
            PsDebug.warning((String)"Invalid vertex.");
            return null;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        piVector.setSize(pgVertexStar.getElement().getSize());
        piVector.copy(pgVertexStar.getElement());
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[pgVertexStar.getSize()];
        double d = PwBary.norm(pgElementSet, n, pdBaryDir, true);
        if (d < 1.0E-10) {
            for (int i = 0; i < pdBaryDirArray.length; ++i) {
                pdBaryDirArray[i] = new PdBaryDir(0.0, 0.0, 0.0);
            }
            return pdBaryDirArray;
        }
        PdVector pdVector = new PdVector();
        double d2 = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector);
        double d3 = Math.PI * 2 - d2;
        if (!pgVertexStar.isClosed()) {
            d2 = Math.PI * 2;
        }
        int n3 = pgVertexStar.getFirstElemInd();
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        pdBaryDir2.m_data[n2] = 1.0;
        pdBaryDir2.m_data[(n2 + 1) % 3] = 0.0;
        pdBaryDir2.m_data[(n2 + 2) % 3] = -1.0;
        double d4 = PwBary.scalar(pgElementSet, n, pdBaryDir, pdBaryDir2, false);
        d4 /= d;
        double d5 = PwBary.norm(pgElementSet, n, pdBaryDir2, false);
        if (d5 < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated in element set.");
            return null;
        }
        if ((d4 /= d5) > 1.0) {
            d4 = 1.0;
        } else if (d4 < -1.0) {
            d4 = -1.0;
        }
        d4 = Math.acos(d4);
        if (pdBaryDir.m_data[(n2 + 1) % 3] > 0.0) {
            d4 = Math.PI * 2 - d4;
        }
        pdBaryDirArray[n3] = new PdBaryDir(3);
        pdBaryDirArray[n3].copy(pdBaryDir);
        piVector2.setSize(pgVertexStar.getVertexLocInd().getSize());
        piVector2.copy(pgVertexStar.getVertexLocInd());
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        PdBaryDir pdBaryDir4 = new PdBaryDir(3);
        double d6 = 0.0;
        for (int i = n3 + 1; i < n3 + pgVertexStar.getSize(); ++i) {
            int n4 = i % pgVertexStar.getSize();
            if (!pgVertexStar.isClosed() && i == pgVertexStar.getSize()) {
                d6 += d3;
            }
            int n5 = piVector2.m_data[n4];
            pdBaryDir2.m_data[n5] = -1.0;
            pdBaryDir2.m_data[(n5 + 1) % 3] = 1.0;
            pdBaryDir2.m_data[(n5 + 2) % 3] = 0.0;
            d5 = PwBary.norm(pgElementSet, piVector.m_data[n4], pdBaryDir2, false);
            if (d5 < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in element set.");
                return null;
            }
            pdBaryDir2.multScalar(1.0 / d5);
            pdBaryDir4 = new PdBaryDir(3);
            pdBaryDir4.m_data[n5] = -1.0;
            pdBaryDir4.m_data[(n5 + 1) % 3] = 0.0;
            pdBaryDir4.m_data[(n5 + 2) % 3] = 1.0;
            pdBaryDir3 = new PdBaryDir(3);
            pdBaryDir3.copy(pdBaryDir2);
            pdBaryDir3.multScalar(-1.0 * PwBary.scalar(pgElementSet, piVector.m_data[n4], pdBaryDir4, pdBaryDir2, false));
            pdBaryDir3.m_data[0] = pdBaryDir3.m_data[0] + pdBaryDir4.m_data[0];
            pdBaryDir3.m_data[1] = pdBaryDir3.m_data[1] + pdBaryDir4.m_data[1];
            pdBaryDir3.m_data[2] = pdBaryDir3.m_data[2] + pdBaryDir4.m_data[2];
            d5 = PwBary.norm(pgElementSet, piVector.m_data[n4], pdBaryDir3, false);
            if (Math.abs(d5) < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in geometry.");
                return null;
            }
            pdBaryDir3.multScalar(1.0 / d5);
            double d7 = d2 / 2.0 - d6 - d4;
            pdBaryDirArray[n4] = new PdBaryDir(3);
            pdBaryDirArray[n4].copy(pdBaryDir2);
            pdBaryDirArray[n4].multScalar(Math.cos(d7));
            pdBaryDir4.copy(pdBaryDir3);
            pdBaryDir4.multScalar(Math.sin(d7));
            pdBaryDirArray[n4].m_data[0] = pdBaryDirArray[n4].m_data[0] + pdBaryDir4.m_data[0];
            pdBaryDirArray[n4].m_data[1] = pdBaryDirArray[n4].m_data[1] + pdBaryDir4.m_data[1];
            pdBaryDirArray[n4].m_data[2] = pdBaryDirArray[n4].m_data[2] + pdBaryDir4.m_data[2];
            pdBaryDirArray[n4].multScalar(d);
            d6 += pdVector.m_data[n4];
        }
        return pdBaryDirArray;
    }

    public static PdBaryDir[] getTransRepresentation(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return null;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return null;
        }
        if (n2 < 0 || n2 >= 3) {
            PsDebug.warning((String)"Invalid vertex.");
            return null;
        }
        PdVector pdVector = new PdVector(1);
        double d = PwBary.getTransRepresentationValues(pgElementSet, n, pdBaryDir, n2, piVector, piVector2, pdVector);
        double d2 = PwBary.norm(pgElementSet, n, pdBaryDir, false);
        int n3 = piVector.getSize();
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[n3];
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        for (int i = 0; i < n3; ++i) {
            int n4 = piVector.getEntry(i);
            int n5 = piVector2.getEntry(i);
            double d3 = pdVector.getEntry(i);
            pdBaryDir2.m_data[n5] = -1.0;
            pdBaryDir2.m_data[(n5 + 1) % 3] = 1.0;
            pdBaryDir2.m_data[(n5 + 2) % 3] = 0.0;
            pdBaryDir3.m_data[n5] = -1.0;
            pdBaryDir3.m_data[(n5 + 1) % 3] = 0.0;
            pdBaryDir3.m_data[(n5 + 2) % 3] = 1.0;
            double d4 = PwBary.norm(pgElementSet, n4, pdBaryDir2, false);
            if (d4 < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated.");
            } else {
                pdBaryDir2.multScalar(1.0 / d4);
            }
            double d5 = PwBary.getOrientedAngle(pgElementSet, n4, pdBaryDir2, pdBaryDir3, false) / 2.0;
            double d6 = d5 - Math.PI * 2 / d * (d3 + d5);
            pdBaryDirArray[i] = new PdBaryDir(3);
            PwBary.rotateInElement(pgElementSet, n4, pdBaryDir2, d6, pdBaryDirArray[i], false);
            pdBaryDirArray[i].multScalar(d2);
        }
        return pdBaryDirArray;
    }

    public static double getTransRepresentationValues(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2, PdVector pdVector) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return 0.0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return 0.0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return 0.0;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        int n3 = pgVertexStar.getFirstElemInd();
        int n4 = pgVertexStar.getElement().getSize();
        piVector2.setSize(n4);
        piVector.setSize(n4);
        for (int i = 0; i < n4; ++i) {
            piVector.setEntry(i, pgVertexStar.getElement().getEntry((i + n3) % n4));
            piVector2.setEntry(i, pgVertexStar.getVertexLocInd().getEntry((i + n3) % n4));
        }
        PdVector pdVector2 = new PdVector();
        double d = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector2);
        double d2 = Math.PI * 2 - d;
        if (!pgVertexStar.isClosed()) {
            d = Math.PI * 2;
        }
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        pdBaryDir2.m_data[n2] = -1.0;
        pdBaryDir2.m_data[(n2 + 1) % 3] = 0.0;
        pdBaryDir2.m_data[(n2 + 2) % 3] = 1.0;
        double d3 = 0.0;
        double d4 = PwBary.norm(pgElementSet, n, pdBaryDir, true);
        if (d4 >= 1.0E-10) {
            d3 = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir, pdBaryDir2, false);
        }
        pdVector.setSize(n4);
        pdVector.setEntry(0, d - pdVector2.m_data[n3] + d3);
        for (int i = n3 + 1; i < n3 + pgVertexStar.getSize(); ++i) {
            int n5 = i % pgVertexStar.getSize();
            if (!pgVertexStar.isClosed() && i == pgVertexStar.getSize()) {
                d3 += d2;
            }
            pdVector.setEntry(i - n3, d3);
            d3 += pdVector2.m_data[n5];
        }
        return d;
    }

    public static PdBaryDir[] getProjRepresentation(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2) {
        int n3;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return null;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return null;
        }
        if (n2 < 0 || n2 >= 3) {
            PsDebug.warning((String)"Invalid vertex.");
            return null;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        int n4 = pgVertexStar.getFirstElemInd();
        piVector.setSize(pgVertexStar.getElement().getSize());
        piVector.copy(pgVertexStar.getElement());
        piVector2.setSize(pgVertexStar.getVertexLocInd().getSize());
        piVector2.copy(pgVertexStar.getVertexLocInd());
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[pgVertexStar.getSize()];
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n5 = pgElementSet.getDimOfVertices();
        PdVector pdVector = new PdVector(n5);
        for (n3 = 0; n3 < n5; ++n3) {
            pdVector.m_data[n3] = 0.0;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (int i = 0; i < 3; ++i) {
                int n6 = n3;
                pdVector.m_data[n6] = pdVector.m_data[n6] + pdBaryDir.m_data[i] * pdVectorArray[piVectorArray[n].m_data[i]].m_data[n3];
            }
        }
        for (n3 = 0; n3 < pdBaryDirArray.length; ++n3) {
            if (n3 == n4) {
                pdBaryDirArray[n3] = new PdBaryDir(3);
                pdBaryDirArray[n3].copy(pdBaryDir);
                continue;
            }
            pdBaryDirArray[n3] = new PdBaryDir(3);
            PwBary.projectOntoElement(pgElementSet, piVector.m_data[n3], pdVector, pdBaryDirArray[n3]);
        }
        return pdBaryDirArray;
    }

    public static boolean projectOntoElement(PgElementSet pgElementSet, int n, PdVector pdVector, PdBaryDir pdBaryDir) {
        double d;
        int n2;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning((String)"Missing vector.");
            return false;
        }
        if (pdBaryDir == null) {
            PsDebug.warning((String)"Missing output variable.");
            return false;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n3 = pgElementSet.getDimOfVertices();
        if (m_projVert == null) {
            m_projVert = new PdVector[3];
            for (n2 = 0; n2 < 3; ++n2) {
                PwBary.m_projVert[n2] = new PdVector(n3);
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            m_projVert[n2].setSize(pdVectorArray[piVectorArray[n].m_data[n2]].getSize());
            m_projVert[n2].copy(pdVectorArray[piVectorArray[n].m_data[n2]]);
        }
        m_projVert[1].sub(m_projVert[0]);
        m_projVert[2].sub(m_projVert[0]);
        m_projN.setSize(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            PwBary.m_projN.m_data[n2] = 0.0;
        }
        if (n3 == 3) {
            m_projN.cross(m_projVert[1], m_projVert[2]);
            double d2 = m_projN.length();
            if (d2 < 1.0E-10) {
                PsDebug.warning((String)errormsg);
                return false;
            }
            m_projN.multScalar(1.0 / d2);
            d = PdVector.dot((PdVector)m_projN, (PdVector)pdVector);
            m_projN.multScalar(-d);
            m_projN.add(pdVector);
        } else if (n3 < 3) {
            m_projN.copy(pdVector);
        }
        double d3 = m_projVert[1].sqrLength();
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)errormsg);
            return false;
        }
        d = PdVector.dot((PdVector)m_projN, (PdVector)m_projVert[1]) / d3;
        double d4 = PdVector.dot((PdVector)m_projVert[2], (PdVector)m_projVert[1]) / d3;
        m_projVert[1].multScalar(-d4);
        m_projVert[2].add(m_projVert[1]);
        d3 = m_projVert[2].sqrLength();
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)errormsg);
            return false;
        }
        double d5 = PdVector.dot((PdVector)m_projN, (PdVector)m_projVert[2]) / d3;
        pdBaryDir.setSize(3);
        pdBaryDir.setElementInd(n);
        pdBaryDir.m_data[0] = -d - d5 + d5 * d4;
        pdBaryDir.m_data[1] = d - d5 * d4;
        pdBaryDir.m_data[2] = d5;
        return true;
    }

    public static PdBary projectOntoElement(PgElementSet pgElementSet, int n, PdVector pdVector, PdBary pdBary) {
        return PwBary.projectOntoElement(pgElementSet, n, pdVector, pgElementSet.getElementNormal(n), pdBary);
    }

    public static PdBary projectOntoElement(PgElementSet pgElementSet, int n, PdVector pdVector, PdVector pdVector2, PdBary pdBary) {
        PiVector piVector = pgElementSet.getElement(n);
        if (piVector.getSize() != 3) {
            PsDebug.warning((String)"Dimension of element must be 3.");
            return null;
        }
        if (pdBary == null) {
            pdBary = new PdBary(3);
        } else {
            pdBary.setSize(3);
        }
        int n2 = pgElementSet.getDimOfVertices();
        for (int i = 0; i < 3; ++i) {
            PdVector pdVector3 = pgElementSet.getVertex(piVector.m_data[(i + 1) % 3]);
            PdVector pdVector4 = pgElementSet.getVertex(piVector.m_data[(i + 2) % 3]);
            pdBary.m_data[i] = 0.0;
            for (int j = 0; j < n2; ++j) {
                int n3 = i;
                pdBary.m_data[n3] = pdBary.m_data[n3] + (pdVector.m_data[j] - pdVector3.m_data[j]) * (pdVector2.m_data[(j + 1) % 3] * (pdVector4.m_data[(j + 2) % 3] - pdVector3.m_data[(j + 2) % 3]) - pdVector2.m_data[(j + 2) % 3] * (pdVector4.m_data[(j + 1) % 3] - pdVector3.m_data[(j + 1) % 3]));
            }
        }
        double d = pdBary.m_data[0] + pdBary.m_data[1] + pdBary.m_data[2];
        if (d <= 1.0E-10 && d >= -1.0E-10) {
            return null;
        }
        int n4 = 0;
        while (n4 < 3) {
            int n5 = n4++;
            pdBary.m_data[n5] = pdBary.m_data[n5] / d;
        }
        pdBary.setElementInd(n);
        return pdBary;
    }

    public static void projectOntoElementEdge(PgElementSet pgElementSet, PdBary pdBary, int n) {
        int n2 = n;
        int n3 = (n + 1) % 3;
        int n4 = (n + 2) % 3;
        PiVector piVector = pgElementSet.getElement(pdBary.getElementInd());
        PdVector pdVector = pgElementSet.getVertex(piVector.m_data[n2]);
        PdVector pdVector2 = pgElementSet.getVertex(piVector.m_data[n3]);
        PdVector pdVector3 = pgElementSet.getVertex(piVector.m_data[n4]);
        double d = pdBary.m_data[n2] * PdVector.dot((PdVector)pdVector2, (PdVector)pdVector3, (PdVector)pdVector) + pdBary.m_data[n4] * PdVector.dot((PdVector)pdVector2, (PdVector)pdVector3, (PdVector)pdVector3);
        double d2 = PdVector.sqrDist((PdVector)pdVector2, (PdVector)pdVector3);
        if (d2 <= 1.0E-10) {
            PsDebug.warning((String)"Degenerated triangle");
            return;
        }
        pdBary.m_data[n2] = 0.0;
        pdBary.m_data[n3] = 1.0 - (d /= d2);
        pdBary.m_data[n4] = d;
    }

    public static void projectToInside(PgElementSet pgElementSet, PdBary pdBary) {
        int n;
        int n2 = 2;
        while (pdBary.m_data[n2] >= 0.0) {
            --n2;
        }
        for (n = n2 - 1; n != -1 && pdBary.m_data[n] >= 0.0; --n) {
        }
        PwBary.projectOntoElementEdge(pgElementSet, pdBary, n2);
        pdBary.projectToInside();
        int n3 = PwBary.liesOnVertex(pdBary);
        if (n != -1 && n3 != -1 && n3 != n2 && n3 != n) {
            PwBary.projectOntoElementEdge(pgElementSet, pdBary, n);
            pdBary.projectToInside();
        }
    }

    public static void projectOntoElementEdge(int n, PdBary pdBary) {
        pdBary.m_data[n] = 0.0;
        int n2 = (n + 1) % 3;
        int n3 = (n + 2) % 3;
        double d = 1.0 / (pdBary.m_data[n2] + pdBary.m_data[n3]);
        int n4 = n2;
        pdBary.m_data[n4] = pdBary.m_data[n4] * d;
        int n5 = n3;
        pdBary.m_data[n5] = pdBary.m_data[n5] * d;
        if (pdBary.m_data[n2] < 0.0) {
            pdBary.m_data[n2] = 0.0;
            pdBary.m_data[n3] = 1.0;
        } else if (pdBary.m_data[n3] < 0.0) {
            pdBary.m_data[n3] = 0.0;
            pdBary.m_data[n2] = 1.0;
        }
        pdBary.projectToInside();
    }

    public static PdBary projectOntoElementSet(PgElementSet pgElementSet, PdVector pdVector, PdBary pdBary) {
        if (pdBary == null) {
            pdBary = new PdBary(3);
        } else {
            pdBary.setSize(3);
        }
        int n = pgElementSet.getNumElements();
        double d = Double.POSITIVE_INFINITY;
        PdBary pdBary2 = new PdBary(3);
        PdVector pdVector2 = new PdVector(3);
        for (int i = 0; i < n; ++i) {
            double d2 = Math.abs(PuVectorGeom.distOfPointToPlane((PdVector)pdVector, (PdVector)pgElementSet.getVertex(pgElementSet.getElement((int)i).m_data[0]), (PdVector)pgElementSet.getElementNormal(i)));
            if (d2 >= d) continue;
            PwBary.projectOntoElement(pgElementSet, i, pdVector, pdBary2);
            if (!pdBary2.isInside()) {
                pdBary2.projectToInside();
                PdVector pdVector3 = pgElementSet.getVertex(pgElementSet.getElement((int)i).m_data[0]);
                PdVector pdVector4 = pgElementSet.getVertex(pgElementSet.getElement((int)i).m_data[1]);
                PdVector pdVector5 = pgElementSet.getVertex(pgElementSet.getElement((int)i).m_data[2]);
                pdBary2.getVertex(pdVector2, pdVector3, pdVector4, pdVector5);
                d2 = pdVector2.dist(pdVector);
            }
            if (!(d2 < d)) continue;
            d = d2;
            pdBary.copy(pdBary2);
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return pdBary;
    }

    public static double projectOntoPolygon(PdVector pdVector, PgPolygon pgPolygon, PdBary pdBary) {
        int n = pgPolygon.getNumEdges();
        int n2 = pgPolygon.getNumVertices();
        double d = Double.MAX_VALUE;
        PdBary pdBary2 = new PdBary(2);
        PdVector pdVector2 = new PdVector(3);
        for (int i = 0; i < n; ++i) {
            int n3 = (i + 1) % n2;
            PdVector pdVector3 = pgPolygon.getVertex(i);
            PdVector pdVector4 = pgPolygon.getVertex(n3);
            PdBary.getBary((PdBary)pdBary2, (PdVector)pdVector, (PdVector)pdVector3, (PdVector)pdVector4);
            pdBary2.projectToInside();
            pdBary2.getVertex(pdVector2, pdVector3, pdVector4);
            double d2 = pdVector2.sqrDist(pdVector);
            if (!(d2 < d)) continue;
            d = d2;
            pdBary.copy(pdBary2);
            pdBary.setElementInd(i);
        }
        return d;
    }

    public static double getOrientedAngle(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, PdBaryDir pdBaryDir2, boolean bl) {
        double d;
        double d2 = Double.NEGATIVE_INFINITY;
        PwBary.m_angleEdge.m_data[0] = 0.0;
        PwBary.m_angleEdge.m_data[1] = -1.0;
        PwBary.m_angleEdge.m_data[2] = 1.0;
        double d3 = PwBary.norm(pgElementSet, n, m_angleEdge, bl);
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated.");
            return d2;
        }
        m_angleEdge.multScalar(1.0 / d3);
        PwBary.m_angleVectors[0] = pdBaryDir;
        PwBary.m_angleVectors[1] = pdBaryDir2;
        for (int i = 0; i < 2; ++i) {
            PwBary.m_angleOriented[i] = PwBary.scalar(pgElementSet, n, m_angleVectors[i], m_angleEdge, false);
            double d4 = PwBary.norm(pgElementSet, n, m_angleVectors[i], false);
            if (d4 < 1.0E-10) {
                PsDebug.warning((String)("Vector degenerated no." + i + "."));
                if (m_angleVectors[i] != null) {
                    PsDebug.warning((String)m_angleVectors[i].toShortString());
                }
                return d2;
            }
            int n2 = i;
            m_angleOriented[n2] = m_angleOriented[n2] / d4;
            if (m_angleOriented[i] > 1.0) {
                PwBary.m_angleOriented[i] = 1.0;
            } else if (m_angleOriented[i] < -1.0) {
                PwBary.m_angleOriented[i] = -1.0;
            }
            PwBary.m_angleOriented[i] = Math.acos(m_angleOriented[i]);
            if (!(PwBary.m_angleVectors[i].m_data[0] < 0.0)) continue;
            int n3 = i;
            m_angleOriented[n3] = m_angleOriented[n3] * -1.0;
        }
        for (d = m_angleOriented[1] - m_angleOriented[0]; d > Math.PI; d -= Math.PI * 2) {
        }
        while (d < -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    public static double getOrientedAngleAtVertex(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, int n3, PdBaryDir pdBaryDir2, int n4, boolean bl) {
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n5 = pgElementSet.getElement(n).getEntry(n2);
        pgVertexStar.makeVertexStar(pgElementSet, n5, n);
        int n6 = pgVertexStar.getSize();
        PiVector piVector = pgVertexStar.getElement();
        int n7 = 0;
        boolean bl2 = false;
        if (!pgVertexStar.isClosed()) {
            int n8 = -1;
            int n9 = -1;
            for (int i = 0; i < n6; ++i) {
                n7 = piVector.getEntry(i);
                if (n7 == n) {
                    n8 = i;
                    continue;
                }
                if (n7 != n3) continue;
                n9 = i;
            }
            if (n8 == -1 || n9 == -1) {
                PsDebug.warning((String)"wrong elem indices");
                return 0.0;
            }
            if (n9 < n8) {
                bl2 = true;
                PdBaryDir pdBaryDir3 = pdBaryDir;
                pdBaryDir = pdBaryDir2;
                pdBaryDir2 = pdBaryDir3;
                n7 = n;
                n = n3;
                n3 = n7;
                n7 = n2;
                n2 = n4;
                n4 = n7;
                n7 = n9;
            } else {
                n7 = n8;
            }
        }
        PdVector pdVector = new PdVector();
        double d = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector);
        double d2 = 0.0;
        PdBaryDir pdBaryDir4 = new PdBaryDir(3);
        pdBaryDir4.copy(PdBaryDir.TRIANGLE_EDGE[(n2 + 1) % 3]);
        pdBaryDir4.multScalar(-1.0);
        double d3 = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir, pdBaryDir4, bl);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        d2 += d3;
        ++n7;
        while (n7 < n6 && piVector.getEntry(n7) != n3) {
            d2 += pdVector.getEntry(n7);
            ++n7;
        }
        d3 = PwBary.getOrientedAngle(pgElementSet, n3, PdBaryDir.TRIANGLE_EDGE[(n4 + 2) % 3], pdBaryDir2, false);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        d2 += d3;
        d2 = bl2 ? -d2 : (d2 *= Math.PI * 2 / d);
        return d2;
    }

    public static double getOrientedAngleAtEdge(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, int n3, PdBaryDir pdBaryDir2, int n4, boolean bl) {
        double d = 0.0;
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        pdBaryDir3.copy(PdBaryDir.TRIANGLE_EDGE[n2]);
        pdBaryDir3.multScalar(-1.0);
        double d2 = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir, pdBaryDir3, bl);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        d += d2;
        d2 = PwBary.getOrientedAngle(pgElementSet, n3, PdBaryDir.TRIANGLE_EDGE[n4], pdBaryDir2, false);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d += d2;
    }

    public static void rotateInElement(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, double d, PdBaryDir pdBaryDir2, boolean bl) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Wrong element index=" + n));
            return;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Wrong direction");
            return;
        }
        if (pdBaryDir2 == null) {
            PsDebug.warning((String)"Missing output parameter");
            return;
        }
        int n2 = -1;
        double d2 = 1.0;
        for (int i = 0; i < 3; ++i) {
            if (!(pdBaryDir.m_data[i] < d2)) continue;
            n2 = i;
            d2 = pdBaryDir.m_data[i];
        }
        double d3 = PwBary.norm(pgElementSet, n, pdBaryDir, bl);
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)"Direction degenerated.");
            return;
        }
        m_tmpEdge3.copyArray(pdBaryDir);
        pdBaryDir2.setSize(3);
        pdBaryDir2.copyArray(PdBaryDir.TRIANGLE_EDGE[n2]);
        m_tmpEdge3.multScalar(1.0 / d3);
        m_tmpEdge4.copyArray(m_tmpEdge3);
        m_tmpEdge4.multScalar(-PwBary.scalar(pgElementSet, n, m_tmpEdge3, pdBaryDir2, false));
        for (int i = 0; i < 3; ++i) {
            int n3 = i;
            pdBaryDir2.m_data[n3] = pdBaryDir2.m_data[n3] + PwBary.m_tmpEdge4.m_data[i];
        }
        double d4 = PwBary.norm(pgElementSet, n, pdBaryDir2, false);
        if (d4 < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated.");
            return;
        }
        pdBaryDir2.multScalar(1.0 / d4);
        m_tmpEdge3.multScalar(Math.cos(d));
        pdBaryDir2.multScalar(Math.sin(d));
        for (int i = 0; i < 3; ++i) {
            int n4 = i;
            pdBaryDir2.m_data[n4] = pdBaryDir2.m_data[n4] + PwBary.m_tmpEdge3.m_data[i];
        }
        pdBaryDir2.multScalar(d3);
    }

    public static int rotateAtVertex(PgElementSet pgElementSet, int n, int n2, PdBaryDir pdBaryDir, PdBaryDir pdBaryDir2, PdBary pdBary, double d) {
        double d2;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return 0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Wrong element index=" + n));
            return 0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Wrong direction");
            return 0;
        }
        if (pdBaryDir2 == null) {
            PsDebug.warning((String)"Missing output parameter");
            return 0;
        }
        m_rotVertStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        double d3 = PwBary.getVertexAngles(m_rotVertStar, pgElementSet, m_rotVertAngles);
        double d4 = !m_rotVertStar.isClosed() ? Math.PI * 2 : d3;
        for (d2 = d; d2 < 0.0; d2 += Math.PI * 2) {
        }
        double d5 = d4 / 2.0 / Math.PI * d2;
        int n3 = m_rotVertStar.getFirstElemInd();
        int n4 = PwBary.m_rotVertStar.getVertexLocInd().m_data[n3];
        int n5 = PwBary.m_rotVertStar.getElement().m_data[n3];
        PwBary.m_rotVertEdge.m_data[n4] = -1.0;
        PwBary.m_rotVertEdge.m_data[(n4 + 1) % 3] = 0.0;
        PwBary.m_rotVertEdge.m_data[(n4 + 2) % 3] = 1.0;
        double d6 = PwBary.norm(pgElementSet, n5, pdBaryDir, false);
        double d7 = PwBary.scalar(pgElementSet, n5, m_rotVertEdge, pdBaryDir, false);
        double d8 = PwBary.norm(pgElementSet, n5, m_rotVertEdge, false);
        if (Math.abs(d8) < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated in geometry.");
            return -1;
        }
        if (Math.abs(d6) < 1.0E-10) {
            PsDebug.warning((String)"Dir degenerated.");
            return -1;
        }
        d7 /= d8;
        if ((d7 /= d6) < -1.0) {
            d7 = -1.0;
        } else if (d7 > 1.0) {
            d7 = 1.0;
        }
        d7 = Math.acos(d7);
        double d9 = 0.0;
        while (d7 + d9 < d5 - 1.0E-6) {
            if (!m_rotVertStar.isClosed() && ++n3 % PwBary.m_rotVertAngles.m_data.length == 0 && n3 > 0) {
                d7 = Math.PI * 2 - d3;
                if (d7 + (d9 += d7) >= d5 + 1.0E-6) {
                    return -1;
                }
                d7 = Math.min(d7, d5 - d9);
            }
            d9 += d7;
            d7 = PwBary.m_rotVertAngles.m_data[n3 % PwBary.m_rotVertAngles.m_data.length];
        }
        if (d7 + d9 < d5) {
            d5 = d7 + d9;
        }
        int n6 = PwBary.m_rotVertStar.getVertexLocInd().m_data[n3 % m_rotVertStar.getSize()];
        n5 = PwBary.m_rotVertStar.getElement().m_data[n3 % PwBary.m_rotVertAngles.m_data.length];
        if (n3 == m_rotVertStar.getFirstElemInd()) {
            pdBaryDir2.setSize(3);
            PwBary.rotateInElement(pgElementSet, n5, pdBaryDir, d5 - d9, pdBaryDir2, false);
        } else {
            int n7;
            PwBary.m_rotVertEdge.m_data[n6] = -1.0;
            PwBary.m_rotVertEdge.m_data[(n6 + 1) % 3] = 1.0;
            PwBary.m_rotVertEdge.m_data[(n6 + 2) % 3] = 0.0;
            d8 = PwBary.norm(pgElementSet, n5, m_rotVertEdge, false);
            if (Math.abs(d8) < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in geometry.");
                return -1;
            }
            m_rotVertEdge.multScalar(1.0 / d8);
            PwBary.m_rotVertHalf.m_data[n6] = -1.0;
            PwBary.m_rotVertHalf.m_data[(n6 + 1) % 3] = 0.0;
            PwBary.m_rotVertHalf.m_data[(n6 + 2) % 3] = 1.0;
            m_rotVertNormal.copy(m_rotVertEdge);
            m_rotVertNormal.multScalar(-1.0 * PwBary.scalar(pgElementSet, n5, m_rotVertHalf, m_rotVertEdge, false));
            for (n7 = 0; n7 < 3; ++n7) {
                int n8 = n7;
                PwBary.m_rotVertNormal.m_data[n8] = PwBary.m_rotVertNormal.m_data[n8] + PwBary.m_rotVertHalf.m_data[n7];
            }
            d8 = PwBary.norm(pgElementSet, n5, m_rotVertNormal, false);
            if (Math.abs(d8) < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in geometry.");
                return -1;
            }
            m_rotVertNormal.multScalar(1.0 / d8);
            pdBaryDir2.copy(m_rotVertEdge);
            pdBaryDir2.multScalar(Math.cos(d5 - d9));
            m_rotVertHalf.copy(m_rotVertNormal);
            m_rotVertHalf.multScalar(Math.sin(d5 - d9));
            for (n7 = 0; n7 < 3; ++n7) {
                int n9 = n7;
                pdBaryDir2.m_data[n9] = pdBaryDir2.m_data[n9] + PwBary.m_rotVertHalf.m_data[n7];
            }
            pdBaryDir2.multScalar(d6);
        }
        pdBary.m_data[n6] = 1.0;
        pdBary.m_data[(n6 + 1) % 3] = 0.0;
        pdBary.m_data[(n6 + 2) % 3] = 0.0;
        return n5;
    }

    public static int rotateAtEdge(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PdBaryDir pdBaryDir2, PdBary pdBary, double d, boolean bl) {
        double d2;
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        while (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        pdBaryDir3.copy(PdBaryDir.TRIANGLE_EDGE[n2]);
        pdBaryDir3.multScalar(-1.0);
        double d3 = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir, pdBaryDir3, bl);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        if ((d2 = d - d3) > 0.0 && d2 < Math.PI) {
            d -= d3;
            int n3 = pgElementSet.getNeighbour(n).getEntry(n2);
            if (n3 == -1) {
                return -1;
            }
            int n4 = pgElementSet.getOppVertexLocInd(n, n2);
            PwBary.rotateInElement(pgElementSet, n3, PdBaryDir.TRIANGLE_EDGE[n4], d, pdBaryDir2, false);
            double d4 = PwBary.norm(pgElementSet, n3, pdBaryDir2, false);
            if (d4 < 1.0E-10) {
                PsDebug.warning((String)"degenerated edges");
                return -1;
            }
            pdBaryDir2.multScalar(1.0 / d4);
            d4 = PwBary.norm(pgElementSet, n, pdBaryDir, false);
            pdBaryDir2.multScalar(d4);
            PwBary.changeBarycentricOnEdge(pdBary, n2, n4);
            return n3;
        }
        PwBary.rotateInElement(pgElementSet, n, pdBaryDir, d, pdBaryDir2, false);
        return n;
    }

    public static boolean showsIntoElement(PdBaryDir pdBaryDir, int n) {
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"wrong direction");
            return false;
        }
        return pdBaryDir.m_data[n] <= 0.0 && pdBaryDir.m_data[(n + 1) % 3] >= 0.0 && pdBaryDir.m_data[(n + 2) % 3] >= 0.0;
    }

    public static int liesOnVertex(PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"missing bary position");
            return -1;
        }
        int n = pdBary.getSize();
        int n2 = 0;
        int n3 = -1;
        for (int i = n - 1; i >= 0; --i) {
            if (pdBary.m_data[i] > 1.0E-10 || pdBary.m_data[i] < -1.0E-10) {
                n3 = i;
                continue;
            }
            ++n2;
        }
        return n2 == n - 1 ? n3 : -1;
    }

    public static int liesOnEdge(PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"missing bary position");
            return -1;
        }
        int n = pdBary.getSize();
        int n2 = 0;
        int n3 = -1;
        for (int i = n - 1; i >= 0; --i) {
            if (!(Math.abs(pdBary.m_data[i]) < 1.0E-10)) continue;
            n3 = i;
            ++n2;
        }
        return n2 == 1 ? n3 : -1;
    }

    public static double computeLambda(PdBary pdBary, PdBaryDir pdBaryDir) {
        int n = pdBary.getSize();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double d2;
            if (!(pdBaryDir.m_data[i] < 0.0) || !((d2 = -pdBary.m_data[i] / pdBaryDir.m_data[i]) >= -1.0E-10) || !(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static int getEdgeIndex(PdBary pdBary) {
        int n = -1;
        int n2 = pdBary.getSize();
        for (int i = 0; i < n2; ++i) {
            if (!(pdBary.m_data[i] < 1.0E-10) || !(pdBary.m_data[i] > -1.0E-10)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static PdBaryDir[] computeNormals(PgPolygonOnElementSet pgPolygonOnElementSet, PdBaryDir[] pdBaryDirArray, PiVector piVector) {
        int n;
        int n2;
        int n3;
        double d;
        int n4 = pgPolygonOnElementSet.getNumVertices();
        if (pdBaryDirArray == null || pdBaryDirArray.length != n4) {
            pdBaryDirArray = new PdBaryDir[n4];
            for (int i = 0; i < n4; ++i) {
                pdBaryDirArray[i] = new PdBaryDir(3);
            }
        }
        if (piVector == null) {
            piVector = new PiVector(n4);
        } else if (piVector.getSize() != n4) {
            piVector.setSize(n4);
        }
        if (n4 < 2) {
            if (n4 == 1) {
                pdBaryDirArray[0].setZero();
            }
            return pdBaryDirArray;
        }
        PgElementSet pgElementSet = pgPolygonOnElementSet.getGeometry();
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        PdBary pdBary3 = new PdBary(3);
        PdBary pdBary4 = new PdBary(3);
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        int n5 = n4 - 1;
        int n6 = 0;
        do {
            n3 = PwBary.equalizeElementIndex(pgPolygonOnElementSet, 0, ++n6, pdBary, pdBary2);
            pdBaryDir.sub(pdBary2, pdBary);
            if (n3 == -1) {
                PsDebug.warning((String)"vertices must have common elements - wrong PgPolygonOnElementSet");
                return null;
            }
            d = PwBary.norm(pgElementSet, n3, pdBaryDir, n6 == 1);
        } while (n6 < n4 - 1 && d < 1.0E-10);
        if (d < 1.0E-10) {
            PsDebug.warning((String)"polygon is degenerated to point");
            return null;
        }
        int n7 = PwBary.liesOnVertex(pdBary);
        if (n7 != -1) {
            n2 = PwBary.rotateAtVertex(pgElementSet, n3, n7, pdBaryDir, pdBaryDirArray[0], pdBary, 1.5707963267948966);
            if (n2 < 0) {
                PwBary.rotateInElement(pgElementSet, n3, pdBaryDir, 1.5707963267948966, pdBaryDirArray[0], true);
                n2 = n3;
            }
            piVector.setEntry(0, n2);
        } else {
            n7 = PwBary.getEdgeIndex(pdBary);
            if (n7 != -1) {
                n2 = PwBary.rotateAtEdge(pgElementSet, n3, pdBaryDir, n7, pdBaryDirArray[0], pdBary, 1.5707963267948966, true);
                if (n2 < 0) {
                    PwBary.rotateInElement(pgElementSet, n3, pdBaryDir, 1.5707963267948966, pdBaryDirArray[0], false);
                    n2 = n3;
                }
                piVector.setEntry(0, n2);
            } else {
                PwBary.rotateInElement(pgElementSet, n3, pdBaryDir, 1.5707963267948966, pdBaryDirArray[0], true);
                piVector.setEntry(0, n3);
            }
        }
        for (n = 1; n < n6; ++n) {
            piVector.setEntry(n, piVector.getEntry(0));
            pdBaryDirArray[n].copy(pdBaryDirArray[0]);
        }
        for (n = n6; n < n4 - 1; ++n) {
            double d2;
            n6 = n;
            do {
                n3 = PwBary.equalizeElementIndex(pgPolygonOnElementSet, n, ++n6, pdBary, pdBary2);
                pdBaryDir.sub(pdBary2, pdBary);
                if (n3 == -1) {
                    PsDebug.warning((String)"vertices must have common elements - wrong PgPolygonOnElementSet");
                    return null;
                }
                d = PwBary.norm(pgElementSet, n3, pdBaryDir, n6 == 1);
            } while (n6 < n4 - 1 && d < 1.0E-10);
            if (d < 1.0E-10) {
                n5 = n;
                break;
            }
            int n8 = PwBary.equalizeElementIndex(pgPolygonOnElementSet, n, n - 1, pdBary3, pdBary4);
            pdBaryDir2.sub(pdBary4, pdBary3);
            if (n8 == -1) {
                PsDebug.warning((String)"vertices must have common elements - wrong PgPolygonOnElementSet");
                return null;
            }
            n7 = PwBary.liesOnVertex(pdBary);
            if (n7 != -1) {
                d2 = PwBary.getOrientedAngleAtVertex(pgElementSet, n3, pdBaryDir, n7, n8, pdBaryDir2, PwBary.liesOnVertex(pdBary3), false);
                n2 = PwBary.rotateAtVertex(pgElementSet, n3, n7, pdBaryDir, pdBaryDirArray[n], pdBary, d2 / 2.0);
                if (n2 < 0) {
                    PwBary.rotateInElement(pgElementSet, n3, pdBaryDir, d2 / 2.0, pdBaryDirArray[n], false);
                    n2 = n3;
                }
                piVector.setEntry(n, n2);
            } else {
                n7 = PwBary.getEdgeIndex(pdBary);
                if (n7 != -1) {
                    d2 = PwBary.getOrientedAngleAtEdge(pgElementSet, n3, pdBaryDir, n7, n8, pdBaryDir2, PwBary.getEdgeIndex(pdBary3), false);
                    n2 = PwBary.rotateAtEdge(pgElementSet, n3, pdBaryDir, n7, pdBaryDirArray[n], pdBary, d2 / 2.0, false);
                    if (n2 < 0) {
                        PwBary.rotateInElement(pgElementSet, n3, pdBaryDir, d2 / 2.0, pdBaryDirArray[n], false);
                        n2 = n3;
                    }
                    piVector.setEntry(n, n2);
                } else {
                    d2 = PwBary.getOrientedAngle(pgElementSet, n3, pdBaryDir, pdBaryDir2, false);
                    if (d2 < 0.0) {
                        d2 += Math.PI * 2;
                    }
                    PwBary.rotateInElement(pgElementSet, n3, pdBaryDir, d2 / 2.0, pdBaryDirArray[n], false);
                    piVector.setEntry(n, n3);
                }
            }
            for (int i = n + 1; i < n6; ++i) {
                piVector.setEntry(i, piVector.getEntry(n));
                pdBaryDirArray[i].copy(pdBaryDirArray[n]);
            }
            n = n6 - 1;
        }
        n3 = PwBary.equalizeElementIndex(pgPolygonOnElementSet, n5, n5 - 1, pdBary, pdBary2);
        pdBaryDir.sub(pdBary2, pdBary);
        if (n3 == -1) {
            PsDebug.warning((String)"vertices must have common elements - wrong PgPolygonOnElementSet");
            return null;
        }
        n7 = PwBary.liesOnVertex(pdBary);
        if (n7 != -1) {
            n2 = PwBary.rotateAtVertex(pgElementSet, n3, n7, pdBaryDir, pdBaryDirArray[n5], pdBary, -1.5707963267948966);
            if (n2 < 0) {
                PwBary.rotateInElement(pgElementSet, n3, pdBaryDir, -1.5707963267948966, pdBaryDirArray[n5], false);
                n2 = n3;
            }
            piVector.setEntry(n5, n2);
        } else {
            n7 = PwBary.getEdgeIndex(pdBary);
            if (n7 != -1) {
                n2 = PwBary.rotateAtEdge(pgElementSet, n3, pdBaryDir, n7, pdBaryDirArray[n5], pdBary, -1.5707963267948966, false);
                if (n2 < 0) {
                    PwBary.rotateInElement(pgElementSet, n3, pdBaryDir, -1.5707963267948966, pdBaryDirArray[n5], false);
                    n2 = n3;
                }
                piVector.setEntry(n5, n2);
            } else {
                PwBary.rotateInElement(pgElementSet, n3, pdBaryDir, -1.5707963267948966, pdBaryDirArray[n5], false);
                piVector.setEntry(n5, n3);
            }
        }
        for (n = n5 + 1; n < n4; ++n) {
            piVector.setEntry(n, piVector.getEntry(n5));
            pdBaryDirArray[n].copy(pdBaryDirArray[n5]);
        }
        for (n = 0; n < n4; ++n) {
            d = PwBary.norm(pgElementSet, piVector.getEntry(n), pdBaryDirArray[n], false);
            if (d < 1.0E-10) {
                PsDebug.warning((String)("degenerated normal at position " + n));
                continue;
            }
            pdBaryDirArray[n].multScalar(1.0 / d);
        }
        return pdBaryDirArray;
    }

    public static void translatePolygonOnElementSet(PgPolygonOnElementSet pgPolygonOnElementSet, PdBaryDir[] pdBaryDirArray, PiVector piVector, PdVector pdVector) {
        PgElementSet pgElementSet = pgPolygonOnElementSet.getGeometry();
        PnStraightestGeodesic pnStraightestGeodesic = new PnStraightestGeodesic(pgElementSet, false);
        int n = pgPolygonOnElementSet.getNumVertices();
        PdBary[] pdBaryArray = pgPolygonOnElementSet.getVertexBary();
        PdBary pdBary = new PdBary(3);
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        for (int i = 0; i < n; ++i) {
            int n2 = piVector.getEntry(i);
            PdBary pdBary2 = pdBaryArray[i];
            if (n2 != pdBaryArray[i].m_elementInd) {
                pdBary2 = pdBary;
                if (n2 < 0) continue;
                if (!PwBary.transformBary(pgElementSet, pdBaryArray[i].m_elementInd, pdBaryArray[i], n2, pdBary2)) {
                    PsDebug.warning((String)"incompatible vector field and polygon");
                    return;
                }
            }
            pdBaryDir.multScalar(pdBaryDirArray[i], pdVector.getEntry(i));
            pnStraightestGeodesic.eval(pdBary2, pdBaryDir, pdBaryArray[i]);
        }
    }

    public static boolean transformBary(PgElementSet pgElementSet, int n, PdBary pdBary, int n2, PdBary pdBary2) {
        if (n2 < 0) {
            return false;
        }
        int n3 = PwBary.liesOnVertex(pdBary);
        if (n3 != -1) {
            int n4 = pgElementSet.getElement(n).getEntry(n3);
            PiVector piVector = pgElementSet.getElement(n2);
            if (piVector == null) {
                return false;
            }
            n3 = -1;
            for (int i = piVector.getSize() - 1; i >= 0; --i) {
                if (piVector.getEntry(i) != n4) continue;
                n3 = i;
                break;
            }
            if (n3 == -1) {
                return false;
            }
            pdBary2.copy(PdBary.TRIANGLE_VERTEX[n3]);
        } else {
            n3 = PwBary.getEdgeIndex(pdBary);
            if (n3 != -1) {
                int n5 = pgElementSet.getNeighbour(n).getEntry(n3);
                if (n2 != n5) {
                    return false;
                }
                pdBary2.copy(pdBary);
                PwBary.changeBarycentricOnEdge(pdBary2, n3, pgElementSet.getOppVertexLocInd(n, n3));
            } else {
                return false;
            }
        }
        return true;
    }

    public static int equalizeElementIndex(PgPolygonOnElementSet pgPolygonOnElementSet, int n, int n2, PdBary pdBary, PdBary pdBary2) {
        int n3;
        PgElementSet pgElementSet = pgPolygonOnElementSet.getGeometry();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int[] nArray = new int[]{n, n2};
        PdBary[] pdBaryArray = new PdBary[]{pdBary, pdBary2};
        PiVector[] piVectorArray3 = new PiVector[2];
        PgVertexStar[] pgVertexStarArray = new PgVertexStar[]{null, null};
        int[] nArray2 = new int[]{-1, -1};
        for (int i = 0; i < 2; ++i) {
            piVectorArray3[i] = new PiVector();
            int n4 = pgPolygonOnElementSet.getVertexElemInd(nArray[i]);
            PdBary pdBary3 = pgPolygonOnElementSet.getVertexBary(nArray[i]);
            int n5 = PwBary.liesOnVertex(pdBary3);
            if (n5 >= 0) {
                pgVertexStarArray[i] = new PgVertexStar();
                pgVertexStarArray[i].makeVertexStar(pgElementSet, piVectorArray[n4].m_data[n5], n4);
                piVectorArray3[i].setSize(pgVertexStarArray[i].getSize());
                piVectorArray3[i].copyArray(pgVertexStarArray[i].getElement());
                continue;
            }
            nArray2[i] = PwBary.getEdgeIndex(pdBary3);
            if (nArray2[i] != -1) {
                piVectorArray3[i].setSize(2);
                piVectorArray3[i].m_data[0] = n4;
                piVectorArray3[i].m_data[1] = piVectorArray2[n4].m_data[nArray2[i]];
                continue;
            }
            piVectorArray3[i].setSize(1);
            piVectorArray3[i].m_data[0] = n4;
        }
        int[] nArray3 = new int[]{-1, -1};
        int n6 = -1;
        int n7 = piVectorArray3[0].getSize();
        int n8 = piVectorArray3[1].getSize();
        block1: for (n3 = 0; n3 < n7; ++n3) {
            for (int i = 0; i < n8; ++i) {
                if (piVectorArray3[0].m_data[n3] != piVectorArray3[1].m_data[i] || piVectorArray3[0].m_data[n3] == -1) continue;
                nArray3[0] = n3;
                nArray3[1] = i;
                n6 = piVectorArray3[0].m_data[n3];
                continue block1;
            }
        }
        if (n6 < 0) {
            return -1;
        }
        for (n3 = 0; n3 < 2; ++n3) {
            if (nArray3[n3] == 0) {
                pdBaryArray[n3].copy(pgPolygonOnElementSet.getVertexBary(nArray[n3]));
                continue;
            }
            if (pgVertexStarArray[n3] != null) {
                pdBaryArray[n3].copy(PdBary.TRIANGLE_VERTEX[pgVertexStarArray[n3].getVertexLocInd().getEntry(nArray3[n3])]);
                continue;
            }
            pdBaryArray[n3].copy(pgPolygonOnElementSet.getVertexBary(nArray[n3]));
            PwBary.changeBarycentricOnEdge(pdBaryArray[n3], nArray2[n3], pgElementSet.getOppVertexLocInd(pgPolygonOnElementSet.getVertexElemInd(nArray[n3]), nArray2[n3]));
        }
        return n6;
    }

    public static void changeBarycentricOnEdge(PdBary pdBary, int n, int n2) {
        double d = pdBary.m_data[(n + 1) % 3];
        double d2 = pdBary.m_data[(n + 2) % 3];
        pdBary.m_data[n2] = 0.0;
        pdBary.m_data[(n2 + 1) % 3] = d2;
        pdBary.m_data[(n2 + 2) % 3] = d;
    }

    public static int changeBarycentricOnEdge(PgElementSet pgElementSet, PdBary pdBary, int n) {
        int n2 = pdBary.getElementInd();
        PiVector piVector = pgElementSet.getElement(n2);
        int n3 = piVector.m_data[(n + 1) % 3];
        int n4 = piVector.m_data[(n + 2) % 3];
        int n5 = pgElementSet.getNeighbour((int)n2).m_data[n];
        if (n5 < 0) {
            return -1;
        }
        PiVector piVector2 = pgElementSet.getElement(n5);
        int n6 = piVector2.getIndexOf(n3);
        int n7 = piVector2.getIndexOf(n4);
        int n8 = 3 - n6 - n7;
        double d = pdBary.m_data[(n + 1) % 3];
        double d2 = pdBary.m_data[(n + 2) % 3];
        pdBary.m_data[n6] = d;
        pdBary.m_data[n7] = d2;
        pdBary.m_data[n8] = 0.0;
        pdBary.m_elementInd = n5;
        pdBary.validate();
        return n8;
    }

    public static boolean changeBarycentricOnEdge(PgElementSet pgElementSet, PdBaryDir pdBaryDir, int n) {
        PdVector pdVector = PwBary.getVector(null, pgElementSet, pdBaryDir);
        int n2 = pdBaryDir.getElementInd();
        if (n2 < 0) {
            PsDebug.warning((String)"No element index given");
            return false;
        }
        int n3 = pgElementSet.getNeighbour((int)n2).m_data[n];
        if (n3 < 0) {
            return false;
        }
        PiVector piVector = pgElementSet.getElement(n2);
        int n4 = piVector.m_data[(n + 1) % 3];
        int n5 = piVector.m_data[(n + 2) % 3];
        PdVector pdVector2 = PdVector.subNew((PdVector)pgElementSet.getVertex(n5), (PdVector)pgElementSet.getVertex(n4));
        pdVector2.normalize();
        double d = -PdVector.angleWithOrientation((PdVector)pdVector, (PdVector)pdVector2, (PdVector)pgElementSet.getElementNormal(n2));
        pdVector2.multScalar(pdVector.length());
        PuVectorGeom.rotatePointAroundVector((PdVector)pdVector2, (PdVector)pdVector2, (PdVector)pgElementSet.getElementNormal(n3), (double)d);
        return PwBary.projectOntoElement(pgElementSet, n3, pdVector2, pdBaryDir);
    }

    public static PdBary[] getBaryDescriptions(PgElementSet pgElementSet, PdBary pdBary, double d) {
        int n = pdBary.isOnVertex(d);
        if (n >= 0) {
            PgVertexStar pgVertexStar = new PgVertexStar();
            int n2 = pgElementSet.getElement((int)pdBary.getElementInd()).m_data[n];
            pgVertexStar.makeVertexStar(pgElementSet, n2, pdBary.getElementInd());
            PiVector piVector = pgVertexStar.getElement();
            PiVector piVector2 = pgVertexStar.getVertexLocInd();
            int n3 = piVector2.getSize();
            PdBary[] pdBaryArray = new PdBary[n3];
            for (int i = 0; i < n3; ++i) {
                pdBaryArray[i] = PwBary.newVertexBary(piVector.m_data[i], piVector2.m_data[i]);
            }
            return pdBaryArray;
        }
        n = -1;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(pdBary.m_data[i]) < d)) continue;
            n = i;
        }
        if (n < 0) {
            PdBary[] pdBaryArray = new PdBary[]{new PdBary(3)};
            pdBaryArray[0].copy(pdBary);
            return pdBaryArray;
        }
        PdBary[] pdBaryArray = new PdBary[2];
        pdBaryArray[0] = new PdBary(3);
        pdBaryArray[0].copy(pdBary);
        pdBaryArray[1] = new PdBary(3);
        pdBaryArray[1].copy(pdBary);
        PwBary.changeBarycentricOnEdge(pgElementSet, pdBaryArray[1], n);
        return pdBaryArray;
    }

    public static boolean makeBaryDescription(PgElementSet pgElementSet, PdBary pdBary, int n, double d) {
        if (pdBary.getElementInd() == n) {
            return true;
        }
        int n2 = pdBary.isOnVertex(d);
        if (n2 >= 0) {
            PiVector piVector = pgElementSet.getElement(pdBary.getElementInd());
            int n3 = piVector.m_data[n2];
            PiVector piVector2 = pgElementSet.getElement(n);
            int n4 = piVector2.getIndexOf(n3);
            if (n4 < 0) {
                return false;
            }
            pdBary.set(n, 0.0, 0.0, 0.0);
            pdBary.m_data[n4] = 1.0;
            return true;
        }
        int n5 = pdBary.isOnEdge(d);
        if (n5 >= 0) {
            PiVector piVector = pgElementSet.getNeighbour(pdBary.getElementInd());
            int n6 = piVector.m_data[n5];
            if (n6 != n) {
                return false;
            }
            pdBary.m_data[n5] = 0.0;
            PwBary.changeBarycentricOnEdge(pgElementSet, pdBary, n5);
            return true;
        }
        return false;
    }

    public static boolean makeCommonBaryDescription(PgElementSet pgElementSet, PdBary pdBary, PdBary pdBary2, double d) {
        int n;
        PdBary[] pdBaryArray = PwBary.getBaryDescriptions(pgElementSet, pdBary, d);
        PdBary[] pdBaryArray2 = PwBary.getBaryDescriptions(pgElementSet, pdBary2, d);
        int n2 = pdBaryArray.length;
        int n3 = pdBaryArray2.length;
        int n4 = pdBary.getElementInd();
        for (n = 0; n < n3; ++n) {
            if (pdBaryArray2[n].m_elementInd != n4) continue;
            pdBary2.copy(pdBaryArray2[n]);
            return true;
        }
        n4 = pdBary2.getElementInd();
        for (n = 0; n < n2; ++n) {
            if (pdBaryArray[n].m_elementInd != n4) continue;
            pdBary.copy(pdBaryArray[n]);
            return true;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (pdBaryArray[n].m_elementInd != pdBaryArray2[i].m_elementInd) continue;
                pdBary.copy(pdBaryArray[n]);
                pdBary2.copy(pdBaryArray2[i]);
                return true;
            }
        }
        return false;
    }

    public static PdVector getVertex(PdVector pdVector, PgElementSet pgElementSet, PdBary pdBary) {
        int n = pdBary.getElementInd();
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Element index out of bounds.");
            return null;
        }
        PiVector piVector = pgElementSet.getElement(n);
        if (piVector.getSize() != 3) {
            PsDebug.warning((String)"Element is not a triangle.");
            return null;
        }
        pdVector = pdBary.getVertex(pdVector, pgElementSet.getVertex(piVector.m_data[0]), pgElementSet.getVertex(piVector.m_data[1]), pgElementSet.getVertex(piVector.m_data[2]));
        return pdVector;
    }

    public static PdVector getVertex(PdVector pdVector, PgPolygon pgPolygon, PdBary pdBary) {
        int n = pdBary.getElementInd();
        if (n < 0 || n >= pgPolygon.getNumEdges()) {
            PsDebug.warning((String)"Edge index out of bounds.");
            return null;
        }
        int n2 = pgPolygon.getNumVertices();
        if (n2 < 2) {
            PsDebug.warning((String)"Polygon has less than two vertices.");
            return null;
        }
        pdVector = pdBary.getVertex(pdVector, pgPolygon.getVertex(n), pgPolygon.getVertex((n + 1) % n2));
        return pdVector;
    }

    public static PdVector getVector(PdVector pdVector, PgElementSet pgElementSet, PdBaryDir pdBaryDir) {
        int n = pdBaryDir.getElementInd();
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Element index out of bounds.");
            return null;
        }
        PiVector piVector = pgElementSet.getElement(n);
        if (piVector.getSize() != 3) {
            PsDebug.warning((String)"Element is not a triangle.");
            return null;
        }
        pdVector = PdBaryDir.getVector((PdVector)pdVector, (PdBaryDir)pdBaryDir, (PdVector)pgElementSet.getVertex(piVector.m_data[0]), (PdVector)pgElementSet.getVertex(piVector.m_data[1]), (PdVector)pgElementSet.getVertex(piVector.m_data[2]));
        return pdVector;
    }

    public static PdBary newVertexBary(int n, int n2) {
        PdBary pdBary = new PdBary(3);
        pdBary.setElementInd(n);
        pdBary.m_data[0] = 0.0;
        pdBary.m_data[n2] = 1.0;
        return pdBary;
    }

    public static PdBaryDir subBary(PgElementSet pgElementSet, PdBary pdBary, PdBary pdBary2, PdBaryDir pdBaryDir) {
        if (!PwBary.makeCommonBaryDescription(pgElementSet, pdBary, pdBary2, 1.0E-10)) {
            return null;
        }
        if (pdBaryDir == null) {
            pdBaryDir = new PdBaryDir(pdBary.getSize());
        }
        pdBaryDir.sub(pdBary, pdBary2);
        return pdBaryDir;
    }

    public static PdBary vertexToBary(PgElementSet pgElementSet, int n, int n2) {
        PiVector piVector = pgElementSet.getElement(n2);
        int n3 = piVector.getIndexOf(n);
        if (n3 < 0) {
            PsDebug.warning((String)"Given element is not adjacent to vertex");
            return null;
        }
        PdBary pdBary = new PdBary(3);
        pdBary.set(n2, 0.0, 0.0, 0.0);
        pdBary.m_data[n3] = 1.0;
        return pdBary;
    }

    static {
        m_tmpEdge1 = new PdBaryDir(3);
        m_tmpEdge2 = new PdBaryDir(3);
        m_tmpEdge3 = new PdBaryDir(3);
        m_tmpEdge4 = new PdBaryDir(3);
        m_projVert = null;
        m_projN = new PdVector();
        m_rotVertAngles = new PdVector();
        m_rotVertStar = new PgVertexStar();
        m_rotVertEdge = new PdBaryDir(3);
        m_rotVertHalf = new PdBaryDir(3);
        m_rotVertNormal = new PdBaryDir(3);
        m_angleEdge = new PdBaryDir(3);
        m_angleOriented = new double[2];
        m_angleVectors = new PdBaryDir[2];
    }
}

