/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.SyntaxDocument;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class DefaultSyntaxDocument
extends PlainDocument
implements SyntaxDocument {
    protected TokenMarker tokenMarker;
    protected Color[] colors = SyntaxUtilities.getDefaultSyntaxColors();

    public DefaultSyntaxDocument() {
        this.addDocumentListener(new DocumentHandler());
    }

    @Override
    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    @Override
    public void setTokenMarker(TokenMarker tm) {
        this.tokenMarker = tm;
        if (tm == null) {
            return;
        }
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    @Override
    public Color[] getColors() {
        return this.colors;
    }

    @Override
    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    @Override
    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    @Override
    public void tokenizeLines(int start, int len) {
        if (this.tokenMarker == null) {
            return;
        }
        Segment lineSegment = new Segment();
        Element map = this.getDefaultRootElement();
        len += start;
        try {
            for (int i = start; i < len; ++i) {
                Element lineElement = map.getElement(i);
                int lineStart = lineElement.getStartOffset();
                this.getText(lineStart, lineElement.getEndOffset() - lineStart - 1, lineSegment);
                this.tokenMarker.markTokens(lineSegment, i);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public class DocumentHandler
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent evt) {
            if (DefaultSyntaxDocument.this.tokenMarker == null) {
                return;
            }
            DocumentEvent.ElementChange ch = evt.getChange(DefaultSyntaxDocument.this.getDefaultRootElement());
            if (ch == null) {
                return;
            }
            DefaultSyntaxDocument.this.tokenMarker.insertLines(ch.getIndex() + 1, ch.getChildrenAdded().length - ch.getChildrenRemoved().length);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (DefaultSyntaxDocument.this.tokenMarker == null) {
                return;
            }
            DocumentEvent.ElementChange ch = evt.getChange(DefaultSyntaxDocument.this.getDefaultRootElement());
            if (ch == null) {
                return;
            }
            Element[] children = ch.getChildrenRemoved();
            if (children == null) {
                return;
            }
            DefaultSyntaxDocument.this.tokenMarker.deleteLines(ch.getIndex() + 1, ch.getChildrenRemoved().length - ch.getChildrenAdded().length);
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }
    }
}

