/*
 * Decompiled with CFR 0.152.
 */
package jasext.jhplotserver;

import jas2.hist.Statistics;
import jasext.jhplotserver.Rebinnable1DHistogramDataWithType;

abstract class StringDataColumn
extends Rebinnable1DHistogramDataWithType {
    protected String[] data;
    private final String title;
    protected final String[] s = new String[]{"MN", "UV", "OQ", "ST", "YX", "AB", "JK", "WX", "FG", "DE"};

    StringDataColumn(String title) {
        this.title = title;
    }

    String getString(int n) {
        return this.data[n];
    }

    @Override
    public int getBins() {
        return this.s.length;
    }

    @Override
    public int getAxisType() {
        return 2;
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        double[][] result = new double[1][bins];
        for (int i = 0; i < this.data.length; ++i) {
            double[] dArray = result[0];
            int n = this.getIndex(this.data[i]);
            dArray[n] = dArray[n] + 1.0;
        }
        return result;
    }

    private int getIndex(String value) {
        for (int i = 0; i < this.s.length; ++i) {
            if (this.s[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public boolean isRebinnable() {
        return false;
    }

    @Override
    public String[] getAxisLabels() {
        return this.s;
    }

    public Statistics getStatistics() {
        return null;
    }
}

