/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas2.hist.Basic1DFunction;
import jas2.hist.Fittable1DFunction;
import jas2.hist.Fitter;
import jas2.hist.FunctionAdvancedOptions;
import jas2.hist.FunctionValueUndefined;
import jas2.hist.InvalidFunctionParameter;
import jas2.hist.JASHist;
import jas2.util.JASDialog;
import jasext.hist.function.SumOfFunctionsException;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

class SumOfFunctions
extends Fittable1DFunction
implements Observer,
FunctionAdvancedOptions {
    private Vector funcs = new Vector();
    private int m_nParams;
    private int[] m_param;
    private boolean[] included;

    SumOfFunctions() {
    }

    void addFunction(Basic1DFunction f) {
        this.funcs.addElement(f);
        f.addObserver(this);
        this.mapParams();
    }

    void removeFunction(Basic1DFunction f) {
        f.deleteObserver(this);
        this.reSetIncluded(this.funcs.indexOf(f));
        this.funcs.removeElement(f);
        this.mapParams();
    }

    void removeAllFunctions() {
        Enumeration e = this.funcs.elements();
        while (e.hasMoreElements()) {
            Basic1DFunction f = (Basic1DFunction)e.nextElement();
            f.deleteObserver(this);
        }
        this.funcs.removeAllElements();
        this.mapParams();
    }

    Enumeration getFunctions() {
        return this.funcs.elements();
    }

    @Override
    public double valueAt(double x) throws FunctionValueUndefined {
        double y = 0.0;
        int i = 0;
        Enumeration e = this.funcs.elements();
        while (e.hasMoreElements()) {
            if (this.included[i++]) {
                Basic1DFunction f = (Basic1DFunction)e.nextElement();
                y += f.valueAt(x);
                continue;
            }
            e.nextElement();
        }
        return y;
    }

    @Override
    public String[] getParameterNames() {
        String[] result = new String[this.m_nParams];
        int j = 0;
        int x = 0;
        Enumeration e = this.funcs.elements();
        while (e.hasMoreElements()) {
            if (this.included[x++]) {
                Basic1DFunction f = (Basic1DFunction)e.nextElement();
                String[] names = f.getParameterNames();
                String title = f.getTitle();
                for (int i = 0; i < names.length; ++i) {
                    result[j++] = title + ": " + names[i];
                }
                continue;
            }
            e.nextElement();
        }
        return result;
    }

    @Override
    public double[] getParameterValues() {
        double[] result = new double[this.m_nParams];
        int j = 0;
        int x = 0;
        Enumeration e = this.funcs.elements();
        while (e.hasMoreElements()) {
            if (this.included[x++]) {
                Basic1DFunction f = (Basic1DFunction)e.nextElement();
                double[] values = f.getParameterValues();
                for (int i = 0; i < values.length; ++i) {
                    result[j++] = values[i];
                }
                continue;
            }
            e.nextElement();
        }
        return result;
    }

    @Override
    public void setParameter(int index, double value) throws InvalidFunctionParameter {
        if (index >= this.m_nParams) {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        for (int i = 0; i < this.m_param.length; ++i) {
            if (index < this.m_param[i]) {
                Basic1DFunction f = (Basic1DFunction)this.funcs.elementAt(i);
                f.setParameter(index, value);
                return;
            }
            index -= this.m_param[i];
        }
        this.clearFit();
        this.setChanged();
    }

    @Override
    public void setFit(Fitter fit, double[] values) throws InvalidFunctionParameter {
        if (values.length != this.m_nParams) {
            throw new IllegalArgumentException("Array passed to setParameters is of wrong length");
        }
        int j = 0;
        int k = 0;
        try {
            for (int i = 0; i < this.m_param.length; ++i) {
                double[] val = new double[this.m_param[i]];
                System.arraycopy(values, j, val, 0, this.m_param[i]);
                while (!this.included[k]) {
                    ++k;
                }
                Fittable1DFunction f = (Fittable1DFunction)this.funcs.elementAt(k++);
                f.setFit(null, val);
                j += this.m_param[i];
            }
            this.setFit(fit);
            this.setChanged();
        }
        catch (ClassCastException e) {
            throw new SumOfFunctionsException("Sum is not fittable since at least one component function is not fittable");
        }
    }

    @Override
    public double valueAt(double x, double[] a) throws FunctionValueUndefined {
        if (a.length != this.m_nParams) {
            throw new IllegalArgumentException("Array passed to valueAt is of wrong length");
        }
        int j = 0;
        int k = 0;
        double y = 0.0;
        try {
            for (int i = 0; i < this.m_param.length; ++i) {
                double[] val = new double[this.m_param[i]];
                System.arraycopy(a, j, val, 0, this.m_param[i]);
                while (!this.included[k]) {
                    ++k;
                }
                Fittable1DFunction f = (Fittable1DFunction)this.funcs.elementAt(k++);
                y += f.valueAt(x, val);
                j += this.m_param[i];
            }
        }
        catch (ClassCastException e) {
            throw new SumOfFunctionsException("Sum is not fittable since at least one component function is not fittable");
        }
        return y;
    }

    @Override
    public String getTitle() {
        String result = null;
        int i = 0;
        int j = 0;
        Enumeration e = this.funcs.elements();
        while (e.hasMoreElements()) {
            if (this.included[i++]) {
                ++j;
                Basic1DFunction f = (Basic1DFunction)e.nextElement();
                if (result == null) {
                    result = f.getTitle();
                    continue;
                }
                result = result + "+" + f.getTitle();
                continue;
            }
            e.nextElement();
        }
        if (j > 1) {
            return result;
        }
        if (j == 1) {
            return result + " (Sum)";
        }
        return "Sum of nothing";
    }

    @Override
    public void update(Observable obs, Object arg) {
        if ("remove".equals(arg)) {
            this.removeFunction((Basic1DFunction)obs);
        }
        this.mapParams();
        this.clearFit();
        this.setChanged();
    }

    private void mapParams() {
        int j = 0;
        int i = 0;
        this.m_nParams = 0;
        int nFuncs = this.funcs.size();
        if (this.included != null) {
            for (int k = 0; k < this.included.length; ++k) {
                if (this.included[k]) continue;
                --nFuncs;
            }
        }
        this.m_param = new int[nFuncs];
        Enumeration e = this.funcs.elements();
        while (e.hasMoreElements()) {
            if (this.included == null || this.included[i++]) {
                Basic1DFunction f = (Basic1DFunction)e.nextElement();
                int n = f.getParameterValues().length;
                this.m_param[j++] = n;
                this.m_nParams += n;
                continue;
            }
            e.nextElement();
        }
        this.initIncludeParametersInFit(this.m_nParams);
    }

    void setIncluded(int length) {
        this.included = new boolean[length];
        for (int i = 0; i < length; ++i) {
            this.included[i] = true;
        }
    }

    private void reSetIncluded(int index) {
        boolean[] newIncluded = new boolean[this.included.length - 1];
        int i = 0;
        for (int j = 0; j < this.included.length; ++j) {
            if (j == index) continue;
            newIncluded[i++] = this.included[j];
        }
        this.included = newIncluded;
    }

    @Override
    public void openAdvancedDialog(Frame f, JASHist hist) {
        new SumOfFunctionsAdvancedDialog(f);
    }

    private class SumOfFunctionsAdvancedDialog
    extends JASDialog {
        SumOfFunctionsAdvancedDialog(Frame f) {
            super(f, "Advanced...", true, 1);
            int n = SumOfFunctions.this.funcs.size();
            Container c = this.getContentPane();
            JCheckBox[] cb = new JCheckBox[n];
            c.setLayout(new GridLayout(n + 1, 1));
            c.add(new JLabel("Select functions to include:"));
            for (int i = 0; i < n; ++i) {
                Basic1DFunction bf = (Basic1DFunction)SumOfFunctions.this.funcs.elementAt(i);
                cb[i] = new JCheckBox(String.valueOf(i + 1) + " " + bf.getTitle(), SumOfFunctions.this.included[i]);
                cb[i].addActionListener(new EnumeratedJCheckBoxListener(i));
                cb[i].setMnemonic(48 + (char)(i + 1));
                c.add(cb[i]);
            }
            this.pack();
            this.setResizable(false);
            this.show();
        }

        private class EnumeratedJCheckBoxListener
        implements ActionListener {
            private int i;

            EnumeratedJCheckBoxListener(int i) {
                this.i = i;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SumOfFunctions)SumOfFunctions.this).included[this.i] = !SumOfFunctions.this.included[this.i];
                SumOfFunctions.this.mapParams();
                SumOfFunctions.this.setChanged();
                SumOfFunctions.this.clearFit();
            }
        }
    }
}

