/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

class Spline {
    public int lastElement;
    public double[] x;
    public double[] y;
    public double[] f;
    double[] d1f;
    double[] d2f;
    double[] d3f;
    double[] dy;
    double[][] v;
    double emptyCode;

    public Spline(int size, double emptyCode) {
        this.x = new double[size];
        this.y = new double[size];
        this.dy = new double[size];
        this.f = new double[size];
        this.d1f = new double[size];
        this.d2f = new double[size];
        this.d3f = new double[size];
        this.v = new double[size][7];
        this.emptyCode = emptyCode;
        this.lastElement = -1;
    }

    public void add(double coord, double func) {
        if (func > this.emptyCode) {
            ++this.lastElement;
            this.x[this.lastElement] = coord;
            this.y[this.lastElement] = func;
            this.dy[this.lastElement] = 0.0;
        }
    }

    public void add(double coord, double func, double uncertainty) {
        if (func > this.emptyCode) {
            this.add(coord, func);
            this.dy[this.lastElement] = uncertainty;
        }
    }

    public void calcApproximation(double maxMeanDistance) {
        if (this.lastElement > 0) {
            if (this.lastElement < 2) {
                for (int i = 0; i < this.lastElement; ++i) {
                    this.f[i] = this.y[i];
                    this.d1f[i] = (this.y[i + 1] - this.y[i]) / (this.x[i + 1] - this.x[i]);
                    this.d2f[i] = 0.0;
                    this.d3f[i] = 0.0;
                }
                this.f[this.lastElement] = this.y[this.lastElement];
            } else {
                int i;
                double sfq;
                int maxIter = 100;
                double p = 0.0;
                double q = 0.0;
                this.SetupQ();
                if (maxMeanDistance > 0.0) {
                    p = 0.0;
                    this.Chol1D(p);
                    sfq = 0.0;
                    for (int i2 = 0; i2 <= this.lastElement; ++i2) {
                        sfq += Math.pow(this.f[i2] * this.dy[i2], 2.0);
                    }
                    if ((sfq *= 36.0) > maxMeanDistance) {
                        boolean OK;
                        double utru = 0.0;
                        for (int i3 = 1; i3 <= this.lastElement; ++i3) {
                            utru += this.v[i3 - 1][3] * (this.d2f[i3 - 1] * (this.d2f[i3 - 1] + this.d2f[i3]) + Math.pow(this.d2f[i3], 2.0));
                        }
                        double ooss = 1.0 / Math.sqrt(maxMeanDistance);
                        double oosf = 1.0 / Math.sqrt(sfq);
                        q = -(oosf - ooss) * sfq / (6.0 * utru * oosf);
                        double prevq = 0.0;
                        double prevsf = oosf;
                        int iter = 0;
                        do {
                            this.Chol1D(q / (1.0 + q));
                            ++iter;
                            sfq = 0.0;
                            for (int i4 = 0; i4 <= this.lastElement; ++i4) {
                                sfq += Math.pow(this.f[i4] * this.dy[i4], 2.0);
                            }
                            OK = Math.abs((sfq = sfq * 36.0 / Math.pow(1.0 + q, 2.0)) - maxMeanDistance) <= 0.01 * maxMeanDistance;
                            if (OK) continue;
                            oosf = 1.0 / Math.sqrt(sfq);
                            double change = (q - prevq) / (oosf - prevsf) * (oosf - ooss);
                            prevq = q;
                            q -= change;
                            prevsf = oosf;
                        } while (!OK && iter <= maxIter);
                        p = q / (1.0 + q);
                    }
                } else {
                    p = 1.0;
                    this.Chol1D(p);
                    sfq = 0.0;
                }
                double temp = 6.0 / (1.0 + q);
                for (i = 0; i <= this.lastElement; ++i) {
                    this.f[i] = this.y[i] - temp * Math.pow(this.dy[i], 2.0) * this.f[i];
                }
                i = 0;
                while (i <= this.lastElement) {
                    int n = i++;
                    this.d2f[n] = this.d2f[n] * (6.0 * p);
                }
                for (i = 0; i < this.lastElement; ++i) {
                    this.d3f[i] = (this.d2f[i + 1] - this.d2f[i]) / this.v[i][3];
                    this.d1f[i] = (this.f[i + 1] - this.f[i]) / this.v[i][3] - (this.d2f[i] + this.d3f[i] / 3.0 * this.v[i][3]) / 2.0 * this.v[i][3];
                }
            }
        }
    }

    void SetupQ() {
        int i;
        this.v[0][3] = this.x[1] - this.x[0];
        for (i = 1; i < this.lastElement; ++i) {
            this.v[i][3] = this.x[i + 1] - this.x[i];
            this.v[i][0] = this.dy[i - 1] / this.v[i - 1][3];
            this.v[i][1] = -this.dy[i] / this.v[i][3] - this.dy[i] / this.v[i - 1][3];
            this.v[i][2] = this.dy[i + 1] / this.v[i][3];
        }
        this.v[this.lastElement][0] = 0.0;
        for (i = 1; i < this.lastElement; ++i) {
            this.v[i][4] = Math.pow(this.v[i][0], 2.0) + Math.pow(this.v[i][1], 2.0) + Math.pow(this.v[i][2], 2.0);
        }
        for (i = 2; i < this.lastElement; ++i) {
            this.v[i - 1][5] = this.v[i - 1][1] * this.v[i][0] + this.v[i - 1][2] * this.v[i][1];
        }
        this.v[this.lastElement - 1][5] = 0.0;
        for (i = 3; i < this.lastElement; ++i) {
            this.v[i - 2][6] = this.v[i - 2][2] * this.v[i][0];
        }
        this.v[this.lastElement - 2][6] = 0.0;
        this.v[this.lastElement - 1][6] = 0.0;
        double prev = (this.y[1] - this.y[0]) / this.v[0][3];
        for (int i2 = 1; i2 < this.lastElement; ++i2) {
            double diff = (this.y[i2 + 1] - this.y[i2]) / this.v[i2][3];
            this.d3f[i2] = diff - prev;
            prev = diff;
        }
    }

    void Chol1D(double p) {
        int i;
        double temp = 6.0 * (1.0 - p);
        for (i = 1; i < this.lastElement; ++i) {
            this.v[i][0] = temp * this.v[i][4] + 2.0 * p * (this.v[i - 1][3] + this.v[i][3]);
            this.v[i][1] = temp * this.v[i][5] + p * this.v[i][3];
            this.v[i][2] = temp * this.v[i][6];
        }
        if (this.lastElement >= 3) {
            for (i = 1; i < this.lastElement - 1; ++i) {
                double ratio = this.v[i][1] / this.v[i][0];
                double[] dArray = this.v[i + 1];
                dArray[0] = dArray[0] - ratio * this.v[i][1];
                double[] dArray2 = this.v[i + 1];
                dArray2[1] = dArray2[1] - ratio * this.v[i][2];
                this.v[i][1] = ratio;
                ratio = this.v[i][2] / this.v[i][0];
                double[] dArray3 = this.v[i + 2];
                dArray3[0] = dArray3[0] - ratio * this.v[i][2];
                this.v[i][2] = ratio;
            }
            this.d2f[0] = 0.0;
            this.d2f[1] = this.d3f[1];
            this.v[0][2] = 0.0;
            for (i = 1; i < this.lastElement - 1; ++i) {
                this.d2f[i + 1] = this.d3f[i + 1] - this.v[i][1] * this.d2f[i] - this.v[i - 1][2] * this.d2f[i - 1];
            }
            this.d2f[this.lastElement] = 0.0;
            this.d2f[this.lastElement - 1] = this.d2f[this.lastElement - 1] / this.v[this.lastElement - 1][0];
            for (i = this.lastElement - 2; i > 0; --i) {
                this.d2f[i] = this.d2f[i] / this.v[i][0] - this.d2f[i + 1] * this.v[i][1] - this.d2f[i + 2] * this.v[i][2];
            }
        } else {
            this.d2f[0] = 0.0;
            this.d2f[1] = this.d3f[1] / this.v[1][0];
            this.d2f[2] = 0.0;
        }
        double prev = 0.0;
        for (int i2 = 1; i2 <= this.lastElement; ++i2) {
            this.f[i2] = (this.d2f[i2] - this.d2f[i2 - 1]) / this.v[i2 - 1][3];
            this.f[i2 - 1] = this.f[i2] - prev;
            prev = this.f[i2];
        }
        this.f[this.lastElement] = -this.f[this.lastElement];
    }

    public void calcInterpolation(boolean isSpline) {
        if (this.lastElement > 0) {
            double stepB;
            int i;
            boolean splineInterpolation = this.lastElement > 1 && isSpline;
            double delta = 0.0;
            double step = this.x[1] - this.x[0];
            this.v[0][3] = -step;
            this.v[0][4] = step * step * delta;
            for (i = 1; i < this.lastElement; ++i) {
                step = this.x[i + 1] - this.x[i];
                stepB = this.x[i] - this.x[i - 1];
                this.v[i][3] = 2.0 * (stepB + step) - stepB * stepB / this.v[i - 1][3];
                this.v[i][4] = (this.y[i + 1] - this.y[i]) / step - (this.y[i] - this.y[i - 1]) / stepB - stepB * this.v[i - 1][4] / this.v[i - 1][3];
            }
            stepB = this.x[this.lastElement] - this.x[this.lastElement - 1];
            this.v[this.lastElement][3] = -stepB - stepB * stepB / this.v[this.lastElement - 1][3];
            this.v[this.lastElement][4] = -(stepB * stepB) * delta - stepB * this.v[this.lastElement - 1][4] / this.v[this.lastElement - 1][3];
            this.d2f[this.lastElement] = splineInterpolation ? this.v[this.lastElement][4] / this.v[this.lastElement][3] : 0.0;
            for (i = this.lastElement - 1; i >= 0; --i) {
                this.d2f[i] = splineInterpolation ? (this.v[i][4] - (this.x[i + 1] - this.x[i]) * this.d2f[i + 1]) / this.v[i][3] : 0.0;
            }
            i = 0;
            while (i < this.lastElement) {
                step = this.x[i + 1] - this.x[i];
                this.f[i] = this.y[i];
                this.d1f[i] = (this.y[i + 1] - this.y[i]) / step - step * (this.d2f[i + 1] + 2.0 * this.d2f[i]);
                this.d3f[i] = 6.0 * (this.d2f[i + 1] - this.d2f[i]) / step;
                int n = i++;
                this.d2f[n] = this.d2f[n] * 6.0;
            }
        }
    }

    public double get(double coord) {
        double result = this.emptyCode - 0.5;
        boolean find = false;
        if (this.lastElement > 0) {
            int i;
            for (i = 0; i < this.lastElement && !(find = coord >= this.x[i] && coord <= this.x[i + 1]); ++i) {
            }
            if (find) {
                double temp = coord - this.x[i];
                result = this.f[i] + temp * (this.d1f[i] + temp * (this.d2f[i] + temp * this.d3f[i] / 3.0) / 2.0);
            }
        }
        return result;
    }
}

