/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import jas2.hist.Statistics;
import jasext.flatfileserver.DataColumn;
import jasext.flatfileserver.DateDataColumn;
import jasext.flatfileserver.DoubleDataColumn;
import jasext.flatfileserver.ExponentialFormat;
import jasext.flatfileserver.IntegerDataColumn;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class StringDataColumn
extends DataColumn {
    private Hashtable hashTable = new Hashtable();
    private int valueCount = 0;
    private int index = 0;
    private Vector data = new Vector();
    private String[] currentArray = new String[100];
    private static final int MAXSIZE = 100;
    private int nBins = 0;

    StringDataColumn(String name) {
        super(name);
    }

    void addRow(String value) {
        if (this.index == 100) {
            this.data.addElement(this.currentArray);
            this.index = 0;
            this.currentArray = new String[100];
        }
        this.currentArray[this.index++] = value;
        ++this.valueCount;
        if (value != null) {
            this.hashTable.put(value, this);
        }
    }

    private int getDataType(Format[] formats) {
        int type;
        String s = null;
        ParsePosition pp = new ParsePosition(0);
        for (type = 0; type < formats.length; ++type) {
            Format f = formats[type];
            try {
                Enumeration e = this.hashTable.keys();
                while (e.hasMoreElements()) {
                    s = (String)e.nextElement();
                    int l = s.length();
                    if (l == 0) {
                        return formats.length;
                    }
                    pp.setIndex(0);
                    f.parseObject(s, pp);
                    if (pp.getIndex() == l) continue;
                    throw new ParseException("Not all characters used", pp.getIndex());
                }
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return type;
    }

    DataColumn convert(Format[] formats) {
        int type = this.getDataType(formats);
        if (type == formats.length) {
            return this;
        }
        Format f = formats[type];
        if (f instanceof DateFormat) {
            return new DateDataColumn(this, (DateFormat)f);
        }
        if (f instanceof ExponentialFormat) {
            return new DoubleDataColumn(this);
        }
        if (f instanceof NumberFormat) {
            return new IntegerDataColumn(this);
        }
        return this;
    }

    @Override
    public int getAxisType() {
        return 2;
    }

    @Override
    public String[] getAxisLabels() {
        if (this.nBins == 0) {
            this.assignBins();
        }
        String[] result = new String[this.nBins];
        Enumeration e = this.hashTable.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            int bin = (Integer)this.hashTable.get(s);
            result[bin] = s;
        }
        return result;
    }

    private void assignBins() {
        Enumeration e = this.hashTable.keys();
        while (e.hasMoreElements()) {
            this.hashTable.put(e.nextElement(), new Integer(this.nBins++));
        }
    }

    @Override
    public int getBins() {
        return this.nBins;
    }

    @Override
    public double getMax() {
        return this.nBins;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public boolean isRebinnable() {
        return false;
    }

    @Override
    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean goFast) {
        int i;
        if (this.nBins == 0) {
            this.assignBins();
        }
        double[] hist = new double[bins];
        for (i = 0; i < bins; ++i) {
            hist[i] = 0.0;
        }
        for (i = 0; i < this.getSize(); ++i) {
            String s = this.getString(i);
            Object o = this.hashTable.get(s);
            int bin = (Integer)o;
            if (bin < 0 || bin >= bins) continue;
            int n = bin;
            hist[n] = hist[n] + 1.0;
        }
        double[][] result = new double[][]{hist};
        return result;
    }

    @Override
    String getString(int n) {
        int ithArray = n / 100;
        if (ithArray >= this.data.size()) {
            return this.currentArray[n % 100];
        }
        String[] a = (String[])this.data.elementAt(ithArray);
        return a[n % 100];
    }

    int getSize() {
        return this.valueCount;
    }

    @Override
    String getType() {
        return "string";
    }

    public Statistics getStatistics() {
        return null;
    }
}

