/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.xml.parserwrappers;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLErrorHandler
implements ErrorHandler {
    private int level = 0;
    private String fileName;

    XMLErrorHandler(String fileName) {
        this.fileName = fileName;
    }

    int getLevel() {
        return this.level;
    }

    @Override
    public void warning(SAXParseException exception) {
        if (this.level < 1) {
            this.level = 1;
        }
    }

    @Override
    public void error(SAXParseException exception) {
        System.err.println(this.fileName + ": Error at line " + exception.getLineNumber() + ": " + exception);
        if (this.level < 2) {
            this.level = 2;
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        System.err.println(this.fileName + ": Fatal error at line " + exception.getLineNumber() + ": " + exception);
        if (this.level < 3) {
            this.level = 3;
        }
        throw exception;
    }
}

