/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.rmi;

import jas2.util.rmi.RMIDestination;
import jas2.util.rmi.RMIEventDeliveryEvent;
import jas2.util.rmi.RMIEventDeliveryListener;
import jas2.util.rmi.RemoteEventReceiver;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class RMIEventDelivery
extends UnicastRemoteObject
implements RemoteEventReceiver {
    private static final RMIEventDeliveryEvent start = new RMIEventDeliveryEvent(true);
    private static final RMIEventDeliveryEvent stop = new RMIEventDeliveryEvent(false);
    private static final boolean debug = System.getProperty("debugEventDelivery") != null;
    private boolean swing;
    private Vector edl = new Vector();
    private Vector dest = new Vector();

    public RMIEventDelivery(boolean swing) throws RemoteException {
        this.swing = swing;
    }

    public RMIDestination getRMIDestination() {
        RMIDestination result = new RMIDestination(this.dest.size());
        this.dest.addElement(result);
        return result;
    }

    public void addRMIEventDeliveryListener(RMIEventDeliveryListener l) {
        this.edl.addElement(l);
    }

    public void removeRMIEventDeliveryListener(RMIEventDeliveryListener l) {
        this.edl.removeElement(l);
    }

    private void fireEventDelivery(RMIEventDeliveryEvent event) {
        Enumeration e = this.edl.elements();
        while (e.hasMoreElements()) {
            RMIEventDeliveryListener ed = (RMIEventDeliveryListener)e.nextElement();
            ed.eventDelivery(event);
        }
    }

    @Override
    public void remoteUpdate(Serializable[] arg) {
        if (this.swing) {
            SwingUtilities.invokeLater(new EventDispatcher(arg));
        } else {
            this.deliver(arg);
        }
    }

    private void deliver(Serializable[] arg) {
        if (debug) {
            System.out.println("Starting delivery of " + arg.length + " remote events");
        }
        RMIDestination currdest = null;
        this.fireEventDelivery(start);
        for (int i = 0; i < arg.length; ++i) {
            Serializable x = arg[i];
            if (debug) {
                System.out.println("event=" + x);
            }
            if (x instanceof RMIDestination) {
                currdest = (RMIDestination)this.dest.elementAt(((RMIDestination)x).getID());
                continue;
            }
            currdest.notifyObservers(x);
        }
        this.fireEventDelivery(stop);
        if (debug) {
            System.out.println("Delivery complete");
        }
    }

    private class EventDispatcher
    implements Runnable {
        private Serializable[] arg;

        EventDispatcher(Serializable[] arg) {
            this.arg = arg;
        }

        @Override
        public void run() {
            RMIEventDelivery.this.deliver(this.arg);
        }
    }
}

