/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.pluginmanager;

import jas2.util.JASDialog;
import jas2.util.JASState;
import jas2.util.pluginmanager.InstallPluginsUI;
import jas2.util.pluginmanager.PluginManager;
import jas2.util.pluginmanager.PluginProperties;
import jas2.util.pluginmanager.UpdatePluginsUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class PluginManagerUI
extends JASDialog
implements ActionListener {
    private Vector loadedplugins;
    private JTree tree;
    private JLabel path;
    private JLabel name;
    private JLabel author;
    private JLabel currversion;
    private JButton remove;
    private JButton update;
    private JButton install;
    private PluginManager pluginmanager;
    private JTextArea textarea;
    private DefaultMutableTreeNode loadedtree;
    private JOptionPane updatepane;
    private Container c;

    public PluginManagerUI(PluginManager pm, Frame frame) {
        super(frame, "Plugin Manager", true, 13);
        this.pluginmanager = pm;
    }

    public void showManagerGUI() {
        super.setHelpTopic("userInterface.pluginmanager");
        this.c = this.getContentPane();
        this.c.removeAll();
        this.c.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.tree = new JTree();
        this.tree.setCellRenderer(new Renderer());
        this.tree.setRootVisible(false);
        this.tree.setVisibleRowCount(8);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeHandler());
        JScrollPane treescroll = new JScrollPane(this.tree);
        panel.add("Center", treescroll);
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel labelBox = new JPanel(new GridLayout(5, 1));
        labelBox.add(new JLabel("Name: ", 4));
        labelBox.add(new JLabel("Author: ", 4));
        labelBox.add(new JLabel("Version: ", 4));
        labelBox.add(new JLabel("Install path: ", 4));
        labelBox.add(new JLabel("Description ", 4));
        panel2.add("West", labelBox);
        JPanel panel3 = new JPanel(new BorderLayout());
        this.textarea = new JTextArea(6, 30);
        this.textarea.setEditable(false);
        this.textarea.setLineWrap(true);
        this.textarea.setWrapStyleWord(true);
        JScrollPane editorscroll = new JScrollPane(this.textarea);
        panel3.add("North", this.textarea);
        JPanel valueBox = new JPanel(new GridLayout(5, 1));
        this.name = new JLabel();
        valueBox.add(this.name);
        this.author = new JLabel();
        valueBox.add(this.author);
        this.currversion = new JLabel();
        valueBox.add(this.currversion);
        this.path = new JLabel();
        valueBox.add(this.path);
        panel2.add("Center", valueBox);
        panel2.add("South", panel3);
        panel.add("South", panel2);
        this.c.add("Center", panel);
        JPanel buttons = new JPanel();
        this.remove = new JButton("Remove selected plugins");
        this.remove.addActionListener(this);
        this.remove.setActionCommand("remove");
        buttons.add(this.remove);
        this.update = new JButton("Update installed plugins");
        this.update.addActionListener(this);
        this.update.setActionCommand("update");
        buttons.add(this.update);
        this.install = new JButton("Install a plugin");
        this.install.addActionListener(this);
        this.install.setActionCommand("install");
        buttons.add(this.install);
        this.c.add("South", buttons);
        this.updateTree();
        this.show();
    }

    protected void updateTree() {
        int i;
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
        DefaultTreeModel treeModel = new DefaultTreeModel(treeRoot, true);
        this.loadedplugins = this.pluginmanager.getLoadedPluginList();
        this.loadedtree = new DefaultMutableTreeNode("Loaded Plugins", true);
        treeModel.insertNodeInto(this.loadedtree, treeRoot, 0);
        DefaultMutableTreeNode node = null;
        if (this.loadedplugins != null) {
            for (i = 0; i < this.loadedplugins.size(); ++i) {
                node = new DefaultMutableTreeNode(this.loadedplugins.elementAt(i), false);
                treeModel.insertNodeInto(node, this.loadedtree, 0);
            }
        }
        treeRoot.insert(this.loadedtree, 0);
        this.tree.setModel(treeModel);
        for (i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.remove.setEnabled(false);
        if (this.pluginmanager.getNotInstalledPluginList().size() > 0) {
            this.install.setEnabled(true);
        } else {
            this.install.setEnabled(false);
        }
        if (this.pluginmanager.getOutDatedPluginList().size() > 0) {
            this.update.setEnabled(true);
        } else {
            this.update.setEnabled(false);
        }
        this.path.setText(null);
        this.name.setText(null);
        this.author.setText(null);
        this.currversion.setText(null);
        this.pack();
    }

    private void removePlugins() throws IOException {
        TreePath[] selectednodes = this.tree.getSelectionPaths();
        DefaultMutableTreeNode node = null;
        Object[] options = new String[]{"OK"};
        boolean successfulremove = false;
        if (selectednodes != null) {
            int n;
            for (int i = 0; i < selectednodes.length; ++i) {
                node = (DefaultMutableTreeNode)selectednodes[i].getLastPathComponent();
                if (node.getParent() != this.loadedtree) continue;
                PluginProperties plugleaf = (PluginProperties)node.getUserObject();
                if (plugleaf.removeable) {
                    int optionbutton;
                    File removefile = new File(plugleaf.path);
                    if (!removefile.canWrite()) {
                        optionbutton = JOptionPane.showOptionDialog(this.c, "You do not have write access to " + removefile.getAbsolutePath() + ".The plugin " + plugleaf.name + " cannot be removed.", "Removing Plugins", -1, 0, null, options, options[0]);
                        continue;
                    }
                    optionbutton = !plugleaf.installable ? JOptionPane.showConfirmDialog(this.c, "The plugin " + plugleaf.name + " cannot be reinstalled by JAS. If you still wish to remove it click 'Ok'.", "Removing Plugin", 2, 2) : 0;
                    if (optionbutton != 0) continue;
                    for (int j = 0; j < plugleaf.files.length; ++j) {
                        removefile = new File(plugleaf.path, plugleaf.files[j]);
                        FileOutputStream out = new FileOutputStream(removefile);
                        try {
                            out.write(null);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        out.close();
                    }
                    successfulremove = true;
                    plugleaf.setState(0);
                    continue;
                }
                n = JOptionPane.showOptionDialog(this.c, "The plugin " + plugleaf.name + " is not removeable.", "Removing Plugins", -1, 1, null, options, options[0]);
            }
            if (successfulremove) {
                n = JOptionPane.showOptionDialog(this.c, "For these changes to take effect you will need to restart JAS.", "Removing Plugins", -1, 1, null, options, options[0]);
            }
        }
        this.updateTree();
        this.show();
    }

    @Override
    public void onOK() {
        this.dispose();
    }

    @Override
    protected void enableHelp(JASState state) {
        state.setEnabled(true);
    }

    @Override
    public void onCancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "install") {
            InstallPluginsUI installPluginsUI = new InstallPluginsUI(this.pluginmanager, this);
        } else if (e.getActionCommand() == "remove") {
            if (this.remove.isEnabled()) {
                try {
                    this.removePlugins();
                }
                catch (IOException io) {
                    System.out.println(io + "Exception occured while trying to remove plugins.");
                }
            }
        } else if (e.getActionCommand() == "update") {
            UpdatePluginsUI updatePluginsUI = new UpdatePluginsUI(this.pluginmanager, this);
        }
    }

    class Renderer
    extends JLabel
    implements TreeCellRenderer {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private Border focusBorder = new LineBorder(UIManager.getColor("Tree.selectionBorderColor"), 1);

        Renderer() {
            this.setOpaque(true);
            this.setFont(UIManager.getFont("Tree.font"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (selected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBackground(tree.getBackground());
                this.setForeground(tree.getForeground());
            }
            DefaultMutableTreeNode node = null;
            if (tree.getPathForRow(row) != null) {
                node = (DefaultMutableTreeNode)tree.getPathForRow(row).getLastPathComponent();
            }
            if (node != null && node.getUserObject() instanceof PluginProperties) {
                PluginProperties plugleaf = (PluginProperties)node.getUserObject();
                this.setText(plugleaf.name);
            } else {
                this.setText(value.toString());
            }
            this.setBorder(hasFocus ? this.focusBorder : this.noFocusBorder);
            return this;
        }
    }

    class TreeHandler
    implements TreeSelectionListener {
        TreeHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            String description;
            String versionstr;
            String authorstr;
            String namestr;
            String pathstr;
            TreePath selection = evt.getPath();
            DefaultMutableTreeNode node = selection == null ? null : (DefaultMutableTreeNode)selection.getLastPathComponent();
            if (node != null && node.isLeaf() && node.getUserObject() instanceof PluginProperties) {
                PluginProperties plugprops = (PluginProperties)node.getUserObject();
                pathstr = plugprops.path;
                namestr = plugprops.name;
                authorstr = plugprops.author;
                versionstr = plugprops.currversion;
                description = plugprops.description;
            } else {
                versionstr = "";
                authorstr = "";
                namestr = "";
                pathstr = "";
                description = "Information describing the use of the available plugins will be displayed here.";
            }
            PluginManagerUI.this.path.setText(pathstr);
            PluginManagerUI.this.name.setText(namestr);
            PluginManagerUI.this.author.setText(authorstr);
            PluginManagerUI.this.currversion.setText(versionstr);
            node = null;
            TreePath[] checkselection = PluginManagerUI.this.tree.getSelectionPaths();
            if (checkselection != null) {
                for (int i = 0; i < checkselection.length; ++i) {
                    node = (DefaultMutableTreeNode)checkselection[i].getLastPathComponent();
                    if (node.getUserObject() instanceof PluginProperties) {
                        PluginManagerUI.this.remove.setEnabled(true);
                        break;
                    }
                    if (node != PluginManagerUI.this.loadedtree) continue;
                    PluginManagerUI.this.remove.setEnabled(false);
                }
            }
            PluginManagerUI.this.textarea.setText(description);
        }
    }
}

