/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.pluginmanager;

import jas2.util.JASDialog;
import jas2.util.pluginmanager.PluginDownloadThread;
import jas2.util.pluginmanager.PluginProperties;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class PluginDownloadProgress
extends JASDialog {
    private static JFrame frame;
    private PluginDownloadThread thread;
    private JLabel message;
    private JProgressBar progress;
    private int count;
    private int done = 1;
    private boolean canceled;
    private Object[] plugins;
    private String path;
    private Container c;

    public PluginDownloadProgress(Object[] plugins, String path) {
        super((Frame)frame, "Download Progress", true, 4);
        this.plugins = plugins;
        this.path = path;
        this.c = this.getContentPane();
        this.c.removeAll();
        this.c.setLayout(new BorderLayout());
        this.count = plugins.length;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.message = new JLabel("Hello World Hello World Hello World");
        this.message.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add("North", this.message);
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        panel.add("Center", this.progress);
        this.setCancelLabel("Stop");
        this.setCancelMnemonic('S');
        this.c.add("Center", panel);
        this.addWindowListener(new WindowHandler());
        this.thread = new PluginDownloadThread(this, plugins, path);
        this.pack();
        this.show();
    }

    public void downloading(String plugin) {
        this.showMessage("downloading: " + plugin);
    }

    public void setMaximum(final int total) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginDownloadProgress.this.progress.setMaximum(total);
            }
        });
    }

    public void setValue(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginDownloadProgress.this.progress.setValue(value);
            }
        });
    }

    public void done() {
        if (this.canceled) {
            return;
        }
        if (this.done == this.count) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PluginDownloadProgress.this.canceled) {
                        return;
                    }
                    PluginDownloadProgress.this.onSuccesfulCompletion();
                    PluginDownloadProgress.this.dispose();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginDownloadProgress.this.progress.setValue(0);
                }
            });
            ++this.done;
        }
    }

    private void showMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginDownloadProgress.this.message.setText(msg);
            }
        });
    }

    @Override
    public void onCancel() {
        this.thread.stopRequest();
        this.canceled = true;
        long i = System.currentTimeMillis();
        try {
            this.thread.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.onCancelFileClean();
        this.dispose();
    }

    private void onCancelFileClean() {
        Object[] options = new String[]{"OK"};
        String pluginstring = "";
        File removefile = null;
        for (int i = 0; i < this.plugins.length; ++i) {
            Object obj = this.plugins[i];
            if (!(obj instanceof PluginProperties)) continue;
            PluginProperties dummyplug = (PluginProperties)this.plugins[i];
            dummyplug.setState(0);
            pluginstring = pluginstring + " " + dummyplug.name;
            for (int j = 0; j < dummyplug.getFiles().length; ++j) {
                removefile = !this.path.equals("update") ? new File(this.path, dummyplug.getFiles()[j]) : new File(dummyplug.path, dummyplug.getFiles()[j]);
                try {
                    FileOutputStream out = new FileOutputStream(removefile);
                    try {
                        out.write(null);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    out.close();
                    continue;
                }
                catch (IOException e) {
                    System.out.println("download cancel remove: " + e);
                }
            }
        }
        int option1 = JOptionPane.showOptionDialog(this.c, "Download canceled for " + pluginstring + " plugin.", "Installing Plugins", -1, 1, null, options, options[0]);
        int option2 = 0;
        option2 = this.path.equals("update") ? JOptionPane.showOptionDialog(this.c, "You will need to restart JAS to remove the partially downloaded plugin files. The plugins will need to be reinstalled.", "Updating Plugins", -1, 1, null, options, options[0]) : JOptionPane.showOptionDialog(this.c, "You will need to restart JAS to remove the partially downloaded plugin files.", "Installing Plugins", -1, 1, null, options, options[0]);
    }

    private void onSuccesfulCompletion() {
        Object[] options = new String[]{"OK"};
        String pluginstring = "";
        for (int i = 0; i < this.plugins.length; ++i) {
            Object obj = this.plugins[i];
            if (!(obj instanceof PluginProperties)) continue;
            if (this.canceled) {
                return;
            }
            PluginProperties dummyplug = (PluginProperties)this.plugins[i];
            dummyplug.setState(1);
            dummyplug.currversion = dummyplug.latestversion;
            if (this.path.equals("update")) continue;
            dummyplug.path = this.path;
        }
        int optionbutton = 0;
        if (!this.path.equals("update")) {
            optionbutton = JOptionPane.showOptionDialog(this.c, "Successful download. For these changes to take effect you will need to restart JAS.", "Installing Plugins", -1, 1, null, options, options[0]);
        } else if (this.path.equals("update")) {
            optionbutton = JOptionPane.showOptionDialog(this.c, "Successful download of updates.", "Updating Plugins", -1, 1, null, options, options[0]);
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            PluginDownloadProgress.this.thread.stopRequest();
            PluginDownloadProgress.this.dispose();
        }
    }
}

