/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.multifunctionpanel.demos;

import jas2.util.multifunctionpanel.demos.MyGlassPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

class CBListener
extends MouseInputAdapter {
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Component liveButton;
    JMenuBar menuBar;
    MyGlassPane glassPane;
    Container contentPane;
    boolean inDrag = false;

    public CBListener(Component liveButton, JMenuBar menuBar, MyGlassPane glassPane, Container contentPane) {
        this.liveButton = liveButton;
        this.menuBar = menuBar;
        this.glassPane = glassPane;
        this.contentPane = contentPane;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.redispatchMouseEvent(e, false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.redispatchMouseEvent(e, false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.redispatchMouseEvent(e, false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.redispatchMouseEvent(e, false);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.redispatchMouseEvent(e, false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.redispatchMouseEvent(e, false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.redispatchMouseEvent(e, true);
        this.inDrag = false;
    }

    private void redispatchMouseEvent(MouseEvent e, boolean repaint) {
        boolean inButton = false;
        boolean inMenuBar = false;
        Point glassPanePoint = e.getPoint();
        Component component = null;
        Container container = this.contentPane;
        Point containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.contentPane);
        int eventID = e.getID();
        if (containerPoint.y < 0) {
            inMenuBar = true;
            container = this.menuBar;
            containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.menuBar);
            this.testForDrag(eventID);
        }
        if ((component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y)) == null) {
            return;
        }
        if (component.equals(this.liveButton)) {
            inButton = true;
            this.testForDrag(eventID);
        }
        if (inMenuBar || inButton || this.inDrag) {
            Point componentPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, component);
            component.dispatchEvent(new MouseEvent(component, eventID, e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }
        if (repaint) {
            this.toolkit.beep();
            this.glassPane.setPoint(glassPanePoint);
            this.glassPane.repaint();
        }
    }

    private void testForDrag(int eventID) {
        if (eventID == 501) {
            this.inDrag = true;
        }
    }
}

