/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.FieldBinding;
import jas2.util.SpinBox;
import jas2.util.UnsupportedType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class SpinFieldBinding
extends FieldBinding
implements ActionListener {
    private int m_oldVal = 0;
    private SpinBox m_field;

    SpinFieldBinding(SpinBox field) {
        this.m_field = field;
        field.addActionListener(this);
    }

    @Override
    void set(Object value) throws UnsupportedType {
        if (!(value instanceof Integer)) {
            throw new UnsupportedType(this.m_field, value.getClass());
        }
        int x = (Integer)value;
        if (this.m_oldVal != x) {
            this.m_field.setValue(x);
            this.m_oldVal = x;
        }
    }

    @Override
    Object get(Class type) throws UnsupportedType {
        if (type != Integer.TYPE) {
            throw new UnsupportedType(this.m_field, type);
        }
        int x = this.m_field.getValue();
        return new Integer(x);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int x = this.m_field.getValue();
        if (x != this.m_oldVal) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getValue();
    }
}

