/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ARGBColorChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    protected JSlider redSlider;
    protected JSlider greenSlider;
    protected JSlider blueSlider;
    protected JSlider alphaSlider;
    protected JSpinner redSpinner;
    protected JSpinner blueSpinner;
    protected JSpinner greenSpinner;
    protected JSpinner alphaSpinner;
    private final int minValue = 0;
    private final int maxValue = 255;
    private boolean isAdjusting = false;

    private void setColor(Color color) {
        int red = color.getRed();
        int blue = color.getBlue();
        int green = color.getGreen();
        int alpha = color.getAlpha();
        if (this.redSlider.getValue() != red) {
            this.redSlider.setValue(red);
        }
        if (this.greenSlider.getValue() != green) {
            this.greenSlider.setValue(green);
        }
        if (this.blueSlider.getValue() != blue) {
            this.blueSlider.setValue(blue);
        }
        if (this.alphaSlider.getValue() != alpha) {
            this.alphaSlider.setValue(alpha);
        }
        if ((Integer)this.redSpinner.getValue() != red) {
            this.redSpinner.setValue(new Integer(red));
        }
        if ((Integer)this.greenSpinner.getValue() != green) {
            this.greenSpinner.setValue(new Integer(green));
        }
        if ((Integer)this.blueSpinner.getValue() != blue) {
            this.blueSpinner.setValue(new Integer(blue));
        }
        if ((Integer)this.alphaSpinner.getValue() != alpha) {
            this.alphaSpinner.setValue(new Integer(alpha));
        }
    }

    @Override
    public String getDisplayName() {
        return "ARGB";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        Color color = this.getColorFromModel();
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        panel.setLayout(layout);
        this.add((Component)panel, "Center");
        JLabel l = new JLabel("Red");
        con.gridwidth = 1;
        layout.setConstraints(l, con);
        panel.add(l);
        this.redSlider = new JSlider(0, 0, 255, color.getRed());
        this.redSlider.setMajorTickSpacing(85);
        this.redSlider.setMinorTickSpacing(17);
        this.redSlider.setPaintTicks(true);
        this.redSlider.setPaintLabels(true);
        layout.setConstraints(this.redSlider, con);
        l.setLabelFor(this.redSlider);
        panel.add(this.redSlider);
        this.redSpinner = new JSpinner(new SpinnerNumberModel(color.getRed(), 0, 255, 1));
        JPanel redSpinnerHolder = new JPanel(new FlowLayout());
        this.redSpinner.addChangeListener(this);
        redSpinnerHolder.add(this.redSpinner);
        con.gridwidth = 0;
        layout.setConstraints(redSpinnerHolder, con);
        panel.add(redSpinnerHolder);
        l = new JLabel("Green");
        con.gridwidth = 1;
        layout.setConstraints(l, con);
        panel.add(l);
        this.greenSlider = new JSlider(0, 0, 255, color.getGreen());
        this.greenSlider.setMajorTickSpacing(85);
        this.greenSlider.setMinorTickSpacing(17);
        this.greenSlider.setPaintTicks(true);
        this.greenSlider.setPaintLabels(true);
        layout.setConstraints(this.greenSlider, con);
        panel.add(this.greenSlider);
        this.greenSpinner = new JSpinner(new SpinnerNumberModel(color.getGreen(), 0, 255, 1));
        l.setLabelFor(this.greenSlider);
        JPanel greenSpinnerHolder = new JPanel(new FlowLayout());
        greenSpinnerHolder.add(this.greenSpinner);
        this.greenSpinner.addChangeListener(this);
        con.gridwidth = 0;
        layout.setConstraints(greenSpinnerHolder, con);
        panel.add(greenSpinnerHolder);
        l = new JLabel("Blue");
        con.gridwidth = 1;
        layout.setConstraints(l, con);
        panel.add(l);
        this.blueSlider = new JSlider(0, 0, 255, color.getBlue());
        this.blueSlider.setMajorTickSpacing(85);
        this.blueSlider.setMinorTickSpacing(17);
        this.blueSlider.setPaintTicks(true);
        this.blueSlider.setPaintLabels(true);
        layout.setConstraints(this.blueSlider, con);
        panel.add(this.blueSlider);
        this.blueSpinner = new JSpinner(new SpinnerNumberModel(color.getBlue(), 0, 255, 1));
        l.setLabelFor(this.blueSlider);
        JPanel blueSpinnerHolder = new JPanel(new FlowLayout());
        blueSpinnerHolder.add(this.blueSpinner);
        this.blueSpinner.addChangeListener(this);
        con.gridwidth = 0;
        layout.setConstraints(blueSpinnerHolder, con);
        panel.add(blueSpinnerHolder);
        l = new JLabel("Alpha");
        con.gridwidth = 1;
        layout.setConstraints(l, con);
        panel.add(l);
        this.alphaSlider = new JSlider(0, 0, 255, color.getAlpha());
        this.alphaSlider.setMajorTickSpacing(85);
        this.alphaSlider.setMinorTickSpacing(17);
        this.alphaSlider.setPaintTicks(true);
        this.alphaSlider.setPaintLabels(true);
        layout.setConstraints(this.alphaSlider, con);
        panel.add(this.alphaSlider);
        this.alphaSpinner = new JSpinner(new SpinnerNumberModel(color.getAlpha(), 0, 255, 1));
        l.setLabelFor(this.alphaSlider);
        JPanel alphaSpinnerHolder = new JPanel(new FlowLayout());
        alphaSpinnerHolder.add(this.alphaSpinner);
        this.alphaSpinner.addChangeListener(this);
        con.gridwidth = 0;
        layout.setConstraints(alphaSpinnerHolder, con);
        panel.add(alphaSpinnerHolder);
        this.redSlider.addChangeListener(this);
        this.greenSlider.addChangeListener(this);
        this.blueSlider.addChangeListener(this);
        this.alphaSlider.addChangeListener(this);
    }

    @Override
    public void updateChooser() {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.setColor(this.getColorFromModel());
            this.isAdjusting = false;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JSlider && !this.isAdjusting) {
            int red = this.redSlider.getValue();
            int green = this.greenSlider.getValue();
            int blue = this.blueSlider.getValue();
            int alpha = this.alphaSlider.getValue();
            Color color = new Color(red, green, blue, alpha);
            this.getColorSelectionModel().setSelectedColor(color);
        } else if (e.getSource() instanceof JSpinner && !this.isAdjusting) {
            int red = (Integer)this.redSpinner.getValue();
            int green = (Integer)this.greenSpinner.getValue();
            int blue = (Integer)this.blueSpinner.getValue();
            int alpha = (Integer)this.alphaSpinner.getValue();
            Color color = new Color(red, green, blue, alpha);
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

