/*
 * Decompiled with CFR 0.152.
 */
package jas2.tuple;

import hepjas.analysis.partition.Abstract1DPartition;
import hepjas.analysis.partition.FixedMeanDatePartition;
import hepjas.analysis.partition.FixedMeanPartition;
import hepjas.analysis.partition.StringPartition;
import jas2.tuple.Hist1DModel;
import jas2.tuple.TupleColumn;
import java.util.Date;

class ProfileModel
extends Hist1DModel {
    private static String[] rows = new String[]{"X-Axis", "Value"};
    private static int[] defaults = new int[]{0, 1};

    ProfileModel(TupleColumn[] tupleColumns) {
        super(rows, defaults, tupleColumns);
    }

    @Override
    protected Abstract1DPartition getPartition(TupleColumn c) {
        int type = c.getType();
        double min = c.getDataSource().getMin();
        double max = c.getDataSource().getMax();
        if (type == 1) {
            return new FixedMeanPartition(min, max);
        }
        if (type == 2) {
            return new FixedMeanPartition(min, max);
        }
        if (type == 3) {
            return new StringPartition();
        }
        if (type == 4) {
            return new FixedMeanDatePartition(new Date((long)(min * 1000.0)), new Date((long)(max * 1000.0)));
        }
        throw new RuntimeException("Bugcheck");
    }

    @Override
    public String toString() {
        return "Profile Plot";
    }
}

